/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.functions;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.vertexium.cypher.VertexiumCypherQueryContext;
import org.vertexium.cypher.ast.CypherCompilerContext;
import org.vertexium.cypher.ast.model.CypherAstBase;
import org.vertexium.cypher.exceptions.VertexiumCypherArgumentErrorException;
import org.vertexium.cypher.executor.ExpressionScope;

public abstract class CypherFunction {
    public void compile(CypherCompilerContext compilerContext, CypherAstBase[] arguments) {
    }

    public abstract Object invoke(VertexiumCypherQueryContext var1, CypherAstBase[] var2, ExpressionScope var3);

    protected void assertArgumentCount(CypherAstBase[] arguments, int ... expectedCounts) {
        for (int count : expectedCounts) {
            if (arguments.length != count) continue;
            return;
        }
        throw new VertexiumCypherArgumentErrorException(String.format("Unexpected number of arguments. Expected %s, found %d", Arrays.stream(expectedCounts).mapToObj(Integer::toString).collect(Collectors.joining(", ")), arguments.length));
    }

    public boolean isConstant() {
        return true;
    }
}

