/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.functions.aggregate;

import java.util.List;
import org.vertexium.cypher.VertexiumCypherQueryContext;
import org.vertexium.cypher.executor.ExpressionScope;
import org.vertexium.cypher.functions.aggregate.PercentileFunction;

public class PercentileContFunction
extends PercentileFunction {
    @Override
    protected Object invoke(VertexiumCypherQueryContext ctx, List<Double> values, double percentile, ExpressionScope scope) {
        int count = values.size();
        values.sort(Double::compare);
        if (percentile == 1.0 || count == 1) {
            return values.get(values.size() - 1);
        }
        if (count > 1) {
            double doubleIndex = percentile * (double)(count - 1);
            int floor = (int)doubleIndex;
            int ceil = (int)Math.ceil(doubleIndex);
            if (ceil == floor || floor == count - 1) {
                return values.get(floor);
            }
            return values.get(floor) * ((double)ceil - doubleIndex) + values.get(ceil) * (doubleIndex - (double)floor);
        }
        return null;
    }
}

