/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.functions.aggregate;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.vertexium.cypher.VertexiumCypherQueryContext;
import org.vertexium.cypher.ast.model.CypherAstBase;
import org.vertexium.cypher.exceptions.VertexiumCypherArgumentErrorException;
import org.vertexium.cypher.exceptions.VertexiumCypherTypeErrorException;
import org.vertexium.cypher.executor.ExpressionScope;
import org.vertexium.cypher.functions.aggregate.AggregationFunction;

public abstract class PercentileFunction
extends AggregationFunction {
    @Override
    public Object invoke(VertexiumCypherQueryContext ctx, CypherAstBase[] arguments, ExpressionScope scope) {
        this.assertArgumentCount(arguments, 2);
        Stream arg0 = ctx.getExpressionExecutor().executeExpression(ctx, arguments[0], scope);
        Object arg1 = ctx.getExpressionExecutor().executeExpression(ctx, arguments[1], scope);
        VertexiumCypherTypeErrorException.assertType(arg1, Number.class);
        double percentile = ((Number)arg1).doubleValue();
        if (percentile < 0.0 || percentile > 1.0) {
            throw new VertexiumCypherArgumentErrorException("NumberOutOfRange: percentile must be between 0.0 and 1.0");
        }
        if (arg0 instanceof Collection) {
            arg0 = ((Collection)((Object)arg0)).stream();
        }
        if (arg0 instanceof Stream) {
            Stream<Double> values = arg0.map(v -> {
                if (v instanceof Number) {
                    return ((Number)v).doubleValue();
                }
                throw new VertexiumCypherTypeErrorException(v, Number.class);
            });
            return this.invoke(ctx, values.collect(Collectors.toList()), percentile, scope);
        }
        throw new VertexiumCypherTypeErrorException(arg0, Collection.class, Stream.class);
    }

    protected abstract Object invoke(VertexiumCypherQueryContext var1, List<Double> var2, double var3, ExpressionScope var5);
}

