/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.utils;

public class StringUtils {
    public static String unescape(String oldstr) {
        StringBuilder newstr = new StringBuilder(oldstr.length());
        boolean saw_backslash = false;
        for (int i = 0; i < oldstr.length(); ++i) {
            int cp = oldstr.codePointAt(i);
            if (oldstr.codePointAt(i) > 65535) {
                ++i;
            }
            if (!saw_backslash) {
                if (cp == 92) {
                    saw_backslash = true;
                    continue;
                }
                newstr.append(Character.toChars(cp));
                continue;
            }
            if (cp == 92) {
                saw_backslash = false;
                newstr.append('\\');
                newstr.append('\\');
                continue;
            }
            switch (cp) {
                case 114: {
                    newstr.append('\r');
                    break;
                }
                case 110: {
                    newstr.append('\n');
                    break;
                }
                case 102: {
                    newstr.append('\f');
                    break;
                }
                case 98: {
                    newstr.append("\\b");
                    break;
                }
                case 116: {
                    newstr.append('\t');
                    break;
                }
                case 97: {
                    newstr.append('\u0007');
                    break;
                }
                case 101: {
                    newstr.append('\u001b');
                    break;
                }
                case 99: {
                    if (++i == oldstr.length()) {
                        StringUtils.die("trailing \\c");
                    }
                    if ((cp = oldstr.codePointAt(i)) > 127) {
                        StringUtils.die("expected ASCII after \\c");
                    }
                    newstr.append(Character.toChars(cp ^ 0x40));
                    break;
                }
                case 56: 
                case 57: {
                    StringUtils.die("illegal octal digit");
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    --i;
                }
                case 48: {
                    char ch;
                    int j;
                    if (i + 1 == oldstr.length()) {
                        newstr.append(Character.toChars(0));
                        break;
                    }
                    ++i;
                    int digits = 0;
                    for (j = 0; j <= 2 && i + j != oldstr.length() && (ch = oldstr.charAt(i + j)) >= '0' && ch <= '7'; ++j) {
                        ++digits;
                    }
                    if (digits == 0) {
                        --i;
                        newstr.append('\u0000');
                        break;
                    }
                    int value = 0;
                    try {
                        value = Integer.parseInt(oldstr.substring(i, i + digits), 8);
                    }
                    catch (NumberFormatException nfe) {
                        StringUtils.die("invalid octal value for \\0 escape");
                    }
                    newstr.append(Character.toChars(value));
                    i += digits - 1;
                    break;
                }
                case 120: {
                    int j;
                    if (i + 2 > oldstr.length()) {
                        StringUtils.die("string too short for \\x escape");
                    }
                    boolean saw_brace = false;
                    if (oldstr.charAt(++i) == '{') {
                        ++i;
                        saw_brace = true;
                    }
                    for (j = 0; j < 8 && (saw_brace || j != 2); ++j) {
                        char ch = oldstr.charAt(i + j);
                        if (ch > '\u007f') {
                            StringUtils.die("illegal non-ASCII hex digit in \\x escape");
                        }
                        if (saw_brace && ch == '}') break;
                        if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F') continue;
                        StringUtils.die(String.format("illegal hex digit #%d '%c' in \\x", ch, (int)ch));
                    }
                    if (j == 0) {
                        StringUtils.die("empty braces in \\x{} escape");
                    }
                    int value = 0;
                    try {
                        value = Integer.parseInt(oldstr.substring(i, i + j), 16);
                    }
                    catch (NumberFormatException nfe) {
                        StringUtils.die("invalid hex value for \\x escape");
                    }
                    newstr.append(Character.toChars(value));
                    if (saw_brace) {
                        ++j;
                    }
                    i += j - 1;
                    break;
                }
                case 117: {
                    int j;
                    if (i + 4 > oldstr.length()) {
                        StringUtils.die("string too short for \\u escape");
                    }
                    ++i;
                    for (j = 0; j < 4; ++j) {
                        if (oldstr.charAt(i + j) <= '\u007f') continue;
                        StringUtils.die("illegal non-ASCII hex digit in \\u escape");
                    }
                    int value = 0;
                    try {
                        value = Integer.parseInt(oldstr.substring(i, i + j), 16);
                    }
                    catch (NumberFormatException nfe) {
                        StringUtils.die("invalid hex value for \\u escape");
                    }
                    newstr.append(Character.toChars(value));
                    i += j - 1;
                    break;
                }
                case 85: {
                    int j;
                    if (i + 8 > oldstr.length()) {
                        StringUtils.die("string too short for \\U escape");
                    }
                    ++i;
                    for (j = 0; j < 8; ++j) {
                        if (oldstr.charAt(i + j) <= '\u007f') continue;
                        StringUtils.die("illegal non-ASCII hex digit in \\U escape");
                    }
                    int value = 0;
                    try {
                        value = Integer.parseInt(oldstr.substring(i, i + j), 16);
                    }
                    catch (NumberFormatException nfe) {
                        StringUtils.die("invalid hex value for \\U escape");
                    }
                    newstr.append(Character.toChars(value));
                    i += j - 1;
                    break;
                }
                default: {
                    newstr.append('\\');
                    newstr.append(Character.toChars(cp));
                }
            }
            saw_backslash = false;
        }
        if (saw_backslash) {
            newstr.append('\\');
        }
        return newstr.toString();
    }

    private static void die(String foa) {
        throw new IllegalArgumentException(foa);
    }
}

