/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.elasticsearch5.plugin;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.search.Query;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.vertexium.elasticsearch5.plugin.FieldNameToVisibilityMap;
import org.vertexium.elasticsearch5.plugin.VertexiumQueryShardContext;

public class VertexiumQueryStringQueryBuilder
extends QueryStringQueryBuilder {
    public static final String NAME = "vertexium_query_string";
    public static final String ELEMENT_DOCUMENT_MAPPER_NAME = "e";
    private final String[] authorizations;

    public VertexiumQueryStringQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.authorizations = in.readStringArray();
        this.allowLeadingWildcard(false);
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        super.doWriteTo(out);
        out.writeStringArray(this.authorizations);
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        super.doXContent(builder, params);
        builder.startArray("authorizations");
        for (String authorization : this.authorizations) {
            builder.value(authorization);
        }
        builder.endArray();
        builder.endObject();
    }

    protected Query doToQuery(QueryShardContext context) throws IOException {
        FieldNameToVisibilityMap fieldNameToVisibilityMap = this.getFieldNameToVisibilityMap(context);
        return super.doToQuery((QueryShardContext)new VertexiumQueryShardContext(context, this.authorizations, fieldNameToVisibilityMap));
    }

    protected boolean doEquals(QueryStringQueryBuilder other) {
        return other instanceof VertexiumQueryStringQueryBuilder && super.doEquals(other) && Objects.deepEquals(this.authorizations, ((VertexiumQueryStringQueryBuilder)other).authorizations);
    }

    protected int doHashCode() {
        return Objects.hash(super.doHashCode(), this.authorizations);
    }

    public String getWriteableName() {
        return NAME;
    }

    public static Optional<QueryStringQueryBuilder> fromXContent(QueryParseContext parseContext) {
        throw new RuntimeException("not implemented");
    }

    protected FieldNameToVisibilityMap getFieldNameToVisibilityMap(QueryShardContext context) {
        try {
            HashMap results = new HashMap();
            ImmutableOpenMap mappings = ((GetMappingsResponse)context.getClient().admin().indices().prepareGetMappings(new String[0]).get()).getMappings();
            for (ObjectCursor index : mappings.keys()) {
                Map vertexiumMeta;
                Map meta;
                MappingMetaData elementMetadata;
                ImmutableOpenMap types = (ImmutableOpenMap)mappings.get(index.value);
                if (types == null || (elementMetadata = (MappingMetaData)types.get((Object)ELEMENT_DOCUMENT_MAPPER_NAME)) == null || (meta = (Map)elementMetadata.getSourceAsMap().get("_meta")) == null || (vertexiumMeta = (Map)meta.get("vertexium")) == null) continue;
                results.putAll(vertexiumMeta);
            }
            return FieldNameToVisibilityMap.createFromVertexiumMetadata(results);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not get mappings", ex);
        }
    }
}

