/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.elasticsearch5.plugin;

import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.lucene.queryparser.classic.MapperQueryParser;
import org.apache.lucene.queryparser.classic.QueryParserSettings;
import org.elasticsearch.index.query.QueryShardContext;
import org.vertexium.elasticsearch5.plugin.FieldNameToVisibilityMap;
import org.vertexium.elasticsearch5.plugin.VertexiumMapperQueryParser;
import org.vertexium.elasticsearch5.plugin.VisibilityUtils;

public class VertexiumQueryShardContext
extends QueryShardContext {
    private final VertexiumMapperQueryParser queryParser;
    private final FieldNameToVisibilityMap fieldNameToVisibilityMap;
    private final String[] authorizations;

    public VertexiumQueryShardContext(QueryShardContext source, String[] authorizations, FieldNameToVisibilityMap fieldNameToVisibilityMap) {
        super(source);
        this.fieldNameToVisibilityMap = fieldNameToVisibilityMap;
        this.authorizations = authorizations;
        this.queryParser = new VertexiumMapperQueryParser(this, authorizations, fieldNameToVisibilityMap);
    }

    public MapperQueryParser queryParser(QueryParserSettings settings) {
        this.queryParser.reset(settings);
        return this.queryParser;
    }

    public Collection<String> simpleMatchToIndexNames(String pattern) {
        return super.simpleMatchToIndexNames(pattern).stream().filter(fieldName -> {
            if (fieldName.startsWith("__") && !fieldName.equals(pattern)) {
                return false;
            }
            String visibility = this.fieldNameToVisibilityMap.getFieldVisibility((String)fieldName);
            return visibility == null || VisibilityUtils.canRead(visibility, this.authorizations);
        }).collect(Collectors.toSet());
    }
}

