/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.security;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.vertexium.security.ByteSequence;
import org.vertexium.security.Constants;

class ByteBufferUtil {
    ByteBufferUtil() {
    }

    public static byte[] toBytes(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        return Arrays.copyOfRange(buffer.array(), buffer.position(), buffer.limit());
    }

    public static List<ByteBuffer> toByteBuffers(Collection<byte[]> bytesList) {
        if (bytesList == null) {
            return null;
        }
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>();
        for (byte[] bytes : bytesList) {
            result.add(ByteBuffer.wrap(bytes));
        }
        return result;
    }

    public static List<byte[]> toBytesList(Collection<ByteBuffer> bytesList) {
        if (bytesList == null) {
            return null;
        }
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (ByteBuffer bytes : bytesList) {
            result.add(ByteBufferUtil.toBytes(bytes));
        }
        return result;
    }

    public static String toString(ByteBuffer bytes) {
        return new String(bytes.array(), bytes.position(), bytes.remaining(), Constants.UTF8);
    }

    public static ByteBuffer toByteBuffers(ByteSequence bs) {
        if (bs == null) {
            return null;
        }
        if (bs.isBackedByArray()) {
            return ByteBuffer.wrap(bs.getBackingArray(), bs.offset(), bs.length());
        }
        return ByteBuffer.wrap(bs.toArray());
    }
}

