/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.security;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.vertexium.security.ArrayByteSequence;
import org.vertexium.security.Authorizations;
import org.vertexium.security.BadArgumentException;
import org.vertexium.security.ByteSequence;
import org.vertexium.security.VisibilityEvaluator;
import org.vertexium.security.WritableComparator;

public class ColumnVisibility {
    Node node = null;
    private byte[] expression;
    private static final Node EMPTY_NODE = new Node(NodeType.EMPTY, 0);

    public byte[] getExpression() {
        return this.expression;
    }

    public static Node normalize(Node root, byte[] expression) {
        return ColumnVisibility.normalize(root, expression, new NodeComparator(expression));
    }

    public static Node normalize(Node root, byte[] expression, NodeComparator comparator) {
        if (root.type != NodeType.TERM) {
            TreeSet<Node> rolledUp = new TreeSet<Node>(comparator);
            Iterator<Node> itr = root.children.iterator();
            while (itr.hasNext()) {
                Node c = ColumnVisibility.normalize(itr.next(), expression, comparator);
                if (c.type != root.type) continue;
                rolledUp.addAll(c.children);
                itr.remove();
            }
            rolledUp.addAll(root.children);
            root.children.clear();
            root.children.addAll(rolledUp);
            if (root.children.size() == 1) {
                return root.children.get(0);
            }
        }
        return root;
    }

    public static void stringify(Node root, byte[] expression, StringBuilder out) {
        if (root.type == NodeType.TERM) {
            out.append(new String(expression, root.start, root.end - root.start, StandardCharsets.UTF_8));
        } else {
            String sep = "";
            for (Node c : root.children) {
                boolean parens;
                out.append(sep);
                boolean bl = parens = c.type != NodeType.TERM && root.type != c.type;
                if (parens) {
                    out.append("(");
                }
                ColumnVisibility.stringify(c, expression, out);
                if (parens) {
                    out.append(")");
                }
                sep = root.type == NodeType.AND ? "&" : "|";
            }
        }
    }

    public byte[] flatten() {
        Node normRoot = ColumnVisibility.normalize(this.node, this.expression);
        StringBuilder builder = new StringBuilder(this.expression.length);
        ColumnVisibility.stringify(normRoot, this.expression, builder);
        return builder.toString().getBytes(StandardCharsets.UTF_8);
    }

    private void validate(byte[] expression) {
        if (expression != null && expression.length > 0) {
            ColumnVisibilityParser p = new ColumnVisibilityParser();
            this.node = p.parse(expression);
        } else {
            this.node = EMPTY_NODE;
        }
        this.expression = expression;
    }

    public ColumnVisibility() {
        this(new byte[0]);
    }

    public ColumnVisibility(String expression) {
        this(expression.getBytes(StandardCharsets.UTF_8));
    }

    public ColumnVisibility(byte[] expression) {
        this.validate(expression);
    }

    public String toString() {
        return "[" + new String(this.expression, StandardCharsets.UTF_8) + "]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof ColumnVisibility) {
            return this.equals((ColumnVisibility)obj);
        }
        return false;
    }

    public boolean equals(ColumnVisibility otherLe) {
        return Arrays.equals(this.expression, otherLe.expression);
    }

    public int hashCode() {
        return Arrays.hashCode(this.expression);
    }

    public Node getParseTree() {
        return this.node;
    }

    public static String quote(String term) {
        return new String(ColumnVisibility.quote(term.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public static byte[] quote(byte[] term) {
        boolean needsQuote = false;
        for (int i = 0; i < term.length; ++i) {
            if (Authorizations.isValidAuthChar(term[i])) continue;
            needsQuote = true;
            break;
        }
        if (!needsQuote) {
            return term;
        }
        return VisibilityEvaluator.escape(term, true);
    }

    private static class ColumnVisibilityParser {
        private int index = 0;
        private int parens = 0;

        Node parse(byte[] expression) {
            if (expression.length > 0) {
                Node node = this.parseExpression(expression);
                if (this.index < expression.length) {
                    throw new BadArgumentException("invalid end of statement", new String(expression, StandardCharsets.UTF_8), this.index - 1);
                }
                if (node == null) {
                    throw new BadArgumentException("operator or missing parens", new String(expression, StandardCharsets.UTF_8), this.index - 1);
                }
                if (this.parens != 0) {
                    throw new BadArgumentException("parenthesis mis-match", new String(expression, StandardCharsets.UTF_8), this.index - 1);
                }
                return node;
            }
            return null;
        }

        private Node parseExpression(byte[] expression) {
            return this.parseLogicalExpression(expression);
        }

        private Node parseLogicalExpression(byte[] expression) {
            Node result;
            int start = this.index;
            Node left = this.parseNotExpression(expression);
            if (this.index >= expression.length) {
                return left;
            }
            byte op = expression[this.index];
            if (op == 38) {
                result = new Node(NodeType.AND, start);
            } else if (op == 124) {
                result = new Node(NodeType.OR, start);
            } else {
                return left;
            }
            ++this.index;
            result.add(left);
            Node right = this.parseExpression(expression);
            if (!right.paren) {
                if (right.type == NodeType.AND && result.type == NodeType.OR) {
                    throw new BadArgumentException("logical operator mis-match", new String(expression, StandardCharsets.UTF_8), this.index - 1);
                }
                if (right.type == NodeType.OR && result.type == NodeType.AND) {
                    throw new BadArgumentException("logical operator mis-match", new String(expression, StandardCharsets.UTF_8), this.index - 1);
                }
            }
            result.add(right);
            result.end = this.index;
            return result;
        }

        private Node parseNotExpression(byte[] expression) {
            int start = this.index;
            if (this.index < expression.length && expression[this.index] == 33) {
                ++this.index;
                Node result = new Node(NodeType.NOT, start);
                result.add(this.parseNotExpression(expression));
                return result;
            }
            return this.parsePrimary(expression);
        }

        private Node parsePrimary(byte[] expression) {
            if (this.index < expression.length && expression[this.index] == 40) {
                ++this.index;
                Node result = this.parseExpression(expression);
                result.paren = true;
                if (this.index >= expression.length || expression[this.index] != 41) {
                    throw new BadArgumentException("Missing ending ')'", new String(expression, StandardCharsets.UTF_8), this.index);
                }
                ++this.index;
                return result;
            }
            return this.parseTerm(expression);
        }

        private Node parseTerm(byte[] expression) {
            int start = this.index;
            while (this.index < expression.length) {
                byte c = expression[this.index];
                if (c == 34) {
                    ++this.index;
                    while (this.index < expression.length) {
                        c = expression[this.index];
                        if (c == 92) {
                            ++this.index;
                        } else if (c == 34) {
                            ++this.index;
                            if (this.index - start <= 2) {
                                throw new BadArgumentException("empty term", new String(expression, StandardCharsets.UTF_8), start);
                            }
                            return new Node(start, this.index);
                        }
                        ++this.index;
                    }
                    throw new BadArgumentException("unterminated quotes", new String(expression, StandardCharsets.UTF_8), start);
                }
                if (!Authorizations.isValidAuthChar(c)) break;
                ++this.index;
            }
            if (start == this.index) {
                throw new BadArgumentException("missing term", new String(expression, StandardCharsets.UTF_8), start);
            }
            return new Node(start, this.index);
        }
    }

    public static class NodeComparator
    implements Comparator<Node>,
    Serializable {
        private static final long serialVersionUID = 1L;
        byte[] text;

        public NodeComparator(byte[] text) {
            this.text = text;
        }

        @Override
        public int compare(Node a, Node b) {
            int diff = a.type.ordinal() - b.type.ordinal();
            if (diff != 0) {
                return diff;
            }
            switch (a.type) {
                case EMPTY: {
                    return 0;
                }
                case TERM: {
                    return WritableComparator.compareBytes(this.text, a.start, a.end - a.start, this.text, b.start, b.end - b.start);
                }
                case OR: 
                case AND: {
                    diff = a.children.size() - b.children.size();
                    if (diff != 0) {
                        return diff;
                    }
                    for (int i = 0; i < a.children.size(); ++i) {
                        diff = this.compare(a.children.get(i), b.children.get(i));
                        if (diff == 0) continue;
                        return diff;
                    }
                    break;
                }
            }
            return 0;
        }
    }

    public static class Node {
        public static final List<Node> EMPTY = Collections.emptyList();
        boolean paren;
        NodeType type;
        int start;
        int end;
        List<Node> children = EMPTY;

        public Node(NodeType type, int start) {
            this.type = type;
            this.start = start;
            this.end = start + 1;
        }

        public Node(int start, int end) {
            this.type = NodeType.TERM;
            this.start = start;
            this.end = end;
        }

        public void add(Node child) {
            if (this.children == EMPTY) {
                this.children = new ArrayList<Node>();
            }
            this.children.add(child);
        }

        public NodeType getType() {
            return this.type;
        }

        public List<Node> getChildren() {
            return this.children;
        }

        public int getTermStart() {
            return this.start;
        }

        public int getTermEnd() {
            return this.end;
        }

        public ByteSequence getTerm(byte[] expression) {
            if (this.type != NodeType.TERM) {
                throw new RuntimeException();
            }
            if (expression[this.start] == 34) {
                int qStart = this.start + 1;
                int qEnd = this.end - 1;
                return new ArrayByteSequence(expression, qStart, qEnd - qStart);
            }
            return new ArrayByteSequence(expression, this.start, this.end - this.start);
        }
    }

    public static enum NodeType {
        EMPTY,
        TERM,
        OR,
        AND,
        NOT;

    }
}

