/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.test;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.vertexium.Authorizations;
import org.vertexium.DateOnly;
import org.vertexium.DefaultGraphVisitor;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.EdgeBuilder;
import org.vertexium.EdgeVertexPair;
import org.vertexium.EdgeVertices;
import org.vertexium.Element;
import org.vertexium.ElementBuilder;
import org.vertexium.ElementFilter;
import org.vertexium.ElementType;
import org.vertexium.ExtendedDataRow;
import org.vertexium.ExtendedDataRowId;
import org.vertexium.FetchHint;
import org.vertexium.FindPathOptions;
import org.vertexium.Graph;
import org.vertexium.GraphVisitor;
import org.vertexium.GraphWithSearchIndex;
import org.vertexium.HasTimestamp;
import org.vertexium.HistoricalPropertyValue;
import org.vertexium.IdFetchHint;
import org.vertexium.Metadata;
import org.vertexium.Path;
import org.vertexium.Property;
import org.vertexium.Range;
import org.vertexium.RelatedEdgeImpl;
import org.vertexium.SecurityVertexiumException;
import org.vertexium.TextIndexHint;
import org.vertexium.Vertex;
import org.vertexium.VertexBuilder;
import org.vertexium.VertexiumException;
import org.vertexium.VertexiumNotSupportedException;
import org.vertexium.Visibility;
import org.vertexium.event.AddEdgeEvent;
import org.vertexium.event.AddExtendedDataEvent;
import org.vertexium.event.AddPropertyEvent;
import org.vertexium.event.AddVertexEvent;
import org.vertexium.event.DeleteEdgeEvent;
import org.vertexium.event.DeleteExtendedDataEvent;
import org.vertexium.event.DeletePropertyEvent;
import org.vertexium.event.DeleteVertexEvent;
import org.vertexium.event.GraphEvent;
import org.vertexium.event.GraphEventListener;
import org.vertexium.mutation.ElementMutation;
import org.vertexium.mutation.ExistingEdgeMutation;
import org.vertexium.mutation.ExistingElementMutation;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.query.Aggregation;
import org.vertexium.query.CalendarFieldAggregation;
import org.vertexium.query.Compare;
import org.vertexium.query.Contains;
import org.vertexium.query.DefaultGraphQuery;
import org.vertexium.query.DefaultGraphQueryIterable;
import org.vertexium.query.GeoCompare;
import org.vertexium.query.GeohashAggregation;
import org.vertexium.query.GeohashBucket;
import org.vertexium.query.GeohashResult;
import org.vertexium.query.HistogramAggregation;
import org.vertexium.query.HistogramBucket;
import org.vertexium.query.HistogramResult;
import org.vertexium.query.IterableWithTotalHits;
import org.vertexium.query.Percentile;
import org.vertexium.query.PercentilesAggregation;
import org.vertexium.query.PercentilesResult;
import org.vertexium.query.Predicate;
import org.vertexium.query.Query;
import org.vertexium.query.QueryParameters;
import org.vertexium.query.QueryResultsIterable;
import org.vertexium.query.QueryStringQueryParameters;
import org.vertexium.query.QueryableIterable;
import org.vertexium.query.RangeAggregation;
import org.vertexium.query.RangeResult;
import org.vertexium.query.SortDirection;
import org.vertexium.query.StatisticsAggregation;
import org.vertexium.query.StatisticsResult;
import org.vertexium.query.TermsAggregation;
import org.vertexium.query.TermsBucket;
import org.vertexium.query.TermsResult;
import org.vertexium.query.TextPredicate;
import org.vertexium.search.DefaultSearchIndex;
import org.vertexium.search.IndexHint;
import org.vertexium.search.SearchIndex;
import org.vertexium.test.util.IterableUtils;
import org.vertexium.test.util.LargeStringInputStream;
import org.vertexium.test.util.VertexiumAssert;
import org.vertexium.type.GeoCircle;
import org.vertexium.type.GeoCollection;
import org.vertexium.type.GeoHash;
import org.vertexium.type.GeoLine;
import org.vertexium.type.GeoPoint;
import org.vertexium.type.GeoPolygon;
import org.vertexium.type.GeoRect;
import org.vertexium.type.GeoShape;
import org.vertexium.type.IpV4Address;
import org.vertexium.util.ConvertingIterable;
import org.vertexium.util.IncreasingTime;
import org.vertexium.util.StreamUtils;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

@RunWith(value=JUnit4.class)
public abstract class GraphTestBase {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(GraphTestBase.class);
    public static final String VISIBILITY_A_STRING = "a";
    public static final String VISIBILITY_B_STRING = "b";
    public static final String VISIBILITY_C_STRING = "c";
    public static final String VISIBILITY_MIXED_CASE_STRING = "MIXED_CASE_a";
    public static final Visibility VISIBILITY_A = new Visibility("a");
    public static final Visibility VISIBILITY_A_AND_B = new Visibility("a&b");
    public static final Visibility VISIBILITY_B = new Visibility("b");
    public static final Visibility VISIBILITY_C = new Visibility("c");
    public static final Visibility VISIBILITY_MIXED_CASE_a = new Visibility("((MIXED_CASE_a))|b");
    public static final Visibility VISIBILITY_EMPTY = new Visibility("");
    public static final String LABEL_LABEL1 = "label1";
    public static final String LABEL_LABEL2 = "label2";
    public static final String LABEL_LABEL3 = "label3";
    public static final String LABEL_BAD = "bad";
    public final Authorizations AUTHORIZATIONS_A;
    public final Authorizations AUTHORIZATIONS_B;
    public final Authorizations AUTHORIZATIONS_C;
    public final Authorizations AUTHORIZATIONS_MIXED_CASE_a_AND_B;
    public final Authorizations AUTHORIZATIONS_A_AND_B;
    public final Authorizations AUTHORIZATIONS_B_AND_C;
    public final Authorizations AUTHORIZATIONS_EMPTY;
    public final Authorizations AUTHORIZATIONS_BAD;
    public final Authorizations AUTHORIZATIONS_ALL;
    public static final int LARGE_PROPERTY_VALUE_SIZE = 0x100001;
    protected Graph graph;
    @Rule
    public TestRule watcher = new TestWatcher(){

        protected void starting(Description description) {
            System.out.println("Starting test: " + description.getMethodName());
        }
    };

    protected abstract Graph createGraph() throws Exception;

    public Graph getGraph() {
        return this.graph;
    }

    public GraphTestBase() {
        this.AUTHORIZATIONS_A = this.createAuthorizations(VISIBILITY_A_STRING);
        this.AUTHORIZATIONS_B = this.createAuthorizations(VISIBILITY_B_STRING);
        this.AUTHORIZATIONS_C = this.createAuthorizations(VISIBILITY_C_STRING);
        this.AUTHORIZATIONS_A_AND_B = this.createAuthorizations(VISIBILITY_A_STRING, VISIBILITY_B_STRING);
        this.AUTHORIZATIONS_B_AND_C = this.createAuthorizations(VISIBILITY_B_STRING, VISIBILITY_C_STRING);
        this.AUTHORIZATIONS_MIXED_CASE_a_AND_B = this.createAuthorizations(VISIBILITY_MIXED_CASE_STRING, VISIBILITY_B_STRING);
        this.AUTHORIZATIONS_EMPTY = this.createAuthorizations(new String[0]);
        this.AUTHORIZATIONS_BAD = this.createAuthorizations(LABEL_BAD);
        this.AUTHORIZATIONS_ALL = this.createAuthorizations(VISIBILITY_A_STRING, VISIBILITY_B_STRING, VISIBILITY_C_STRING, VISIBILITY_MIXED_CASE_STRING);
    }

    protected abstract Authorizations createAuthorizations(String ... var1);

    protected abstract void addAuthorizations(String ... var1);

    @Before
    public void before() throws Exception {
        this.graph = this.createGraph();
        VertexiumAssert.clearGraphEvents();
        this.graph.addGraphEventListener(new GraphEventListener(){

            public void onGraphEvent(GraphEvent graphEvent) {
                VertexiumAssert.addGraphEvent(graphEvent);
            }
        });
    }

    @After
    public void after() throws Exception {
        if (this.graph != null) {
            this.graph.shutdown();
            this.graph = null;
        }
    }

    @Test
    public void testAddVertexWithId() {
        Vertex vertexAdded = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Assert.assertNotNull((Object)vertexAdded);
        Assert.assertEquals((Object)"v1", (Object)vertexAdded.getId());
        this.graph.flush();
        Vertex v = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"v1", (Object)v.getId());
        Assert.assertEquals((Object)VISIBILITY_A, (Object)v.getVisibility());
        v = this.graph.getVertex("", this.AUTHORIZATIONS_A);
        Assert.assertNull((Object)v);
        v = this.graph.getVertex(null, this.AUTHORIZATIONS_A);
        Assert.assertNull((Object)v);
        VertexiumAssert.assertEvents(new GraphEvent[]{new AddVertexEvent(this.graph, vertexAdded)});
    }

    @Test
    public void testAddVertexWithoutId() {
        Vertex vertexAdded = this.graph.addVertex(VISIBILITY_A, this.AUTHORIZATIONS_A);
        Assert.assertNotNull((Object)vertexAdded);
        String vertexId = vertexAdded.getId();
        Assert.assertNotNull((Object)vertexId);
        this.graph.flush();
        Vertex v = this.graph.getVertex(vertexId, this.AUTHORIZATIONS_A);
        Assert.assertNotNull((Object)v);
        Assert.assertNotNull((Object)vertexId);
        VertexiumAssert.assertEvents(new GraphEvent[]{new AddVertexEvent(this.graph, vertexAdded)});
    }

    @Test
    public void testGetSingleVertexWithSameRowPrefix() {
        this.graph.addVertex("prefix", VISIBILITY_EMPTY, this.AUTHORIZATIONS_EMPTY);
        this.graph.addVertex("prefixA", VISIBILITY_EMPTY, this.AUTHORIZATIONS_EMPTY);
        this.graph.flush();
        Vertex v = this.graph.getVertex("prefix", this.AUTHORIZATIONS_EMPTY);
        Assert.assertEquals((Object)"prefix", (Object)v.getId());
        v = this.graph.getVertex("prefixA", this.AUTHORIZATIONS_EMPTY);
        Assert.assertEquals((Object)"prefixA", (Object)v.getId());
    }

    @Test
    public void testStreamingPropertyValueReadAsString() {
        this.graph.prepareVertex("v1", VISIBILITY_EMPTY).setProperty("spv", (Object)StreamingPropertyValue.create((String)"Hello World"), VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_EMPTY);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_EMPTY);
        Assert.assertEquals((Object)"Hello World", (Object)((StreamingPropertyValue)v1.getPropertyValue("spv")).readToString());
        Assert.assertEquals((Object)"Wor", (Object)((StreamingPropertyValue)v1.getPropertyValue("spv")).readToString(6L, 3L));
        Assert.assertEquals((Object)"", (Object)((StreamingPropertyValue)v1.getPropertyValue("spv")).readToString((long)"Hello World".length(), 1L));
        Assert.assertEquals((Object)"Hello World", (Object)((StreamingPropertyValue)v1.getPropertyValue("spv")).readToString(0L, 100L));
    }

    @Test
    public void testAddStreamingPropertyValue() throws IOException, InterruptedException {
        String expectedLargeValue = IOUtils.toString((InputStream)new LargeStringInputStream(0x100001));
        StreamingPropertyValue propSmall = StreamingPropertyValue.create((InputStream)new ByteArrayInputStream("value1".getBytes()), String.class, (Long)6L);
        StreamingPropertyValue propLarge = StreamingPropertyValue.create((InputStream)new ByteArrayInputStream(expectedLargeValue.getBytes()), String.class, null);
        String largePropertyName = "propLarge/\\*!@#$%^&*()[]{}|";
        Vertex v1 = (Vertex)this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("propSmall", (Object)propSmall, VISIBILITY_A).setProperty(largePropertyName, (Object)propLarge, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Iterable propSmallValues = v1.getPropertyValues("propSmall");
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)propSmallValues));
        Object propSmallValue = propSmallValues.iterator().next();
        Assert.assertTrue((String)("propSmallValue was " + propSmallValue.getClass().getName()), (boolean)(propSmallValue instanceof StreamingPropertyValue));
        StreamingPropertyValue value = (StreamingPropertyValue)propSmallValue;
        Assert.assertEquals(String.class, (Object)value.getValueType());
        Assert.assertEquals((long)"value1".getBytes().length, (long)value.getLength());
        Assert.assertEquals((Object)"value1", (Object)IOUtils.toString((InputStream)value.getInputStream()));
        Assert.assertEquals((Object)"value1", (Object)IOUtils.toString((InputStream)value.getInputStream()));
        Iterable propLargeValues = v1.getPropertyValues(largePropertyName);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)propLargeValues));
        Object propLargeValue = propLargeValues.iterator().next();
        Assert.assertTrue((String)(largePropertyName + " was " + propLargeValue.getClass().getName()), (boolean)(propLargeValue instanceof StreamingPropertyValue));
        value = (StreamingPropertyValue)propLargeValue;
        Assert.assertEquals(String.class, (Object)value.getValueType());
        Assert.assertEquals((long)expectedLargeValue.getBytes().length, (long)value.getLength());
        Assert.assertEquals((Object)expectedLargeValue, (Object)IOUtils.toString((InputStream)value.getInputStream()));
        Assert.assertEquals((Object)expectedLargeValue, (Object)IOUtils.toString((InputStream)value.getInputStream()));
        this.graph.flush();
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        propSmallValues = v1.getPropertyValues("propSmall");
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)propSmallValues));
        propSmallValue = propSmallValues.iterator().next();
        Assert.assertTrue((String)("propSmallValue was " + propSmallValue.getClass().getName()), (boolean)(propSmallValue instanceof StreamingPropertyValue));
        value = (StreamingPropertyValue)propSmallValue;
        Assert.assertEquals(String.class, (Object)value.getValueType());
        Assert.assertEquals((long)"value1".getBytes().length, (long)value.getLength());
        Assert.assertEquals((Object)"value1", (Object)IOUtils.toString((InputStream)value.getInputStream()));
        Assert.assertEquals((Object)"value1", (Object)IOUtils.toString((InputStream)value.getInputStream()));
        propLargeValues = v1.getPropertyValues(largePropertyName);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)propLargeValues));
        propLargeValue = propLargeValues.iterator().next();
        Assert.assertTrue((String)(largePropertyName + " was " + propLargeValue.getClass().getName()), (boolean)(propLargeValue instanceof StreamingPropertyValue));
        value = (StreamingPropertyValue)propLargeValue;
        Assert.assertEquals(String.class, (Object)value.getValueType());
        Assert.assertEquals((long)expectedLargeValue.getBytes().length, (long)value.getLength());
        Assert.assertEquals((Object)expectedLargeValue, (Object)IOUtils.toString((InputStream)value.getInputStream()));
        Assert.assertEquals((Object)expectedLargeValue, (Object)IOUtils.toString((InputStream)value.getInputStream()));
    }

    @Test
    public void testStreamingPropertyValueLargeReads() throws IOException {
        String expectedLargeValue = IOUtils.toString((InputStream)new LargeStringInputStream(0x100001));
        byte[] expectedLargeValueBytes = expectedLargeValue.getBytes();
        StreamingPropertyValue propLarge = StreamingPropertyValue.create((InputStream)new ByteArrayInputStream(expectedLargeValue.getBytes()), String.class);
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("propLarge", (Object)propLarge, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        StreamingPropertyValue prop = (StreamingPropertyValue)v1.getPropertyValue("propLarge");
        byte[] buffer = new byte[0x200002];
        int leftToRead = expectedLargeValueBytes.length;
        InputStream in = prop.getInputStream();
        int expectedOffset = 0;
        while (expectedOffset < expectedLargeValueBytes.length) {
            int sizeRead = in.read(buffer);
            int j = 0;
            while (j < sizeRead) {
                Assert.assertEquals((String)("invalid data at offset " + expectedOffset), (long)expectedLargeValueBytes[expectedOffset], (long)buffer[j]);
                ++j;
                ++expectedOffset;
                --leftToRead;
            }
        }
        Assert.assertEquals((long)0L, (long)leftToRead);
        Assert.assertEquals((long)-1L, (long)in.read(buffer));
    }

    @Test
    public void testStreamingPropertyDecreasingSize() throws IOException {
        Metadata metadata = new Metadata();
        Long timestamp = System.currentTimeMillis();
        String expectedValue = IOUtils.toString((InputStream)new LargeStringInputStream(0x100001));
        StreamingPropertyValue propLarge = StreamingPropertyValue.create((InputStream)new ByteArrayInputStream(expectedValue.getBytes()), String.class, (Long)Long.valueOf(expectedValue.length()));
        this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("key1", "largeProp", (Object)propLarge, metadata, timestamp, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B);
        StreamingPropertyValue spv = (StreamingPropertyValue)v1.getPropertyValue("key1", "largeProp");
        Assert.assertEquals((Object)expectedValue, (Object)spv.readToString());
        expectedValue = "small";
        propLarge = StreamingPropertyValue.create((InputStream)new ByteArrayInputStream(expectedValue.getBytes()), String.class, (Long)Long.valueOf(expectedValue.length()));
        this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("key1", "largeProp", (Object)propLarge, metadata, Long.valueOf(timestamp + 1L), VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B);
        spv = (StreamingPropertyValue)v1.getPropertyValue("key1", "largeProp");
        Assert.assertEquals((Object)expectedValue, (Object)spv.readToString());
    }

    protected boolean isInputStreamMarkResetSupported() {
        return true;
    }

    @Test
    public void testStreamingPropertyValueMarkReset() throws IOException {
        Assume.assumeTrue((String)"InputStream mark/reset is not supported", (boolean)this.isInputStreamMarkResetSupported());
        String expectedLargeValue = "abcdefghijk";
        StreamingPropertyValue propLarge = StreamingPropertyValue.create((InputStream)new ByteArrayInputStream(expectedLargeValue.getBytes()), String.class);
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("propLarge", (Object)propLarge, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        StreamingPropertyValue prop = (StreamingPropertyValue)v1.getPropertyValue("propLarge");
        InputStream in = prop.getInputStream();
        byte[] buffer = new byte[15];
        int sizeRead = in.read(buffer);
        Assert.assertEquals((long)11L, (long)sizeRead);
        Assert.assertEquals((Object)"abcdefghijk", (Object)new String(buffer, 0, sizeRead));
        in.reset();
        buffer = new byte[3];
        sizeRead = in.read(buffer);
        Assert.assertEquals((long)3L, (long)sizeRead);
        Assert.assertEquals((Object)"abc", (Object)new String(buffer, 0, sizeRead));
        Assert.assertEquals((long)100L, (long)((char)in.read()));
        Assert.assertEquals((long)101L, (long)((char)in.read()));
        in.mark(32);
        buffer = new byte[5];
        sizeRead = in.read(buffer);
        Assert.assertEquals((long)5L, (long)sizeRead);
        Assert.assertEquals((Object)"fghij", (Object)new String(buffer, 0, sizeRead));
        in.reset();
        buffer = new byte[10];
        sizeRead = in.read(buffer);
        Assert.assertEquals((long)6L, (long)sizeRead);
        Assert.assertEquals((Object)"fghijk", (Object)new String(buffer, 0, sizeRead));
        Assert.assertEquals((long)-1L, (long)in.read(buffer));
        in.reset();
        buffer = new byte[10];
        sizeRead = in.read(buffer);
        Assert.assertEquals((long)6L, (long)sizeRead);
        Assert.assertEquals((Object)"fghijk", (Object)new String(buffer, 0, sizeRead));
    }

    @Test
    public void testStreamingPropertyValueMarkResetLargeReads() throws IOException {
        Assume.assumeTrue((String)"InputStream mark/reset is not supported", (boolean)this.isInputStreamMarkResetSupported());
        String expectedLargeValue = IOUtils.toString((InputStream)new LargeStringInputStream(0x100001));
        byte[] expectedLargeValueBytes = expectedLargeValue.getBytes();
        StreamingPropertyValue propLarge = StreamingPropertyValue.create((InputStream)new ByteArrayInputStream(expectedLargeValue.getBytes()), String.class);
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("propLarge", (Object)propLarge, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        StreamingPropertyValue prop = (StreamingPropertyValue)v1.getPropertyValue("propLarge");
        InputStream in = prop.getInputStream();
        byte[] buffer = null;
        for (int amountToRead = expectedLargeValueBytes.length - 8; amountToRead > 0; amountToRead -= in.read(buffer)) {
            buffer = new byte[amountToRead];
        }
        Assert.assertEquals((long)expectedLargeValue.charAt(expectedLargeValue.length() - 9), (long)((char)buffer[buffer.length - 1]));
        in.mark(32);
        buffer = new byte[2];
        int sizeRead = in.read(buffer);
        Assert.assertEquals((long)2L, (long)sizeRead);
        Assert.assertEquals((long)expectedLargeValue.charAt(expectedLargeValue.length() - 8), (long)((char)buffer[0]));
        Assert.assertEquals((long)expectedLargeValue.charAt(expectedLargeValue.length() - 7), (long)((char)buffer[1]));
        Assert.assertEquals((long)expectedLargeValue.charAt(expectedLargeValue.length() - 6), (long)((char)in.read()));
        in.reset();
        sizeRead = in.read(buffer);
        Assert.assertEquals((long)2L, (long)sizeRead);
        Assert.assertEquals((long)expectedLargeValue.charAt(expectedLargeValue.length() - 8), (long)((char)buffer[0]));
    }

    @Test
    public void testStreamingPropertyValueResetMutlipleLargeReadsUntilEnd() throws IOException {
        Assume.assumeTrue((String)"InputStream mark/reset is not supported", (boolean)this.isInputStreamMarkResetSupported());
        String expectedLargeValue = IOUtils.toString((InputStream)new LargeStringInputStream(0x100001));
        byte[] expectedLargeValueBytes = expectedLargeValue.getBytes();
        StreamingPropertyValue propLarge = StreamingPropertyValue.create((InputStream)new ByteArrayInputStream(expectedLargeValue.getBytes()), String.class);
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("propLarge", (Object)propLarge, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        StreamingPropertyValue prop = (StreamingPropertyValue)v1.getPropertyValue("propLarge");
        InputStream in = prop.getInputStream();
        in.mark(2);
        for (int i = 0; i < 3; ++i) {
            int totalBytesRead = 0;
            while (in.read() >= 0) {
                Assert.assertTrue((String)"Read past end of input stream", (++totalBytesRead <= expectedLargeValueBytes.length ? 1 : 0) != 0);
            }
            Assert.assertEquals((String)("Read unexpected number of bytes on loop: " + i), (long)expectedLargeValueBytes.length, (long)totalBytesRead);
            Assert.assertEquals((long)-1L, (long)in.read());
            in.reset();
        }
    }

    @Test
    public void testAddVertexPropertyWithMetadata() {
        Metadata prop1Metadata = new Metadata();
        prop1Metadata.add("metadata1", (Object)"metadata1Value", VISIBILITY_A);
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("prop1", (Object)"value1", prop1Metadata, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        final AtomicInteger vertexCount = new AtomicInteger();
        final AtomicInteger vertexPropertyCount = new AtomicInteger();
        this.graph.visitElements((GraphVisitor)new DefaultGraphVisitor(){

            public void visitVertex(Vertex vertex) {
                vertexCount.incrementAndGet();
            }

            public void visitProperty(Element element, Property property) {
                vertexPropertyCount.incrementAndGet();
            }
        }, this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)1L, (long)vertexCount.get());
        Assert.assertEquals((long)1L, (long)vertexPropertyCount.get());
        Vertex v = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_A);
        if (v instanceof HasTimestamp) {
            Assert.assertTrue((String)"timestamp should be more than 0", (v.getTimestamp() > 0L ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v.getProperties("prop1")));
        Property prop1 = (Property)v.getProperties("prop1").iterator().next();
        if (prop1 instanceof HasTimestamp) {
            Assert.assertTrue((String)"timestamp should be more than 0", (prop1.getTimestamp() > 0L ? 1 : 0) != 0);
        }
        prop1Metadata = prop1.getMetadata();
        Assert.assertNotNull((Object)prop1Metadata);
        Assert.assertEquals((long)1L, (long)prop1Metadata.entrySet().size());
        Assert.assertEquals((Object)"metadata1Value", (Object)prop1Metadata.getEntry("metadata1", VISIBILITY_A).getValue());
        prop1Metadata.add("metadata2", (Object)"metadata2Value", VISIBILITY_A);
        v.prepareMutation().setProperty("prop1", (Object)"value1", prop1Metadata, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v.getProperties("prop1")));
        prop1 = (Property)v.getProperties("prop1").iterator().next();
        prop1Metadata = prop1.getMetadata();
        Assert.assertEquals((long)2L, (long)prop1Metadata.entrySet().size());
        Assert.assertEquals((Object)"metadata1Value", (Object)prop1Metadata.getEntry("metadata1", VISIBILITY_A).getValue());
        Assert.assertEquals((Object)"metadata2Value", (Object)prop1Metadata.getEntry("metadata2", VISIBILITY_A).getValue());
        prop1Metadata = new Metadata();
        v.setProperty("prop1", (Object)"value2", prop1Metadata, VISIBILITY_A, this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v.getProperties("prop1")));
        prop1 = (Property)v.getProperties("prop1").iterator().next();
        Assert.assertEquals((Object)"value2", (Object)prop1.getValue());
        prop1Metadata = prop1.getMetadata();
        Assert.assertEquals((long)0L, (long)prop1Metadata.entrySet().size());
    }

    @Test
    public void testAddVertexWithProperties() {
        Vertex vertexAdded = (Vertex)this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("prop1", (Object)"value1", VISIBILITY_A).setProperty("prop2", (Object)"value2", VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertexAdded.getProperties("prop1")));
        Assert.assertEquals((Object)"value1", vertexAdded.getPropertyValues("prop1").iterator().next());
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertexAdded.getProperties("prop2")));
        Assert.assertEquals((Object)"value2", vertexAdded.getPropertyValues("prop2").iterator().next());
        this.graph.flush();
        Vertex v = this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v.getProperties("prop1")));
        Assert.assertEquals((Object)"value1", v.getPropertyValues("prop1").iterator().next());
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v.getProperties("prop2")));
        Assert.assertEquals((Object)"value2", v.getPropertyValues("prop2").iterator().next());
        VertexiumAssert.assertEvents(new GraphEvent[]{new AddVertexEvent(this.graph, vertexAdded), new AddPropertyEvent(this.graph, (Element)vertexAdded, vertexAdded.getProperty("prop1")), new AddPropertyEvent(this.graph, (Element)vertexAdded, vertexAdded.getProperty("prop2"))});
        VertexiumAssert.clearGraphEvents();
        v = this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B);
        vertexAdded = (Vertex)v.prepareMutation().addPropertyValue("key1", "prop1Mutation", (Object)"value1Mutation", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v = this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v.getProperties("prop1Mutation")));
        Assert.assertEquals((Object)"value1Mutation", v.getPropertyValues("prop1Mutation").iterator().next());
        VertexiumAssert.assertEvents(new GraphEvent[]{new AddPropertyEvent(this.graph, (Element)vertexAdded, vertexAdded.getProperty("prop1Mutation"))});
    }

    @Test
    public void testNullPropertyValue() {
        try {
            this.graph.prepareVertex("v1", VISIBILITY_EMPTY).setProperty("prop1", null, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
            throw new VertexiumException("expected null check");
        }
        catch (NullPointerException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("prop1"));
            return;
        }
    }

    @Test
    public void testConcurrentModificationOfProperties() {
        Vertex v = (Vertex)this.graph.prepareVertex("v1", VISIBILITY_EMPTY).setProperty("prop1", (Object)"value1", VISIBILITY_A).setProperty("prop2", (Object)"value2", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        int i = 0;
        for (Property p : v.getProperties()) {
            Assert.assertNotNull((Object)p.toString());
            if (i == 0) {
                v.setProperty("prop3", (Object)"value3", VISIBILITY_A, this.AUTHORIZATIONS_A_AND_B);
            }
            ++i;
        }
    }

    @Test
    public void testAddVertexWithPropertiesWithTwoDifferentVisibilities() {
        Vertex v = (Vertex)this.graph.prepareVertex("v1", VISIBILITY_EMPTY).setProperty("prop1", (Object)"value1a", VISIBILITY_A).setProperty("prop1", (Object)"value1b", VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)v.getProperties("prop1")));
        this.graph.flush();
        v = this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B);
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)v.getProperties("prop1")));
        v = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v.getProperties("prop1")));
        Assert.assertEquals((Object)"value1a", (Object)v.getPropertyValue("prop1"));
        v = this.graph.getVertex("v1", this.AUTHORIZATIONS_B);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v.getProperties("prop1")));
        Assert.assertEquals((Object)"value1b", (Object)v.getPropertyValue("prop1"));
    }

    @Test
    public void testMultivaluedProperties() {
        Vertex v = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        v.prepareMutation().addPropertyValue("propid1a", "prop1", (Object)"value1a", VISIBILITY_A).addPropertyValue("propid2a", "prop2", (Object)"value2a", VISIBILITY_A).addPropertyValue("propid3a", "prop3", (Object)"value3a", VISIBILITY_A).save(this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        v = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertEquals((Object)"value1a", v.getPropertyValues("prop1").iterator().next());
        Assert.assertEquals((Object)"value2a", v.getPropertyValues("prop2").iterator().next());
        Assert.assertEquals((Object)"value3a", v.getPropertyValues("prop3").iterator().next());
        Assert.assertEquals((long)3L, (long)org.vertexium.util.IterableUtils.count((Iterable)v.getProperties()));
        v.prepareMutation().addPropertyValue("propid1a", "prop1", (Object)"value1b", VISIBILITY_A).addPropertyValue("propid2a", "prop2", (Object)"value2b", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v.getPropertyValues("prop1")));
        Assert.assertEquals((Object)"value1b", v.getPropertyValues("prop1").iterator().next());
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v.getPropertyValues("prop2")));
        Assert.assertEquals((Object)"value2b", v.getPropertyValues("prop2").iterator().next());
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v.getPropertyValues("prop3")));
        Assert.assertEquals((Object)"value3a", v.getPropertyValues("prop3").iterator().next());
        Assert.assertEquals((long)3L, (long)org.vertexium.util.IterableUtils.count((Iterable)v.getProperties()));
        v.addPropertyValue("propid1b", "prop1", (Object)"value1a-new", VISIBILITY_A, this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        IterableUtils.assertContains("value1b", v.getPropertyValues("prop1"));
        IterableUtils.assertContains("value1a-new", v.getPropertyValues("prop1"));
        Assert.assertEquals((long)4L, (long)org.vertexium.util.IterableUtils.count((Iterable)v.getProperties()));
    }

    @Test
    public void testMultivaluedPropertyOrder() {
        this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue(VISIBILITY_A_STRING, "prop", (Object)VISIBILITY_A_STRING, VISIBILITY_A).addPropertyValue("aa", "prop", (Object)"aa", VISIBILITY_A).addPropertyValue(VISIBILITY_B_STRING, "prop", (Object)VISIBILITY_B_STRING, VISIBILITY_A).addPropertyValue("0", "prop", (Object)"0", VISIBILITY_A).addPropertyValue("A", "prop", (Object)"A", VISIBILITY_A).addPropertyValue("Z", "prop", (Object)"Z", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertEquals((Object)"0", (Object)v1.getPropertyValue("prop", 0));
        Assert.assertEquals((Object)"A", (Object)v1.getPropertyValue("prop", 1));
        Assert.assertEquals((Object)"Z", (Object)v1.getPropertyValue("prop", 2));
        Assert.assertEquals((Object)VISIBILITY_A_STRING, (Object)v1.getPropertyValue("prop", 3));
        Assert.assertEquals((Object)"aa", (Object)v1.getPropertyValue("prop", 4));
        Assert.assertEquals((Object)VISIBILITY_B_STRING, (Object)v1.getPropertyValue("prop", 5));
    }

    @Test
    public void testDeleteProperty() {
        Vertex v = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        v.prepareMutation().addPropertyValue("propid1a", "prop1", (Object)"value1a", VISIBILITY_A).addPropertyValue("propid1b", "prop1", (Object)"value1b", VISIBILITY_A).addPropertyValue("propid2a", "prop2", (Object)"value2a", VISIBILITY_A).save(this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        VertexiumAssert.clearGraphEvents();
        v = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_A);
        Property prop1_propid1a = v.getProperty("propid1a", "prop1");
        Property prop1_propid1b = v.getProperty("propid1b", "prop1");
        v.deleteProperties("prop1", this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v.getProperties()));
        v = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v.getProperties()));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("prop2", (Object)"value2a").vertices()));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("prop1", (Object)"value1a").vertices()));
        VertexiumAssert.assertEvents(new GraphEvent[]{new DeletePropertyEvent(this.graph, (Element)v, prop1_propid1a), new DeletePropertyEvent(this.graph, (Element)v, prop1_propid1b)});
        VertexiumAssert.clearGraphEvents();
        Property prop2_propid2a = v.getProperty("propid2a", "prop2");
        v.deleteProperty("propid2a", "prop2", this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)v.getProperties()));
        v = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)v.getProperties()));
        VertexiumAssert.assertEvents(new GraphEvent[]{new DeletePropertyEvent(this.graph, (Element)v, prop2_propid2a)});
    }

    @Test
    public void testDeletePropertyWithMutation() {
        Vertex v1 = (Vertex)this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("propid1a", "prop1", (Object)"value1a", VISIBILITY_A).addPropertyValue("propid1b", "prop1", (Object)"value1b", VISIBILITY_A).addPropertyValue("propid2a", "prop2", (Object)"value2a", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.prepareEdge("e1", v1, v2, LABEL_LABEL1, VISIBILITY_A).addPropertyValue("key1", "prop1", (Object)"value1", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        VertexiumAssert.clearGraphEvents();
        v1 = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_A);
        Property prop1_propid1a = v1.getProperty("propid1a", "prop1");
        Property prop1_propid1b = v1.getProperty("propid1b", "prop1");
        v1.prepareMutation().deleteProperties("prop1").save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getProperties()));
        v1 = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getProperties()));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("prop2", (Object)"value2a").vertices()));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("prop1", (Object)"value1a").vertices()));
        VertexiumAssert.assertEvents(new GraphEvent[]{new DeletePropertyEvent(this.graph, (Element)v1, prop1_propid1a), new DeletePropertyEvent(this.graph, (Element)v1, prop1_propid1b)});
        VertexiumAssert.clearGraphEvents();
        Property prop2_propid2a = v1.getProperty("propid2a", "prop2");
        v1.prepareMutation().deleteProperties("propid2a", "prop2").save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getProperties()));
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getProperties()));
        VertexiumAssert.assertEvents(new GraphEvent[]{new DeletePropertyEvent(this.graph, (Element)v1, prop2_propid2a)});
        VertexiumAssert.clearGraphEvents();
        Edge e1 = this.graph.getEdge("e1", FetchHint.ALL, this.AUTHORIZATIONS_A);
        Property edgeProperty = e1.getProperty("key1", "prop1");
        e1.prepareMutation().deleteProperties("key1", "prop1").save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)e1.getProperties()));
        e1 = this.graph.getEdge("e1", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)e1.getProperties()));
        VertexiumAssert.assertEvents(new GraphEvent[]{new DeletePropertyEvent(this.graph, (Element)e1, edgeProperty)});
    }

    @Test
    public void testDeleteElement() {
        Vertex v = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        v.prepareMutation().setProperty("prop1", (Object)"value1", VISIBILITY_A).save(this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        v = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("prop1", (Object)"value1").vertices()));
        this.graph.deleteVertex(v.getId(), this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertNull((Object)v);
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("prop1", (Object)"value1").vertices()));
    }

    @Test
    public void testDeleteVertex() {
        this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertices(this.AUTHORIZATIONS_A)));
        this.graph.deleteVertex("v1", this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertices(this.AUTHORIZATIONS_A)));
    }

    @Test
    public void testSoftDeleteVertex() {
        this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("key1", "name1", (Object)"value1", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("v2", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareEdge("e1", "v1", "v2", LABEL_LABEL1, VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertices(this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("name1", (Object)"value1").vertices()));
        Vertex v2 = this.graph.getVertex("v2", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)1L, (long)v2.getEdgeCount(Direction.BOTH, this.AUTHORIZATIONS_A));
        this.graph.softDeleteVertex("v1", this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertices(this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("name1", (Object)"value1").vertices()));
        v2 = this.graph.getVertex("v2", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)0L, (long)v2.getEdgeCount(Direction.BOTH, this.AUTHORIZATIONS_A));
        this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("key1", "name1", (Object)"value1", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("v3", VISIBILITY_A).addPropertyValue("key1", "name1", (Object)"value1", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("v4", VISIBILITY_A).addPropertyValue("key1", "name1", (Object)"value1", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertEquals((long)4L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertices(this.AUTHORIZATIONS_A)));
        VertexiumAssert.assertResultsCount(3, (QueryResultsIterable<? extends Element>)this.graph.query(this.AUTHORIZATIONS_A).has("name1", (Object)"value1").vertices());
        this.graph.softDeleteVertex("v3", this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertEquals((long)3L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertices(this.AUTHORIZATIONS_A)));
        VertexiumAssert.assertResultsCount(2, (QueryResultsIterable<? extends Element>)this.graph.query(this.AUTHORIZATIONS_A).has("name1", (Object)"value1").vertices());
    }

    @Test
    public void testReAddingSoftDeletedVertex() {
        Vertex v1 = this.graph.prepareVertex("v1", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertEquals((Object)VISIBILITY_A.getVisibilityString(), (Object)v1.getVisibility().getVisibilityString());
        this.graph.softDeleteVertex(v1, this.AUTHORIZATIONS_A);
        this.graph.flush();
        this.graph.prepareVertex("v1", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertNotNull((Object)v1);
        Assert.assertEquals((Object)VISIBILITY_A.getVisibilityString(), (Object)v1.getVisibility().getVisibilityString());
        this.graph.softDeleteVertex(v1, this.AUTHORIZATIONS_A);
        this.graph.flush();
        this.graph.prepareVertex("v1", VISIBILITY_A_AND_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B);
        Assert.assertNotNull((Object)v1);
        Assert.assertEquals((Object)VISIBILITY_A_AND_B.getVisibilityString(), (Object)v1.getVisibility().getVisibilityString());
        this.graph.softDeleteVertex(v1, this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        this.graph.addVertex("v1", VISIBILITY_EMPTY, this.AUTHORIZATIONS_EMPTY);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B);
        Assert.assertNotNull((Object)v1);
        Assert.assertEquals((Object)VISIBILITY_EMPTY.getVisibilityString(), (Object)v1.getVisibility().getVisibilityString());
    }

    @Test
    public void testGetSoftDeletedElementWithFetchHintsAndTimestamp() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Edge e1 = this.graph.addEdge("e1", v1, v2, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.flush();
        long beforeDeleteTime = IncreasingTime.currentTimeMillis();
        this.graph.softDeleteEdge(e1, this.AUTHORIZATIONS_A);
        this.graph.softDeleteVertex(v1, this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertNull((Object)this.graph.getEdge(e1.getId(), this.AUTHORIZATIONS_A));
        Assert.assertNull((Object)this.graph.getEdge(e1.getId(), this.graph.getDefaultFetchHints(), this.AUTHORIZATIONS_A));
        Assert.assertNull((Object)this.graph.getEdge(e1.getId(), FetchHint.ALL_INCLUDING_HIDDEN, this.AUTHORIZATIONS_A));
        Assert.assertNull((Object)this.graph.getVertex(v1.getId(), this.AUTHORIZATIONS_A));
        Assert.assertNull((Object)this.graph.getVertex(v1.getId(), this.graph.getDefaultFetchHints(), this.AUTHORIZATIONS_A));
        Assert.assertNull((Object)this.graph.getVertex(v1.getId(), FetchHint.ALL_INCLUDING_HIDDEN, this.AUTHORIZATIONS_A));
        Assert.assertNotNull((Object)this.graph.getEdge(e1.getId(), this.graph.getDefaultFetchHints(), Long.valueOf(beforeDeleteTime), this.AUTHORIZATIONS_A));
        Assert.assertNotNull((Object)this.graph.getEdge(e1.getId(), FetchHint.ALL_INCLUDING_HIDDEN, Long.valueOf(beforeDeleteTime), this.AUTHORIZATIONS_A));
        Assert.assertNotNull((Object)this.graph.getVertex(v1.getId(), this.graph.getDefaultFetchHints(), Long.valueOf(beforeDeleteTime), this.AUTHORIZATIONS_A));
        Assert.assertNotNull((Object)this.graph.getVertex(v1.getId(), FetchHint.ALL_INCLUDING_HIDDEN, Long.valueOf(beforeDeleteTime), this.AUTHORIZATIONS_A));
    }

    @Test
    public void testSoftDeleteEdge() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A_AND_B);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_B, this.AUTHORIZATIONS_A_AND_B);
        Vertex v3 = this.graph.addVertex("v3", VISIBILITY_B, this.AUTHORIZATIONS_A_AND_B);
        this.graph.addEdge("e1", v1, v2, LABEL_LABEL1, VISIBILITY_B, this.AUTHORIZATIONS_A_AND_B);
        this.graph.addEdge("e2", v1, v3, LABEL_LABEL1, VISIBILITY_B, this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Edge e1 = this.graph.getEdge("e1", this.AUTHORIZATIONS_A_AND_B);
        this.graph.softDeleteEdge(e1, this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getEdgeIds(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getEdges(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getVertexIds(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B)));
        v1 = this.graph.getVertex("v1", FetchHint.ALL_INCLUDING_HIDDEN, this.AUTHORIZATIONS_A_AND_B);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getEdgeIds(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getEdges(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getVertexIds(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B)));
        v2 = this.graph.getVertex("v2", this.AUTHORIZATIONS_A_AND_B);
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)v2.getEdgeIds(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B)));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)v2.getEdges(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B)));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)v2.getVertexIds(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B)));
        v2 = this.graph.getVertex("v2", FetchHint.ALL_INCLUDING_HIDDEN, this.AUTHORIZATIONS_A_AND_B);
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)v2.getEdgeIds(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B)));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)v2.getEdges(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B)));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)v2.getVertexIds(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B)));
        v3 = this.graph.getVertex("v3", this.AUTHORIZATIONS_A_AND_B);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v3.getEdgeIds(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v3.getEdges(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v3.getVertexIds(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B)));
        v3 = this.graph.getVertex("v3", FetchHint.ALL_INCLUDING_HIDDEN, this.AUTHORIZATIONS_A_AND_B);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v3.getEdgeIds(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v3.getEdges(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v3.getVertexIds(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B)));
    }

    @Test
    public void testSoftDeleteProperty() throws InterruptedException {
        this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("key1", "name1", (Object)"value1", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A).getProperties()));
        VertexiumAssert.assertResultsCount(1, (QueryResultsIterable<? extends Element>)this.graph.query(this.AUTHORIZATIONS_A).has("name1", (Object)"value1").vertices());
        this.graph.getVertex("v1", this.AUTHORIZATIONS_A).softDeleteProperties("name1", this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A).getProperties()));
        VertexiumAssert.assertResultsCount(0, (QueryResultsIterable<? extends Element>)this.graph.query(this.AUTHORIZATIONS_A).has("name1", (Object)"value1").vertices());
        this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("key1", "name1", (Object)"value1", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A).getProperties()));
        VertexiumAssert.assertResultsCount(1, (QueryResultsIterable<? extends Element>)this.graph.query(this.AUTHORIZATIONS_A).has("name1", (Object)"value1").vertices());
        this.graph.getVertex("v1", this.AUTHORIZATIONS_A).softDeleteProperties("name1", this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A).getProperties()));
        VertexiumAssert.assertResultsCount(0, (QueryResultsIterable<? extends Element>)this.graph.query(this.AUTHORIZATIONS_A).has("name1", (Object)"value1").vertices());
    }

    @Test
    public void testSoftDeletePropertyThroughMutation() {
        this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("key1", "name1", (Object)"value1", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A).getProperties()));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("name1", (Object)"value1").vertices()));
        this.graph.getVertex("v1", this.AUTHORIZATIONS_A).prepareMutation().softDeleteProperties("name1").save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A).getProperties()));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("name1", (Object)"value1").vertices()));
        this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("key1", "name1", (Object)"value1", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A).getProperties()));
        VertexiumAssert.assertResultsCount(1, (QueryResultsIterable<? extends Element>)this.graph.query(this.AUTHORIZATIONS_A).has("name1", (Object)"value1").vertices());
        this.graph.getVertex("v1", this.AUTHORIZATIONS_A).prepareMutation().softDeleteProperties("name1").save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A).getProperties()));
        VertexiumAssert.assertResultsCount(0, (QueryResultsIterable<? extends Element>)this.graph.query(this.AUTHORIZATIONS_A).has("name1", (Object)"value1").vertices());
    }

    @Test
    public void testSoftDeletePropertyOnEdgeNotIndexed() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A_AND_B);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_B, this.AUTHORIZATIONS_A_AND_B);
        ElementBuilder elementBuilder = this.graph.prepareEdge("e1", v1, v2, LABEL_LABEL1, VISIBILITY_B).setProperty("prop1", (Object)"value1", VISIBILITY_B);
        elementBuilder.setIndexHint(IndexHint.DO_NOT_INDEX);
        Edge e1 = (Edge)elementBuilder.save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        ExistingEdgeMutation m = e1.prepareMutation();
        m.softDeleteProperty("prop1", VISIBILITY_B);
        m.setIndexHint(IndexHint.DO_NOT_INDEX);
        m.save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        e1 = this.graph.getEdge("e1", this.AUTHORIZATIONS_A_AND_B);
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)e1.getProperties()));
    }

    @Test
    public void testSoftDeletePropertyWithVisibility() {
        Vertex v1 = (Vertex)this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("key1", "name1", (Object)"value1", VISIBILITY_A).addPropertyValue("key1", "name1", (Object)"value2", VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B).getProperties()));
        IterableUtils.assertContains("value1", v1.getPropertyValues("name1"));
        IterableUtils.assertContains("value2", v1.getPropertyValues("name1"));
        this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B).softDeleteProperty("key1", "name1", VISIBILITY_A, this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B).getProperties()));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B).getPropertyValues("key1", "name1")));
        IterableUtils.assertContains("value2", this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B).getPropertyValues("name1"));
    }

    @Test
    public void testSoftDeletePropertyThroughMutationWithVisibility() {
        Vertex v1 = (Vertex)this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("key1", "name1", (Object)"value1", VISIBILITY_A).addPropertyValue("key1", "name1", (Object)"value2", VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B).getProperties()));
        IterableUtils.assertContains("value1", v1.getPropertyValues("name1"));
        IterableUtils.assertContains("value2", v1.getPropertyValues("name1"));
        v1 = (Vertex)this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B).prepareMutation().softDeleteProperty("key1", "name1", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getProperties()));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getPropertyValues("key1", "name1")));
        IterableUtils.assertContains("value2", v1.getPropertyValues("name1"));
    }

    @Test
    public void testSoftDeletePropertyOnAHiddenVertex() {
        Vertex v1 = (Vertex)this.graph.prepareVertex("v1", VISIBILITY_EMPTY).addPropertyValue("key1", "name1", (Object)"value1", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        this.graph.markVertexHidden(v1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", FetchHint.ALL_INCLUDING_HIDDEN, this.AUTHORIZATIONS_A);
        v1.softDeleteProperty("key1", "name1", this.AUTHORIZATIONS_A);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", FetchHint.ALL_INCLUDING_HIDDEN, this.AUTHORIZATIONS_A);
        Assert.assertNull((Object)v1.getProperty("key1", "name1", VISIBILITY_EMPTY));
    }

    @Test
    public void testMarkHiddenWithVisibilityChange() {
        Vertex v1 = (Vertex)this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("key1", "firstName", (Object)"Joe", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getProperties()));
        IterableUtils.assertContains("Joe", v1.getPropertyValues("firstName"));
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B);
        v1.markPropertyHidden("key1", "firstName", VISIBILITY_A, VISIBILITY_B, this.AUTHORIZATIONS_A_AND_B);
        v1.addPropertyValue("key1", "firstName", (Object)"Joseph", VISIBILITY_B, this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", FetchHint.ALL_INCLUDING_HIDDEN, this.AUTHORIZATIONS_A_AND_B);
        List properties = org.vertexium.util.IterableUtils.toList((Iterable)v1.getProperties());
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)properties));
        boolean foundJoeProp = false;
        boolean foundJosephProp = false;
        for (Property property : properties) {
            if (property.getName().equals("firstName")) {
                if (property.getKey().equals("key1") && property.getValue().equals("Joe")) {
                    foundJoeProp = true;
                    Assert.assertTrue((String)"should be hidden", (boolean)property.isHidden(this.AUTHORIZATIONS_A_AND_B));
                    Assert.assertFalse((String)"should not be hidden", (boolean)property.isHidden(this.AUTHORIZATIONS_A));
                    continue;
                }
                if (property.getKey().equals("key1") && property.getValue().equals("Joseph")) {
                    if (property.getVisibility().equals((Object)VISIBILITY_B)) {
                        foundJosephProp = true;
                        Assert.assertFalse((String)"should not be hidden", (boolean)property.isHidden(this.AUTHORIZATIONS_A_AND_B));
                        continue;
                    }
                    throw new RuntimeException("Unexpected visibility " + property.getVisibility());
                }
                throw new RuntimeException("Unexpected property key " + property.getKey());
            }
            throw new RuntimeException("Unexpected property name " + property.getName());
        }
        Assert.assertTrue((String)"Joseph property value not found", (boolean)foundJosephProp);
        Assert.assertTrue((String)"Joe property value not found", (boolean)foundJoeProp);
    }

    @Test
    public void testSoftDeleteWithVisibilityChanges() {
        Vertex v1 = (Vertex)this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("key1", "firstName", (Object)"Joe", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getProperties()));
        IterableUtils.assertContains("Joe", v1.getPropertyValues("firstName"));
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B);
        v1.markPropertyHidden("key1", "firstName", VISIBILITY_A, VISIBILITY_B, this.AUTHORIZATIONS_A_AND_B);
        v1.addPropertyValue("key1", "firstName", (Object)"Joseph", VISIBILITY_B, this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v1.softDeleteProperty("key1", "firstName", VISIBILITY_B, this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v1.markPropertyVisible("key1", "firstName", VISIBILITY_A, VISIBILITY_B, this.AUTHORIZATIONS_A_AND_B);
        v1.addPropertyValue("key1", "firstName", (Object)"Joseph", VISIBILITY_A, this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        List properties = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B).getProperties());
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)properties));
        Property property = (Property)properties.iterator().next();
        Assert.assertEquals((Object)VISIBILITY_A, (Object)property.getVisibility());
        Assert.assertEquals((Object)"Joseph", (Object)property.getValue());
        Vertex v2 = (Vertex)this.graph.prepareVertex("v2", VISIBILITY_A).addPropertyValue("key1", "firstName", (Object)"Joe", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v2.getProperties()));
        IterableUtils.assertContains("Joe", v2.getPropertyValues("firstName"));
        v2 = this.graph.getVertex("v2", this.AUTHORIZATIONS_A_AND_B);
        v2.markPropertyHidden("key1", "firstName", VISIBILITY_A, VISIBILITY_B, this.AUTHORIZATIONS_A_AND_B);
        v2.addPropertyValue("key1", "firstName", (Object)"Joseph", VISIBILITY_B, this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v2.softDeleteProperty("key1", "firstName", VISIBILITY_B, this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v2.markPropertyVisible("key1", "firstName", VISIBILITY_A, VISIBILITY_B, this.AUTHORIZATIONS_A_AND_B);
        v2.addPropertyValue("key1", "firstName", (Object)"Joe", VISIBILITY_A, this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        properties = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getVertex("v2", this.AUTHORIZATIONS_A_AND_B).getProperties());
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)properties));
        property = (Property)properties.iterator().next();
        Assert.assertEquals((Object)VISIBILITY_A, (Object)property.getVisibility());
        Assert.assertEquals((Object)"Joe", (Object)property.getValue());
    }

    @Test
    public void testMarkPropertyVisible() {
        Vertex v1 = (Vertex)this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("key1", "firstName", (Object)"Joe", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getProperties()));
        IterableUtils.assertContains("Joe", v1.getPropertyValues("firstName"));
        long t = IncreasingTime.currentTimeMillis();
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B);
        v1.markPropertyHidden("key1", "firstName", VISIBILITY_A, Long.valueOf(t), VISIBILITY_B, this.AUTHORIZATIONS_A_AND_B);
        List properties = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getVertex("v1", FetchHint.ALL_INCLUDING_HIDDEN, this.AUTHORIZATIONS_A_AND_B).getProperties());
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)properties));
        long beforeMarkPropertyVisibleTimestamp = t += 10L;
        v1.markPropertyVisible("key1", "firstName", VISIBILITY_A, Long.valueOf(t += 10L), VISIBILITY_B, this.AUTHORIZATIONS_A_AND_B);
        properties = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B).getProperties());
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)properties));
        this.graph.flush();
        v1 = this.graph.getVertex("v1", this.graph.getDefaultFetchHints(), Long.valueOf(beforeMarkPropertyVisibleTimestamp), this.AUTHORIZATIONS_A_AND_B);
        Assert.assertNotNull((String)("could not find v1 before timestamp " + beforeMarkPropertyVisibleTimestamp + " current time " + (t += 10L)), (Object)v1);
        properties = org.vertexium.util.IterableUtils.toList((Iterable)v1.getProperties());
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)properties));
    }

    @Test
    public void testAddVertexWithVisibility() {
        this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        this.graph.addVertex("v2", VISIBILITY_B, this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        Iterable cVertices = this.graph.getVertices(this.AUTHORIZATIONS_C);
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)cVertices));
        Iterable aVertices = this.graph.getVertices(this.AUTHORIZATIONS_A);
        Assert.assertEquals((Object)"v1", (Object)((Vertex)org.vertexium.util.IterableUtils.single((Iterable)aVertices)).getId());
        Iterable bVertices = this.graph.getVertices(this.AUTHORIZATIONS_B);
        Assert.assertEquals((Object)"v2", (Object)((Vertex)org.vertexium.util.IterableUtils.single((Iterable)bVertices)).getId());
        Iterable allVertices = this.graph.getVertices(this.AUTHORIZATIONS_A_AND_B);
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)allVertices));
    }

    @Test
    public void testAddMultipleVertices() {
        ArrayList<ElementBuilder> elements = new ArrayList<ElementBuilder>();
        elements.add(this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("prop1", (Object)"v1", VISIBILITY_A));
        elements.add(this.graph.prepareVertex("v2", VISIBILITY_A).setProperty("prop1", (Object)"v2", VISIBILITY_A));
        Iterable vertices = this.graph.addVertices(elements, this.AUTHORIZATIONS_A_AND_B);
        VertexiumAssert.assertVertexIds(vertices, "v1", "v2");
        this.graph.flush();
        if (this.graph instanceof GraphWithSearchIndex) {
            ((GraphWithSearchIndex)this.graph).getSearchIndex().addElements(this.graph, vertices, this.AUTHORIZATIONS_A_AND_B);
            VertexiumAssert.assertVertexIds((Iterable<Vertex>)this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("prop1", (Object)"v1").vertices(), "v1");
            VertexiumAssert.assertVertexIds((Iterable<Vertex>)this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("prop1", (Object)"v2").vertices(), "v2");
        }
    }

    @Test
    public void testAddExtendedDataRows() {
        this.graph.prepareVertex("v1", VISIBILITY_A).addExtendedData("table1", "row1", "name", (Object)"value1", VISIBILITY_A).addExtendedData("table1", "row2", "name", (Object)"value2", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        if (this.graph instanceof GraphWithSearchIndex) {
            SearchIndex searchIndex = ((GraphWithSearchIndex)this.graph).getSearchIndex();
            searchIndex.truncate(this.graph);
            searchIndex.flush(this.graph);
            Iterable extendedData = this.graph.getExtendedData(ElementType.VERTEX, "v1", "table1", this.AUTHORIZATIONS_A);
            searchIndex.addExtendedData(this.graph, extendedData, this.AUTHORIZATIONS_A);
        }
        QueryResultsIterable rows = this.graph.query(this.AUTHORIZATIONS_A).has("name", (Object)"value1").extendedDataRows();
        VertexiumAssert.assertResultsCount(1, 1, rows);
        ExtendedDataRow row = (ExtendedDataRow)org.vertexium.util.IterableUtils.single((Iterable)rows);
        Assert.assertEquals((Object)"v1", (Object)row.getId().getElementId());
        Assert.assertEquals((Object)"table1", (Object)row.getId().getTableName());
        Assert.assertEquals((Object)"row1", (Object)row.getId().getRowId());
    }

    @Test
    public void testGetVerticesWithIds() {
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("prop1", (Object)"v1", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v1b", VISIBILITY_A).setProperty("prop1", (Object)"v1b", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_A).setProperty("prop1", (Object)"v2", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v3", VISIBILITY_A).setProperty("prop1", (Object)"v3", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add("v2");
        ids.add("v1");
        Iterable vertices = this.graph.getVertices(ids, this.AUTHORIZATIONS_A);
        boolean foundV1 = false;
        boolean foundV2 = false;
        for (Vertex v : vertices) {
            if (v.getId().equals("v1")) {
                Assert.assertEquals((Object)"v1", (Object)v.getPropertyValue("prop1"));
                foundV1 = true;
                continue;
            }
            if (v.getId().equals("v2")) {
                Assert.assertEquals((Object)"v2", (Object)v.getPropertyValue("prop1"));
                foundV2 = true;
                continue;
            }
            Assert.assertTrue((String)("Unexpected vertex id: " + v.getId()), (boolean)false);
        }
        Assert.assertTrue((String)"v1 not found", (boolean)foundV1);
        Assert.assertTrue((String)"v2 not found", (boolean)foundV2);
        List verticesInOrder = this.graph.getVerticesInOrder(ids, this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)2L, (long)verticesInOrder.size());
        Assert.assertEquals((Object)"v2", (Object)((Vertex)verticesInOrder.get(0)).getId());
        Assert.assertEquals((Object)"v1", (Object)((Vertex)verticesInOrder.get(1)).getId());
    }

    @Test
    public void testGetVerticesWithPrefix() {
        this.graph.addVertex(VISIBILITY_A_STRING, VISIBILITY_EMPTY, this.AUTHORIZATIONS_ALL);
        this.graph.addVertex("aa", VISIBILITY_EMPTY, this.AUTHORIZATIONS_ALL);
        this.graph.addVertex("az", VISIBILITY_EMPTY, this.AUTHORIZATIONS_ALL);
        this.graph.addVertex(VISIBILITY_B_STRING, VISIBILITY_EMPTY, this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        List<Vertex> vertices = this.sortById(org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getVerticesWithPrefix(VISIBILITY_A_STRING, this.AUTHORIZATIONS_ALL)));
        VertexiumAssert.assertVertexIds(vertices, VISIBILITY_A_STRING, "aa", "az");
        vertices = this.sortById(org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getVerticesWithPrefix(VISIBILITY_B_STRING, this.AUTHORIZATIONS_ALL)));
        VertexiumAssert.assertVertexIds(vertices, VISIBILITY_B_STRING);
        vertices = this.sortById(org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getVerticesWithPrefix(VISIBILITY_C_STRING, this.AUTHORIZATIONS_ALL)));
        VertexiumAssert.assertVertexIds(vertices, new String[0]);
    }

    @Test
    public void testGetVerticesInRange() {
        this.graph.addVertex(VISIBILITY_A_STRING, VISIBILITY_EMPTY, this.AUTHORIZATIONS_ALL);
        this.graph.addVertex("aa", VISIBILITY_EMPTY, this.AUTHORIZATIONS_ALL);
        this.graph.addVertex("az", VISIBILITY_EMPTY, this.AUTHORIZATIONS_ALL);
        this.graph.addVertex(VISIBILITY_B_STRING, VISIBILITY_EMPTY, this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        List vertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getVerticesInRange(new Range(null, VISIBILITY_A_STRING), this.AUTHORIZATIONS_ALL));
        VertexiumAssert.assertVertexIds(vertices, new String[0]);
        vertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getVerticesInRange(new Range(null, VISIBILITY_B_STRING), this.AUTHORIZATIONS_ALL));
        VertexiumAssert.assertVertexIds(vertices, VISIBILITY_A_STRING, "aa", "az");
        vertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getVerticesInRange(new Range(null, "bb"), this.AUTHORIZATIONS_ALL));
        VertexiumAssert.assertVertexIds(vertices, VISIBILITY_A_STRING, "aa", "az", VISIBILITY_B_STRING);
        vertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getVerticesInRange(new Range(null, null), this.AUTHORIZATIONS_ALL));
        VertexiumAssert.assertVertexIds(vertices, VISIBILITY_A_STRING, "aa", "az", VISIBILITY_B_STRING);
    }

    @Test
    public void testGetEdgesInRange() {
        this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(VISIBILITY_A_STRING, "v1", "v2", LABEL_LABEL1, VISIBILITY_EMPTY, this.AUTHORIZATIONS_ALL);
        this.graph.addEdge("aa", "v1", "v2", LABEL_LABEL1, VISIBILITY_EMPTY, this.AUTHORIZATIONS_ALL);
        this.graph.addEdge("az", "v1", "v2", LABEL_LABEL1, VISIBILITY_EMPTY, this.AUTHORIZATIONS_ALL);
        this.graph.addEdge(VISIBILITY_B_STRING, "v1", "v2", LABEL_LABEL1, VISIBILITY_EMPTY, this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        List edges = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getEdgesInRange(new Range(null, VISIBILITY_A_STRING), this.AUTHORIZATIONS_ALL));
        VertexiumAssert.assertEdgeIds(edges, new String[0]);
        edges = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getEdgesInRange(new Range(null, VISIBILITY_B_STRING), this.AUTHORIZATIONS_ALL));
        VertexiumAssert.assertEdgeIds(edges, VISIBILITY_A_STRING, "aa", "az");
        edges = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getEdgesInRange(new Range(null, "bb"), this.AUTHORIZATIONS_ALL));
        VertexiumAssert.assertEdgeIds(edges, VISIBILITY_A_STRING, "aa", "az", VISIBILITY_B_STRING);
        edges = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getEdgesInRange(new Range(null, null), this.AUTHORIZATIONS_ALL));
        VertexiumAssert.assertEdgeIds(edges, VISIBILITY_A_STRING, "aa", "az", VISIBILITY_B_STRING);
    }

    @Test
    public void testGetEdgesWithIds() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v3 = this.graph.addVertex("v3", VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.prepareEdge("e1", v1, v2, LABEL_LABEL1, VISIBILITY_A).setProperty("prop1", (Object)"e1", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareEdge("e1a", v1, v2, LABEL_LABEL1, VISIBILITY_A).setProperty("prop1", (Object)"e1a", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareEdge("e2", v1, v3, LABEL_LABEL1, VISIBILITY_A).setProperty("prop1", (Object)"e2", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareEdge("e3", v2, v3, LABEL_LABEL1, VISIBILITY_A).setProperty("prop1", (Object)"e3", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add("e1");
        ids.add("e2");
        Iterable edges = this.graph.getEdges(ids, this.AUTHORIZATIONS_A);
        boolean foundE1 = false;
        boolean foundE2 = false;
        for (Edge e : edges) {
            if (e.getId().equals("e1")) {
                Assert.assertEquals((Object)"e1", (Object)e.getPropertyValue("prop1"));
                foundE1 = true;
                continue;
            }
            if (e.getId().equals("e2")) {
                Assert.assertEquals((Object)"e2", (Object)e.getPropertyValue("prop1"));
                foundE2 = true;
                continue;
            }
            Assert.assertTrue((String)("Unexpected vertex id: " + e.getId()), (boolean)false);
        }
        Assert.assertTrue((String)"e1 not found", (boolean)foundE1);
        Assert.assertTrue((String)"e2 not found", (boolean)foundE2);
    }

    @Test
    public void testMarkVertexAndPropertiesHidden() {
        this.graph.prepareVertex("v1", VISIBILITY_EMPTY).addPropertyValue("k1", "age", (Object)25, VISIBILITY_EMPTY).addPropertyValue("k2", "age", (Object)30, VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_ALL);
        this.graph.markVertexHidden(v1, VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        for (Property property : v1.getProperties()) {
            v1.markPropertyHidden(property, VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        }
        this.graph.flush();
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertNull((String)"v1 was found", (Object)v1);
        v1 = this.graph.getVertex("v1", FetchHint.ALL_INCLUDING_HIDDEN, this.AUTHORIZATIONS_ALL);
        Assert.assertNotNull((String)"could not find v1", (Object)v1);
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getProperties()));
        Assert.assertEquals((Object)25, (Object)v1.getPropertyValue("k1", "age"));
        Assert.assertEquals((Object)30, (Object)v1.getPropertyValue("k2", "age"));
        v1 = this.graph.getVertex("v1", FetchHint.ALL_INCLUDING_HIDDEN, this.AUTHORIZATIONS_ALL);
        this.graph.markVertexVisible(v1, VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        Vertex v1AfterVisible = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertNotNull((String)"could not find v1", (Object)v1AfterVisible);
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1AfterVisible.getProperties()));
        for (Property property : v1.getProperties()) {
            v1.markPropertyVisible(property, VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        }
        this.graph.flush();
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertNotNull((String)"could not find v1", (Object)v1);
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getProperties()));
        Assert.assertEquals((Object)25, (Object)v1.getPropertyValue("k1", "age"));
        Assert.assertEquals((Object)30, (Object)v1.getPropertyValue("k2", "age"));
    }

    @Test
    public void testMarkVertexHidden() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        this.graph.addEdge("v1tov2", v1, v2, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        ArrayList<String> vertexIdList = new ArrayList<String>();
        vertexIdList.add("v1");
        vertexIdList.add("v2");
        vertexIdList.add(LABEL_BAD);
        Map verticesExist = this.graph.doVerticesExist(vertexIdList, this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)3L, (long)vertexIdList.size());
        Assert.assertTrue((String)"v1 exist", (boolean)((Boolean)verticesExist.get("v1")));
        Assert.assertTrue((String)"v2 exist", (boolean)((Boolean)verticesExist.get("v2")));
        Assert.assertFalse((String)"bad exist", (boolean)((Boolean)verticesExist.get(LABEL_BAD)));
        Assert.assertTrue((String)"v1 exists (auth A)", (boolean)this.graph.doesVertexExist("v1", this.AUTHORIZATIONS_A));
        Assert.assertFalse((String)"v1 exists (auth B)", (boolean)this.graph.doesVertexExist("v1", this.AUTHORIZATIONS_B));
        Assert.assertTrue((String)"v1 exists (auth A&B)", (boolean)this.graph.doesVertexExist("v1", this.AUTHORIZATIONS_A_AND_B));
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertices(this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getEdges(this.AUTHORIZATIONS_A)));
        this.graph.markVertexHidden(v1, VISIBILITY_A_AND_B, this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertTrue((String)"v1 exists (auth A)", (boolean)this.graph.doesVertexExist("v1", this.AUTHORIZATIONS_A));
        Assert.assertFalse((String)"v1 exists (auth B)", (boolean)this.graph.doesVertexExist("v1", this.AUTHORIZATIONS_B));
        Assert.assertFalse((String)"v1 exists (auth A&B)", (boolean)this.graph.doesVertexExist("v1", this.AUTHORIZATIONS_A_AND_B));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertices(this.AUTHORIZATIONS_A_AND_B)));
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertices(this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertices(this.AUTHORIZATIONS_B)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getEdges(this.AUTHORIZATIONS_A)));
        this.graph.markVertexHidden(v1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertFalse((String)"v1 exists (auth A)", (boolean)this.graph.doesVertexExist("v1", this.AUTHORIZATIONS_A));
        Assert.assertFalse((String)"v1 exists (auth B)", (boolean)this.graph.doesVertexExist("v1", this.AUTHORIZATIONS_B));
        Assert.assertFalse((String)"v1 exists (auth A&B)", (boolean)this.graph.doesVertexExist("v1", this.AUTHORIZATIONS_A_AND_B));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertices(this.AUTHORIZATIONS_A_AND_B)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertices(this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertices(this.AUTHORIZATIONS_B)));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getEdges(this.AUTHORIZATIONS_A)));
        Assert.assertNull((String)"found v1 but shouldn't have", (Object)this.graph.getVertex("v1", this.graph.getDefaultFetchHints(), this.AUTHORIZATIONS_A));
        Vertex v1Hidden = this.graph.getVertex("v1", FetchHint.ALL_INCLUDING_HIDDEN, this.AUTHORIZATIONS_A);
        Assert.assertNotNull((String)"did not find v1 but should have", (Object)v1Hidden);
        Assert.assertTrue((String)"v1 should be hidden", (boolean)v1Hidden.isHidden(this.AUTHORIZATIONS_A));
        this.graph.markVertexVisible(v1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertTrue((String)"v1 exists (auth A)", (boolean)this.graph.doesVertexExist("v1", this.AUTHORIZATIONS_A));
        Assert.assertFalse((String)"v1 exists (auth B)", (boolean)this.graph.doesVertexExist("v1", this.AUTHORIZATIONS_B));
        Assert.assertFalse((String)"v1 exists (auth A&B)", (boolean)this.graph.doesVertexExist("v1", this.AUTHORIZATIONS_A_AND_B));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertices(this.AUTHORIZATIONS_A_AND_B)));
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertices(this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertices(this.AUTHORIZATIONS_B)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getEdges(this.AUTHORIZATIONS_A)));
        this.graph.markVertexVisible(v1, VISIBILITY_A_AND_B, this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertTrue((String)"v1 exists (auth A)", (boolean)this.graph.doesVertexExist("v1", this.AUTHORIZATIONS_A));
        Assert.assertFalse((String)"v1 exists (auth B)", (boolean)this.graph.doesVertexExist("v1", this.AUTHORIZATIONS_B));
        Assert.assertTrue((String)"v1 exists (auth A&B)", (boolean)this.graph.doesVertexExist("v1", this.AUTHORIZATIONS_A_AND_B));
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertices(this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getEdges(this.AUTHORIZATIONS_A)));
    }

    @Test
    public void testMarkEdgeHidden() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        Vertex v3 = this.graph.addVertex("v3", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        Edge e1 = this.graph.addEdge("v1tov2", v1, v2, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        this.graph.addEdge("v2tov3", v2, v3, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        ArrayList<String> edgeIdList = new ArrayList<String>();
        edgeIdList.add("v1tov2");
        edgeIdList.add("v2tov3");
        edgeIdList.add(LABEL_BAD);
        Map edgesExist = this.graph.doEdgesExist(edgeIdList, this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)3L, (long)edgeIdList.size());
        Assert.assertTrue((String)"v1tov2 exist", (boolean)((Boolean)edgesExist.get("v1tov2")));
        Assert.assertTrue((String)"v2tov3 exist", (boolean)((Boolean)edgesExist.get("v2tov3")));
        Assert.assertFalse((String)"bad exist", (boolean)((Boolean)edgesExist.get(LABEL_BAD)));
        Assert.assertTrue((String)"v1tov2 exists (auth A)", (boolean)this.graph.doesEdgeExist("v1tov2", this.AUTHORIZATIONS_A));
        Assert.assertFalse((String)"v1tov2 exists (auth B)", (boolean)this.graph.doesEdgeExist("v1tov2", this.AUTHORIZATIONS_B));
        Assert.assertTrue((String)"v1tov2 exists (auth A&B)", (boolean)this.graph.doesEdgeExist("v1tov2", this.AUTHORIZATIONS_A_AND_B));
        Assert.assertEquals((long)3L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertices(this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getEdges(this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A).getEdges(Direction.BOTH, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v3", 2), this.AUTHORIZATIONS_A_AND_B)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v3", 10), this.AUTHORIZATIONS_A_AND_B)));
        this.graph.markEdgeHidden(e1, VISIBILITY_A_AND_B, this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertTrue((String)"v1tov2 exists (auth A)", (boolean)this.graph.doesEdgeExist("v1tov2", this.AUTHORIZATIONS_A));
        Assert.assertFalse((String)"v1tov2 exists (auth B)", (boolean)this.graph.doesEdgeExist("v1tov2", this.AUTHORIZATIONS_B));
        Assert.assertFalse((String)"v1tov2 exists (auth A&B)", (boolean)this.graph.doesEdgeExist("v1tov2", this.AUTHORIZATIONS_A_AND_B));
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getEdges(this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getEdges(this.AUTHORIZATIONS_B)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getEdges(this.AUTHORIZATIONS_A_AND_B)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A).getEdges(Direction.BOTH, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A).getEdgeIds(Direction.BOTH, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B).getEdges(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B)));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B).getEdgeIds(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B)));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B).getEdgeInfos(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B)));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", FetchHint.ALL_INCLUDING_HIDDEN, this.AUTHORIZATIONS_A_AND_B).getEdges(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", FetchHint.ALL_INCLUDING_HIDDEN, this.AUTHORIZATIONS_A_AND_B).getEdges(Direction.BOTH, FetchHint.ALL_INCLUDING_HIDDEN, this.AUTHORIZATIONS_A_AND_B)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", FetchHint.ALL_INCLUDING_HIDDEN, this.AUTHORIZATIONS_A_AND_B).getEdgeIds(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", FetchHint.ALL_INCLUDING_HIDDEN, this.AUTHORIZATIONS_A_AND_B).getEdgeInfos(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B)));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v3", 2), this.AUTHORIZATIONS_A_AND_B)));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v3", 10), this.AUTHORIZATIONS_A_AND_B)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v3", 10), this.AUTHORIZATIONS_A)));
        Assert.assertNull((String)"found e1 but shouldn't have", (Object)this.graph.getEdge("v1tov2", this.graph.getDefaultFetchHints(), this.AUTHORIZATIONS_A_AND_B));
        Edge e1Hidden = this.graph.getEdge("v1tov2", FetchHint.ALL_INCLUDING_HIDDEN, this.AUTHORIZATIONS_A_AND_B);
        Assert.assertNotNull((String)"did not find e1 but should have", (Object)e1Hidden);
        Assert.assertTrue((String)"e1 should be hidden", (boolean)e1Hidden.isHidden(this.AUTHORIZATIONS_A_AND_B));
        this.graph.markEdgeVisible(e1, VISIBILITY_A_AND_B, this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertTrue((String)"v1tov2 exists (auth A)", (boolean)this.graph.doesEdgeExist("v1tov2", this.AUTHORIZATIONS_A));
        Assert.assertFalse((String)"v1tov2 exists (auth B)", (boolean)this.graph.doesEdgeExist("v1tov2", this.AUTHORIZATIONS_B));
        Assert.assertTrue((String)"v1tov2 exists (auth A&B)", (boolean)this.graph.doesEdgeExist("v1tov2", this.AUTHORIZATIONS_A_AND_B));
        Assert.assertEquals((long)3L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertices(this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getEdges(this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A).getEdges(Direction.BOTH, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v3", 2), this.AUTHORIZATIONS_A_AND_B)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v3", 10), this.AUTHORIZATIONS_A_AND_B)));
    }

    @Test
    public void testSearchingForHiddenEdges() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        Vertex v3 = this.graph.addVertex("v3", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        Edge e1 = this.graph.addEdge("v1tov2", v1, v2, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        Edge e2 = this.graph.addEdge("v2tov3", v2, v3, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        this.graph.markEdgeHidden(e1, VISIBILITY_B, this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        QueryResultsIterable edges = this.graph.query(this.AUTHORIZATIONS_A).edges(EnumSet.of(FetchHint.PROPERTIES));
        VertexiumAssert.assertResultsCount(2, (QueryResultsIterable<? extends Element>)edges);
        VertexiumAssert.assertEdgeIdsAnyOrder((Iterable<Edge>)edges, e1.getId(), e2.getId());
        edges = this.graph.query(this.AUTHORIZATIONS_A_AND_B).edges(EnumSet.of(FetchHint.PROPERTIES));
        VertexiumAssert.assertResultsCount(1, (QueryResultsIterable<? extends Element>)edges);
        VertexiumAssert.assertEdgeIdsAnyOrder((Iterable<Edge>)edges, e2.getId());
        this.graph.markEdgeVisible(e1, VISIBILITY_B, this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        edges = this.graph.query(this.AUTHORIZATIONS_A_AND_B).edges(EnumSet.of(FetchHint.PROPERTIES));
        VertexiumAssert.assertResultsCount(2, (QueryResultsIterable<? extends Element>)edges);
        VertexiumAssert.assertEdgeIdsAnyOrder((Iterable<Edge>)edges, e1.getId(), e2.getId());
    }

    @Test
    public void testMarkPropertyHidden() {
        Vertex v1 = (Vertex)this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("key1", "prop1", (Object)"value1", VISIBILITY_A).addPropertyValue("key1", "prop1", (Object)"value1", VISIBILITY_B).addPropertyValue("key2", "prop1", (Object)"value1", VISIBILITY_A).save(this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        Assert.assertEquals((long)3L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B).getProperties("prop1")));
        v1.markPropertyHidden("key1", "prop1", VISIBILITY_A, VISIBILITY_A_AND_B, this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        List properties = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B).getProperties("prop1"));
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)properties));
        boolean foundProp1Key2 = false;
        boolean foundProp1Key1VisB = false;
        for (Property property : properties) {
            if (property.getName().equals("prop1")) {
                if (property.getKey().equals("key2")) {
                    foundProp1Key2 = true;
                    continue;
                }
                if (property.getKey().equals("key1")) {
                    if (property.getVisibility().equals((Object)VISIBILITY_B)) {
                        foundProp1Key1VisB = true;
                        continue;
                    }
                    throw new RuntimeException("Unexpected visibility " + property.getVisibility());
                }
                throw new RuntimeException("Unexpected property key " + property.getKey());
            }
            throw new RuntimeException("Unexpected property name " + property.getName());
        }
        Assert.assertTrue((String)"Prop1Key2 not found", (boolean)foundProp1Key2);
        Assert.assertTrue((String)"Prop1Key1VisB not found", (boolean)foundProp1Key1VisB);
        List hiddenProperties = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getVertex("v1", FetchHint.ALL_INCLUDING_HIDDEN, this.AUTHORIZATIONS_A_AND_B).getProperties());
        Assert.assertEquals((long)3L, (long)hiddenProperties.size());
        boolean foundProp1Key1VisA = false;
        foundProp1Key2 = false;
        foundProp1Key1VisB = false;
        for (Property property : hiddenProperties) {
            if (property.getName().equals("prop1")) {
                if (property.getKey().equals("key2")) {
                    foundProp1Key2 = true;
                    Assert.assertFalse((String)"should not be hidden", (boolean)property.isHidden(this.AUTHORIZATIONS_A_AND_B));
                    continue;
                }
                if (property.getKey().equals("key1")) {
                    if (property.getVisibility().equals((Object)VISIBILITY_A)) {
                        foundProp1Key1VisA = true;
                        Assert.assertFalse((String)"should not be hidden", (boolean)property.isHidden(this.AUTHORIZATIONS_A));
                        Assert.assertTrue((String)"should be hidden", (boolean)property.isHidden(this.AUTHORIZATIONS_A_AND_B));
                        continue;
                    }
                    if (property.getVisibility().equals((Object)VISIBILITY_B)) {
                        foundProp1Key1VisB = true;
                        Assert.assertFalse((String)"should not be hidden", (boolean)property.isHidden(this.AUTHORIZATIONS_A_AND_B));
                        continue;
                    }
                    throw new RuntimeException("Unexpected visibility " + property.getVisibility());
                }
                throw new RuntimeException("Unexpected property key " + property.getKey());
            }
            throw new RuntimeException("Unexpected property name " + property.getName());
        }
        Assert.assertTrue((String)"Prop1Key2 not found", (boolean)foundProp1Key2);
        Assert.assertTrue((String)"Prop1Key1VisB not found", (boolean)foundProp1Key1VisB);
        Assert.assertTrue((String)"Prop1Key1VisA not found", (boolean)foundProp1Key1VisA);
        v1.markPropertyVisible("key1", "prop1", VISIBILITY_A, VISIBILITY_A_AND_B, this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Assert.assertEquals((long)3L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B).getProperties("prop1")));
    }

    @Test
    public void testSearchingForHiddenVertices() {
        Vertex v1 = (Vertex)this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("key1", "prop1", (Object)"value1", VISIBILITY_A).save(this.AUTHORIZATIONS_ALL);
        Vertex v2 = (Vertex)this.graph.prepareVertex("v2", VISIBILITY_A).addPropertyValue("key1", "prop1", (Object)"value1", VISIBILITY_A).save(this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        this.graph.markVertexHidden(v1, VISIBILITY_B, this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A).has("prop1", (Object)"value1").vertices(EnumSet.of(FetchHint.PROPERTIES));
        VertexiumAssert.assertResultsCount(2, (QueryResultsIterable<? extends Element>)vertices);
        VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)vertices, v1.getId(), v2.getId());
        vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("prop1", (Object)"value1").vertices(EnumSet.of(FetchHint.PROPERTIES));
        VertexiumAssert.assertResultsCount(1, (QueryResultsIterable<? extends Element>)vertices);
        VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)vertices, v2.getId());
        this.graph.markVertexVisible(v1, VISIBILITY_B, this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("prop1", (Object)"value1").vertices(EnumSet.of(FetchHint.PROPERTIES));
        VertexiumAssert.assertResultsCount(2, (QueryResultsIterable<? extends Element>)vertices);
        VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)vertices, v1.getId(), v2.getId());
    }

    @Test
    public void testMarkVertexHiddenAndDeleteEdges() {
        Vertex w1 = this.graph.addVertex("w1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex w2 = this.graph.addVertex("w2", VISIBILITY_B, this.AUTHORIZATIONS_B);
        Vertex e1 = this.graph.addVertex("e1", VISIBILITY_EMPTY, this.AUTHORIZATIONS_A);
        Vertex e2 = this.graph.addVertex("e2", VISIBILITY_EMPTY, this.AUTHORIZATIONS_A);
        this.graph.addEdge("w1-e1", w1, e1, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge("w2-e1", w2, e1, LABEL_LABEL1, VISIBILITY_B, this.AUTHORIZATIONS_B);
        this.graph.addEdge("e1-e2", e1, e2, LABEL_LABEL1, VISIBILITY_EMPTY, this.AUTHORIZATIONS_A);
        this.graph.flush();
        e1 = this.graph.getVertex("e1", this.AUTHORIZATIONS_EMPTY);
        this.graph.markVertexHidden(e1, VISIBILITY_A, this.AUTHORIZATIONS_EMPTY);
        this.graph.flush();
        this.graph.getVertex("w1", this.AUTHORIZATIONS_A);
        this.graph.deleteVertex("w1", this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertices(this.AUTHORIZATIONS_A)));
        Assert.assertEquals((Object)"e2", (Object)((Vertex)org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getVertices(this.AUTHORIZATIONS_A)).get(0)).getId());
        Assert.assertEquals((long)3L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertices(this.AUTHORIZATIONS_B)));
        boolean foundW2 = false;
        boolean foundE1 = false;
        boolean foundE2 = false;
        for (Vertex v : this.graph.getVertices(this.AUTHORIZATIONS_B)) {
            if (v.getId().equals("w2")) {
                foundW2 = true;
                continue;
            }
            if (v.getId().equals("e1")) {
                foundE1 = true;
                continue;
            }
            if (v.getId().equals("e2")) {
                foundE2 = true;
                continue;
            }
            throw new VertexiumException("Unexpected id: " + v.getId());
        }
        Assert.assertTrue((String)"w2", (boolean)foundW2);
        Assert.assertTrue((String)"e1", (boolean)foundE1);
        Assert.assertTrue((String)"e2", (boolean)foundE2);
    }

    @Test
    public void testDeleteVertexWithProperties() {
        Vertex v1 = (Vertex)this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("prop1", (Object)"value1", VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Property prop1 = v1.getProperty("prop1");
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertices(this.AUTHORIZATIONS_A)));
        this.graph.deleteVertex("v1", this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertices(this.AUTHORIZATIONS_A_AND_B)));
        VertexiumAssert.assertEvents(new GraphEvent[]{new AddVertexEvent(this.graph, v1), new AddPropertyEvent(this.graph, (Element)v1, prop1), new DeleteVertexEvent(this.graph, v1)});
    }

    @Test
    public void testAddEdge() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Edge addedEdge = this.graph.addEdge("e1", v1, v2, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertNotNull((Object)addedEdge);
        Assert.assertEquals((Object)"e1", (Object)addedEdge.getId());
        Assert.assertEquals((Object)LABEL_LABEL1, (Object)addedEdge.getLabel());
        Assert.assertEquals((Object)"v1", (Object)addedEdge.getVertexId(Direction.OUT));
        Assert.assertEquals((Object)v1, (Object)addedEdge.getVertex(Direction.OUT, this.AUTHORIZATIONS_A));
        Assert.assertEquals((Object)"v2", (Object)addedEdge.getVertexId(Direction.IN));
        Assert.assertEquals((Object)v2, (Object)addedEdge.getVertex(Direction.IN, this.AUTHORIZATIONS_A));
        Assert.assertEquals((Object)VISIBILITY_A, (Object)addedEdge.getVisibility());
        EdgeVertices addedEdgeVertices = addedEdge.getVertices(this.AUTHORIZATIONS_A);
        Assert.assertEquals((Object)v1, (Object)addedEdgeVertices.getOutVertex());
        Assert.assertEquals((Object)v2, (Object)addedEdgeVertices.getInVertex());
        this.graph.getVertex("v1", FetchHint.NONE, this.AUTHORIZATIONS_A);
        this.graph.getVertex("v1", this.graph.getDefaultFetchHints(), this.AUTHORIZATIONS_A);
        this.graph.getVertex("v1", EnumSet.of(FetchHint.PROPERTIES), this.AUTHORIZATIONS_A);
        this.graph.getVertex("v1", FetchHint.EDGE_REFS, this.AUTHORIZATIONS_A);
        this.graph.getVertex("v1", EnumSet.of(FetchHint.IN_EDGE_REFS), this.AUTHORIZATIONS_A);
        this.graph.getVertex("v1", EnumSet.of(FetchHint.OUT_EDGE_REFS), this.AUTHORIZATIONS_A);
        this.graph.getEdge("e1", FetchHint.NONE, this.AUTHORIZATIONS_A);
        this.graph.getEdge("e1", this.graph.getDefaultFetchHints(), this.AUTHORIZATIONS_A);
        this.graph.getEdge("e1", EnumSet.of(FetchHint.PROPERTIES), this.AUTHORIZATIONS_A);
        Edge e = this.graph.getEdge("e1", this.AUTHORIZATIONS_B);
        Assert.assertNull((Object)e);
        e = this.graph.getEdge("e1", this.AUTHORIZATIONS_A);
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)"e1", (Object)e.getId());
        Assert.assertEquals((Object)LABEL_LABEL1, (Object)e.getLabel());
        Assert.assertEquals((Object)"v1", (Object)e.getVertexId(Direction.OUT));
        Assert.assertEquals((Object)v1, (Object)e.getVertex(Direction.OUT, this.AUTHORIZATIONS_A));
        Assert.assertEquals((Object)"v2", (Object)e.getVertexId(Direction.IN));
        Assert.assertEquals((Object)v2, (Object)e.getVertex(Direction.IN, this.AUTHORIZATIONS_A));
        Assert.assertEquals((Object)VISIBILITY_A, (Object)e.getVisibility());
        this.graph.flush();
        VertexiumAssert.assertEvents(new GraphEvent[]{new AddVertexEvent(this.graph, v1), new AddVertexEvent(this.graph, v2), new AddEdgeEvent(this.graph, addedEdge)});
    }

    @Test
    public void testGetEdge() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge("e1to2label1", v1, v2, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge("e1to2label2", v1, v2, LABEL_LABEL2, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge("e2to1", v2.getId(), v1.getId(), LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)3L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getEdges(Direction.BOTH, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getEdges(Direction.OUT, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getEdges(Direction.IN, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)3L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getEdges(v2, Direction.BOTH, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getEdges(v2, Direction.OUT, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getEdges(v2, Direction.IN, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getEdges(v2, Direction.BOTH, LABEL_LABEL1, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getEdges(v2, Direction.OUT, LABEL_LABEL1, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getEdges(v2, Direction.IN, LABEL_LABEL1, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)3L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getEdges(v2, Direction.BOTH, new String[]{LABEL_LABEL1, LABEL_LABEL2}, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getEdges(v2, Direction.OUT, new String[]{LABEL_LABEL1, LABEL_LABEL2}, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getEdges(v2, Direction.IN, new String[]{LABEL_LABEL1, LABEL_LABEL2}, this.AUTHORIZATIONS_A)));
        Assert.assertArrayEquals((Object[])new String[]{LABEL_LABEL1, LABEL_LABEL2}, (Object[])org.vertexium.util.IterableUtils.toArray((Iterable)v1.getEdgeLabels(Direction.OUT, this.AUTHORIZATIONS_A), String.class));
        Assert.assertArrayEquals((Object[])new String[]{LABEL_LABEL1}, (Object[])org.vertexium.util.IterableUtils.toArray((Iterable)v1.getEdgeLabels(Direction.IN, this.AUTHORIZATIONS_A), String.class));
        Assert.assertArrayEquals((Object[])new String[]{LABEL_LABEL1, LABEL_LABEL2}, (Object[])org.vertexium.util.IterableUtils.toArray((Iterable)v1.getEdgeLabels(Direction.BOTH, this.AUTHORIZATIONS_A), String.class));
    }

    @Test
    public void testGetEdgeVertexPairs() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v3 = this.graph.addVertex("v3", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Edge v1_to_v2_label1 = this.graph.addEdge("v1_to_v2_label1", v1, v2, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        Edge v1_to_v2_label2 = this.graph.addEdge("v1_to_v2_label2", v1, v2, LABEL_LABEL2, VISIBILITY_A, this.AUTHORIZATIONS_A);
        Edge v1_to_v3_label2 = this.graph.addEdge("v1_to_v3_label2", v1, v3, LABEL_LABEL2, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        List pairs = org.vertexium.util.IterableUtils.toList((Iterable)v1.getEdgeVertexPairs(Direction.BOTH, this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)3L, (long)pairs.size());
        Assert.assertTrue((boolean)pairs.contains(new EdgeVertexPair(v1_to_v2_label1, v2)));
        Assert.assertTrue((boolean)pairs.contains(new EdgeVertexPair(v1_to_v2_label2, v2)));
        Assert.assertTrue((boolean)pairs.contains(new EdgeVertexPair(v1_to_v3_label2, v3)));
        pairs = org.vertexium.util.IterableUtils.toList((Iterable)v1.getEdgeVertexPairs(Direction.BOTH, LABEL_LABEL2, this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)2L, (long)pairs.size());
        Assert.assertTrue((boolean)pairs.contains(new EdgeVertexPair(v1_to_v2_label2, v2)));
        Assert.assertTrue((boolean)pairs.contains(new EdgeVertexPair(v1_to_v3_label2, v3)));
    }

    @Test
    public void testAddEdgeWithProperties() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Edge addedEdge = (Edge)this.graph.prepareEdge("e1", v1, v2, LABEL_LABEL1, VISIBILITY_A).setProperty("propA", (Object)"valueA", VISIBILITY_A).setProperty("propB", (Object)"valueB", VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Edge e = this.graph.getEdge("e1", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)e.getProperties()));
        Assert.assertEquals((Object)"valueA", e.getPropertyValues("propA").iterator().next());
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)e.getPropertyValues("propB")));
        e = this.graph.getEdge("e1", this.AUTHORIZATIONS_A_AND_B);
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)e.getProperties()));
        Assert.assertEquals((Object)"valueA", e.getPropertyValues("propA").iterator().next());
        Assert.assertEquals((Object)"valueB", e.getPropertyValues("propB").iterator().next());
        Assert.assertEquals((Object)"valueA", (Object)e.getPropertyValue("propA"));
        Assert.assertEquals((Object)"valueB", (Object)e.getPropertyValue("propB"));
        this.graph.flush();
        VertexiumAssert.assertEvents(new GraphEvent[]{new AddVertexEvent(this.graph, v1), new AddVertexEvent(this.graph, v2), new AddEdgeEvent(this.graph, addedEdge), new AddPropertyEvent(this.graph, (Element)addedEdge, addedEdge.getProperty("propA")), new AddPropertyEvent(this.graph, (Element)addedEdge, addedEdge.getProperty("propB"))});
    }

    @Test
    public void testAddEdgeWithNullInOutVertices() {
        try {
            String outVertexId = null;
            String inVertexId = null;
            this.getGraph().prepareEdge("e1", outVertexId, inVertexId, LABEL_LABEL1, VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_ALL);
            Assert.fail((String)"should throw an exception");
        }
        catch (Exception ex) {
            Assert.assertNotNull((Object)ex);
        }
        try {
            Vertex outVertex = null;
            Vertex inVertex = null;
            this.getGraph().prepareEdge("e1", outVertex, inVertex, LABEL_LABEL1, VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_ALL);
            Assert.fail((String)"should throw an exception");
        }
        catch (Exception ex) {
            Assert.assertNotNull((Object)ex);
        }
    }

    @Test
    public void testAddEdgeWithNullLabels() {
        String label;
        try {
            label = null;
            this.getGraph().prepareEdge("e1", "v1", "v2", label, VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_ALL);
            Assert.fail((String)"should throw an exception");
        }
        catch (Exception ex) {
            Assert.assertNotNull((Object)ex);
        }
        try {
            label = null;
            Vertex outVertex = this.getGraph().addVertex("v1", VISIBILITY_EMPTY, this.AUTHORIZATIONS_ALL);
            Vertex inVertex = this.getGraph().addVertex("v2", VISIBILITY_EMPTY, this.AUTHORIZATIONS_ALL);
            this.getGraph().prepareEdge("e1", outVertex, inVertex, label, VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_ALL);
            Assert.fail((String)"should throw an exception");
        }
        catch (Exception ex) {
            Assert.assertNotNull((Object)ex);
        }
    }

    @Test
    public void testChangingPropertyOnEdge() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.prepareEdge("e1", v1, v2, LABEL_LABEL1, VISIBILITY_A).setProperty("propA", (Object)"valueA", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Edge e = this.graph.getEdge("e1", this.AUTHORIZATIONS_A_AND_B);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)e.getProperties()));
        Assert.assertEquals((Object)"valueA", e.getPropertyValues("propA").iterator().next());
        Property propA = e.getProperty("", "propA");
        Assert.assertNotNull((Object)propA);
        e.markPropertyHidden(propA, VISIBILITY_A, this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        e = this.graph.getEdge("e1", this.AUTHORIZATIONS_A_AND_B);
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)e.getProperties()));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)e.getPropertyValues("propA")));
        e.setProperty(propA.getName(), (Object)"valueA_changed", VISIBILITY_B, this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        e = this.graph.getEdge("e1", this.AUTHORIZATIONS_A_AND_B);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)e.getProperties()));
        Assert.assertEquals((Object)"valueA_changed", e.getPropertyValues("propA").iterator().next());
        e.markPropertyVisible(propA, VISIBILITY_A, this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        e = this.graph.getEdge("e1", this.AUTHORIZATIONS_A_AND_B);
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)e.getProperties()));
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)e.getPropertyValues("propA")));
        List propertyValues = org.vertexium.util.IterableUtils.toList((Iterable)e.getPropertyValues("propA"));
        Assert.assertTrue((boolean)propertyValues.contains("valueA"));
        Assert.assertTrue((boolean)propertyValues.contains("valueA_changed"));
    }

    @Test
    public void testAlterEdgeLabel() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.prepareEdge("e1", v1, v2, LABEL_LABEL1, VISIBILITY_A).setProperty("propA", (Object)"valueA", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        Edge e = this.graph.getEdge("e1", this.AUTHORIZATIONS_A);
        Assert.assertEquals((Object)LABEL_LABEL1, (Object)e.getLabel());
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)e.getProperties()));
        Assert.assertEquals((Object)"valueA", e.getPropertyValues("propA").iterator().next());
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getEdges(Direction.OUT, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((Object)LABEL_LABEL1, (Object)org.vertexium.util.IterableUtils.single((Iterable)v1.getEdgeLabels(Direction.OUT, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v2.getEdges(Direction.IN, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((Object)LABEL_LABEL1, (Object)org.vertexium.util.IterableUtils.single((Iterable)v2.getEdgeLabels(Direction.IN, this.AUTHORIZATIONS_A)));
        e.prepareMutation().alterEdgeLabel(LABEL_LABEL2).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        e = this.graph.getEdge("e1", this.AUTHORIZATIONS_A);
        Assert.assertEquals((Object)LABEL_LABEL2, (Object)e.getLabel());
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)e.getProperties()));
        Assert.assertEquals((Object)"valueA", e.getPropertyValues("propA").iterator().next());
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getEdges(Direction.OUT, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((Object)LABEL_LABEL2, (Object)org.vertexium.util.IterableUtils.single((Iterable)v1.getEdgeLabels(Direction.OUT, this.AUTHORIZATIONS_A)));
        v2 = this.graph.getVertex("v2", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v2.getEdges(Direction.IN, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((Object)LABEL_LABEL2, (Object)org.vertexium.util.IterableUtils.single((Iterable)v2.getEdgeLabels(Direction.IN, this.AUTHORIZATIONS_A)));
        this.graph.prepareEdge(e.getId(), e.getVertexId(Direction.OUT), e.getVertexId(Direction.IN), e.getLabel(), e.getVisibility()).alterEdgeLabel(LABEL_LABEL3).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        e = this.graph.getEdge("e1", this.AUTHORIZATIONS_A);
        Assert.assertEquals((Object)LABEL_LABEL3, (Object)e.getLabel());
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)e.getProperties()));
        Assert.assertEquals((Object)"valueA", e.getPropertyValues("propA").iterator().next());
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getEdges(Direction.OUT, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((Object)LABEL_LABEL3, (Object)org.vertexium.util.IterableUtils.single((Iterable)v1.getEdgeLabels(Direction.OUT, this.AUTHORIZATIONS_A)));
        v2 = this.graph.getVertex("v2", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v2.getEdges(Direction.IN, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((Object)LABEL_LABEL3, (Object)org.vertexium.util.IterableUtils.single((Iterable)v2.getEdgeLabels(Direction.IN, this.AUTHORIZATIONS_A)));
    }

    @Test
    public void testDeleteEdge() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Edge addedEdge = this.graph.addEdge("e1", v1, v2, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getEdges(this.AUTHORIZATIONS_A)));
        try {
            this.graph.deleteEdge("e1", this.AUTHORIZATIONS_B);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getEdges(this.AUTHORIZATIONS_A)));
        this.graph.deleteEdge("e1", this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getEdges(this.AUTHORIZATIONS_A)));
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getVertices(Direction.BOTH, this.AUTHORIZATIONS_A)));
        v2 = this.graph.getVertex("v2", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)v2.getVertices(Direction.BOTH, this.AUTHORIZATIONS_A)));
        this.graph.flush();
        VertexiumAssert.assertEvents(new GraphEvent[]{new AddVertexEvent(this.graph, v1), new AddVertexEvent(this.graph, v2), new AddEdgeEvent(this.graph, addedEdge), new DeleteEdgeEvent(this.graph, addedEdge)});
    }

    @Test
    public void testAddEdgeWithVisibility() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge("e1", v1, v2, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge("e2", v1, v2, LABEL_LABEL2, VISIBILITY_B, this.AUTHORIZATIONS_B);
        this.graph.flush();
        Iterable aEdges = this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B).getEdges(Direction.BOTH, this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)aEdges));
        Assert.assertEquals((Object)LABEL_LABEL1, (Object)((Edge)org.vertexium.util.IterableUtils.single((Iterable)aEdges)).getLabel());
        Iterable bEdges = this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B).getEdges(Direction.BOTH, this.AUTHORIZATIONS_B);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)bEdges));
        Assert.assertEquals((Object)LABEL_LABEL2, (Object)((Edge)org.vertexium.util.IterableUtils.single((Iterable)bEdges)).getLabel());
        Iterable allEdges = this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B).getEdges(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B);
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)allEdges));
    }

    @Test
    public void testGraphQueryPagingForUniqueIdsSortedOrder() {
        String namePropertyName = "first.name";
        this.graph.defineProperty(namePropertyName).dataType(String.class).sortable(true).textIndexHint((Collection)TextIndexHint.ALL).define();
        this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("k1", namePropertyName, (Object)"B", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("v2", VISIBILITY_A).addPropertyValue("k1", namePropertyName, (Object)"A", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("v3", VISIBILITY_A).addPropertyValue("k1", namePropertyName, (Object)"C", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        QueryResultsIterable idsIterable = this.graph.query(this.AUTHORIZATIONS_A).sort("__ID__", SortDirection.ASCENDING).skip(0).limit(Integer.valueOf(1)).vertexIds();
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)idsIterable, "v1");
        VertexiumAssert.assertResultsCount(1, 3, idsIterable);
        idsIterable = this.graph.query(this.AUTHORIZATIONS_A).sort("__ID__", SortDirection.ASCENDING).skip(1).limit(Integer.valueOf(1)).vertexIds();
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)idsIterable, "v2");
        idsIterable = this.graph.query(this.AUTHORIZATIONS_A).sort("__ID__", SortDirection.ASCENDING).skip(2).limit(Integer.valueOf(1)).vertexIds();
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)idsIterable, "v3");
        idsIterable = this.graph.query(this.AUTHORIZATIONS_A).sort(namePropertyName, SortDirection.ASCENDING).vertexIds();
        VertexiumAssert.assertResultsCount(3, 3, idsIterable);
        idsIterable = this.graph.query(this.AUTHORIZATIONS_A).limit((Long)null).vertexIds();
        VertexiumAssert.assertResultsCount(3, 3, idsIterable);
        List vertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(this.AUTHORIZATIONS_A).sort(namePropertyName, SortDirection.ASCENDING).skip(0).limit(Integer.valueOf(1)).vertices());
        Assert.assertEquals((long)1L, (long)vertices.size());
        Assert.assertEquals((Object)"v2", (Object)((Vertex)vertices.get(0)).getId());
    }

    @Test
    public void testGraphQueryForIds() {
        String namePropertyName = "first.name";
        Vertex v1 = (Vertex)this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("k1", namePropertyName, (Object)"joe", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("v3", VISIBILITY_A).addExtendedData("table1", "row1", namePropertyName, (Object)"value 1", VISIBILITY_A).addExtendedData("table1", "row2", namePropertyName, (Object)"value 2", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.addEdge("e1", v1, v2, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge("e2", v1, v2, LABEL_LABEL2, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.flush();
        QueryResultsIterable idsIterable = this.graph.query(this.AUTHORIZATIONS_A).vertexIds();
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)idsIterable, "v1", "v2", "v3");
        VertexiumAssert.assertResultsCount(3, 3, idsIterable);
        idsIterable = this.graph.query(this.AUTHORIZATIONS_A).skip(1).vertexIds();
        VertexiumAssert.assertResultsCount(2, 3, idsIterable);
        idsIterable = this.graph.query(this.AUTHORIZATIONS_A).limit(Integer.valueOf(1)).vertexIds();
        VertexiumAssert.assertResultsCount(1, 3, idsIterable);
        idsIterable = this.graph.query(this.AUTHORIZATIONS_A).skip(1).limit(Integer.valueOf(1)).vertexIds();
        VertexiumAssert.assertResultsCount(1, 3, idsIterable);
        idsIterable = this.graph.query(this.AUTHORIZATIONS_A).skip(3).vertexIds();
        VertexiumAssert.assertResultsCount(0, 3, idsIterable);
        idsIterable = this.graph.query(this.AUTHORIZATIONS_A).skip(2).limit(Integer.valueOf(2)).vertexIds();
        VertexiumAssert.assertResultsCount(1, 3, idsIterable);
        idsIterable = this.graph.query(this.AUTHORIZATIONS_A).edgeIds();
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)idsIterable, "e1", "e2");
        VertexiumAssert.assertResultsCount(2, 2, idsIterable);
        idsIterable = this.graph.query(this.AUTHORIZATIONS_A).hasEdgeLabel(new String[]{LABEL_LABEL1}).edgeIds();
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)idsIterable, "e1");
        VertexiumAssert.assertResultsCount(1, 1, idsIterable);
        idsIterable = this.graph.query(this.AUTHORIZATIONS_A).hasEdgeLabel(new String[]{LABEL_LABEL1, LABEL_LABEL2}).edgeIds();
        VertexiumAssert.assertResultsCount(2, 2, idsIterable);
        idsIterable = this.graph.query(this.AUTHORIZATIONS_A).elementIds();
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)idsIterable, "v1", "v2", "v3", "e1", "e2");
        VertexiumAssert.assertResultsCount(5, 5, idsIterable);
        Assume.assumeTrue((String)"FetchHint.NONE vertex queries are not supported", (boolean)this.isFetchHintNoneVertexQuerySupported());
        idsIterable = this.graph.query(this.AUTHORIZATIONS_A).has(namePropertyName).vertexIds();
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)idsIterable, "v1");
        VertexiumAssert.assertResultsCount(1, 1, idsIterable);
        QueryResultsIterable extendedDataRowIds = this.graph.query(this.AUTHORIZATIONS_A).hasExtendedData("table1").extendedDataRowIds();
        List<String> rowIds = StreamUtils.stream((Iterable[])new Iterable[]{extendedDataRowIds}).map(ExtendedDataRowId::getRowId).collect(Collectors.toList());
        VertexiumAssert.assertIdsAnyOrder(rowIds, "row1", "row2");
        VertexiumAssert.assertResultsCount(2, 2, extendedDataRowIds);
        idsIterable = this.graph.query(this.AUTHORIZATIONS_A).hasNot(namePropertyName).vertexIds();
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)idsIterable, "v2", "v3");
        VertexiumAssert.assertResultsCount(2, 2, idsIterable);
        idsIterable = this.graph.query(this.AUTHORIZATIONS_A).has("notSetProp").vertexIds();
        VertexiumAssert.assertResultsCount(0, 0, idsIterable);
        idsIterable = this.graph.query(this.AUTHORIZATIONS_A).hasNot("notSetProp").vertexIds();
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)idsIterable, "v1", "v2", "v3");
        VertexiumAssert.assertResultsCount(3, 3, idsIterable);
        try {
            this.graph.query(this.AUTHORIZATIONS_A).has("notSetProp", (Predicate)Compare.NOT_EQUAL, (Object)5).vertexIds();
            Assert.fail((String)"Value queries should not be allowed for properties that are not defined.");
        }
        catch (VertexiumException ve) {
            Assert.assertEquals((Object)"Could not find property definition for property name: notSetProp", (Object)ve.getMessage());
        }
    }

    @Test
    public void testGraphQuery() {
        String namePropertyName = "first.name";
        Vertex v1 = (Vertex)this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("k1", namePropertyName, (Object)"joe", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge("e1", v1, v2, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge("e2", v1, v2, LABEL_LABEL2, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.flush();
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A).vertices();
        VertexiumAssert.assertResultsCount(2, 2, vertices);
        vertices = this.graph.query(this.AUTHORIZATIONS_A).skip(1).vertices();
        VertexiumAssert.assertResultsCount(1, 2, vertices);
        vertices = this.graph.query(this.AUTHORIZATIONS_A).limit(Integer.valueOf(1)).vertices();
        VertexiumAssert.assertResultsCount(1, 2, vertices);
        vertices = this.graph.query(this.AUTHORIZATIONS_A).skip(1).limit(Integer.valueOf(1)).vertices();
        VertexiumAssert.assertResultsCount(1, 2, vertices);
        vertices = this.graph.query(this.AUTHORIZATIONS_A).skip(2).vertices();
        VertexiumAssert.assertResultsCount(0, 2, vertices);
        vertices = this.graph.query(this.AUTHORIZATIONS_A).skip(1).limit(Integer.valueOf(2)).vertices();
        VertexiumAssert.assertResultsCount(1, 2, vertices);
        QueryResultsIterable edges = this.graph.query(this.AUTHORIZATIONS_A).edges();
        VertexiumAssert.assertResultsCount(2, 2, edges);
        edges = this.graph.query(this.AUTHORIZATIONS_A).hasEdgeLabel(new String[]{LABEL_LABEL1}).edges();
        VertexiumAssert.assertResultsCount(1, 1, edges);
        edges = this.graph.query(this.AUTHORIZATIONS_A).hasEdgeLabel(new String[]{LABEL_LABEL1, LABEL_LABEL2}).edges();
        VertexiumAssert.assertResultsCount(2, 2, edges);
        QueryResultsIterable elements = this.graph.query(this.AUTHORIZATIONS_A).elements();
        VertexiumAssert.assertResultsCount(4, 4, elements);
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has(namePropertyName).vertices();
        VertexiumAssert.assertResultsCount(1, 1, vertices);
        vertices = this.graph.query(this.AUTHORIZATIONS_A).hasNot(namePropertyName).vertices();
        VertexiumAssert.assertResultsCount(1, 1, vertices);
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has("notSetProp").vertices();
        VertexiumAssert.assertResultsCount(0, 0, vertices);
        vertices = this.graph.query(this.AUTHORIZATIONS_A).hasNot("notSetProp").vertices();
        VertexiumAssert.assertResultsCount(2, 2, vertices);
        vertices = this.graph.query(this.AUTHORIZATIONS_A).hasId(new String[]{"v1"}).vertices();
        VertexiumAssert.assertResultsCount(1, 1, vertices);
        vertices = this.graph.query(this.AUTHORIZATIONS_A).hasId(new String[]{"v1", "v2"}).vertices();
        VertexiumAssert.assertResultsCount(2, 2, vertices);
        edges = this.graph.query(this.AUTHORIZATIONS_A).hasId(new String[]{"e1"}).edges();
        VertexiumAssert.assertResultsCount(1, 1, edges);
        edges = this.graph.query(this.AUTHORIZATIONS_A).hasId(new String[]{"e1", "e2"}).edges();
        VertexiumAssert.assertResultsCount(2, 2, edges);
        try {
            this.graph.query(this.AUTHORIZATIONS_A).has("notSetProp", (Predicate)Compare.NOT_EQUAL, (Object)5).vertices();
            Assert.fail((String)"Value queries should not be allowed for properties that are not defined.");
        }
        catch (VertexiumException ve) {
            Assert.assertEquals((Object)"Could not find property definition for property name: notSetProp", (Object)ve.getMessage());
        }
    }

    @Test
    public void testGraphQueryWithBoolean() {
        this.graph.defineProperty("boolean").dataType(Boolean.class).define();
        this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("k1", "boolean", (Object)true, VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        QueryResultsIterable vertices = this.graph.query("zzzzz", this.AUTHORIZATIONS_A).vertices();
        VertexiumAssert.assertResultsCount(0, 0, vertices);
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has("boolean", (Object)true).vertices();
        VertexiumAssert.assertResultsCount(1, 1, vertices);
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has("boolean", (Object)false).vertices();
        VertexiumAssert.assertResultsCount(0, 0, vertices);
    }

    @Test
    public void testGraphQueryWithFetchHints() {
        this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("k1", "name", (Object)"joe", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("v2", VISIBILITY_A).addPropertyValue("k1", "name", (Object)"matt", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("v3", VISIBILITY_A).addPropertyValue("k1", "name", (Object)"joe", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertTrue((this.graph.getVertexCount(this.AUTHORIZATIONS_A) == 3L ? 1 : 0) != 0);
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A).has("name", (Object)"joe").vertices(EnumSet.of(FetchHint.PROPERTIES));
        VertexiumAssert.assertResultsCount(2, 2, vertices);
        Assume.assumeTrue((String)"FetchHint.NONE vertex queries are not supported", (boolean)this.isFetchHintNoneVertexQuerySupported());
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has("name", (Object)"joe").vertices(FetchHint.NONE);
        VertexiumAssert.assertResultsCount(2, 2, vertices);
    }

    protected boolean isFetchHintNoneVertexQuerySupported() {
        return true;
    }

    @Test
    public void testSaveElementMutations() {
        ArrayList<Object> mutations = new ArrayList<Object>();
        for (int i = 0; i < 2; ++i) {
            ElementBuilder m = this.graph.prepareVertex("v" + i, VISIBILITY_A).addPropertyValue("k1", "name", (Object)"joe", VISIBILITY_A).addExtendedData("table1", "row1", "col1", (Object)"extended", VISIBILITY_A);
            mutations.add(m);
        }
        List saveVertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.saveElementMutations(mutations, this.AUTHORIZATIONS_ALL));
        this.graph.flush();
        VertexiumAssert.assertEvents(new GraphEvent[]{new AddVertexEvent(this.graph, (Vertex)saveVertices.get(0)), new AddPropertyEvent(this.graph, (Element)saveVertices.get(0), ((Element)saveVertices.get(0)).getProperty("k1", "name")), new AddExtendedDataEvent(this.graph, (Element)saveVertices.get(0), "table1", "row1", "col1", null, (Object)"extended", VISIBILITY_A), new AddVertexEvent(this.graph, (Vertex)saveVertices.get(1)), new AddPropertyEvent(this.graph, (Element)saveVertices.get(1), ((Element)saveVertices.get(1)).getProperty("k1", "name")), new AddExtendedDataEvent(this.graph, (Element)saveVertices.get(1), "table1", "row1", "col1", null, (Object)"extended", VISIBILITY_A)});
        VertexiumAssert.clearGraphEvents();
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_ALL).vertices();
        VertexiumAssert.assertResultsCount(2, 2, vertices);
        QueryResultsIterable items = this.graph.query(this.AUTHORIZATIONS_ALL).has("col1", (Object)"extended").search();
        VertexiumAssert.assertResultsCount(2, 2, items);
        mutations.clear();
        mutations.add(((Vertex)saveVertices.get(0)).prepareMutation());
        this.graph.saveElementMutations(mutations, this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        VertexiumAssert.assertEvents(new GraphEvent[0]);
    }

    @Test
    public void testAddValuesToExistingProperties() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        this.graph.defineProperty("p1").dataType(String.class).sortable(true).textIndexHint((Collection)TextIndexHint.ALL).define();
        v1.addPropertyValue("k1", "p1", (Object)"val1", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)this.getGraph().query(this.AUTHORIZATIONS_ALL).has("p1", (Object)"val1").vertexIds(), "v1");
        v1.addPropertyValue("k2", "p1", (Object)"val2", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)this.getGraph().query(this.AUTHORIZATIONS_ALL).has("p1", (Object)"val1").vertexIds(), "v1");
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)this.getGraph().query(this.AUTHORIZATIONS_ALL).has("p1", (Object)"val2").vertexIds(), "v1");
        VertexiumAssert.assertResultsCount(0, 0, this.getGraph().query(this.AUTHORIZATIONS_ALL).has("p1", (Object)"val3").vertexIds());
        v1.addPropertyValue("k1", "p1", (Object)"val3", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)this.getGraph().query(this.AUTHORIZATIONS_ALL).has("p1", (Object)"val3").vertexIds(), "v1");
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)this.getGraph().query(this.AUTHORIZATIONS_ALL).has("p1", (Object)"val2").vertexIds(), "v1");
        VertexiumAssert.assertResultsCount(0, 0, this.getGraph().query(this.AUTHORIZATIONS_ALL).has("p1", (Object)"val1").vertexIds());
    }

    @Test
    public void testRemoveValuesFromMultivalueProperties() {
        this.graph.defineProperty("p1").dataType(String.class).sortable(true).textIndexHint((Collection)TextIndexHint.ALL).define();
        Vertex v1 = (Vertex)this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("k1", "p1", (Object)"v1", VISIBILITY_A).addPropertyValue("k2", "p1", (Object)"v2", VISIBILITY_A).save(this.AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)this.getGraph().query(this.AUTHORIZATIONS_ALL).has("p1", (Object)"v1").vertexIds(), "v1");
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)this.getGraph().query(this.AUTHORIZATIONS_ALL).has("p1", (Object)"v2").vertexIds(), "v1");
        VertexiumAssert.assertResultsCount(0, 0, this.getGraph().query(this.AUTHORIZATIONS_ALL).has("p1", (Object)"v3").vertexIds());
        v1.prepareMutation().addPropertyValue("k3", "p1", (Object)"v3", VISIBILITY_A).deleteProperty("k1", "p1", VISIBILITY_A).save(this.AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)this.getGraph().query(this.AUTHORIZATIONS_ALL).has("p1", (Object)"v2").vertexIds(), "v1");
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)this.getGraph().query(this.AUTHORIZATIONS_ALL).has("p1", (Object)"v3").vertexIds(), "v1");
        VertexiumAssert.assertResultsCount(0, 0, this.getGraph().query(this.AUTHORIZATIONS_ALL).has("p1", (Object)"v1").vertexIds());
        v1.deleteProperty("k2", "p1", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)this.getGraph().query(this.AUTHORIZATIONS_ALL).has("p1", (Object)"v3").vertexIds(), "v1");
        VertexiumAssert.assertResultsCount(0, 0, this.getGraph().query(this.AUTHORIZATIONS_ALL).has("p1", (Object)"v1").vertexIds());
        VertexiumAssert.assertResultsCount(0, 0, this.getGraph().query(this.AUTHORIZATIONS_ALL).has("p1", (Object)"v2").vertexIds());
    }

    @Test
    public void testGraphQueryWithQueryString() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        v1.setProperty("description", (Object)"This is vertex 1 - dog.", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        v2.setProperty("description", (Object)"This is vertex 2 - cat.", VISIBILITY_B, this.AUTHORIZATIONS_ALL);
        Edge e1 = this.graph.addEdge("e1", v1, v2, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        e1.setProperty("description", (Object)"This is edge 1 - dog to cat.", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.graph.query("vertex", this.AUTHORIZATIONS_A_AND_B).vertices();
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query("vertex", this.AUTHORIZATIONS_A).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query("dog", this.AUTHORIZATIONS_A).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query("dog", this.AUTHORIZATIONS_B).vertices();
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        QueryResultsIterable elements = this.graph.query("dog", this.AUTHORIZATIONS_A_AND_B).elements();
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)elements));
    }

    @Test
    public void testGraphQueryWithQueryStringWithAuthorizations() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        v1.setProperty("description", (Object)"This is vertex 1 - dog.", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_B, this.AUTHORIZATIONS_ALL);
        v2.setProperty("description", (Object)"This is vertex 2 - cat.", VISIBILITY_B, this.AUTHORIZATIONS_ALL);
        Edge e1 = this.graph.addEdge("e1", v1, v2, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        e1.setProperty("edgeDescription", (Object)"This is edge 1 - dog to cat.", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        if (this.isIterableWithTotalHitsSupported((Iterable<Vertex>)vertices)) {
            IterableWithTotalHits hits = (IterableWithTotalHits)vertices;
            Assert.assertEquals((long)1L, (long)hits.getTotalHits());
        }
        QueryResultsIterable edges = this.graph.query(this.AUTHORIZATIONS_A).edges();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)edges));
    }

    protected boolean isIterableWithTotalHitsSupported(Iterable<Vertex> vertices) {
        return vertices instanceof IterableWithTotalHits;
    }

    @Test
    public void testGraphQueryHas() {
        String agePropertyName = "age.property";
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("text", (Object)"hello", VISIBILITY_A).setProperty(agePropertyName, (Object)25, VISIBILITY_A).setProperty("birthDate", (Object)new DateOnly(1989, 1, 5), VISIBILITY_A).setProperty("lastAccessed", (Object)this.createDate(2014, 2, 24, 13, 0, 5), VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_A).setProperty("text", (Object)"world", VISIBILITY_A).setProperty(agePropertyName, (Object)30, VISIBILITY_A).setProperty("birthDate", (Object)new DateOnly(1984, 1, 5), VISIBILITY_A).setProperty("lastAccessed", (Object)this.createDate(2014, 2, 25, 13, 0, 5), VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A).has(agePropertyName).vertices();
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        try {
            vertices = this.graph.query(this.AUTHORIZATIONS_A).hasNot(agePropertyName).vertices();
            Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        }
        catch (VertexiumNotSupportedException ex) {
            LOGGER.warn("skipping. Not supported", (Throwable)ex);
        }
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has(agePropertyName, (Predicate)Compare.EQUAL, (Object)25).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has(agePropertyName, (Predicate)Compare.EQUAL, (Object)25).has("birthDate", (Predicate)Compare.EQUAL, (Object)this.createDate(1989, 1, 5)).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query("hello", this.AUTHORIZATIONS_A).has(agePropertyName, (Predicate)Compare.EQUAL, (Object)25).has("birthDate", (Predicate)Compare.EQUAL, (Object)this.createDate(1989, 1, 5)).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has("birthDate", (Predicate)Compare.EQUAL, (Object)this.createDate(1989, 1, 5)).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has("lastAccessed", (Predicate)Compare.EQUAL, (Object)this.createDate(2014, 2, 24, 13, 0, 5)).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has(agePropertyName, (Object)25).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        Assert.assertEquals((long)25L, (long)((Integer)((Vertex)org.vertexium.util.IterableUtils.toList((Iterable)vertices).get(0)).getPropertyValue(agePropertyName)).intValue());
        try {
            vertices = this.graph.query(this.AUTHORIZATIONS_A).hasNot(agePropertyName, (Object)25).vertices();
            Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
            Assert.assertEquals((long)30L, (long)((Integer)((Vertex)org.vertexium.util.IterableUtils.toList((Iterable)vertices).get(0)).getPropertyValue(agePropertyName)).intValue());
        }
        catch (VertexiumNotSupportedException ex) {
            LOGGER.warn("skipping. Not supported", (Throwable)ex);
        }
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has(agePropertyName, (Predicate)Compare.GREATER_THAN_EQUAL, (Object)25).vertices();
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has(agePropertyName, (Predicate)Contains.IN, (Object)new Integer[]{25}).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        Assert.assertEquals((long)25L, (long)((Integer)((Vertex)org.vertexium.util.IterableUtils.toList((Iterable)vertices).get(0)).getPropertyValue(agePropertyName)).intValue());
        try {
            vertices = this.graph.query(this.AUTHORIZATIONS_A).has(agePropertyName, (Predicate)Contains.NOT_IN, (Object)new Integer[]{25}).vertices();
            Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
            Assert.assertEquals((long)30L, (long)((Integer)((Vertex)org.vertexium.util.IterableUtils.toList((Iterable)vertices).get(0)).getPropertyValue(agePropertyName)).intValue());
        }
        catch (VertexiumNotSupportedException ex) {
            LOGGER.warn("skipping. Not supported", (Throwable)ex);
        }
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has(agePropertyName, (Predicate)Contains.IN, (Object)new Integer[]{25, 30}).vertices();
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has(agePropertyName, (Predicate)Compare.GREATER_THAN, (Object)25).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has(agePropertyName, (Predicate)Compare.LESS_THAN, (Object)26).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has(agePropertyName, (Predicate)Compare.LESS_THAN_EQUAL, (Object)25).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has(agePropertyName, (Predicate)Compare.NOT_EQUAL, (Object)25).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has("lastAccessed", (Predicate)Compare.EQUAL, (Object)new DateOnly(2014, 2, 24)).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query("*", this.AUTHORIZATIONS_A).has(agePropertyName, (Predicate)Contains.IN, (Object)new Integer[]{25, 30}).vertices();
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testGraphQueryMultiPropertyHas() {
        this.graph.defineProperty("unusedFloatProp").dataType(Float.class).define();
        this.graph.defineProperty("unusedDateProp").dataType(Date.class).define();
        this.graph.defineProperty("unusedStringProp").dataType(String.class).textIndexHint((Collection)TextIndexHint.ALL).define();
        String agePropertyName = "age.property";
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("text", (Object)"hello", VISIBILITY_A).setProperty("text2", (Object)"foo", VISIBILITY_A).setProperty("text3", (Object)"bar", VISIBILITY_A).setProperty(agePropertyName, (Object)25, VISIBILITY_A).setProperty("birthDate", (Object)new DateOnly(1989, 1, 5), VISIBILITY_A).setProperty("lastAccessed", (Object)this.createDate(2014, 2, 24, 13, 0, 5), VISIBILITY_A).setProperty("location", (Object)new GeoPoint(38.9544, -77.3464, "Reston, VA"), VISIBILITY_A).addExtendedData("table1", "row1", "column1", (Object)"value1", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_A).setProperty("text", (Object)"world", VISIBILITY_A).setProperty("text2", (Object)"foo", VISIBILITY_A).setProperty(agePropertyName, (Object)30, VISIBILITY_A).setProperty("birthDate", (Object)new DateOnly(1984, 1, 5), VISIBILITY_A).setProperty("lastAccessed", (Object)this.createDate(2014, 2, 25, 13, 0, 5), VISIBILITY_A).setProperty("location", (Object)new GeoPoint(38.9186, -77.2297, "Reston, VA"), VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A).has(String.class).vertices();
        VertexiumAssert.assertResultsCount(2, (QueryResultsIterable<? extends Element>)vertices);
        VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)vertices, "v1", "v2");
        vertices = this.graph.query(this.AUTHORIZATIONS_A).hasNot(String.class).vertices();
        VertexiumAssert.assertResultsCount(0, (QueryResultsIterable<? extends Element>)vertices);
        try {
            this.graph.query(this.AUTHORIZATIONS_A).has(Double.class).vertices();
            Assert.fail((String)"Should not allow searching for a dataType that there are no mappings for");
        }
        catch (VertexiumException vertexiumException) {
            // empty catch block
        }
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has(Float.class).vertices();
        VertexiumAssert.assertResultsCount(0, (QueryResultsIterable<? extends Element>)vertices);
        vertices = this.graph.query(this.AUTHORIZATIONS_A).hasNot(Float.class).vertices();
        VertexiumAssert.assertResultsCount(2, (QueryResultsIterable<? extends Element>)vertices);
        VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)vertices, "v1", "v2");
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has(Arrays.asList("text3", "unusedStringProp")).vertices();
        VertexiumAssert.assertResultsCount(1, (QueryResultsIterable<? extends Element>)vertices);
        VertexiumAssert.assertVertexIds((Iterable<Vertex>)vertices, "v1");
        vertices = this.graph.query(this.AUTHORIZATIONS_A).hasNot(Arrays.asList("text3", "unusedStringProp")).vertices();
        VertexiumAssert.assertResultsCount(1, (QueryResultsIterable<? extends Element>)vertices);
        VertexiumAssert.assertVertexIds((Iterable<Vertex>)vertices, "v2");
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has(String.class, (Predicate)Compare.EQUAL, (Object)"hello").vertices();
        VertexiumAssert.assertResultsCount(1, (QueryResultsIterable<? extends Element>)vertices);
        VertexiumAssert.assertVertexIds((Iterable<Vertex>)vertices, "v1");
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has(String.class, (Predicate)Compare.EQUAL, (Object)"foo").vertices();
        VertexiumAssert.assertResultsCount(2, (QueryResultsIterable<? extends Element>)vertices);
        VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)vertices, "v1", "v2");
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has(Arrays.asList("text", "text2"), (Predicate)Compare.EQUAL, (Object)"hello").vertices();
        VertexiumAssert.assertResultsCount(1, (QueryResultsIterable<? extends Element>)vertices);
        VertexiumAssert.assertVertexIds((Iterable<Vertex>)vertices, "v1");
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has(Arrays.asList("text", "text2"), (Predicate)Compare.EQUAL, (Object)"foo").vertices();
        VertexiumAssert.assertResultsCount(2, (QueryResultsIterable<? extends Element>)vertices);
        VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)vertices, "v1", "v2");
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has(Arrays.asList("text"), (Predicate)Compare.EQUAL, (Object)"foo").vertices();
        VertexiumAssert.assertResultsCount(0, (QueryResultsIterable<? extends Element>)vertices);
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has(Number.class, (Predicate)Compare.EQUAL, (Object)25).vertices();
        VertexiumAssert.assertResultsCount(1, (QueryResultsIterable<? extends Element>)vertices);
        VertexiumAssert.assertVertexIds((Iterable<Vertex>)vertices, "v1");
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has(Date.class, (Predicate)Compare.GREATER_THAN, (Object)this.createDate(2014, 2, 25, 0, 0, 0)).vertices();
        VertexiumAssert.assertResultsCount(1, (QueryResultsIterable<? extends Element>)vertices);
        VertexiumAssert.assertVertexIds((Iterable<Vertex>)vertices, "v2");
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has(Date.class, (Predicate)Compare.LESS_THAN, (Object)this.createDate(2014, 2, 25, 0, 0, 0)).vertices();
        VertexiumAssert.assertResultsCount(2, (QueryResultsIterable<? extends Element>)vertices);
        VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)vertices, "v1", "v2");
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has(Date.class, (Predicate)Compare.LESS_THAN, (Object)new DateOnly(1985, 1, 5)).vertices();
        VertexiumAssert.assertResultsCount(1, (QueryResultsIterable<? extends Element>)vertices);
        VertexiumAssert.assertVertexIds((Iterable<Vertex>)vertices, "v2");
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has(Date.class, (Predicate)Compare.GREATER_THAN, (Object)new DateOnly(2000, 1, 1)).vertices();
        VertexiumAssert.assertResultsCount(2, (QueryResultsIterable<? extends Element>)vertices);
        VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)vertices, "v1", "v2");
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has(GeoShape.class, (Predicate)GeoCompare.WITHIN, (Object)new GeoCircle(38.9186, -77.2297, 1.0)).vertices();
        VertexiumAssert.assertResultsCount(1, (QueryResultsIterable<? extends Element>)vertices);
        VertexiumAssert.assertVertexIds((Iterable<Vertex>)vertices, "v2");
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has(GeoPoint.class, (Predicate)GeoCompare.WITHIN, (Object)new GeoCircle(38.9186, -77.2297, 1.0)).vertices();
        VertexiumAssert.assertResultsCount(1, (QueryResultsIterable<? extends Element>)vertices);
        VertexiumAssert.assertVertexIds((Iterable<Vertex>)vertices, "v2");
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has(GeoPoint.class, (Predicate)GeoCompare.WITHIN, (Object)new GeoCircle(38.9186, -77.2297, 25.0)).vertices();
        VertexiumAssert.assertResultsCount(2, (QueryResultsIterable<? extends Element>)vertices);
        VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)vertices, "v1", "v2");
        try {
            this.graph.query(this.AUTHORIZATIONS_A).has(Date.class, (Predicate)GeoCompare.WITHIN, (Object)new GeoCircle(38.9186, -77.2297, 1.0)).vertices().getTotalHits();
            Assert.fail((String)"GeoCompare searches should not be allowed for date fields");
        }
        catch (VertexiumException vertexiumException) {
            // empty catch block
        }
        try {
            this.graph.query(this.AUTHORIZATIONS_A).has(Double.class, (Predicate)Compare.EQUAL, (Object)25).vertices();
            Assert.fail((String)"Should not allow searching for a dataType that there are no mappings for");
        }
        catch (VertexiumException vertexiumException) {
            // empty catch block
        }
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has(Float.class, (Predicate)Compare.EQUAL, (Object)25).vertices();
        VertexiumAssert.assertResultsCount(0, (QueryResultsIterable<? extends Element>)vertices);
    }

    @Test
    public void testGraphQueryHasAuthorization() {
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("text", (Object)"hello", VISIBILITY_A).save(this.AUTHORIZATIONS_ALL);
        this.graph.prepareVertex("v2", VISIBILITY_A).setProperty("text.with.dots", (Object)"world", VISIBILITY_B).save(this.AUTHORIZATIONS_ALL);
        this.graph.prepareVertex("v3", VISIBILITY_C).setProperty("text", (Object)"world", VISIBILITY_A).save(this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_ALL).hasAuthorization(new String[]{VISIBILITY_A_STRING}).vertices();
        VertexiumAssert.assertResultsCount(3, 3, vertices);
        VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)vertices, "v1", "v2", "v3");
        vertices = this.graph.query(this.AUTHORIZATIONS_ALL).hasAuthorization(new String[]{VISIBILITY_B_STRING}).vertices();
        VertexiumAssert.assertResultsCount(1, 1, vertices);
        VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)vertices, "v2");
        vertices = this.graph.query(this.AUTHORIZATIONS_ALL).hasAuthorization(new String[]{VISIBILITY_C_STRING}).vertices();
        VertexiumAssert.assertResultsCount(1, 1, vertices);
        VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)vertices, "v3");
    }

    @Test
    public void testGraphQueryHasAuthorizationWithHidden() {
        Vertex v1 = this.graph.addVertex("v1", Visibility.EMPTY, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", Visibility.EMPTY, this.AUTHORIZATIONS_A);
        Vertex v3 = (Vertex)this.graph.prepareVertex("v3", VISIBILITY_EMPTY).addPropertyValue("junit", "name", (Object)"value", VISIBILITY_B).save(this.AUTHORIZATIONS_B_AND_C);
        Edge e1 = this.graph.addEdge("e1", v1.getId(), v2.getId(), "junit edge", Visibility.EMPTY, this.AUTHORIZATIONS_A);
        this.graph.flush();
        this.graph.markEdgeHidden(e1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.markVertexHidden(v1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        v3.markPropertyHidden("junit", "name", VISIBILITY_B, VISIBILITY_C, this.AUTHORIZATIONS_B_AND_C);
        this.graph.flush();
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A).hasAuthorization(new String[]{VISIBILITY_A_STRING}).vertices(FetchHint.ALL);
        VertexiumAssert.assertResultsCount(0, (QueryResultsIterable<? extends Element>)vertices);
        QueryResultsIterable vertexIds = this.graph.query(this.AUTHORIZATIONS_A).hasAuthorization(new String[]{VISIBILITY_A_STRING}).vertexIds(IdFetchHint.NONE);
        VertexiumAssert.assertResultsCount(0, 0, vertexIds);
        vertexIds = this.graph.query(this.AUTHORIZATIONS_A).hasAuthorization(new String[]{VISIBILITY_A_STRING}).vertexIds();
        VertexiumAssert.assertResultsCount(0, 0, vertexIds);
        vertices = this.graph.query(this.AUTHORIZATIONS_A).hasAuthorization(new String[]{VISIBILITY_A_STRING}).vertices(FetchHint.ALL_INCLUDING_HIDDEN);
        VertexiumAssert.assertResultsCount(1, (QueryResultsIterable<? extends Element>)vertices);
        VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)vertices, v1.getId());
        vertices = this.graph.query(this.AUTHORIZATIONS_B_AND_C).hasAuthorization(new String[]{VISIBILITY_C_STRING}).vertices(FetchHint.ALL_INCLUDING_HIDDEN);
        VertexiumAssert.assertResultsCount(1, (QueryResultsIterable<? extends Element>)vertices);
        VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)vertices, v3.getId());
        vertexIds = this.graph.query(this.AUTHORIZATIONS_A).hasAuthorization(new String[]{VISIBILITY_A_STRING}).vertexIds(IdFetchHint.ALL_INCLUDING_HIDDEN);
        VertexiumAssert.assertResultsCount(1, 1, vertexIds);
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)vertexIds, v1.getId());
        vertexIds = this.graph.query(this.AUTHORIZATIONS_B_AND_C).hasAuthorization(new String[]{VISIBILITY_C_STRING}).vertexIds(IdFetchHint.ALL_INCLUDING_HIDDEN);
        VertexiumAssert.assertResultsCount(1, 1, vertexIds);
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)vertexIds, v3.getId());
        QueryResultsIterable edges = this.graph.query(this.AUTHORIZATIONS_A).hasAuthorization(new String[]{VISIBILITY_A_STRING}).edges(FetchHint.ALL);
        VertexiumAssert.assertResultsCount(0, (QueryResultsIterable<? extends Element>)edges);
        QueryResultsIterable edgeIds = this.graph.query(this.AUTHORIZATIONS_A).hasAuthorization(new String[]{VISIBILITY_A_STRING}).edgeIds(IdFetchHint.NONE);
        VertexiumAssert.assertResultsCount(0, 0, edgeIds);
        edgeIds = this.graph.query(this.AUTHORIZATIONS_A).hasAuthorization(new String[]{VISIBILITY_A_STRING}).edgeIds();
        VertexiumAssert.assertResultsCount(0, 0, edgeIds);
        edges = this.graph.query(this.AUTHORIZATIONS_A).hasAuthorization(new String[]{VISIBILITY_A_STRING}).edges(FetchHint.ALL_INCLUDING_HIDDEN);
        VertexiumAssert.assertResultsCount(1, (QueryResultsIterable<? extends Element>)edges);
        VertexiumAssert.assertEdgeIdsAnyOrder((Iterable<Edge>)edges, e1.getId());
        edgeIds = this.graph.query(this.AUTHORIZATIONS_A).hasAuthorization(new String[]{VISIBILITY_A_STRING}).edgeIds(IdFetchHint.ALL_INCLUDING_HIDDEN);
        VertexiumAssert.assertResultsCount(1, 1, edgeIds);
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)edgeIds, e1.getId());
        QueryResultsIterable elements = this.graph.query(this.AUTHORIZATIONS_A).hasAuthorization(new String[]{VISIBILITY_A_STRING}).elements(FetchHint.ALL);
        VertexiumAssert.assertResultsCount(0, (QueryResultsIterable<? extends Element>)elements);
        QueryResultsIterable elementIds = this.graph.query(this.AUTHORIZATIONS_A).hasAuthorization(new String[]{VISIBILITY_A_STRING}).elementIds(IdFetchHint.NONE);
        VertexiumAssert.assertResultsCount(0, 0, elementIds);
        elementIds = this.graph.query(this.AUTHORIZATIONS_A).hasAuthorization(new String[]{VISIBILITY_A_STRING}).elementIds();
        VertexiumAssert.assertResultsCount(0, 0, elementIds);
        elements = this.graph.query(this.AUTHORIZATIONS_A).hasAuthorization(new String[]{VISIBILITY_A_STRING}).elements(FetchHint.ALL_INCLUDING_HIDDEN);
        VertexiumAssert.assertResultsCount(2, (QueryResultsIterable<? extends Element>)elements);
        VertexiumAssert.assertElementIdsAnyOrder((Iterable<? extends Element>)elements, v1.getId(), e1.getId());
        elementIds = this.graph.query(this.AUTHORIZATIONS_A).hasAuthorization(new String[]{VISIBILITY_A_STRING}).elementIds(IdFetchHint.ALL_INCLUDING_HIDDEN);
        VertexiumAssert.assertResultsCount(2, 2, elementIds);
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)elementIds, v1.getId(), e1.getId());
    }

    @Test
    public void testGraphQueryContainsNotIn() {
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("status", (Object)"0", VISIBILITY_A).setProperty("name", (Object)"susan", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_A).setProperty("status", (Object)"1", VISIBILITY_A).setProperty("name", (Object)"joe", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v3", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v4", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v5", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v6", VISIBILITY_A).setProperty("status", (Object)"0", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        try {
            QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A).has("status", (Predicate)Contains.NOT_IN, (Object)new String[]{"0"}).vertices();
            Assert.assertEquals((long)4L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
            vertices = this.graph.query(this.AUTHORIZATIONS_A).has("status", (Predicate)Contains.NOT_IN, (Object)new String[]{"0", "1"}).vertices();
            Assert.assertEquals((long)3L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        }
        catch (VertexiumNotSupportedException ex) {
            LOGGER.warn("skipping. Not supported", (Throwable)ex);
        }
    }

    @Test
    public void testGraphQueryHasGeoPointAndExact() {
        this.graph.defineProperty("location").dataType(GeoPoint.class).define();
        this.graph.defineProperty("exact").dataType(String.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH}).define();
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("prop1", (Object)"val1", VISIBILITY_A).setProperty("exact", (Object)"val1", VISIBILITY_A).setProperty("location", (Object)new GeoPoint(38.9186, -77.2297), VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_A).setProperty("prop2", (Object)"val2", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        QueryResultsIterable results = this.graph.query("*", this.AUTHORIZATIONS_A_AND_B).has("prop1").elements();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)results));
        Assert.assertEquals((long)1L, (long)((IterableWithTotalHits)results).getTotalHits());
        Assert.assertEquals((Object)"v1", (Object)((Element)results.iterator().next()).getId());
        results = this.graph.query("*", this.AUTHORIZATIONS_A_AND_B).has("exact").elements();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)results));
        Assert.assertEquals((long)1L, (long)((IterableWithTotalHits)results).getTotalHits());
        Assert.assertEquals((Object)"v1", (Object)((Element)results.iterator().next()).getId());
        results = this.graph.query("*", this.AUTHORIZATIONS_A_AND_B).has("location").elements();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)results));
        Assert.assertEquals((long)1L, (long)((IterableWithTotalHits)results).getTotalHits());
        Assert.assertEquals((Object)"v1", (Object)((Element)results.iterator().next()).getId());
    }

    @Test
    public void testGraphQueryHasNotGeoPointAndExact() {
        this.graph.defineProperty("location").dataType(GeoPoint.class).define();
        this.graph.defineProperty("exact").dataType(String.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH}).define();
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("prop1", (Object)"val1", VISIBILITY_A).setProperty("exact", (Object)"val1", VISIBILITY_A).setProperty("location", (Object)new GeoPoint(38.9186, -77.2297), VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_A).setProperty("prop2", (Object)"val2", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        QueryResultsIterable results = this.graph.query("*", this.AUTHORIZATIONS_A_AND_B).hasNot("prop1").elements();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)results));
        Assert.assertEquals((long)1L, (long)((IterableWithTotalHits)results).getTotalHits());
        Assert.assertEquals((Object)"v2", (Object)((Element)results.iterator().next()).getId());
        results = this.graph.query("*", this.AUTHORIZATIONS_A_AND_B).hasNot("prop3").sort("__ID__", SortDirection.ASCENDING).elements();
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)results));
        Iterator iterator = results.iterator();
        Assert.assertEquals((Object)"v1", (Object)((Element)iterator.next()).getId());
        Assert.assertEquals((Object)"v2", (Object)((Element)iterator.next()).getId());
        results = this.graph.query("*", this.AUTHORIZATIONS_A_AND_B).hasNot("exact").elements();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)results));
        Assert.assertEquals((long)1L, (long)((IterableWithTotalHits)results).getTotalHits());
        Assert.assertEquals((Object)"v2", (Object)((Element)results.iterator().next()).getId());
        results = this.graph.query("*", this.AUTHORIZATIONS_A_AND_B).hasNot("location").elements();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)results));
        Assert.assertEquals((long)1L, (long)((IterableWithTotalHits)results).getTotalHits());
        Assert.assertEquals((Object)"v2", (Object)((Element)results.iterator().next()).getId());
    }

    @Test
    public void testGraphQueryHasTwoVisibilities() {
        String agePropertyName = "age.property";
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("name", (Object)"v1", VISIBILITY_A).setProperty(agePropertyName, (Object)25, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_A).setProperty("name", (Object)"v2", VISIBILITY_A).addPropertyValue("k1", agePropertyName, (Object)30, VISIBILITY_A).addPropertyValue("k2", agePropertyName, (Object)35, VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v3", VISIBILITY_A).setProperty("name", (Object)"v3", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has(agePropertyName).vertices();
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).hasNot(agePropertyName).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testGraphQueryIn() {
        String namePropertyName = "full.name";
        this.graph.defineProperty("age").dataType(Integer.class).sortable(true).define();
        this.graph.defineProperty(namePropertyName).dataType(String.class).sortable(true).textIndexHint((Collection)TextIndexHint.ALL).define();
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty(namePropertyName, (Object)"joe ferner", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_A).setProperty(namePropertyName, (Object)"bob smith", VISIBILITY_B).setProperty("age", (Object)25, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v3", VISIBILITY_A).setProperty(namePropertyName, (Object)"tom thumb", VISIBILITY_A).setProperty("age", (Object)30, VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("joe ferner");
        strings.add("tom thumb");
        QueryResultsIterable results = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has(namePropertyName, (Predicate)Contains.IN, strings).vertices();
        Assert.assertEquals((long)2L, (long)((IterableWithTotalHits)results).getTotalHits());
        VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)results, "v1", "v3");
    }

    @Test
    public void testGraphQuerySort() {
        String namePropertyName = "first.name";
        String agePropertyName = "age";
        String genderPropertyName = "gender";
        this.graph.defineProperty(agePropertyName).dataType(Integer.class).sortable(true).define();
        this.graph.defineProperty(namePropertyName).dataType(String.class).sortable(true).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH}).define();
        this.graph.defineProperty(genderPropertyName).dataType(String.class).sortable(true).textIndexHint(new TextIndexHint[]{TextIndexHint.FULL_TEXT, TextIndexHint.EXACT_MATCH}).define();
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty(namePropertyName, (Object)"joe", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_A).setProperty(namePropertyName, (Object)"bob", VISIBILITY_B).setProperty(agePropertyName, (Object)25, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v3", VISIBILITY_A).setProperty(namePropertyName, (Object)"tom", VISIBILITY_A).setProperty(agePropertyName, (Object)30, VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v4", VISIBILITY_A).setProperty(namePropertyName, (Object)"tom", VISIBILITY_A).setProperty(agePropertyName, (Object)35, VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareEdge("e1", "v1", "v2", LABEL_LABEL2, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareEdge("e2", "v1", "v2", LABEL_LABEL1, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareEdge("e3", "v1", "v2", LABEL_LABEL3, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        List vertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(this.AUTHORIZATIONS_A_AND_B).sort(agePropertyName, SortDirection.ASCENDING).vertices());
        VertexiumAssert.assertVertexIds(vertices, "v2", "v3", "v4", "v1");
        vertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(this.AUTHORIZATIONS_A_AND_B).sort(agePropertyName, SortDirection.DESCENDING).vertices());
        VertexiumAssert.assertVertexIds(vertices, "v4", "v3", "v2", "v1");
        vertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(this.AUTHORIZATIONS_A_AND_B).sort(namePropertyName, SortDirection.ASCENDING).vertices());
        Assert.assertEquals((long)4L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        Assert.assertEquals((Object)"v2", (Object)((Vertex)vertices.get(0)).getId());
        Assert.assertEquals((Object)"v1", (Object)((Vertex)vertices.get(1)).getId());
        Assert.assertTrue((((Vertex)vertices.get(2)).getId().equals("v3") || ((Vertex)vertices.get(2)).getId().equals("v4") ? 1 : 0) != 0);
        Assert.assertTrue((((Vertex)vertices.get(3)).getId().equals("v3") || ((Vertex)vertices.get(3)).getId().equals("v4") ? 1 : 0) != 0);
        vertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(this.AUTHORIZATIONS_A_AND_B).sort(namePropertyName, SortDirection.DESCENDING).vertices());
        Assert.assertEquals((long)4L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        Assert.assertTrue((((Vertex)vertices.get(0)).getId().equals("v3") || ((Vertex)vertices.get(0)).getId().equals("v4") ? 1 : 0) != 0);
        Assert.assertTrue((((Vertex)vertices.get(1)).getId().equals("v3") || ((Vertex)vertices.get(1)).getId().equals("v4") ? 1 : 0) != 0);
        Assert.assertEquals((Object)"v1", (Object)((Vertex)vertices.get(2)).getId());
        Assert.assertEquals((Object)"v2", (Object)((Vertex)vertices.get(3)).getId());
        vertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(this.AUTHORIZATIONS_A_AND_B).sort(namePropertyName, SortDirection.ASCENDING).sort(agePropertyName, SortDirection.ASCENDING).vertices());
        VertexiumAssert.assertVertexIds(vertices, "v2", "v1", "v3", "v4");
        vertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(this.AUTHORIZATIONS_A_AND_B).sort(namePropertyName, SortDirection.ASCENDING).sort(agePropertyName, SortDirection.DESCENDING).vertices());
        VertexiumAssert.assertVertexIds(vertices, "v2", "v1", "v4", "v3");
        vertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(this.AUTHORIZATIONS_A_AND_B).sort("__ID__", SortDirection.ASCENDING).vertices());
        VertexiumAssert.assertVertexIds(vertices, "v1", "v2", "v3", "v4");
        vertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(this.AUTHORIZATIONS_A_AND_B).sort("__ID__", SortDirection.DESCENDING).vertices());
        VertexiumAssert.assertVertexIds(vertices, "v4", "v3", "v2", "v1");
        vertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(this.AUTHORIZATIONS_A_AND_B).sort("otherfield", SortDirection.ASCENDING).vertices());
        Assert.assertEquals((long)4L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        List edges = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(this.AUTHORIZATIONS_A_AND_B).sort("__edgeLabel", SortDirection.ASCENDING).edges());
        VertexiumAssert.assertEdgeIds(edges, "e2", "e1", "e3");
        edges = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(this.AUTHORIZATIONS_A_AND_B).sort("__edgeLabel", SortDirection.DESCENDING).edges());
        VertexiumAssert.assertEdgeIds(edges, "e3", "e1", "e2");
        this.graph.prepareVertex("v5", VISIBILITY_A).setProperty(genderPropertyName, (Object)"female", VISIBILITY_A).addExtendedData("table1", "row1", "column1", (Object)"value1", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v6", VISIBILITY_A).setProperty(genderPropertyName, (Object)"male", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        vertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(this.AUTHORIZATIONS_A_AND_B).sort(genderPropertyName, SortDirection.ASCENDING).vertices());
        Assert.assertEquals((long)6L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        Assert.assertEquals((Object)"v5", (Object)((Vertex)vertices.get(0)).getId());
        Assert.assertEquals((Object)"v6", (Object)((Vertex)vertices.get(1)).getId());
        Assert.assertTrue((((Vertex)vertices.get(2)).getId().equals("v2") || ((Vertex)vertices.get(2)).getId().equals("v1") ? 1 : 0) != 0);
        Assert.assertTrue((((Vertex)vertices.get(3)).getId().equals("v2") || ((Vertex)vertices.get(3)).getId().equals("v1") ? 1 : 0) != 0);
        Assert.assertTrue((((Vertex)vertices.get(4)).getId().equals("v3") || ((Vertex)vertices.get(4)).getId().equals("v4") ? 1 : 0) != 0);
        Assert.assertTrue((((Vertex)vertices.get(5)).getId().equals("v3") || ((Vertex)vertices.get(5)).getId().equals("v4") ? 1 : 0) != 0);
    }

    @Test
    public void testGraphQuerySortOnPropertyThatHasNoValuesInTheIndex() {
        this.graph.defineProperty("age").dataType(Integer.class).sortable(true).define();
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("name", (Object)"joe", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_A).setProperty("name", (Object)"bob", VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A).sort("age", SortDirection.ASCENDING).vertices();
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testGraphQuerySortOnPropertyWhichIsFullTextAndExactMatchIndexed() {
        this.graph.defineProperty("name").dataType(String.class).sortable(true).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH, TextIndexHint.FULL_TEXT}).define();
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("name", (Object)"1-2", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_A).setProperty("name", (Object)"1-1", VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v3", VISIBILITY_A).setProperty("name", (Object)"3-1", VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).sort("name", SortDirection.ASCENDING).vertices();
        VertexiumAssert.assertVertexIds((Iterable<Vertex>)vertices, "v2", "v1", "v3");
        vertices = this.graph.query("3", this.AUTHORIZATIONS_A_AND_B).vertices();
        VertexiumAssert.assertVertexIds((Iterable<Vertex>)vertices, "v3");
        vertices = this.graph.query("*", this.AUTHORIZATIONS_A_AND_B).has("name", (Predicate)Compare.EQUAL, (Object)"3-1").vertices();
        VertexiumAssert.assertVertexIds((Iterable<Vertex>)vertices, "v3");
    }

    @Test
    public void testGraphQueryVertexHasWithSecurity() {
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("age", (Object)25, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_A).setProperty("age", (Object)25, VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A).has("age", (Predicate)Compare.EQUAL, (Object)25).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        if (vertices instanceof IterableWithTotalHits) {
            Assert.assertEquals((long)1L, (long)((IterableWithTotalHits)vertices).getTotalHits());
        }
        vertices = this.graph.query(this.AUTHORIZATIONS_B).has("age", (Predicate)Compare.EQUAL, (Object)25).vertices();
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        if (vertices instanceof IterableWithTotalHits) {
            Assert.assertEquals((long)0L, (long)((IterableWithTotalHits)vertices).getTotalHits());
        }
        vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("age", (Predicate)Compare.EQUAL, (Object)25).vertices();
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        if (vertices instanceof IterableWithTotalHits) {
            Assert.assertEquals((long)2L, (long)((IterableWithTotalHits)vertices).getTotalHits());
        }
    }

    @Test
    public void testGraphQueryVertexHasWithSecurityGranularity() {
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("description", (Object)"v1", VISIBILITY_A).setProperty("age", (Object)25, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_A).setProperty("description", (Object)"v2", VISIBILITY_A).setProperty("age", (Object)25, VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A).vertices();
        boolean hasAgeVisA = false;
        boolean hasAgeVisB = false;
        for (Vertex v : vertices) {
            Property prop = v.getProperty("age");
            if (prop == null || (Integer)prop.getValue() != 25) continue;
            if (prop.getVisibility().equals((Object)VISIBILITY_A)) {
                hasAgeVisA = true;
                continue;
            }
            if (!prop.getVisibility().equals((Object)VISIBILITY_B)) continue;
            hasAgeVisB = true;
        }
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        Assert.assertTrue((String)"has a", (boolean)hasAgeVisA);
        Assert.assertFalse((String)"has b", (boolean)hasAgeVisB);
        vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).vertices();
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testGraphQueryVertexHasWithSecurityComplexFormula() {
        this.graph.prepareVertex("v1", VISIBILITY_MIXED_CASE_a).setProperty("age", (Object)25, VISIBILITY_MIXED_CASE_a).save(this.AUTHORIZATIONS_ALL);
        this.graph.prepareVertex("v2", VISIBILITY_A).setProperty("age", (Object)25, VISIBILITY_B).save(this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_MIXED_CASE_a_AND_B).has("age", (Predicate)Compare.EQUAL, (Object)25).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testGetVertexWithBadAuthorizations() {
        this.graph.addVertex("v1", VISIBILITY_EMPTY, this.AUTHORIZATIONS_A);
        this.graph.flush();
        try {
            this.graph.getVertex("v1", this.AUTHORIZATIONS_BAD);
            throw new RuntimeException("Should throw " + SecurityVertexiumException.class.getSimpleName());
        }
        catch (SecurityVertexiumException securityVertexiumException) {
            return;
        }
    }

    @Test
    public void testGraphQueryVertexNoVisibility() {
        this.graph.prepareVertex("v1", VISIBILITY_EMPTY).setProperty("text", (Object)"hello", VISIBILITY_EMPTY).setProperty("age", (Object)25, VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        QueryResultsIterable vertices = this.graph.query("hello", this.AUTHORIZATIONS_A_AND_B).has("age", (Predicate)Compare.EQUAL, (Object)25).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query("hello", this.AUTHORIZATIONS_A_AND_B).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testGraphQueryHidden() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v3 = this.graph.addVertex("v3", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Edge e1 = this.graph.addEdge("e1", "v1", "v2", "junit edge", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Edge e2 = this.graph.addEdge("e2", "v2", "v3", "junit edge", VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.flush();
        this.graph.markEdgeHidden(e1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.markVertexHidden(v1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.flush();
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A).vertices(FetchHint.ALL);
        VertexiumAssert.assertResultsCount(2, (QueryResultsIterable<? extends Element>)vertices);
        VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)vertices, v2.getId(), v3.getId());
        QueryResultsIterable vertexIds = this.graph.query(this.AUTHORIZATIONS_A).vertexIds(IdFetchHint.NONE);
        VertexiumAssert.assertResultsCount(2, 2, vertexIds);
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)vertexIds, v2.getId(), v3.getId());
        vertexIds = this.graph.query(this.AUTHORIZATIONS_A).vertexIds();
        VertexiumAssert.assertResultsCount(2, 2, vertexIds);
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)vertexIds, v2.getId(), v3.getId());
        vertices = this.graph.query(this.AUTHORIZATIONS_A).vertices(FetchHint.ALL_INCLUDING_HIDDEN);
        VertexiumAssert.assertResultsCount(3, (QueryResultsIterable<? extends Element>)vertices);
        VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)vertices, v1.getId(), v2.getId(), v3.getId());
        vertexIds = this.graph.query(this.AUTHORIZATIONS_A).vertexIds(IdFetchHint.ALL_INCLUDING_HIDDEN);
        VertexiumAssert.assertResultsCount(3, 3, vertexIds);
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)vertexIds, v1.getId(), v2.getId(), v3.getId());
        QueryResultsIterable edges = this.graph.query(this.AUTHORIZATIONS_A).edges(FetchHint.ALL);
        VertexiumAssert.assertResultsCount(1, (QueryResultsIterable<? extends Element>)edges);
        VertexiumAssert.assertEdgeIdsAnyOrder((Iterable<Edge>)edges, e2.getId());
        QueryResultsIterable edgeIds = this.graph.query(this.AUTHORIZATIONS_A).edgeIds(IdFetchHint.NONE);
        VertexiumAssert.assertResultsCount(1, 1, edgeIds);
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)edgeIds, e2.getId());
        edgeIds = this.graph.query(this.AUTHORIZATIONS_A).edgeIds();
        VertexiumAssert.assertResultsCount(1, 1, edgeIds);
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)edgeIds, e2.getId());
        edges = this.graph.query(this.AUTHORIZATIONS_A).edges(FetchHint.ALL_INCLUDING_HIDDEN);
        VertexiumAssert.assertResultsCount(2, (QueryResultsIterable<? extends Element>)edges);
        VertexiumAssert.assertEdgeIdsAnyOrder((Iterable<Edge>)edges, e1.getId(), e2.getId());
        edgeIds = this.graph.query(this.AUTHORIZATIONS_A).edgeIds(IdFetchHint.ALL_INCLUDING_HIDDEN);
        VertexiumAssert.assertResultsCount(2, 2, edgeIds);
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)edgeIds, e1.getId(), e2.getId());
        QueryResultsIterable elements = this.graph.query(this.AUTHORIZATIONS_A).elements(FetchHint.ALL);
        VertexiumAssert.assertResultsCount(3, (QueryResultsIterable<? extends Element>)elements);
        VertexiumAssert.assertElementIdsAnyOrder((Iterable<? extends Element>)elements, v2.getId(), v3.getId(), e2.getId());
        QueryResultsIterable elementIds = this.graph.query(this.AUTHORIZATIONS_A).elementIds(IdFetchHint.NONE);
        VertexiumAssert.assertResultsCount(3, 3, elementIds);
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)elementIds, v2.getId(), v3.getId(), e2.getId());
        elementIds = this.graph.query(this.AUTHORIZATIONS_A).elementIds();
        VertexiumAssert.assertResultsCount(3, 3, elementIds);
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)elementIds, v2.getId(), v3.getId(), e2.getId());
        elements = this.graph.query(this.AUTHORIZATIONS_A).elements(FetchHint.ALL_INCLUDING_HIDDEN);
        VertexiumAssert.assertResultsCount(5, (QueryResultsIterable<? extends Element>)elements);
        VertexiumAssert.assertElementIdsAnyOrder((Iterable<? extends Element>)elements, v1.getId(), v2.getId(), v3.getId(), e1.getId(), e2.getId());
        elementIds = this.graph.query(this.AUTHORIZATIONS_A).elementIds(IdFetchHint.ALL_INCLUDING_HIDDEN);
        VertexiumAssert.assertResultsCount(5, 5, elementIds);
        VertexiumAssert.assertIdsAnyOrder((Iterable<String>)elementIds, v1.getId(), v2.getId(), v3.getId(), e1.getId(), e2.getId());
    }

    @Test
    public void testGraphQueryVertexWithVisibilityChange() {
        Vertex v1 = this.graph.prepareVertex("v1", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A).vertices();
        VertexiumAssert.assertResultsCount(1, (QueryResultsIterable<? extends Element>)vertices);
        VertexiumAssert.assertVertexIds((Iterable<Vertex>)vertices, v1.getId());
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        v1 = (Vertex)v1.prepareMutation().alterElementVisibility(VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertEquals((Object)VISIBILITY_EMPTY, (Object)v1.getVisibility());
        vertices = this.graph.query(this.AUTHORIZATIONS_A).vertices();
        VertexiumAssert.assertResultsCount(1, (QueryResultsIterable<? extends Element>)vertices);
        VertexiumAssert.assertVertexIds((Iterable<Vertex>)vertices, v1.getId());
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        v1.prepareMutation().alterElementVisibility(VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        vertices = this.graph.query(this.AUTHORIZATIONS_A).vertices();
        VertexiumAssert.assertResultsCount(0, (QueryResultsIterable<? extends Element>)vertices);
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testGraphQueryVertexHasWithSecurityCantSeeVertex() {
        this.graph.prepareVertex("v1", VISIBILITY_B).setProperty("age", (Object)25, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A).has("age", (Predicate)Compare.EQUAL, (Object)25).vertices();
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("age", (Predicate)Compare.EQUAL, (Object)25).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testGraphQueryVertexHasWithSecurityCantSeeProperty() {
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("age", (Object)25, VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A).has("age", (Predicate)Compare.EQUAL, (Object)25).vertices();
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testGraphQueryEdgeHasWithSecurity() {
        Vertex v1 = this.graph.prepareVertex("v1", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        Vertex v2 = this.graph.prepareVertex("v2", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        Vertex v3 = this.graph.prepareVertex("v3", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareEdge("e1", v1, v2, LABEL_LABEL1, VISIBILITY_A).setProperty("age", (Object)25, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareEdge("e2", v1, v3, LABEL_LABEL1, VISIBILITY_A).setProperty("age", (Object)25, VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        QueryResultsIterable edges = this.graph.query(this.AUTHORIZATIONS_A).has("age", (Predicate)Compare.EQUAL, (Object)25).edges();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)edges));
    }

    @Test
    public void testGraphQueryUpdateVertex() throws NoSuchFieldException, IllegalAccessException {
        this.graph.prepareVertex("v1", VISIBILITY_EMPTY).setProperty("age", (Object)25, VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        Vertex v2 = this.graph.prepareVertex("v2", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        Vertex v3 = this.graph.prepareVertex("v3", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.addEdge("v2tov3", v2, v3, LABEL_LABEL1, VISIBILITY_EMPTY, this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        this.graph.prepareVertex("v1", VISIBILITY_EMPTY).setProperty("name", (Object)"Joe", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_EMPTY).setProperty("name", (Object)"Bob", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v3", VISIBILITY_EMPTY).setProperty("name", (Object)"Same", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        List allVertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(this.AUTHORIZATIONS_A_AND_B).vertices());
        Assert.assertEquals((long)3L, (long)org.vertexium.util.IterableUtils.count((Iterable)allVertices));
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("age", (Predicate)Compare.EQUAL, (Object)25).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("name", (Predicate)Compare.EQUAL, (Object)"Joe").vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("age", (Predicate)Compare.EQUAL, (Object)25).has("name", (Predicate)Compare.EQUAL, (Object)"Joe").vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testQueryWithVertexIds() {
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("age", (Object)25, VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("v2", VISIBILITY_A).setProperty("age", (Object)30, VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("v3", VISIBILITY_A).setProperty("age", (Object)35, VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        List vertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(new String[]{"v1", "v2"}, this.AUTHORIZATIONS_A).has("age", (Predicate)Compare.GREATER_THAN, (Object)27).vertices());
        Assert.assertEquals((long)1L, (long)vertices.size());
        Assert.assertEquals((Object)"v2", (Object)((Vertex)vertices.get(0)).getId());
        vertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(new String[]{"v1", "v2", "v3"}, this.AUTHORIZATIONS_A).has("age", (Predicate)Compare.GREATER_THAN, (Object)27).vertices());
        Assert.assertEquals((long)2L, (long)vertices.size());
        List vertexIds = org.vertexium.util.IterableUtils.toList((Iterable)new ConvertingIterable<Vertex, String>((Iterable)vertices){

            protected String convert(Vertex o) {
                return o.getId();
            }
        });
        Assert.assertTrue((String)"v2 not found", (boolean)vertexIds.contains("v2"));
        Assert.assertTrue((String)"v3 not found", (boolean)vertexIds.contains("v3"));
    }

    @Test
    public void testDisableEdgeIndexing() throws NoSuchFieldException, IllegalAccessException {
        Assume.assumeTrue((String)"disabling indexing not supported", (boolean)this.disableEdgeIndexing(this.graph));
        Vertex v1 = this.graph.prepareVertex("v1", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        Vertex v2 = this.graph.prepareVertex("v2", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareEdge("e1", v1, v2, LABEL_LABEL1, VISIBILITY_A).setProperty("prop1", (Object)"value1", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        QueryResultsIterable edges = this.graph.query(this.AUTHORIZATIONS_A).has("prop1", (Object)"value1").edges();
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)edges));
    }

    @Test
    public void testGraphQueryHasWithSpaces() {
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("name", (Object)"Joe Ferner", VISIBILITY_A).setProperty("propWithNonAlphaCharacters", (Object)"hyphen-word, etc.", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_A).setProperty("name", (Object)"Joe Smith", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        QueryResultsIterable vertices = this.graph.query("Ferner", this.AUTHORIZATIONS_A).vertices();
        Assert.assertEquals((long)1L, (long)vertices.getTotalHits());
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query("joe", this.AUTHORIZATIONS_A).vertices();
        Assert.assertEquals((long)2L, (long)vertices.getTotalHits());
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        if (this.isLuceneQueriesSupported()) {
            vertices = this.graph.query("joe AND ferner", this.AUTHORIZATIONS_A).vertices();
            Assert.assertEquals((long)1L, (long)vertices.getTotalHits());
            Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        }
        if (this.isLuceneQueriesSupported()) {
            vertices = this.graph.query("joe smith", this.AUTHORIZATIONS_A).vertices();
            List verticesList = org.vertexium.util.IterableUtils.toList((Iterable)vertices);
            Assert.assertEquals((long)2L, (long)verticesList.size());
            boolean foundV1 = false;
            boolean foundV2 = false;
            for (Vertex v : verticesList) {
                if (v.getId().equals("v1")) {
                    foundV1 = true;
                    continue;
                }
                if (v.getId().equals("v2")) {
                    foundV2 = true;
                    continue;
                }
                throw new RuntimeException("Invalid vertex id: " + v.getId());
            }
            Assert.assertTrue((boolean)foundV1);
            Assert.assertTrue((boolean)foundV2);
        }
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has("name", (Predicate)TextPredicate.CONTAINS, (Object)"Ferner").vertices();
        Assert.assertEquals((long)1L, (long)vertices.getTotalHits());
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has("name", (Predicate)TextPredicate.CONTAINS, (Object)"Joe").has("name", (Predicate)TextPredicate.CONTAINS, (Object)"Ferner").vertices();
        Assert.assertEquals((long)1L, (long)vertices.getTotalHits());
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has("name", (Predicate)TextPredicate.CONTAINS, (Object)"Joe Ferner").vertices();
        Assert.assertEquals((long)1L, (long)vertices.getTotalHits());
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has("propWithNonAlphaCharacters", (Predicate)TextPredicate.CONTAINS, (Object)"hyphen-word, etc.").vertices();
        Assert.assertEquals((long)1L, (long)vertices.getTotalHits());
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testGraphQueryWithANDOperatorAndWithExactMatchFields() {
        this.graph.defineProperty("firstName").dataType(String.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH}).define();
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("firstName", (Object)"Joe", VISIBILITY_A).setProperty("lastName", (Object)"Ferner", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_A).setProperty("firstName", (Object)"Joe", VISIBILITY_A).setProperty("lastName", (Object)"Smith", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Assume.assumeTrue((String)"lucene and queries not supported", (this.isLuceneQueriesSupported() && this.isLuceneAndQueriesSupported() ? 1 : 0) != 0);
        QueryResultsIterable vertices = this.graph.query("Joe AND ferner", this.AUTHORIZATIONS_A).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testGraphQueryHasWithSpacesAndFieldedQueryString() {
        Assume.assumeTrue((String)"fielded query not supported", (boolean)this.isFieldNamesInQuerySupported());
        this.graph.defineProperty("http://vertexium.org#name").dataType(String.class).textIndexHint((Collection)TextIndexHint.ALL).define();
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("http://vertexium.org#name", (Object)"Joe Ferner", VISIBILITY_A).setProperty("propWithHyphen", (Object)"hyphen-word", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_A).setProperty("http://vertexium.org#name", (Object)"Joe Smith", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        Assume.assumeTrue((String)"lucene queries", (boolean)this.isLuceneQueriesSupported());
        QueryResultsIterable vertices = this.graph.query("http\\:\\/\\/vertexium.org#name:Joe", this.AUTHORIZATIONS_A).vertices();
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query("http\\:\\/\\/vertexium.org#name:\"Joe Ferner\"", this.AUTHORIZATIONS_A).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
    }

    protected boolean isFieldNamesInQuerySupported() {
        return true;
    }

    protected boolean isLuceneQueriesSupported() {
        return !(this.graph.query(this.AUTHORIZATIONS_A) instanceof DefaultGraphQuery);
    }

    protected boolean isLuceneAndQueriesSupported() {
        return !(this.graph.query(this.AUTHORIZATIONS_A) instanceof DefaultGraphQuery);
    }

    @Test
    public void testStoreGeoPoint() {
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("location", (Object)new GeoPoint(38.9186, -77.2297, "Reston, VA"), VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_A).setProperty("location", (Object)new GeoPoint(38.9544, -77.3464, "Reston, VA"), VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        List vertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("location", (Predicate)GeoCompare.WITHIN, (Object)new GeoCircle(38.9186, -77.2297, 1.0)).vertices());
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        GeoPoint geoPoint = (GeoPoint)((Vertex)vertices.get(0)).getPropertyValue("location");
        Assert.assertEquals((double)38.9186, (double)geoPoint.getLatitude(), (double)0.001);
        Assert.assertEquals((double)-77.2297, (double)geoPoint.getLongitude(), (double)0.001);
        Assert.assertEquals((Object)"Reston, VA", (Object)geoPoint.getDescription());
        vertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("location", (Predicate)GeoCompare.WITHIN, (Object)new GeoCircle(38.9186, -77.2297, 25.0)).vertices());
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("location", (Predicate)GeoCompare.WITHIN, (Object)new GeoRect(new GeoPoint(39.0, -78.0), new GeoPoint(38.0, -77.0))).vertices());
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("location", (Predicate)GeoCompare.WITHIN, (Object)new GeoHash(38.9186, -77.2297, 2)).vertices());
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("location", (Predicate)GeoCompare.WITHIN, (Object)new GeoHash(38.9186, -77.2297, 3)).vertices());
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("location", (Predicate)TextPredicate.CONTAINS, (Object)"Reston").vertices());
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
    }

    protected boolean isAdvancedGeoQuerySupported() {
        return true;
    }

    @Test
    public void testStoreGeoCircle() {
        Assume.assumeTrue((String)"GeoCircle storage and queries are not supported", (boolean)this.isAdvancedGeoQuerySupported());
        GeoCircle within = new GeoCircle(38.627, -90.1994, 100.0, "St. Louis, MO - within");
        GeoCircle contains = new GeoCircle(38.627, -90.1994, 800.0, "St. Louis, MO - contains");
        GeoCircle intersects = new GeoCircle(38.627, -80.0, 500.0, "St. Louis, MO - intersects");
        GeoCircle disjoint = new GeoCircle(38.627, -70.0, 500.0, "St. Louis, MO - disjoint");
        this.doALLGeoshapeTestQueries((GeoShape)intersects, (GeoShape)disjoint, (GeoShape)within, (GeoShape)contains);
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("location", (Object)within.getDescription()).vertices();
        Assert.assertEquals((long)1L, (long)vertices.getTotalHits());
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        GeoCircle geoCircle = (GeoCircle)((Vertex)org.vertexium.util.IterableUtils.toList((Iterable)vertices).get(0)).getPropertyValue("location");
        Assert.assertEquals((Object)within, (Object)geoCircle);
        Assert.assertEquals((Object)within.getDescription(), (Object)geoCircle.getDescription());
    }

    @Test
    public void testStoreGeoRect() {
        Assume.assumeTrue((String)"GeoRect storage and queries are not supported", (boolean)this.isAdvancedGeoQuerySupported());
        GeoRect within = new GeoRect(new GeoPoint(39.52632, -91.35059), new GeoPoint(37.72767, -89.0482), "St. Louis, MO - within");
        GeoRect contains = new GeoRect(new GeoPoint(45.82157, -99.42435), new GeoPoint(31.43242, -80.97444), "St. Louis, MO - contains");
        GeoRect intersects = new GeoRect(new GeoPoint(43.1236, -85.75962), new GeoPoint(34.13039, -74.24038), "St. Louis, MO - intersects");
        GeoRect disjoint = new GeoRect(new GeoPoint(43.1236, -75.75962), new GeoPoint(34.13039, -64.24038), "St. Louis, MO - disjoint");
        this.doALLGeoshapeTestQueries((GeoShape)intersects, (GeoShape)disjoint, (GeoShape)within, (GeoShape)contains);
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("location", (Object)within.getDescription()).vertices();
        Assert.assertEquals((long)1L, (long)vertices.getTotalHits());
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        GeoRect geoRect = (GeoRect)((Vertex)org.vertexium.util.IterableUtils.toList((Iterable)vertices).get(0)).getPropertyValue("location");
        Assert.assertEquals((Object)within, (Object)geoRect);
        Assert.assertEquals((Object)within.getDescription(), (Object)geoRect.getDescription());
    }

    @Test
    public void testStoreGeoLine() {
        Assume.assumeTrue((String)"GeoLine storage and queries are not supported", (boolean)this.isAdvancedGeoQuerySupported());
        GeoLine within = new GeoLine(new GeoPoint(39.5, -90.1994), new GeoPoint(37.9, -90.1994), "St. Louis, MO - within");
        GeoLine contains = new GeoLine(new GeoPoint(35.0, -100.0), new GeoPoint(39.5, -80.0), "St. Louis, MO - contains");
        GeoLine intersects = new GeoLine(new GeoPoint(38.67, -85.0), new GeoPoint(38.67, -80.0), "St. Louis, MO - intersects");
        GeoLine disjoint = new GeoLine(new GeoPoint(38.6, -74.0), new GeoPoint(38.6, -68.0), "St. Louis, MO - disjoint");
        this.doALLGeoshapeTestQueries((GeoShape)intersects, (GeoShape)disjoint, (GeoShape)within, (GeoShape)contains);
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("location", (Object)within.getDescription()).vertices();
        Assert.assertEquals((long)1L, (long)vertices.getTotalHits());
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        GeoLine geoLine = (GeoLine)((Vertex)org.vertexium.util.IterableUtils.toList((Iterable)vertices).get(0)).getPropertyValue("location");
        Assert.assertEquals((Object)within, (Object)geoLine);
        Assert.assertEquals((Object)within.getDescription(), (Object)geoLine.getDescription());
    }

    @Test
    public void testStoreGeoPolygon() {
        Assume.assumeTrue((String)"GeoPolygon storage and queries are not supported", (boolean)this.isAdvancedGeoQuerySupported());
        GeoPolygon within = new GeoPolygon(Arrays.asList(new GeoPoint(39.4, -91.0), new GeoPoint(38.1, -91.0), new GeoPoint(38.627, -89.0), new GeoPoint(39.4, -91.0)), "St. Louis, MO - within");
        GeoPolygon contains = new GeoPolygon(Arrays.asList(new GeoPoint(50.0, -98.0), new GeoPoint(26.0, -98.0), new GeoPoint(38.627, -75.0), new GeoPoint(50.0, -98.0)), "St. Louis, MO - contains");
        GeoPolygon intersects = new GeoPolygon(Arrays.asList(new GeoPoint(43.0, -86.0), new GeoPoint(34.0, -86.0), new GeoPoint(38.627, -74.0), new GeoPoint(43.0, -86.0)), "St. Louis, MO - intersects");
        GeoPolygon disjoint = new GeoPolygon(Arrays.asList(new GeoPoint(43.0, -75.0), new GeoPoint(34.0, -75.0), new GeoPoint(38.627, -65.0), new GeoPoint(43.0, -75.0)), "St. Louis, MO - disjoint");
        within.addHole(Arrays.asList(new GeoPoint(39.0, -90.5), new GeoPoint(38.627, -89.5), new GeoPoint(38.5, -90.5), new GeoPoint(39.0, -90.5)));
        this.doALLGeoshapeTestQueries((GeoShape)intersects, (GeoShape)disjoint, (GeoShape)within, (GeoShape)contains);
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("location", (Object)within.getDescription()).vertices();
        Assert.assertEquals((long)1L, (long)vertices.getTotalHits());
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        GeoPolygon geoPolygon = (GeoPolygon)((Vertex)org.vertexium.util.IterableUtils.toList((Iterable)vertices).get(0)).getPropertyValue("location");
        Assert.assertEquals((Object)within, (Object)geoPolygon);
        Assert.assertEquals((Object)within.getDescription(), (Object)geoPolygon.getDescription());
    }

    @Test
    public void testStoreGeoCollection() {
        Assume.assumeTrue((String)"GeoCollection storage and queries are not supported", (boolean)this.isAdvancedGeoQuerySupported());
        GeoCollection within = new GeoCollection("St. Louis, MO - within").addShape((GeoShape)new GeoCircle(38.627, -90.1994, 100.0));
        GeoCollection contains = new GeoCollection("St. Louis, MO - contains").addShape((GeoShape)new GeoCircle(38.627, -90.1994, 800.0));
        GeoCollection intersects = new GeoCollection("St. Louis, MO - intersects").addShape((GeoShape)new GeoCircle(38.627, -80.0, 500.0));
        GeoCollection disjoint = new GeoCollection("St. Louis, MO - disjoint").addShape((GeoShape)new GeoCircle(38.627, -70.0, 500.0));
        within.addShape((GeoShape)new GeoPoint(38.627, -90.1994));
        this.doALLGeoshapeTestQueries((GeoShape)intersects, (GeoShape)disjoint, (GeoShape)within, (GeoShape)contains);
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("location", (Object)within.getDescription()).vertices();
        Assert.assertEquals((long)1L, (long)vertices.getTotalHits());
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        GeoCollection geoCollection = (GeoCollection)((Vertex)org.vertexium.util.IterableUtils.toList((Iterable)vertices).get(0)).getPropertyValue("location");
        Assert.assertEquals((Object)within.getGeoShapes(), (Object)geoCollection.getGeoShapes());
        Assert.assertEquals((Object)within.getDescription(), (Object)geoCollection.getDescription());
    }

    private void doALLGeoshapeTestQueries(GeoShape intersects, GeoShape disjoint, GeoShape within, GeoShape contains) {
        this.graph.defineProperty("location").dataType(GeoShape.class).define();
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("location", (Object)intersects, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_A).setProperty("location", (Object)disjoint, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v3", VISIBILITY_A).setProperty("location", (Object)within, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v4", VISIBILITY_A).setProperty("location", (Object)contains, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        GeoCircle circle = new GeoCircle(38.627, -90.1994, 500.0, "Circle");
        GeoRect rect = new GeoRect(new GeoPoint(43.1236, -95.959), new GeoPoint(34.1303, -84.4397), "Rect");
        GeoPolygon triangle = new GeoPolygon(Arrays.asList(new GeoPoint(43.1236, -95.959), new GeoPoint(34.1303, -95.959), new GeoPoint(38.627, -84.4397), new GeoPoint(43.1236, -95.959)), "Triangle");
        GeoLine line = new GeoLine(Arrays.asList(new GeoPoint(34.1303, -95.959), new GeoPoint(43.1236, -84.4397), new GeoPoint(38.627, -84.4397)), "Line");
        GeoCollection collection = new GeoCollection("Collection").addShape((GeoShape)new GeoCircle(38.627, -90.1994, 250.0)).addShape((GeoShape)new GeoLine(new GeoPoint(39.5, -84.0), new GeoPoint(38.5, -84.0)));
        Arrays.asList(circle, rect, triangle, line, collection).forEach(searchArea -> {
            QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("location", (Predicate)GeoCompare.INTERSECTS, searchArea).vertices();
            Assert.assertEquals((String)("Incorrect total hits match INTERSECTS for shape " + searchArea.getDescription()), (long)3L, (long)vertices.getTotalHits());
            VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)vertices, "v1", "v3", "v4");
            vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("location", (Predicate)GeoCompare.DISJOINT, searchArea).vertices();
            Assert.assertEquals((String)("Incorrect total hits match DISJOINT for shape " + searchArea.getDescription()), (long)1L, (long)vertices.getTotalHits());
            VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)vertices, "v2");
            if (searchArea != line) {
                vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("location", (Predicate)GeoCompare.WITHIN, searchArea).vertices();
                Assert.assertEquals((String)("Incorrect total hits match WITHIN for shape " + searchArea.getDescription()), (long)1L, (long)vertices.getTotalHits());
                VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)vertices, "v3");
                vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("location", (Predicate)GeoCompare.CONTAINS, searchArea).vertices();
                if (intersects instanceof GeoLine) {
                    Assert.assertEquals((String)("Incorrect total hits match CONTAINS for shape " + searchArea.getDescription()), (long)0L, (long)vertices.getTotalHits());
                } else {
                    Assert.assertEquals((String)("Incorrect total hits match CONTAINS for shape " + searchArea.getDescription()), (long)1L, (long)vertices.getTotalHits());
                    VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)vertices, "v4");
                }
            }
        });
        triangle.addHole(Arrays.asList(new GeoPoint(40.0, -92.5), new GeoPoint(40.0, -88.5), new GeoPoint(37.4, -88.5), new GeoPoint(37.4, -92.5), new GeoPoint(40.0, -92.5)));
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("location", (Predicate)GeoCompare.INTERSECTS, (Object)triangle).vertices();
        Assert.assertEquals((String)"Incorrect total hits match INTERSECTS for polygon with hole", (long)2L, (long)vertices.getTotalHits());
        VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)vertices, "v1", "v4");
        vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("location", (Predicate)GeoCompare.DISJOINT, (Object)triangle).vertices();
        Assert.assertEquals((String)"Incorrect total hits match DISJOINT for polygon with hole", (long)2L, (long)vertices.getTotalHits());
        VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)vertices, "v2", "v3");
        vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("location", (Predicate)GeoCompare.WITHIN, (Object)triangle).vertices();
        Assert.assertEquals((String)"Incorrect total hits match WITHIN for polygon with hole", (long)0L, (long)vertices.getTotalHits());
        vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("location", (Predicate)GeoCompare.CONTAINS, (Object)triangle).vertices();
        if (intersects instanceof GeoLine) {
            Assert.assertEquals((String)"Incorrect total hits match CONTAINS for polygon with hole", (long)0L, (long)vertices.getTotalHits());
        } else {
            Assert.assertEquals((String)"Incorrect total hits match CONTAINS for polygon with hole", (long)1L, (long)vertices.getTotalHits());
            VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)vertices, "v4");
        }
    }

    private Date createDate(int year, int month, int day) {
        return new GregorianCalendar(year, month, day).getTime();
    }

    private Date createDate(int year, int month, int day, int hour, int min, int sec) {
        return new GregorianCalendar(year, month, day, hour, min, sec).getTime();
    }

    @Test
    public void testGraphQueryRange() {
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("age", (Object)25, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_A).setProperty("age", (Object)30, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A).range("age", (Object)25, (Object)25).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query(this.AUTHORIZATIONS_A).range("age", (Object)20, (Object)29).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query(this.AUTHORIZATIONS_A).range("age", (Object)25, (Object)30).vertices();
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query(this.AUTHORIZATIONS_A).range("age", (Object)25, true, (Object)30, false).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        Assert.assertEquals((Object)25, (Object)((Vertex)org.vertexium.util.IterableUtils.toList((Iterable)vertices).get(0)).getPropertyValue("age"));
        vertices = this.graph.query(this.AUTHORIZATIONS_A).range("age", (Object)25, false, (Object)30, true).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        Assert.assertEquals((Object)30, (Object)((Vertex)org.vertexium.util.IterableUtils.toList((Iterable)vertices).get(0)).getPropertyValue("age"));
        vertices = this.graph.query(this.AUTHORIZATIONS_A).range("age", (Object)25, true, (Object)30, true).vertices();
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        vertices = this.graph.query(this.AUTHORIZATIONS_A).range("age", (Object)25, false, (Object)30, false).vertices();
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testVertexQuery() {
        String propertyName = "prop.one";
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        v1.setProperty(propertyName, (Object)"value1", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        v2.setProperty(propertyName, (Object)"value2", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        Vertex v3 = this.graph.addVertex("v3", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        v3.setProperty(propertyName, (Object)"value3", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        Edge ev1v2 = (Edge)this.graph.prepareEdge("e v1->v2", v1, v2, LABEL_LABEL1, VISIBILITY_A).setProperty(propertyName, (Object)"value1", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        Edge ev1v3 = (Edge)this.graph.prepareEdge("e v1->v3", v1, v3, LABEL_LABEL2, VISIBILITY_A).setProperty(propertyName, (Object)"value2", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareEdge("e v2->v3", v2, v3, LABEL_LABEL2, VISIBILITY_A).setProperty(propertyName, (Object)"value2", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        QueryResultsIterable vertices = v1.query(this.AUTHORIZATIONS_A).vertices();
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        IterableUtils.assertContains(v2, vertices);
        IterableUtils.assertContains(v3, vertices);
        if (this.isIterableWithTotalHitsSupported((Iterable<Vertex>)vertices)) {
            Assert.assertEquals((long)2L, (long)((IterableWithTotalHits)vertices).getTotalHits());
            vertices = v1.query(this.AUTHORIZATIONS_A).limit(Integer.valueOf(1)).vertices();
            Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
            Assert.assertEquals((long)2L, (long)((IterableWithTotalHits)vertices).getTotalHits());
        }
        vertices = v1.query(this.AUTHORIZATIONS_A).has(propertyName, (Object)"value2").vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        IterableUtils.assertContains(v2, vertices);
        QueryResultsIterable edges = v1.query(this.AUTHORIZATIONS_A).edges();
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)edges));
        IterableUtils.assertContains(ev1v2, edges);
        IterableUtils.assertContains(ev1v3, edges);
        edges = v1.query(this.AUTHORIZATIONS_A).hasEdgeLabel(new String[]{LABEL_LABEL1, LABEL_LABEL2}).edges();
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)edges));
        IterableUtils.assertContains(ev1v2, edges);
        IterableUtils.assertContains(ev1v3, edges);
        edges = v1.query(this.AUTHORIZATIONS_A).hasEdgeLabel(new String[]{LABEL_LABEL1}).edges();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)edges));
        IterableUtils.assertContains(ev1v2, edges);
        vertices = v1.query(this.AUTHORIZATIONS_A).hasEdgeLabel(new String[]{LABEL_LABEL1}).vertices();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)vertices));
        IterableUtils.assertContains(v2, vertices);
        VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)v1.query(this.AUTHORIZATIONS_A).hasDirection(Direction.OUT).vertices(), "v2", "v3");
        VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)v1.query(this.AUTHORIZATIONS_A).hasDirection(Direction.IN).vertices(), new String[0]);
        VertexiumAssert.assertEdgeIdsAnyOrder((Iterable<Edge>)v1.query(this.AUTHORIZATIONS_A).hasDirection(Direction.OUT).edges(), "e v1->v2", "e v1->v3");
        VertexiumAssert.assertEdgeIdsAnyOrder((Iterable<Edge>)v1.query(this.AUTHORIZATIONS_A).hasDirection(Direction.IN).edges(), new String[0]);
        VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)v1.query(this.AUTHORIZATIONS_A).hasOtherVertexId("v2").vertices(), "v2");
        VertexiumAssert.assertEdgeIds((Iterable<Edge>)v1.query(this.AUTHORIZATIONS_A).hasOtherVertexId("v2").edges(), "e v1->v2");
    }

    @Test
    public void testFindPaths() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v3 = this.graph.addVertex("v3", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v4 = this.graph.addVertex("v4", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v5 = this.graph.addVertex("v5", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v6 = this.graph.addVertex("v6", VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v1, v2, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v2, v4, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v1, v3, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v3, v4, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v3, v5, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v4, v6, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.flush();
        List paths = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v2", 2), this.AUTHORIZATIONS_A));
        List pathsByLabels = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v2", 2).setLabels(new String[]{LABEL_LABEL1}), this.AUTHORIZATIONS_A));
        Assert.assertEquals((Object)pathsByLabels, (Object)paths);
        List pathsByBadLabel = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v2", 2).setLabels(new String[]{LABEL_BAD}), this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)0L, (long)pathsByBadLabel.size());
        this.assertPaths(paths, new Path(new String[]{"v1", "v2"}));
        paths = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v4", 2), this.AUTHORIZATIONS_A));
        pathsByLabels = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v4", 2).setLabels(new String[]{LABEL_LABEL1}), this.AUTHORIZATIONS_A));
        Assert.assertEquals((Object)pathsByLabels, (Object)paths);
        pathsByBadLabel = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v4", 2).setLabels(new String[]{LABEL_BAD}), this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)0L, (long)pathsByBadLabel.size());
        this.assertPaths(paths, new Path(new String[]{"v1", "v2", "v4"}), new Path(new String[]{"v1", "v3", "v4"}));
        paths = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v4", "v1", 2), this.AUTHORIZATIONS_A));
        pathsByLabels = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v4", "v1", 2).setLabels(new String[]{LABEL_LABEL1}), this.AUTHORIZATIONS_A));
        Assert.assertEquals((Object)pathsByLabels, (Object)paths);
        pathsByBadLabel = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v4", "v1", 2).setLabels(new String[]{LABEL_BAD}), this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)0L, (long)pathsByBadLabel.size());
        this.assertPaths(paths, new Path(new String[]{"v4", "v2", "v1"}), new Path(new String[]{"v4", "v3", "v1"}));
        paths = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v6", 3), this.AUTHORIZATIONS_A));
        pathsByLabels = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v6", 3).setLabels(new String[]{LABEL_LABEL1}), this.AUTHORIZATIONS_A));
        Assert.assertEquals((Object)pathsByLabels, (Object)paths);
        pathsByBadLabel = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v6", 3).setLabels(new String[]{LABEL_BAD}), this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)0L, (long)pathsByBadLabel.size());
        this.assertPaths(paths, new Path(new String[]{"v1", "v2", "v4", "v6"}), new Path(new String[]{"v1", "v3", "v4", "v6"}));
    }

    @Test
    public void testFindPathExcludeLabels() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v3 = this.graph.addVertex("v3", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v4 = this.graph.addVertex("v4", VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v1, v2, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v2, v4, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v1, v3, LABEL_LABEL2, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v3, v4, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.flush();
        this.assertPaths(this.graph.findPaths(new FindPathOptions("v1", "v4", 2), this.AUTHORIZATIONS_A), new Path(new String[]{"v1", "v2", "v4"}), new Path(new String[]{"v1", "v3", "v4"}));
        this.assertPaths(this.graph.findPaths(new FindPathOptions("v1", "v4", 2).setExcludedLabels(new String[]{LABEL_LABEL2}), this.AUTHORIZATIONS_A), new Path(new String[]{"v1", "v2", "v4"}));
        this.assertPaths(this.graph.findPaths(new FindPathOptions("v1", "v4", 3).setExcludedLabels(new String[]{LABEL_LABEL2}), this.AUTHORIZATIONS_A), new Path(new String[]{"v1", "v2", "v4"}));
    }

    private void assertPaths(Iterable<Path> found, Path ... expected) {
        List foundPaths = org.vertexium.util.IterableUtils.toList(found);
        ArrayList expectedPaths = new ArrayList();
        Collections.addAll(expectedPaths, expected);
        Assert.assertEquals((long)expectedPaths.size(), (long)foundPaths.size());
        for (Path foundPath : foundPaths) {
            if (expectedPaths.remove(foundPath)) continue;
            Assert.fail((String)("Unexpected path: " + foundPath));
        }
    }

    @Test
    public void testFindPathsWithSoftDeletedEdges() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_EMPTY, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_EMPTY, this.AUTHORIZATIONS_A);
        Vertex v3 = this.graph.addVertex("v3", VISIBILITY_EMPTY, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v1, v2, LABEL_LABEL1, VISIBILITY_EMPTY, this.AUTHORIZATIONS_A);
        Edge v2ToV3 = this.graph.addEdge(v2, v3, LABEL_LABEL1, VISIBILITY_EMPTY, this.AUTHORIZATIONS_A);
        this.graph.flush();
        List paths = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v3", 2), this.AUTHORIZATIONS_A));
        this.assertPaths(paths, new Path(new String[]{"v1", "v2", "v3"}));
        this.graph.softDeleteEdge(v2ToV3, this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertNull((Object)this.graph.getEdge(v2ToV3.getId(), this.AUTHORIZATIONS_A));
        paths = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v3", 2), this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)0L, (long)paths.size());
    }

    @Test
    public void testFindPathsWithHiddenEdges() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_EMPTY, this.AUTHORIZATIONS_A_AND_B);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_EMPTY, this.AUTHORIZATIONS_A_AND_B);
        Vertex v3 = this.graph.addVertex("v3", VISIBILITY_EMPTY, this.AUTHORIZATIONS_A_AND_B);
        this.graph.addEdge(v1, v2, LABEL_LABEL1, VISIBILITY_EMPTY, this.AUTHORIZATIONS_A_AND_B);
        Edge v2ToV3 = this.graph.addEdge(v2, v3, LABEL_LABEL1, VISIBILITY_EMPTY, this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        List paths = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v3", 2), this.AUTHORIZATIONS_A_AND_B));
        this.assertPaths(paths, new Path(new String[]{"v1", "v2", "v3"}));
        this.graph.markEdgeHidden(v2ToV3, VISIBILITY_A, this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Assert.assertNull((Object)this.graph.getEdge(v2ToV3.getId(), this.AUTHORIZATIONS_A_AND_B));
        paths = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v3", 2), this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)0L, (long)paths.size());
        paths = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v3", 2), this.AUTHORIZATIONS_B));
        Assert.assertEquals((long)1L, (long)paths.size());
    }

    @Test
    public void testFindPathsMultiplePaths() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v3 = this.graph.addVertex("v3", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v4 = this.graph.addVertex("v4", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v5 = this.graph.addVertex("v5", VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v1, v4, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v1, v3, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v3, v4, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v2, v3, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v4, v2, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v2, v5, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.flush();
        List paths = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v2", 2), this.AUTHORIZATIONS_A));
        this.assertPaths(paths, new Path(new String[]{"v1", "v4", "v2"}), new Path(new String[]{"v1", "v3", "v2"}));
        paths = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v2", 3), this.AUTHORIZATIONS_A));
        this.assertPaths(paths, new Path(new String[]{"v1", "v4", "v2"}), new Path(new String[]{"v1", "v3", "v2"}), new Path(new String[]{"v1", "v3", "v4", "v2"}), new Path(new String[]{"v1", "v4", "v3", "v2"}));
        paths = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v5", 2), this.AUTHORIZATIONS_A));
        this.assertPaths(paths, new Path[0]);
        paths = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v5", 3), this.AUTHORIZATIONS_A));
        this.assertPaths(paths, new Path(new String[]{"v1", "v4", "v2", "v5"}), new Path(new String[]{"v1", "v3", "v2", "v5"}));
    }

    @Test
    public void testFindPathsWithDifferentVisibilityData() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_EMPTY, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_EMPTY, this.AUTHORIZATIONS_A);
        Vertex v3 = this.graph.addVertex("v3", VISIBILITY_EMPTY, this.AUTHORIZATIONS_A);
        this.graph.addEdge("v1v2", v1, v2, LABEL_LABEL1, VISIBILITY_EMPTY, this.AUTHORIZATIONS_A);
        this.graph.addEdge("v2v3", v2, v3, LABEL_LABEL1, VISIBILITY_EMPTY, this.AUTHORIZATIONS_A);
        this.graph.addEdge("v3v1", v3, v1, LABEL_LABEL1, VISIBILITY_EMPTY, this.AUTHORIZATIONS_A);
        this.graph.flush();
        List paths = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v3", 2), this.AUTHORIZATIONS_A));
        this.assertPaths(paths, new Path(new String[]{"v1", "v2", "v3"}), new Path(new String[]{"v1", "v3"}));
        this.graph.getEdge("v3v1", this.AUTHORIZATIONS_A).prepareMutation().alterElementVisibility(VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.getVertex("v2", this.AUTHORIZATIONS_A).prepareMutation().alterElementVisibility(VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        paths = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v3", 2), this.AUTHORIZATIONS_EMPTY));
        Assert.assertEquals((long)0L, (long)paths.size());
        paths = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v3", 3), this.AUTHORIZATIONS_EMPTY));
        Assert.assertEquals((long)0L, (long)paths.size());
        paths = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v3", 2), this.AUTHORIZATIONS_A));
        this.assertPaths(paths, new Path(new String[]{"v1", "v2", "v3"}), new Path(new String[]{"v1", "v3"}));
        this.graph.getVertex("v2", this.AUTHORIZATIONS_A).prepareMutation().alterElementVisibility(Visibility.EMPTY).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        paths = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v2", 4), this.AUTHORIZATIONS_EMPTY));
        this.assertPaths(paths, new Path(new String[]{"v1", "v2"}));
    }

    @Test
    public void testHasPath() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v3 = this.graph.addVertex("v3", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v4 = this.graph.addVertex("v4", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v5 = this.graph.addVertex("v5", VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v1, v3, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v3, v4, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v2, v3, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v4, v2, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v2, v5, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.flush();
        List paths = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v4", 2, true), this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)1L, (long)paths.size());
        paths = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v4", 3, true), this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)1L, (long)paths.size());
        paths = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findPaths(new FindPathOptions("v1", "v5", 2, true), this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)0L, (long)paths.size());
    }

    @Test
    public void testGetVerticesFromVertex() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v3 = this.graph.addVertex("v3", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v4 = this.graph.addVertex("v4", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v5 = this.graph.addVertex("v5", VISIBILITY_B, this.AUTHORIZATIONS_B);
        this.graph.addEdge(v1, v2, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v1, v3, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v1, v4, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v2, v3, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v2, v5, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)3L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getVertices(Direction.BOTH, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)3L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getVertices(Direction.OUT, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getVertices(Direction.IN, this.AUTHORIZATIONS_A)));
        v2 = this.graph.getVertex("v2", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)v2.getVertices(Direction.BOTH, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v2.getVertices(Direction.OUT, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v2.getVertices(Direction.IN, this.AUTHORIZATIONS_A)));
        v3 = this.graph.getVertex("v3", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)v3.getVertices(Direction.BOTH, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)v3.getVertices(Direction.OUT, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)v3.getVertices(Direction.IN, this.AUTHORIZATIONS_A)));
        v4 = this.graph.getVertex("v4", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v4.getVertices(Direction.BOTH, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)v4.getVertices(Direction.OUT, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v4.getVertices(Direction.IN, this.AUTHORIZATIONS_A)));
    }

    @Test
    public void testGetVertexIdsFromVertex() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v3 = this.graph.addVertex("v3", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v4 = this.graph.addVertex("v4", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v5 = this.graph.addVertex("v5", VISIBILITY_B, this.AUTHORIZATIONS_B);
        this.graph.addEdge(v1, v2, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v1, v3, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v1, v4, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v2, v3, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge(v2, v5, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)3L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getVertexIds(Direction.BOTH, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)3L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getVertexIds(Direction.OUT, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getVertexIds(Direction.IN, this.AUTHORIZATIONS_A)));
        v2 = this.graph.getVertex("v2", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)3L, (long)org.vertexium.util.IterableUtils.count((Iterable)v2.getVertexIds(Direction.BOTH, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)v2.getVertexIds(Direction.OUT, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v2.getVertexIds(Direction.IN, this.AUTHORIZATIONS_A)));
        v3 = this.graph.getVertex("v3", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)v3.getVertexIds(Direction.BOTH, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)v3.getVertexIds(Direction.OUT, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)v3.getVertexIds(Direction.IN, this.AUTHORIZATIONS_A)));
        v4 = this.graph.getVertex("v4", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v4.getVertexIds(Direction.BOTH, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)v4.getVertexIds(Direction.OUT, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v4.getVertexIds(Direction.IN, this.AUTHORIZATIONS_A)));
    }

    @Test
    public void testBlankVisibilityString() {
        Vertex v = this.graph.addVertex("v1", VISIBILITY_EMPTY, this.AUTHORIZATIONS_EMPTY);
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"v1", (Object)v.getId());
        this.graph.flush();
        v = this.graph.getVertex("v1", this.AUTHORIZATIONS_EMPTY);
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"v1", (Object)v.getId());
        Assert.assertEquals((Object)VISIBILITY_EMPTY, (Object)v.getVisibility());
    }

    @Test
    public void testElementMutationDoesntChangeObjectUntilSave() throws InterruptedException {
        Vertex v = this.graph.addVertex("v1", VISIBILITY_EMPTY, this.AUTHORIZATIONS_ALL);
        v.setProperty("prop1", (Object)"value1-1", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        ElementMutation m = v.prepareMutation().setProperty("prop1", (Object)"value1-2", VISIBILITY_A).setProperty("prop2", (Object)"value2-2", VISIBILITY_A);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v.getProperties()));
        Assert.assertEquals((Object)"value1-1", (Object)v.getPropertyValue("prop1"));
        v = (Vertex)m.save(this.AUTHORIZATIONS_A_AND_B);
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)v.getProperties()));
        Assert.assertEquals((Object)"value1-2", (Object)v.getPropertyValue("prop1"));
        Assert.assertEquals((Object)"value2-2", (Object)v.getPropertyValue("prop2"));
    }

    @Test
    public void testFindRelatedEdges() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v3 = this.graph.addVertex("v3", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v4 = this.graph.addVertex("v4", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Edge ev1v2 = this.graph.addEdge("e v1->v2", v1, v2, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        Edge ev1v3 = this.graph.addEdge("e v1->v3", v1, v3, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        Edge ev2v3 = this.graph.addEdge("e v2->v3", v2, v3, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        Edge ev3v1 = this.graph.addEdge("e v3->v1", v3, v1, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge("e v3->v4", v3, v4, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.flush();
        ArrayList<String> vertexIds = new ArrayList<String>();
        vertexIds.add("v1");
        vertexIds.add("v2");
        vertexIds.add("v3");
        List edgeIds = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findRelatedEdgeIds(vertexIds, this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)4L, (long)org.vertexium.util.IterableUtils.count((Iterable)edgeIds));
        IterableUtils.assertContains(ev1v2.getId(), edgeIds);
        IterableUtils.assertContains(ev1v3.getId(), edgeIds);
        IterableUtils.assertContains(ev2v3.getId(), edgeIds);
        IterableUtils.assertContains(ev3v1.getId(), edgeIds);
    }

    @Test
    public void testFindRelatedEdgeIdsForVertices() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v3 = this.graph.addVertex("v3", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v4 = this.graph.addVertex("v4", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Edge ev1v2 = this.graph.addEdge("e v1->v2", v1, v2, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        Edge ev1v3 = this.graph.addEdge("e v1->v3", v1, v3, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        Edge ev2v3 = this.graph.addEdge("e v2->v3", v2, v3, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        Edge ev3v1 = this.graph.addEdge("e v3->v1", v3, v1, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge("e v3->v4", v3, v4, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        vertices.add(v1);
        vertices.add(v2);
        vertices.add(v3);
        List edgeIds = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findRelatedEdgeIdsForVertices(vertices, this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)4L, (long)org.vertexium.util.IterableUtils.count((Iterable)edgeIds));
        IterableUtils.assertContains(ev1v2.getId(), edgeIds);
        IterableUtils.assertContains(ev1v3.getId(), edgeIds);
        IterableUtils.assertContains(ev2v3.getId(), edgeIds);
        IterableUtils.assertContains(ev3v1.getId(), edgeIds);
    }

    @Test
    public void testFindRelatedEdgeSummary() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v3 = this.graph.addVertex("v3", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v4 = this.graph.addVertex("v4", VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge("e v1->v2", v1, v2, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge("e v1->v3", v1, v3, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge("e v2->v3", v2, v3, LABEL_LABEL2, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge("e v3->v1", v3, v1, LABEL_LABEL2, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge("e v3->v4", v3, v4, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.flush();
        ArrayList<String> vertexIds = new ArrayList<String>();
        vertexIds.add("v1");
        vertexIds.add("v2");
        vertexIds.add("v3");
        List relatedEdges = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findRelatedEdgeSummary(vertexIds, this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)4L, (long)relatedEdges.size());
        IterableUtils.assertContains(new RelatedEdgeImpl("e v1->v2", LABEL_LABEL1, v1.getId(), v2.getId()), relatedEdges);
        IterableUtils.assertContains(new RelatedEdgeImpl("e v1->v3", LABEL_LABEL1, v1.getId(), v3.getId()), relatedEdges);
        IterableUtils.assertContains(new RelatedEdgeImpl("e v2->v3", LABEL_LABEL2, v2.getId(), v3.getId()), relatedEdges);
        IterableUtils.assertContains(new RelatedEdgeImpl("e v3->v1", LABEL_LABEL2, v3.getId(), v1.getId()), relatedEdges);
    }

    @Test
    public void testFindRelatedEdgeSummaryAfterSoftDelete() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Edge e1 = this.graph.addEdge("e v1->v2", v1, v2, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.flush();
        ArrayList<String> vertexIds = new ArrayList<String>();
        vertexIds.add("v1");
        vertexIds.add("v2");
        List relatedEdges = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findRelatedEdgeSummary(vertexIds, this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)1L, (long)relatedEdges.size());
        IterableUtils.assertContains(new RelatedEdgeImpl("e v1->v2", LABEL_LABEL1, v1.getId(), v2.getId()), relatedEdges);
        this.graph.softDeleteEdge(e1, this.AUTHORIZATIONS_A);
        this.graph.flush();
        relatedEdges = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findRelatedEdgeSummary(vertexIds, this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)0L, (long)relatedEdges.size());
    }

    @Test
    public void testFindRelatedEdgeSummaryAfterMarkedHidden() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Edge e1 = this.graph.addEdge("e v1->v2", v1, v2, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.flush();
        ArrayList<String> vertexIds = new ArrayList<String>();
        vertexIds.add("v1");
        vertexIds.add("v2");
        List relatedEdges = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findRelatedEdgeSummary(vertexIds, this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)1L, (long)relatedEdges.size());
        IterableUtils.assertContains(new RelatedEdgeImpl("e v1->v2", LABEL_LABEL1, v1.getId(), v2.getId()), relatedEdges);
        this.graph.markEdgeHidden(e1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.flush();
        relatedEdges = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findRelatedEdgeSummary(vertexIds, this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)0L, (long)relatedEdges.size());
    }

    @Test
    @Ignore
    public void testFindRelatedEdgesPerformance() {
        int totalNumberOfVertices = 100;
        int totalNumberOfEdges = 10000;
        int totalVerticesToCheck = 100;
        Random random = new Random(100L);
        Date startTime = new Date();
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        for (int i = 0; i < totalNumberOfVertices; ++i) {
            vertices.add(this.graph.addVertex("v" + i, VISIBILITY_A, this.AUTHORIZATIONS_A));
        }
        this.graph.flush();
        Date endTime = new Date();
        long insertVerticesTime = endTime.getTime() - startTime.getTime();
        startTime = new Date();
        for (int i = 0; i < totalNumberOfEdges; ++i) {
            Vertex outVertex = (Vertex)vertices.get(random.nextInt(vertices.size()));
            Vertex inVertex = (Vertex)vertices.get(random.nextInt(vertices.size()));
            this.graph.addEdge("e" + i, outVertex, inVertex, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        }
        this.graph.flush();
        endTime = new Date();
        long insertEdgesTime = endTime.getTime() - startTime.getTime();
        ArrayList<String> vertexIds = new ArrayList<String>();
        for (int i = 0; i < totalVerticesToCheck; ++i) {
            Vertex v = (Vertex)vertices.get(random.nextInt(vertices.size()));
            vertexIds.add(v.getId());
        }
        startTime = new Date();
        List edgeIds = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.findRelatedEdgeIds(vertexIds, this.AUTHORIZATIONS_A));
        org.vertexium.util.IterableUtils.count((Iterable)edgeIds);
        endTime = new Date();
        long findRelatedEdgesTime = endTime.getTime() - startTime.getTime();
        LOGGER.info("RESULTS\ntotalNumberOfVertices,totalNumberOfEdges,totalVerticesToCheck,insertVerticesTime,insertEdgesTime,findRelatedEdgesTime\n%d,%d,%d,%d,%d,%d", new Object[]{totalNumberOfVertices, totalNumberOfEdges, totalVerticesToCheck, insertVerticesTime, insertEdgesTime, findRelatedEdgesTime});
    }

    @Test
    public void testFilterEdgeIdsByAuthorization() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Metadata metadataPropB = new Metadata();
        metadataPropB.add("meta1", (Object)"meta1", VISIBILITY_A);
        this.graph.prepareEdge("e1", v1, v2, LABEL_LABEL1, VISIBILITY_A).setProperty("propA", (Object)"propA", VISIBILITY_A).setProperty("propB", (Object)"propB", VISIBILITY_A_AND_B).setProperty("propBmeta", (Object)"propBmeta", metadataPropB, VISIBILITY_A).save(this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        ArrayList<String> edgeIds = new ArrayList<String>();
        edgeIds.add("e1");
        List foundEdgeIds = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.filterEdgeIdsByAuthorization(edgeIds, VISIBILITY_A_STRING, ElementFilter.ALL, this.AUTHORIZATIONS_ALL));
        IterableUtils.assertContains("e1", foundEdgeIds);
        foundEdgeIds = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.filterEdgeIdsByAuthorization(edgeIds, VISIBILITY_B_STRING, ElementFilter.ALL, this.AUTHORIZATIONS_ALL));
        IterableUtils.assertContains("e1", foundEdgeIds);
        foundEdgeIds = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.filterEdgeIdsByAuthorization(edgeIds, VISIBILITY_C_STRING, ElementFilter.ALL, this.AUTHORIZATIONS_ALL));
        Assert.assertEquals((long)0L, (long)foundEdgeIds.size());
        foundEdgeIds = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.filterEdgeIdsByAuthorization(edgeIds, VISIBILITY_A_STRING, EnumSet.of(ElementFilter.ELEMENT), this.AUTHORIZATIONS_ALL));
        IterableUtils.assertContains("e1", foundEdgeIds);
        foundEdgeIds = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.filterEdgeIdsByAuthorization(edgeIds, VISIBILITY_B_STRING, EnumSet.of(ElementFilter.ELEMENT), this.AUTHORIZATIONS_ALL));
        Assert.assertEquals((long)0L, (long)foundEdgeIds.size());
        foundEdgeIds = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.filterEdgeIdsByAuthorization(edgeIds, VISIBILITY_A_STRING, EnumSet.of(ElementFilter.PROPERTY), this.AUTHORIZATIONS_ALL));
        IterableUtils.assertContains("e1", foundEdgeIds);
        foundEdgeIds = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.filterEdgeIdsByAuthorization(edgeIds, VISIBILITY_C_STRING, EnumSet.of(ElementFilter.PROPERTY), this.AUTHORIZATIONS_ALL));
        Assert.assertEquals((long)0L, (long)foundEdgeIds.size());
        foundEdgeIds = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.filterEdgeIdsByAuthorization(edgeIds, VISIBILITY_A_STRING, EnumSet.of(ElementFilter.PROPERTY_METADATA), this.AUTHORIZATIONS_ALL));
        IterableUtils.assertContains("e1", foundEdgeIds);
        foundEdgeIds = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.filterEdgeIdsByAuthorization(edgeIds, VISIBILITY_C_STRING, EnumSet.of(ElementFilter.PROPERTY_METADATA), this.AUTHORIZATIONS_ALL));
        Assert.assertEquals((long)0L, (long)foundEdgeIds.size());
    }

    @Test
    public void testFilterVertexIdsByAuthorization() {
        Metadata metadataPropB = new Metadata();
        metadataPropB.add("meta1", (Object)"meta1", VISIBILITY_A);
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("propA", (Object)"propA", VISIBILITY_A).setProperty("propB", (Object)"propB", VISIBILITY_A_AND_B).setProperty("propBmeta", (Object)"propBmeta", metadataPropB, VISIBILITY_A).save(this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        ArrayList<String> vertexIds = new ArrayList<String>();
        vertexIds.add("v1");
        List foundVertexIds = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.filterVertexIdsByAuthorization(vertexIds, VISIBILITY_A_STRING, ElementFilter.ALL, this.AUTHORIZATIONS_ALL));
        IterableUtils.assertContains("v1", foundVertexIds);
        foundVertexIds = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.filterVertexIdsByAuthorization(vertexIds, VISIBILITY_B_STRING, ElementFilter.ALL, this.AUTHORIZATIONS_ALL));
        IterableUtils.assertContains("v1", foundVertexIds);
        foundVertexIds = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.filterVertexIdsByAuthorization(vertexIds, VISIBILITY_C_STRING, ElementFilter.ALL, this.AUTHORIZATIONS_ALL));
        Assert.assertEquals((long)0L, (long)foundVertexIds.size());
        foundVertexIds = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.filterVertexIdsByAuthorization(vertexIds, VISIBILITY_A_STRING, EnumSet.of(ElementFilter.ELEMENT), this.AUTHORIZATIONS_ALL));
        IterableUtils.assertContains("v1", foundVertexIds);
        foundVertexIds = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.filterVertexIdsByAuthorization(vertexIds, VISIBILITY_B_STRING, EnumSet.of(ElementFilter.ELEMENT), this.AUTHORIZATIONS_ALL));
        Assert.assertEquals((long)0L, (long)foundVertexIds.size());
        foundVertexIds = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.filterVertexIdsByAuthorization(vertexIds, VISIBILITY_A_STRING, EnumSet.of(ElementFilter.PROPERTY), this.AUTHORIZATIONS_ALL));
        IterableUtils.assertContains("v1", foundVertexIds);
        foundVertexIds = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.filterVertexIdsByAuthorization(vertexIds, VISIBILITY_C_STRING, EnumSet.of(ElementFilter.PROPERTY), this.AUTHORIZATIONS_ALL));
        Assert.assertEquals((long)0L, (long)foundVertexIds.size());
        foundVertexIds = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.filterVertexIdsByAuthorization(vertexIds, VISIBILITY_A_STRING, EnumSet.of(ElementFilter.PROPERTY_METADATA), this.AUTHORIZATIONS_ALL));
        IterableUtils.assertContains("v1", foundVertexIds);
        foundVertexIds = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.filterVertexIdsByAuthorization(vertexIds, VISIBILITY_C_STRING, EnumSet.of(ElementFilter.PROPERTY_METADATA), this.AUTHORIZATIONS_ALL));
        Assert.assertEquals((long)0L, (long)foundVertexIds.size());
    }

    @Test
    public void testMetadataMutationsOnVertex() {
        Metadata metadataPropB = new Metadata();
        metadataPropB.add("meta1", (Object)"meta1", VISIBILITY_A);
        Vertex vertex = (Vertex)this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("propBmeta", (Object)"propBmeta", metadataPropB, VISIBILITY_A).save(this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        ExistingElementMutation m = vertex.prepareMutation();
        m.setPropertyMetadata("propBmeta", "meta1", (Object)"meta2", VISIBILITY_A);
        vertex = (Vertex)m.save(this.AUTHORIZATIONS_ALL);
        Assert.assertEquals((Object)"meta2", (Object)vertex.getProperty("propBmeta").getMetadata().getEntry("meta1").getValue());
    }

    @Test
    public void testMetadataMutationsOnEdge() {
        Metadata metadataPropB = new Metadata();
        metadataPropB.add("meta1", (Object)"meta1", VISIBILITY_A);
        Edge edge = (Edge)this.graph.prepareEdge("v1", "v2", LABEL_LABEL1, VISIBILITY_A).setProperty("propBmeta", (Object)"propBmeta", metadataPropB, VISIBILITY_A).save(this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        ExistingEdgeMutation m = edge.prepareMutation();
        m.setPropertyMetadata("propBmeta", "meta1", (Object)"meta2", VISIBILITY_A);
        edge = (Edge)m.save(this.AUTHORIZATIONS_ALL);
        Assert.assertEquals((Object)"meta2", (Object)edge.getProperty("propBmeta").getMetadata().getEntry("meta1").getValue());
    }

    @Test
    public void testEmptyPropertyMutation() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        v1.prepareMutation().save(this.AUTHORIZATIONS_ALL);
    }

    @Test
    public void testTextIndex() throws Exception {
        this.graph.defineProperty("none").dataType(String.class).textIndexHint((Collection)TextIndexHint.NONE).define();
        this.graph.defineProperty("none").dataType(String.class).textIndexHint((Collection)TextIndexHint.NONE).define();
        this.graph.defineProperty("both").dataType(String.class).textIndexHint((Collection)TextIndexHint.ALL).define();
        this.graph.defineProperty("fullText").dataType(String.class).textIndexHint(new TextIndexHint[]{TextIndexHint.FULL_TEXT}).define();
        this.graph.defineProperty("exactMatch").dataType(String.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH}).define();
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("none", (Object)"Test Value", VISIBILITY_A).setProperty("both", (Object)"Test Value", VISIBILITY_A).setProperty("fullText", (Object)"Test Value", VISIBILITY_A).setProperty("exactMatch", (Object)"Test Value", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertEquals((Object)"Test Value", (Object)v1.getPropertyValue("none"));
        Assert.assertEquals((Object)"Test Value", (Object)v1.getPropertyValue("both"));
        Assert.assertEquals((Object)"Test Value", (Object)v1.getPropertyValue("fullText"));
        Assert.assertEquals((Object)"Test Value", (Object)v1.getPropertyValue("exactMatch"));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("both", (Predicate)TextPredicate.CONTAINS, (Object)"Test").vertices()));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("fullText", (Predicate)TextPredicate.CONTAINS, (Object)"Test").vertices()));
        Assert.assertEquals((String)"exact match shouldn't match partials", (long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("exactMatch", (Object)"Test").vertices()));
        Assert.assertEquals((String)"un-indexed property shouldn't match partials", (long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("none", (Object)"Test").vertices()));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("both", (Object)"Test Value").vertices()));
        Assert.assertEquals((String)"default has predicate is equals which shouldn't work for full text", (long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("fullText", (Object)"Test Value").vertices()));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("exactMatch", (Object)"Test Value").vertices()));
        if (org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("none", (Object)"Test Value").vertices()) != 0) {
            LOGGER.warn("default has predicate is equals which shouldn't work for un-indexed", new Object[0]);
        }
    }

    @Test
    public void testTextIndexDoesNotContain() throws Exception {
        this.graph.defineProperty("both").dataType(String.class).textIndexHint((Collection)TextIndexHint.ALL).define();
        this.graph.defineProperty("fullText").dataType(String.class).textIndexHint(new TextIndexHint[]{TextIndexHint.FULL_TEXT}).define();
        this.graph.defineProperty("exactMatch").dataType(String.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH}).define();
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("exactMatch", (Object)"Test Value", VISIBILITY_A).setProperty("both", (Object)"Test123", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_A).setProperty("both", (Object)"Test Value", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v3", VISIBILITY_A).setProperty("both", (Object)"Temp", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v4", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v5", VISIBILITY_A).setProperty("both", (Object)"Test123 test", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A).has("both", (Predicate)TextPredicate.DOES_NOT_CONTAIN, (Object)"Test").vertices();
        VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)vertices, "v1", "v3", "v4");
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has("exactMatch", (Object)"Test Value").vertices();
        VertexiumAssert.assertVertexIds((Iterable<Vertex>)vertices, "v1");
        this.graph.query(this.AUTHORIZATIONS_A).has("exactMatch", (Predicate)TextPredicate.DOES_NOT_CONTAIN, (Object)"Test").vertices();
        this.graph.prepareVertex("v6", VISIBILITY_A).setProperty("both", (Object)"susan-test", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v7", VISIBILITY_A).setProperty("both", (Object)"susan-test", Visibility.EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        vertices = this.graph.query(this.AUTHORIZATIONS_A).has("both", (Predicate)TextPredicate.DOES_NOT_CONTAIN, (Object)"susan").vertices();
        VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)vertices, "v1", "v2", "v3", "v4", "v5");
    }

    @Test
    public void testTextIndexStreamingPropertyValue() throws Exception {
        this.graph.defineProperty("none").dataType(String.class).textIndexHint((Collection)TextIndexHint.NONE).define();
        this.graph.defineProperty("both").dataType(String.class).textIndexHint((Collection)TextIndexHint.ALL).define();
        this.graph.defineProperty("fullText").dataType(String.class).textIndexHint(new TextIndexHint[]{TextIndexHint.FULL_TEXT}).define();
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("none", (Object)StreamingPropertyValue.create((String)"Test Value"), VISIBILITY_A).setProperty("both", (Object)StreamingPropertyValue.create((String)"Test Value"), VISIBILITY_A).setProperty("fullText", (Object)StreamingPropertyValue.create((String)"Test Value"), VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("both", (Predicate)TextPredicate.CONTAINS, (Object)"Test").vertices()));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("fullText", (Predicate)TextPredicate.CONTAINS, (Object)"Test").vertices()));
        Assert.assertEquals((String)"un-indexed property shouldn't match partials", (long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("none", (Object)"Test").vertices()));
        try {
            this.graph.query(this.AUTHORIZATIONS_A).has("none", (Predicate)TextPredicate.CONTAINS, (Object)"Test");
            Assert.fail((String)"Full text queries should not be allowed for properties that are not indexed with FULL_TEXT.");
        }
        catch (VertexiumException ve) {
            Assert.assertEquals((Object)"Check your TextIndexHint settings. Property none is not full text indexed.", (Object)ve.getMessage());
        }
    }

    @Test
    public void testGetStreamingPropertyValueInputStreams() throws Exception {
        this.graph.defineProperty(VISIBILITY_A_STRING).dataType(String.class).textIndexHint(new TextIndexHint[]{TextIndexHint.FULL_TEXT}).define();
        this.graph.defineProperty(VISIBILITY_B_STRING).dataType(String.class).textIndexHint(new TextIndexHint[]{TextIndexHint.FULL_TEXT}).define();
        this.graph.defineProperty(VISIBILITY_C_STRING).dataType(String.class).textIndexHint(new TextIndexHint[]{TextIndexHint.FULL_TEXT}).define();
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty(VISIBILITY_A_STRING, (Object)StreamingPropertyValue.create((String)"Test Value A"), VISIBILITY_A).setProperty(VISIBILITY_B_STRING, (Object)StreamingPropertyValue.create((String)"Test Value B"), VISIBILITY_A).setProperty(VISIBILITY_C_STRING, (Object)StreamingPropertyValue.create((String)"Test Value C"), VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B);
        StreamingPropertyValue spvA = (StreamingPropertyValue)v1.getPropertyValue(VISIBILITY_A_STRING);
        Assert.assertEquals((long)12L, (long)spvA.getLength());
        StreamingPropertyValue spvB = (StreamingPropertyValue)v1.getPropertyValue(VISIBILITY_B_STRING);
        Assert.assertEquals((long)12L, (long)spvA.getLength());
        StreamingPropertyValue spvC = (StreamingPropertyValue)v1.getPropertyValue(VISIBILITY_C_STRING);
        Assert.assertEquals((long)12L, (long)spvA.getLength());
        ArrayList spvs = Lists.newArrayList((Object[])new StreamingPropertyValue[]{spvA, spvB, spvC});
        List streams = this.graph.getStreamingPropertyValueInputStreams((List)spvs);
        Assert.assertEquals((Object)"Test Value A", (Object)IOUtils.toString((InputStream)((InputStream)streams.get(0))));
        Assert.assertEquals((Object)"Test Value B", (Object)IOUtils.toString((InputStream)((InputStream)streams.get(1))));
        Assert.assertEquals((Object)"Test Value C", (Object)IOUtils.toString((InputStream)((InputStream)streams.get(2))));
    }

    @Test
    public void testFieldBoost() throws Exception {
        Assume.assumeTrue((String)"Boost not supported", (boolean)this.graph.isFieldBoostSupported());
        this.graph.defineProperty(VISIBILITY_A_STRING).dataType(String.class).textIndexHint((Collection)TextIndexHint.ALL).boost(1.0).define();
        this.graph.defineProperty(VISIBILITY_B_STRING).dataType(String.class).textIndexHint((Collection)TextIndexHint.ALL).boost(2.0).define();
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty(VISIBILITY_A_STRING, (Object)"Test Value", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_A).setProperty(VISIBILITY_B_STRING, (Object)"Test Value", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        VertexiumAssert.assertVertexIds((Iterable<Vertex>)this.graph.query("Test", this.AUTHORIZATIONS_A).vertices(), "v2", "v1");
    }

    @Test
    public void testValueTypes() throws Exception {
        Date date = this.createDate(2014, 2, 24, 13, 0, 5);
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("int", (Object)5, VISIBILITY_A).setProperty("bigInteger", (Object)BigInteger.valueOf(10L), VISIBILITY_A).setProperty("bigDecimal", (Object)BigDecimal.valueOf(1.1), VISIBILITY_A).setProperty("double", (Object)5.6, VISIBILITY_A).setProperty("float", (Object)Float.valueOf(6.4f), VISIBILITY_A).setProperty("string", (Object)"test", VISIBILITY_A).setProperty("byte", (Object)5, VISIBILITY_A).setProperty("long", (Object)5L, VISIBILITY_A).setProperty("boolean", (Object)true, VISIBILITY_A).setProperty("geopoint", (Object)new GeoPoint(77.0, -33.0), VISIBILITY_A).setProperty("short", (Object)5, VISIBILITY_A).setProperty("date", (Object)date, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("int", (Object)5).vertices()));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("double", (Object)5.6).vertices()));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).range("float", (Object)Float.valueOf(6.3f), (Object)Float.valueOf(6.5f)).vertices()));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("string", (Object)"test").vertices()));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("byte", (Object)5).vertices()));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("long", (Object)5).vertices()));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("boolean", (Object)true).vertices()));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("short", (Object)5).vertices()));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("date", (Object)date).vertices()));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("bigInteger", (Object)BigInteger.valueOf(10L)).vertices()));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("bigInteger", (Object)10).vertices()));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("bigDecimal", (Object)BigDecimal.valueOf(1.1)).vertices()));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("bigDecimal", (Object)1.1).vertices()));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("geopoint", (Predicate)GeoCompare.WITHIN, (Object)new GeoCircle(77.0, -33.0, 1.0)).vertices()));
    }

    @Test
    public void testChangeVisibilityVertex() {
        this.graph.prepareVertex("v1", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        v1.prepareMutation().alterElementVisibility(VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertNull((Object)v1);
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_B);
        Assert.assertNotNull((Object)v1);
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_B);
        v1.prepareMutation().alterElementVisibility(VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertNull((Object)v1);
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_B);
        Assert.assertNotNull((Object)v1);
    }

    @Test
    public void testChangeVertexVisibilityAndAlterPropertyVisibilityAndChangePropertyAtTheSameTime() {
        Metadata metadata = new Metadata();
        metadata.add("m1", (Object)"m1-value1", VISIBILITY_EMPTY);
        metadata.add("m2", (Object)"m2-value1", VISIBILITY_EMPTY);
        this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("k1", "age", (Object)25, metadata, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.createAuthorizations(this.AUTHORIZATIONS_ALL, new String[0]);
        this.graph.flush();
        VertexiumAssert.assertResultsCount(1, 1, this.graph.query(this.AUTHORIZATIONS_A).has("age", (Object)25).vertices());
        Vertex v1 = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_ALL);
        ExistingElementMutation m = v1.prepareMutation();
        m.alterElementVisibility(VISIBILITY_B);
        for (Property property : v1.getProperties()) {
            m.alterPropertyVisibility(property, VISIBILITY_B);
            m.setPropertyMetadata(property, "m1", (Object)"m1-value2", VISIBILITY_EMPTY);
        }
        m.save(this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_B);
        Assert.assertEquals((Object)VISIBILITY_B, (Object)v1.getVisibility());
        List properties = org.vertexium.util.IterableUtils.toList((Iterable)v1.getProperties());
        Assert.assertEquals((long)1L, (long)properties.size());
        Assert.assertEquals((Object)"age", (Object)((Property)properties.get(0)).getName());
        Assert.assertEquals((Object)VISIBILITY_B, (Object)((Property)properties.get(0)).getVisibility());
        Assert.assertEquals((long)2L, (long)((Property)properties.get(0)).getMetadata().entrySet().size());
        Assert.assertTrue((boolean)((Property)properties.get(0)).getMetadata().containsKey("m1"));
        Assert.assertEquals((Object)"m1-value2", (Object)((Property)properties.get(0)).getMetadata().getEntry("m1").getValue());
        Assert.assertEquals((Object)VISIBILITY_EMPTY, (Object)((Property)properties.get(0)).getMetadata().getEntry("m1").getVisibility());
        Assert.assertTrue((boolean)((Property)properties.get(0)).getMetadata().containsKey("m2"));
        Assert.assertEquals((Object)"m2-value1", (Object)((Property)properties.get(0)).getMetadata().getEntry("m2").getValue());
        Assert.assertEquals((Object)VISIBILITY_EMPTY, (Object)((Property)properties.get(0)).getMetadata().getEntry("m2").getVisibility());
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertNull((String)"v1 should not be returned for auth a", (Object)v1);
        VertexiumAssert.assertResultsCount(0, 0, this.graph.query(this.AUTHORIZATIONS_A).has("age", (Object)25).vertices());
        VertexiumAssert.assertResultsCount(1, 1, this.graph.query(this.AUTHORIZATIONS_B).has("age", (Object)25).vertices());
    }

    @Test
    public void testChangeVisibilityPropertiesWithPropertyKey() {
        this.graph.prepareVertex("v1", VISIBILITY_EMPTY).addPropertyValue("k1", "prop1", (Object)"value1", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B);
        v1.prepareMutation().alterPropertyVisibility("k1", "prop1", VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertNull((Object)v1.getProperty("prop1"));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_B).has("prop1", (Object)"value1").vertices()));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("prop1", (Object)"value1").vertices()));
        Map<Object, Long> propertyCountByValue = this.queryGraphQueryWithTermsAggregation("prop1", ElementType.VERTEX, this.AUTHORIZATIONS_A);
        if (propertyCountByValue != null) {
            Assert.assertEquals(null, (Object)propertyCountByValue.get("value1"));
        }
        if ((propertyCountByValue = this.queryGraphQueryWithTermsAggregation("prop1", ElementType.VERTEX, this.AUTHORIZATIONS_B)) != null) {
            Assert.assertEquals((long)1L, (long)propertyCountByValue.get("value1"));
        }
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B);
        Property v1Prop1 = v1.getProperty("prop1");
        Assert.assertNotNull((Object)v1Prop1);
        Assert.assertEquals((Object)VISIBILITY_B, (Object)v1Prop1.getVisibility());
        this.graph.prepareVertex("v2", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        this.graph.prepareEdge("e1", "v1", "v2", LABEL_LABEL1, VISIBILITY_EMPTY).addPropertyValue("k2", "prop2", (Object)"value2", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Edge e1 = this.graph.getEdge("e1", this.AUTHORIZATIONS_A_AND_B);
        e1.prepareMutation().alterPropertyVisibility("k2", "prop2", VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        e1 = this.graph.getEdge("e1", this.AUTHORIZATIONS_A);
        Assert.assertNull((Object)e1.getProperty("prop2"));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_B).has("prop2", (Object)"value2").edges()));
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("prop2", (Object)"value2").edges()));
        propertyCountByValue = this.queryGraphQueryWithTermsAggregation("prop2", ElementType.EDGE, this.AUTHORIZATIONS_A);
        if (propertyCountByValue != null) {
            Assert.assertEquals(null, (Object)propertyCountByValue.get("value2"));
        }
        if ((propertyCountByValue = this.queryGraphQueryWithTermsAggregation("prop2", ElementType.EDGE, this.AUTHORIZATIONS_B)) != null) {
            Assert.assertEquals((long)1L, (long)propertyCountByValue.get("value2"));
        }
        e1 = this.graph.getEdge("e1", this.AUTHORIZATIONS_A_AND_B);
        Property e1prop1 = e1.getProperty("prop2");
        Assert.assertNotNull((Object)e1prop1);
        Assert.assertEquals((Object)VISIBILITY_B, (Object)e1prop1.getVisibility());
    }

    @Test
    public void testChangeVisibilityVertexProperties() {
        Metadata prop1Metadata = new Metadata();
        prop1Metadata.add("prop1_key1", (Object)"value1", VISIBILITY_EMPTY);
        Metadata prop2Metadata = new Metadata();
        prop2Metadata.add("prop2_key1", (Object)"value1", VISIBILITY_EMPTY);
        this.graph.prepareVertex("v1", VISIBILITY_EMPTY).setProperty("prop1", (Object)"value1", prop1Metadata, VISIBILITY_A).setProperty("prop2", (Object)"value2", prop2Metadata, VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_A_AND_B);
        v1.prepareMutation().alterPropertyVisibility("prop1", VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertNull((Object)v1.getProperty("prop1"));
        Assert.assertNotNull((Object)v1.getProperty("prop2"));
        VertexiumAssert.assertResultsCount(0, 0, this.graph.query(this.AUTHORIZATIONS_A).has("prop1", (Object)"value1").vertices());
        VertexiumAssert.assertResultsCount(1, 1, this.graph.query(this.AUTHORIZATIONS_B).has("prop1", (Object)"value1").vertices());
        Map<Object, Long> propertyCountByValue = this.queryGraphQueryWithTermsAggregation("prop1", ElementType.VERTEX, this.AUTHORIZATIONS_A);
        if (propertyCountByValue != null) {
            Assert.assertEquals(null, (Object)propertyCountByValue.get("value1"));
        }
        if ((propertyCountByValue = this.queryGraphQueryWithTermsAggregation("prop1", ElementType.VERTEX, this.AUTHORIZATIONS_B)) != null) {
            Assert.assertEquals((long)1L, (long)propertyCountByValue.get("value1"));
        }
        v1 = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_A_AND_B);
        Property v1Prop1 = v1.getProperty("prop1");
        Assert.assertNotNull((Object)v1Prop1);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.toList((Iterable)v1Prop1.getMetadata().entrySet()).size());
        Assert.assertEquals((Object)"value1", (Object)v1Prop1.getMetadata().getValue("prop1_key1"));
        Assert.assertNotNull((Object)v1.getProperty("prop2"));
        v1 = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_A_AND_B);
        v1.prepareMutation().alterPropertyVisibility("prop1", VISIBILITY_A).setProperty("prop1", (Object)"value1New", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        VertexiumAssert.assertResultsCount(0, 0, this.graph.query(this.AUTHORIZATIONS_B).has("prop1", (Object)"value1").vertices());
        VertexiumAssert.assertResultsCount(0, 0, this.graph.query(this.AUTHORIZATIONS_A).has("prop1", (Object)"value1").vertices());
        VertexiumAssert.assertResultsCount(0, 0, this.graph.query(this.AUTHORIZATIONS_B).has("prop1", (Object)"value1New").vertices());
        VertexiumAssert.assertResultsCount(1, 1, this.graph.query(this.AUTHORIZATIONS_A).has("prop1", (Object)"value1New").vertices());
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B);
        Assert.assertNotNull((Object)v1.getProperty("prop1"));
        Assert.assertEquals((Object)"value1New", (Object)v1.getPropertyValue("prop1"));
        v1 = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_A_AND_B);
        v1.prepareMutation().alterPropertyVisibility("prop1", VISIBILITY_A).setProperty("prop1", (Object)"value1New2", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B);
        Assert.assertNotNull((Object)v1.getProperty("prop1"));
        Assert.assertEquals((Object)"value1New2", (Object)v1.getPropertyValue("prop1"));
        VertexiumAssert.assertResultsCount(0, 0, this.graph.query(this.AUTHORIZATIONS_B).has("prop1", (Object)"value1").vertices());
        VertexiumAssert.assertResultsCount(0, 0, this.graph.query(this.AUTHORIZATIONS_A).has("prop1", (Object)"value1").vertices());
        VertexiumAssert.assertResultsCount(0, 0, this.graph.query(this.AUTHORIZATIONS_B).has("prop1", (Object)"value1New").vertices());
        VertexiumAssert.assertResultsCount(0, 0, this.graph.query(this.AUTHORIZATIONS_A).has("prop1", (Object)"value1New").vertices());
        VertexiumAssert.assertResultsCount(0, 0, this.graph.query(this.AUTHORIZATIONS_B).has("prop1", (Object)"value1New2").vertices());
        VertexiumAssert.assertResultsCount(1, 1, this.graph.query(this.AUTHORIZATIONS_A).has("prop1", (Object)"value1New2").vertices());
    }

    @Test
    public void testAlterVisibilityAndSetMetadataInOneMutation() {
        Metadata prop1Metadata = new Metadata();
        prop1Metadata.add("prop1_key1", (Object)"metadata1", VISIBILITY_EMPTY);
        this.graph.prepareVertex("v1", VISIBILITY_EMPTY).setProperty("prop1", (Object)"value1", prop1Metadata, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_A_AND_B);
        v1.prepareMutation().alterPropertyVisibility("prop1", VISIBILITY_B).setPropertyMetadata("prop1", "prop1_key1", (Object)"metadata1New", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_A_AND_B);
        Assert.assertNotNull((Object)v1.getProperty("prop1"));
        Assert.assertEquals((Object)VISIBILITY_B, (Object)v1.getProperty("prop1").getVisibility());
        Assert.assertEquals((Object)"metadata1New", (Object)v1.getProperty("prop1").getMetadata().getValue("prop1_key1"));
        List historicalPropertyValues = org.vertexium.util.IterableUtils.toList((Iterable)v1.getHistoricalPropertyValues(this.AUTHORIZATIONS_A_AND_B));
        Assert.assertEquals((long)2L, (long)historicalPropertyValues.size());
        Assert.assertEquals((Object)"metadata1New", (Object)((HistoricalPropertyValue)historicalPropertyValues.get(0)).getMetadata().getValue("prop1_key1"));
        Assert.assertEquals((Object)"metadata1", (Object)((HistoricalPropertyValue)historicalPropertyValues.get(1)).getMetadata().getValue("prop1_key1"));
    }

    @Test
    public void testAlterPropertyVisibilityOverwritingProperty() {
        this.graph.prepareVertex("v1", VISIBILITY_EMPTY).addPropertyValue("", "prop1", (Object)"value1", VISIBILITY_EMPTY).addPropertyValue("", "prop1", (Object)"value2", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        long beforeAlterTimestamp = IncreasingTime.currentTimeMillis();
        Vertex v1 = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_A);
        v1.prepareMutation().alterPropertyVisibility(v1.getProperty("", "prop1", VISIBILITY_A), VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getProperties()));
        Assert.assertNotNull((Object)v1.getProperty("", "prop1", VISIBILITY_EMPTY));
        Assert.assertEquals((Object)"value2", (Object)v1.getProperty("", "prop1", VISIBILITY_EMPTY).getValue());
        Assert.assertNull((Object)v1.getProperty("", "prop1", VISIBILITY_A));
        v1 = this.graph.getVertex("v1", this.graph.getDefaultFetchHints(), Long.valueOf(beforeAlterTimestamp), this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getProperties()));
        Assert.assertNotNull((Object)v1.getProperty("", "prop1", VISIBILITY_EMPTY));
        Assert.assertEquals((Object)"value1", (Object)v1.getProperty("", "prop1", VISIBILITY_EMPTY).getValue());
        Assert.assertNotNull((Object)v1.getProperty("", "prop1", VISIBILITY_A));
        Assert.assertEquals((Object)"value2", (Object)v1.getProperty("", "prop1", VISIBILITY_A).getValue());
    }

    @Test
    public void testChangeVisibilityEdge() {
        Vertex v1 = this.graph.prepareVertex("v1", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        Vertex v2 = this.graph.prepareVertex("v2", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareEdge("e1", v1, v2, LABEL_LABEL1, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getEdges(Direction.BOTH, this.AUTHORIZATIONS_B)));
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getEdges(Direction.BOTH, this.AUTHORIZATIONS_A)));
        Edge e1 = this.graph.getEdge("e1", this.AUTHORIZATIONS_A);
        e1.prepareMutation().alterElementVisibility(VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_B);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getEdges(Direction.BOTH, this.AUTHORIZATIONS_B)));
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getEdges(Direction.BOTH, this.AUTHORIZATIONS_A)));
        e1 = this.graph.getEdge("e1", this.AUTHORIZATIONS_B);
        e1.prepareMutation().alterElementVisibility(VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_B);
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getEdges(Direction.BOTH, this.AUTHORIZATIONS_B)));
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)v1.getEdges(Direction.BOTH, this.AUTHORIZATIONS_A)));
    }

    @Test
    public void testChangeVisibilityOnBadPropertyName() {
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("prop1", (Object)"value1", VISIBILITY_EMPTY).setProperty("prop2", (Object)"value2", VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        try {
            this.graph.getVertex("v1", this.AUTHORIZATIONS_A).prepareMutation().alterPropertyVisibility("propBad", VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
            Assert.fail((String)"show throw");
        }
        catch (VertexiumException ex) {
            Assert.assertNotNull((Object)((Object)ex));
        }
    }

    @Test
    public void testChangeVisibilityOnStreamingProperty() throws IOException {
        String expectedLargeValue = IOUtils.toString((InputStream)new LargeStringInputStream(0x100001));
        StreamingPropertyValue propSmall = StreamingPropertyValue.create((InputStream)new ByteArrayInputStream("value1".getBytes()), String.class);
        StreamingPropertyValue propLarge = StreamingPropertyValue.create((InputStream)new ByteArrayInputStream(expectedLargeValue.getBytes()), String.class);
        String largePropertyName = "propLarge/\\*!@#$%^&*()[]{}|";
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("propSmall", (Object)propSmall, VISIBILITY_A).setProperty(largePropertyName, (Object)propLarge, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A).getProperties()));
        this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_A).prepareMutation().alterPropertyVisibility("propSmall", VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A).getProperties()));
        this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_A).prepareMutation().alterPropertyVisibility(largePropertyName, VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A).getProperties()));
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B).getProperties()));
    }

    @Test
    public void testChangePropertyMetadata() {
        Metadata prop1Metadata = new Metadata();
        prop1Metadata.add("prop1_key1", (Object)"valueOld", VISIBILITY_EMPTY);
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("prop1", (Object)"value1", prop1Metadata, VISIBILITY_EMPTY).setProperty("prop2", (Object)"value2", null, VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_A);
        v1.prepareMutation().setPropertyMetadata("prop1", "prop1_key1", (Object)"valueNew", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Assert.assertEquals((Object)"valueNew", (Object)v1.getProperty("prop1").getMetadata().getEntry("prop1_key1", VISIBILITY_EMPTY).getValue());
        v1 = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_A);
        Assert.assertEquals((Object)"valueNew", (Object)v1.getProperty("prop1").getMetadata().getEntry("prop1_key1", VISIBILITY_EMPTY).getValue());
        v1 = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_A);
        v1.prepareMutation().setPropertyMetadata("prop2", "prop2_key1", (Object)"valueNew", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Assert.assertEquals((Object)"valueNew", (Object)v1.getProperty("prop2").getMetadata().getEntry("prop2_key1", VISIBILITY_EMPTY).getValue());
        v1 = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_A);
        Assert.assertEquals((Object)"valueNew", (Object)v1.getProperty("prop2").getMetadata().getEntry("prop2_key1", VISIBILITY_EMPTY).getValue());
    }

    @Test
    public void testMutationChangePropertyVisibilityFollowedByMetadataUsingPropertyObject() {
        Metadata prop1Metadata = new Metadata();
        prop1Metadata.add("prop1_key1", (Object)"valueOld", VISIBILITY_A);
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("prop1", (Object)"value1", prop1Metadata, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_A_AND_B);
        Property p1 = v1.getProperty("prop1", VISIBILITY_A);
        v1.prepareMutation().alterPropertyVisibility(p1, VISIBILITY_B).setPropertyMetadata(p1, "prop1_key1", (Object)"valueNew", VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_A_AND_B);
        Assert.assertEquals((Object)"valueNew", (Object)v1.getProperty("prop1", VISIBILITY_B).getMetadata().getEntry("prop1_key1", VISIBILITY_B).getValue());
    }

    @Test
    public void testMetadata() {
        Vertex v1 = (Vertex)this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("prop1", (Object)"value1", VISIBILITY_A).setProperty("prop1", (Object)"value1", VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        ExistingElementMutation m = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_A_AND_B).prepareMutation();
        m.setPropertyMetadata(v1.getProperty("prop1", VISIBILITY_A), "metadata1", (Object)"metadata-value1aa", VISIBILITY_A);
        m.setPropertyMetadata(v1.getProperty("prop1", VISIBILITY_A), "metadata1", (Object)"metadata-value1ab", VISIBILITY_B);
        m.setPropertyMetadata(v1.getProperty("prop1", VISIBILITY_B), "metadata1", (Object)"metadata-value1bb", VISIBILITY_B);
        m.save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_A_AND_B);
        Property prop1A = v1.getProperty("prop1", VISIBILITY_A);
        Assert.assertEquals((long)2L, (long)prop1A.getMetadata().entrySet().size());
        Assert.assertEquals((Object)"metadata-value1aa", (Object)prop1A.getMetadata().getValue("metadata1", VISIBILITY_A));
        Assert.assertEquals((Object)"metadata-value1ab", (Object)prop1A.getMetadata().getValue("metadata1", VISIBILITY_B));
        Property prop1B = v1.getProperty("prop1", VISIBILITY_B);
        Assert.assertEquals((long)1L, (long)prop1B.getMetadata().entrySet().size());
        Assert.assertEquals((Object)"metadata-value1bb", (Object)prop1B.getMetadata().getValue("metadata1", VISIBILITY_B));
    }

    @Test
    public void testIsVisibilityValid() {
        Assert.assertFalse((boolean)this.graph.isVisibilityValid(VISIBILITY_A, this.AUTHORIZATIONS_C));
        Assert.assertTrue((boolean)this.graph.isVisibilityValid(VISIBILITY_B, this.AUTHORIZATIONS_A_AND_B));
        Assert.assertTrue((boolean)this.graph.isVisibilityValid(VISIBILITY_B, this.AUTHORIZATIONS_B));
        Assert.assertTrue((boolean)this.graph.isVisibilityValid(VISIBILITY_EMPTY, this.AUTHORIZATIONS_A));
    }

    @Test
    public void testModifyVertexWithLowerAuthorizationThenOtherProperties() {
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("prop1", (Object)"value1", VISIBILITY_A).setProperty("prop2", (Object)"value2", VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        v1.setProperty("prop1", (Object)"value1New", VISIBILITY_A, this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("prop2", (Object)"value2").vertices();
        VertexiumAssert.assertVertexIds((Iterable<Vertex>)vertices, "v1");
    }

    @Test
    public void testPartialUpdateOfVertex() {
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("prop1", (Object)"value1", VISIBILITY_A).setProperty("prop2", (Object)"value2", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("prop1", (Object)"value1New", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("prop2", (Object)"value2").vertices();
        VertexiumAssert.assertVertexIds((Iterable<Vertex>)vertices, "v1");
    }

    @Test
    public void testPartialUpdateOfVertexPropertyKey() {
        Assume.assumeTrue((String)"Known bug in partial updates", (boolean)this.isParitalUpdateOfVertexPropertyKeySupported());
        this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("key1", "prop", (Object)"value1", VISIBILITY_A).addPropertyValue("key2", "prop", (Object)"value2", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("prop", (Object)"value1").vertices();
        VertexiumAssert.assertVertexIds((Iterable<Vertex>)vertices, "v1");
        vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("prop", (Object)"value2").vertices();
        VertexiumAssert.assertVertexIds((Iterable<Vertex>)vertices, "v1");
        this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("key1", "prop", (Object)"value1New", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("prop", (Object)"value1New").vertices();
        VertexiumAssert.assertVertexIds((Iterable<Vertex>)vertices, "v1");
        vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("prop", (Object)"value2").vertices();
        VertexiumAssert.assertVertexIds((Iterable<Vertex>)vertices, "v1");
        vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("prop", (Object)"value1").vertices();
        VertexiumAssert.assertVertexIds((Iterable<Vertex>)vertices, new String[0]);
    }

    protected boolean isParitalUpdateOfVertexPropertyKeySupported() {
        return true;
    }

    @Test
    public void testAddVertexWithoutIndexing() {
        Assume.assumeTrue((String)"add vertex without indexing not supported", (!this.isDefaultSearchIndex() ? 1 : 0) != 0);
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("prop1", (Object)"value1", VISIBILITY_A).setIndexHint(IndexHint.DO_NOT_INDEX).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("prop1", (Object)"value1").vertices();
        VertexiumAssert.assertVertexIds((Iterable<Vertex>)vertices, new String[0]);
    }

    @Test
    public void testAlterVertexWithoutIndexing() {
        Assume.assumeTrue((String)"alter vertex without indexing not supported", (!this.isDefaultSearchIndex() ? 1 : 0) != 0);
        this.graph.prepareVertex("v1", VISIBILITY_A).setIndexHint(IndexHint.DO_NOT_INDEX).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        v1.prepareMutation().setProperty("prop1", (Object)"value1", VISIBILITY_A).setIndexHint(IndexHint.DO_NOT_INDEX).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A).has("prop1", (Object)"value1").vertices();
        VertexiumAssert.assertVertexIds((Iterable<Vertex>)vertices, new String[0]);
    }

    @Test
    public void testAddEdgeWithoutIndexing() {
        Assume.assumeTrue((String)"add edge without indexing not supported", (!this.isDefaultSearchIndex() ? 1 : 0) != 0);
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.prepareEdge("e1", v1, v2, LABEL_LABEL1, VISIBILITY_A).setProperty("prop1", (Object)"value1", VISIBILITY_A).setIndexHint(IndexHint.DO_NOT_INDEX).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        QueryResultsIterable edges = this.graph.query(this.AUTHORIZATIONS_A_AND_B).has("prop1", (Object)"value1").edges();
        VertexiumAssert.assertEdgeIds((Iterable<Edge>)edges, new String[0]);
    }

    @Test
    public void testIteratorWithLessThanPageSizeResultsPageOne() {
        QueryStringQueryParameters parameters = new QueryStringQueryParameters("*", this.AUTHORIZATIONS_EMPTY);
        parameters.setSkip(0L);
        parameters.setLimit(Integer.valueOf(5));
        DefaultGraphQueryIterable iterable = new DefaultGraphQueryIterable((QueryParameters)parameters, this.getVertices(3L), false, false, false);
        int count = 0;
        Iterator iterator = iterable.iterator();
        Vertex v = null;
        while (iterator.hasNext()) {
            ++count;
            v = (Vertex)iterator.next();
            Assert.assertNotNull((Object)v);
        }
        Assert.assertEquals((long)3L, (long)count);
        Assert.assertNotNull((String)"v was null", (Object)v);
        Assert.assertEquals((Object)"2", (Object)v.getId());
    }

    @Test
    public void testIteratorWithPageSizeResultsPageOne() {
        QueryStringQueryParameters parameters = new QueryStringQueryParameters("*", this.AUTHORIZATIONS_EMPTY);
        parameters.setSkip(0L);
        parameters.setLimit(Integer.valueOf(5));
        DefaultGraphQueryIterable iterable = new DefaultGraphQueryIterable((QueryParameters)parameters, this.getVertices(5L), false, false, false);
        int count = 0;
        Iterator iterator = iterable.iterator();
        Vertex v = null;
        while (iterator.hasNext()) {
            ++count;
            v = (Vertex)iterator.next();
            Assert.assertNotNull((Object)v);
        }
        Assert.assertEquals((long)5L, (long)count);
        Assert.assertNotNull((String)"v was null", (Object)v);
        Assert.assertEquals((Object)"4", (Object)v.getId());
    }

    @Test
    public void testIteratorWithMoreThanPageSizeResultsPageOne() {
        QueryStringQueryParameters parameters = new QueryStringQueryParameters("*", this.AUTHORIZATIONS_EMPTY);
        parameters.setSkip(0L);
        parameters.setLimit(Integer.valueOf(5));
        DefaultGraphQueryIterable iterable = new DefaultGraphQueryIterable((QueryParameters)parameters, this.getVertices(7L), false, false, false);
        int count = 0;
        Iterator iterator = iterable.iterator();
        Vertex v = null;
        while (iterator.hasNext()) {
            ++count;
            v = (Vertex)iterator.next();
            Assert.assertNotNull((Object)v);
        }
        Assert.assertEquals((long)5L, (long)count);
        Assert.assertNotNull((String)"v was null", (Object)v);
        Assert.assertEquals((Object)"4", (Object)v.getId());
    }

    @Test
    public void testIteratorWithMoreThanPageSizeResultsPageTwo() {
        QueryStringQueryParameters parameters = new QueryStringQueryParameters("*", this.AUTHORIZATIONS_EMPTY);
        parameters.setSkip(5L);
        parameters.setLimit(Integer.valueOf(5));
        DefaultGraphQueryIterable iterable = new DefaultGraphQueryIterable((QueryParameters)parameters, this.getVertices(12L), false, false, false);
        int count = 0;
        Iterator iterator = iterable.iterator();
        Vertex v = null;
        while (iterator.hasNext()) {
            ++count;
            v = (Vertex)iterator.next();
            Assert.assertNotNull((Object)v);
        }
        Assert.assertEquals((long)5L, (long)count);
        Assert.assertNotNull((String)"v was null", (Object)v);
        Assert.assertEquals((Object)"9", (Object)v.getId());
    }

    @Test
    public void testIteratorWithMoreThanPageSizeResultsPageThree() {
        QueryStringQueryParameters parameters = new QueryStringQueryParameters("*", this.AUTHORIZATIONS_EMPTY);
        parameters.setSkip(10L);
        parameters.setLimit(Integer.valueOf(5));
        DefaultGraphQueryIterable iterable = new DefaultGraphQueryIterable((QueryParameters)parameters, this.getVertices(12L), false, false, false);
        int count = 0;
        Iterator iterator = iterable.iterator();
        Vertex v = null;
        while (iterator.hasNext()) {
            ++count;
            v = (Vertex)iterator.next();
            Assert.assertNotNull((Object)v);
        }
        Assert.assertEquals((long)2L, (long)count);
        Assert.assertNotNull((String)"v was null", (Object)v);
        Assert.assertEquals((Object)"11", (Object)v.getId());
    }

    @Test
    public void testGraphMetadata() {
        List existingMetadata = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getMetadata());
        this.graph.setMetadata("test1", (Object)"value1old");
        this.graph.setMetadata("test1", (Object)"value1");
        this.graph.setMetadata("test2", (Object)"value2");
        Assert.assertEquals((Object)"value1", (Object)this.graph.getMetadata("test1"));
        Assert.assertEquals((Object)"value2", (Object)this.graph.getMetadata("test2"));
        Assert.assertEquals(null, (Object)this.graph.getMetadata("missingProp"));
        List newMetadata = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getMetadata());
        Assert.assertEquals((long)(existingMetadata.size() + 2), (long)newMetadata.size());
    }

    @Test
    public void testSimilarityByText() {
        Assume.assumeTrue((String)"query similar", (boolean)this.graph.isQuerySimilarToTextSupported());
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("text", (Object)"Mary had a little lamb, His fleece was white as snow.", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("v2", VISIBILITY_A).setProperty("text", (Object)"Mary had a little tiger, His fleece was white as snow.", VISIBILITY_B).save(this.AUTHORIZATIONS_B);
        this.graph.prepareVertex("v3", VISIBILITY_A).setProperty("text", (Object)"Mary had a little lamb.", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("v4", VISIBILITY_A).setProperty("text", (Object)"His fleece was white as snow.", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("v5", VISIBILITY_A).setProperty("text", (Object)"Mary had a little lamb, His fleece was black as snow.", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("v5", VISIBILITY_A).setProperty("text", (Object)"Jack and Jill went up the hill to fetch a pail of water.", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        List vertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.querySimilarTo(new String[]{"text"}, "Mary had a little lamb, His fleece was white as snow", this.AUTHORIZATIONS_A_AND_B).minTermFrequency(1).maxQueryTerms(25).minDocFrequency(1).maxDocFrequency(10).boost(2.0f).vertices());
        Assert.assertTrue((vertices.size() > 0 ? 1 : 0) != 0);
        vertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.querySimilarTo(new String[]{"text"}, "Mary had a little lamb, His fleece was white as snow", this.AUTHORIZATIONS_A).minTermFrequency(1).maxQueryTerms(25).minDocFrequency(1).maxDocFrequency(10).boost(2.0f).vertices());
        Assert.assertTrue((vertices.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAllPropertyHistoricalVersions() {
        HistoricalPropertyValue item;
        int i;
        Date time25 = this.createDate(2015, 4, 6, 16, 15, 0);
        Date time30 = this.createDate(2015, 4, 6, 16, 16, 0);
        Metadata metadata = new Metadata();
        metadata.add("author", (Object)"author1", VISIBILITY_A);
        this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("", "age", (Object)25, metadata, Long.valueOf(time25.getTime()), VISIBILITY_A).addPropertyValue("k1", "name", (Object)"k1Time25Value", metadata, Long.valueOf(time25.getTime()), VISIBILITY_A).addPropertyValue("k2", "name", (Object)"k2Time25Value", metadata, Long.valueOf(time25.getTime()), VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        metadata = new Metadata();
        metadata.add("author", (Object)"author2", VISIBILITY_A);
        this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("", "age", (Object)30, metadata, Long.valueOf(time30.getTime()), VISIBILITY_A).addPropertyValue("k1", "name", (Object)"k1Time30Value", metadata, Long.valueOf(time30.getTime()), VISIBILITY_A).addPropertyValue("k2", "name", (Object)"k2Time30Value", metadata, Long.valueOf(time30.getTime()), VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        List values = org.vertexium.util.IterableUtils.toList((Iterable)v1.getHistoricalPropertyValues(this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)6L, (long)values.size());
        for (i = 0; i < 3; ++i) {
            item = (HistoricalPropertyValue)values.get(i);
            Assert.assertEquals((Object)time30, (Object)new Date(((HistoricalPropertyValue)values.get(i)).getTimestamp()));
            if (item.getPropertyName().equals("age")) {
                Assert.assertEquals((Object)30, (Object)item.getValue());
                continue;
            }
            if (item.getPropertyName().equals("name") && item.getPropertyKey().equals("k1")) {
                Assert.assertEquals((Object)"k1Time30Value", (Object)item.getValue());
                continue;
            }
            if (item.getPropertyName().equals("name") && item.getPropertyKey().equals("k2")) {
                Assert.assertEquals((Object)"k2Time30Value", (Object)item.getValue());
                continue;
            }
            Assert.fail((String)("Invalid " + item));
        }
        for (i = 3; i < 6; ++i) {
            item = (HistoricalPropertyValue)values.get(i);
            Assert.assertEquals((Object)time25, (Object)new Date(((HistoricalPropertyValue)values.get(i)).getTimestamp()));
            if (item.getPropertyName().equals("age")) {
                Assert.assertEquals((Object)25, (Object)item.getValue());
                continue;
            }
            if (item.getPropertyName().equals("name") && item.getPropertyKey().equals("k1")) {
                Assert.assertEquals((Object)"k1Time25Value", (Object)item.getValue());
                continue;
            }
            if (item.getPropertyName().equals("name") && item.getPropertyKey().equals("k2")) {
                Assert.assertEquals((Object)"k2Time25Value", (Object)item.getValue());
                continue;
            }
            Assert.fail((String)("Invalid " + item));
        }
    }

    @Test
    public void testPropertyHistoricalVersions() {
        Date time25 = this.createDate(2015, 4, 6, 16, 15, 0);
        Date time30 = this.createDate(2015, 4, 6, 16, 16, 0);
        Metadata metadata = new Metadata();
        metadata.add("author", (Object)"author1", VISIBILITY_A);
        this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("", "age", (Object)25, metadata, Long.valueOf(time25.getTime()), VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        metadata = new Metadata();
        metadata.add("author", (Object)"author2", VISIBILITY_A);
        this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("", "age", (Object)30, metadata, Long.valueOf(time30.getTime()), VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_A);
        List values = org.vertexium.util.IterableUtils.toList((Iterable)v1.getHistoricalPropertyValues("", "age", VISIBILITY_A, this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)2L, (long)values.size());
        Assert.assertEquals((Object)30, (Object)((HistoricalPropertyValue)values.get(0)).getValue());
        Assert.assertEquals((Object)time30, (Object)new Date(((HistoricalPropertyValue)values.get(0)).getTimestamp()));
        Assert.assertEquals((Object)"author2", (Object)((HistoricalPropertyValue)values.get(0)).getMetadata().getValue("author", VISIBILITY_A));
        Assert.assertEquals((Object)25, (Object)((HistoricalPropertyValue)values.get(1)).getValue());
        Assert.assertEquals((Object)time25, (Object)new Date(((HistoricalPropertyValue)values.get(1)).getTimestamp()));
        Assert.assertEquals((Object)"author1", (Object)((HistoricalPropertyValue)values.get(1)).getMetadata().getValue("author", VISIBILITY_A));
        Assert.assertEquals((Object)30, (Object)v1.getPropertyValue("", "age"));
        Assert.assertEquals((Object)"author2", (Object)v1.getProperty("", "age").getMetadata().getValue("author", VISIBILITY_A));
    }

    @Test
    public void testStreamingPropertyHistoricalVersions() {
        Date time25 = this.createDate(2015, 4, 6, 16, 15, 0);
        Date time30 = this.createDate(2015, 4, 6, 16, 16, 0);
        Metadata metadata = new Metadata();
        StreamingPropertyValue value1 = StreamingPropertyValue.create((String)"value1");
        this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("", "text", (Object)value1, metadata, Long.valueOf(time25.getTime()), VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        StreamingPropertyValue value2 = StreamingPropertyValue.create((String)"value2");
        this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("", "text", (Object)value2, metadata, Long.valueOf(time30.getTime()), VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        List values = org.vertexium.util.IterableUtils.toList((Iterable)v1.getHistoricalPropertyValues("", "text", VISIBILITY_A, this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)2L, (long)values.size());
        Assert.assertEquals((Object)"value2", (Object)((StreamingPropertyValue)((HistoricalPropertyValue)values.get(0)).getValue()).readToString());
        Assert.assertEquals((Object)time30, (Object)new Date(((HistoricalPropertyValue)values.get(0)).getTimestamp()));
        Assert.assertEquals((Object)"value1", (Object)((StreamingPropertyValue)((HistoricalPropertyValue)values.get(1)).getValue()).readToString());
        Assert.assertEquals((Object)time25, (Object)new Date(((HistoricalPropertyValue)values.get(1)).getTimestamp()));
        Assert.assertEquals((Object)"value2", (Object)((StreamingPropertyValue)v1.getPropertyValue("", "text")).readToString());
    }

    @Test
    public void testGetVertexAtASpecificTimeInHistory() {
        Date time25 = this.createDate(2015, 4, 6, 16, 15, 0);
        Date time30 = this.createDate(2015, 4, 6, 16, 16, 0);
        Metadata metadata = new Metadata();
        Vertex v1 = (Vertex)this.graph.prepareVertex("v1", Long.valueOf(time25.getTime()), VISIBILITY_A).addPropertyValue("", "age", (Object)25, metadata, Long.valueOf(time25.getTime()), VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        Vertex v2 = (Vertex)this.graph.prepareVertex("v2", Long.valueOf(time25.getTime()), VISIBILITY_A).addPropertyValue("", "age", (Object)20, metadata, Long.valueOf(time25.getTime()), VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareEdge("e1", v1, v2, LABEL_LABEL1, Long.valueOf(time30.getTime()), VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("v1", Long.valueOf(time30.getTime()), VISIBILITY_A).addPropertyValue("", "age", (Object)30, metadata, Long.valueOf(time30.getTime()), VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("v3", Long.valueOf(time30.getTime()), VISIBILITY_A).addPropertyValue("", "age", (Object)35, metadata, Long.valueOf(time30.getTime()), VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertEquals((Object)30, (Object)this.graph.getVertex("v1", this.AUTHORIZATIONS_A).getPropertyValue("", "age"));
        Assert.assertEquals((Object)20, (Object)this.graph.getVertex("v2", this.AUTHORIZATIONS_A).getPropertyValue("", "age"));
        Assert.assertEquals((Object)35, (Object)this.graph.getVertex("v3", this.AUTHORIZATIONS_A).getPropertyValue("", "age"));
        Assert.assertEquals((long)1L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getEdges(this.AUTHORIZATIONS_A)));
        Assert.assertEquals((Object)25, (Object)this.graph.getVertex("v1", this.graph.getDefaultFetchHints(), Long.valueOf(time25.getTime()), this.AUTHORIZATIONS_A).getPropertyValue("", "age"));
        Assert.assertNull((String)"v3 should not exist at time25", (Object)this.graph.getVertex("v3", this.graph.getDefaultFetchHints(), Long.valueOf(time25.getTime()), this.AUTHORIZATIONS_A));
        Assert.assertEquals((String)"e1 should not exist", (long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)this.graph.getEdges(this.graph.getDefaultFetchHints(), Long.valueOf(time25.getTime()), this.AUTHORIZATIONS_A)));
    }

    @Test
    public void testSaveMultipleTimestampedValuesInSameMutationVertex() {
        String vertexId = "v1";
        String propertyKey = "k1";
        String propertyName = "p1";
        ImmutableMap values = ImmutableMap.of((Object)"value1", (Object)this.createDate(2016, 4, 6, 9, 20, 0).getTime(), (Object)"value2", (Object)this.createDate(2016, 5, 6, 9, 20, 0).getTime(), (Object)"value3", (Object)this.createDate(2016, 6, 6, 9, 20, 0).getTime(), (Object)"value4", (Object)this.createDate(2016, 7, 6, 9, 20, 0).getTime(), (Object)"value5", (Object)this.createDate(2016, 8, 6, 9, 20, 0).getTime());
        VertexBuilder vertexMutation = this.graph.prepareVertex(vertexId, VISIBILITY_EMPTY);
        for (Map.Entry entry : values.entrySet()) {
            vertexMutation.addPropertyValue(propertyKey, propertyName, entry.getKey(), new Metadata(), (Long)entry.getValue(), VISIBILITY_EMPTY);
        }
        vertexMutation.save(this.AUTHORIZATIONS_EMPTY);
        this.graph.flush();
        Vertex retrievedVertex = this.graph.getVertex(vertexId, this.AUTHORIZATIONS_EMPTY);
        Iterable historicalPropertyValues = retrievedVertex.getHistoricalPropertyValues(propertyKey, propertyName, VISIBILITY_EMPTY, null, null, this.AUTHORIZATIONS_EMPTY);
        this.compareHistoricalValues((Map<String, Long>)values, historicalPropertyValues);
    }

    @Test
    public void testSaveMultipleTimestampedValuesInSameMutationEdge() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_EMPTY, this.AUTHORIZATIONS_EMPTY);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_EMPTY, this.AUTHORIZATIONS_EMPTY);
        String edgeId = "e1";
        String propertyKey = "k1";
        String propertyName = "p1";
        ImmutableMap values = ImmutableMap.of((Object)"value1", (Object)this.createDate(2016, 4, 6, 9, 20, 0).getTime(), (Object)"value2", (Object)this.createDate(2016, 5, 6, 9, 20, 0).getTime(), (Object)"value3", (Object)this.createDate(2016, 6, 6, 9, 20, 0).getTime(), (Object)"value4", (Object)this.createDate(2016, 7, 6, 9, 20, 0).getTime(), (Object)"value5", (Object)this.createDate(2016, 8, 6, 9, 20, 0).getTime());
        EdgeBuilder edgeMutation = this.graph.prepareEdge(edgeId, v1, v2, LABEL_LABEL1, VISIBILITY_EMPTY);
        for (Map.Entry entry : values.entrySet()) {
            edgeMutation.addPropertyValue(propertyKey, propertyName, entry.getKey(), new Metadata(), (Long)entry.getValue(), VISIBILITY_EMPTY);
        }
        edgeMutation.save(this.AUTHORIZATIONS_EMPTY);
        this.graph.flush();
        Edge retrievedEdge = this.graph.getEdge(edgeId, this.AUTHORIZATIONS_EMPTY);
        Iterable historicalPropertyValues = retrievedEdge.getHistoricalPropertyValues(propertyKey, propertyName, VISIBILITY_EMPTY, null, null, this.AUTHORIZATIONS_EMPTY);
        this.compareHistoricalValues((Map<String, Long>)values, historicalPropertyValues);
    }

    private void compareHistoricalValues(Map<String, Long> expectedValues, Iterable<HistoricalPropertyValue> historicalPropertyValues) {
        HashMap<String, Long> expectedValuesCopy = new HashMap<String, Long>(expectedValues);
        for (HistoricalPropertyValue historicalPropertyValue : historicalPropertyValues) {
            String value = (String)historicalPropertyValue.getValue();
            if (!expectedValuesCopy.containsKey(value)) {
                throw new VertexiumException("Expected historical values to contain: " + value);
            }
            long expectedValue = (Long)expectedValuesCopy.remove(value);
            long ts = historicalPropertyValue.getTimestamp();
            Assert.assertEquals((long)expectedValue, (long)ts);
        }
        if (expectedValuesCopy.size() > 0) {
            StringBuilder result = new StringBuilder();
            for (Map.Entry entry : expectedValuesCopy.entrySet()) {
                result.append((String)entry.getKey()).append(" = ").append(entry.getValue()).append("\n");
            }
            throw new VertexiumException("Missing historical values:\n" + result.toString());
        }
    }

    @Test
    public void testTimestampsInExistingElementMutation() {
        long t1 = this.createDate(2017, 1, 18, 9, 20, 0).getTime();
        long t2 = this.createDate(2017, 1, 19, 9, 20, 0).getTime();
        this.graph.prepareVertex("v1", VISIBILITY_EMPTY).addPropertyValue("k1", "prop1", (Object)"test1", new Metadata(), Long.valueOf(t1), VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_ALL);
        Assert.assertEquals((long)t1, (long)v1.getProperty("k1", "prop1").getTimestamp());
        this.graph.getVertex("v1", this.AUTHORIZATIONS_ALL).prepareMutation().addPropertyValue("k1", "prop1", (Object)"test2", new Metadata(), Long.valueOf(t2), VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_ALL);
        Assert.assertEquals((long)t2, (long)v1.getProperty("k1", "prop1").getTimestamp());
        List historicalValues = org.vertexium.util.IterableUtils.toList((Iterable)v1.getHistoricalPropertyValues("k1", "prop1", VISIBILITY_EMPTY, this.AUTHORIZATIONS_ALL));
        Assert.assertEquals((long)2L, (long)historicalValues.size());
        Assert.assertEquals((long)t1, (long)((HistoricalPropertyValue)historicalValues.get(1)).getTimestamp());
        Assert.assertEquals((long)t2, (long)((HistoricalPropertyValue)historicalValues.get(0)).getTimestamp());
    }

    @Test
    public void testGraphQueryWithTermsAggregation() {
        boolean searchIndexFieldLevelSecurity = this.isSearchIndexFieldLevelSecuritySupported();
        this.graph.defineProperty("name").dataType(String.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH, TextIndexHint.FULL_TEXT}).define();
        this.graph.defineProperty("emptyField").dataType(Integer.class).define();
        this.graph.prepareVertex("v1", VISIBILITY_EMPTY).addPropertyValue("k1", "name", (Object)"Joe", VISIBILITY_EMPTY).addPropertyValue("k2", "name", (Object)"Joseph", VISIBILITY_EMPTY).addPropertyValue("", "age", (Object)25, VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_EMPTY).addPropertyValue("k1", "name", (Object)"Joe", VISIBILITY_EMPTY).addPropertyValue("k2", "name", (Object)"Joseph", VISIBILITY_B).addPropertyValue("", "age", (Object)20, VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareEdge("e1", "v1", "v2", LABEL_LABEL1, VISIBILITY_EMPTY).addPropertyValue("k1", "name", (Object)"Joe", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareEdge("e2", "v1", "v2", LABEL_LABEL1, VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareEdge("e3", "v1", "v2", LABEL_LABEL2, VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Map<Object, Long> vertexPropertyCountByValue = this.queryGraphQueryWithTermsAggregation("name", ElementType.VERTEX, this.AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"terms aggregation not supported", (vertexPropertyCountByValue != null ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)vertexPropertyCountByValue.size());
        Assert.assertEquals((long)2L, (long)vertexPropertyCountByValue.get("Joe"));
        Assert.assertEquals((long)(searchIndexFieldLevelSecurity ? 1L : 2L), (long)vertexPropertyCountByValue.get("Joseph"));
        vertexPropertyCountByValue = this.queryGraphQueryWithTermsAggregation("emptyField", ElementType.VERTEX, this.AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"terms aggregation not supported", (vertexPropertyCountByValue != null ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)vertexPropertyCountByValue.size());
        vertexPropertyCountByValue = this.queryGraphQueryWithTermsAggregation("name", ElementType.VERTEX, this.AUTHORIZATIONS_A_AND_B);
        Assume.assumeTrue((String)"terms aggregation not supported", (vertexPropertyCountByValue != null ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)vertexPropertyCountByValue.size());
        Assert.assertEquals((long)2L, (long)vertexPropertyCountByValue.get("Joe"));
        Assert.assertEquals((long)2L, (long)vertexPropertyCountByValue.get("Joseph"));
        Map<Object, Long> edgePropertyCountByValue = this.queryGraphQueryWithTermsAggregation("__edgeLabel", ElementType.EDGE, this.AUTHORIZATIONS_A_AND_B);
        Assume.assumeTrue((String)"terms aggregation not supported", (edgePropertyCountByValue != null ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)edgePropertyCountByValue.size());
        Assert.assertEquals((long)2L, (long)edgePropertyCountByValue.get(LABEL_LABEL1));
        Assert.assertEquals((long)1L, (long)edgePropertyCountByValue.get(LABEL_LABEL2));
        vertexPropertyCountByValue = this.queryGraphQueryWithTermsAggregation("Joe", "name", ElementType.VERTEX, this.AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"terms aggregation not supported", (vertexPropertyCountByValue != null ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)vertexPropertyCountByValue.size());
        Assert.assertEquals((long)2L, (long)vertexPropertyCountByValue.get("Joe"));
        Assert.assertEquals((long)(searchIndexFieldLevelSecurity ? 1L : 2L), (long)vertexPropertyCountByValue.get("Joseph"));
    }

    private boolean isSearchIndexFieldLevelSecuritySupported() {
        if (this.graph instanceof GraphWithSearchIndex) {
            return ((GraphWithSearchIndex)this.graph).getSearchIndex().isFieldLevelSecuritySupported();
        }
        return true;
    }

    @Test
    public void testGraphQueryVertexWithTermsAggregationAlterElementVisibility() {
        this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("k1", "age", (Object)25, VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B);
        v1.prepareMutation().alterElementVisibility(VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Map<Object, Long> propertyCountByValue = this.queryGraphQueryWithTermsAggregation("age", ElementType.VERTEX, this.AUTHORIZATIONS_A_AND_B);
        Assume.assumeTrue((String)"terms aggregation not supported", (propertyCountByValue != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)propertyCountByValue.size());
        propertyCountByValue = this.queryGraphQueryWithTermsAggregation("age", ElementType.VERTEX, this.AUTHORIZATIONS_A);
        Assume.assumeTrue((String)"terms aggregation not supported", (propertyCountByValue != null ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)propertyCountByValue.size());
        propertyCountByValue = this.queryGraphQueryWithTermsAggregation("age", ElementType.VERTEX, this.AUTHORIZATIONS_B);
        Assume.assumeTrue((String)"terms aggregation not supported", (propertyCountByValue != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)propertyCountByValue.size());
    }

    @Test
    public void testGraphQueryEdgeWithTermsAggregationAlterElementVisibility() {
        this.graph.prepareVertex("v1", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareEdge("e1", "v1", "v2", LABEL_LABEL1, VISIBILITY_A).addPropertyValue("k1", "age", (Object)25, VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Edge e1 = this.graph.getEdge("e1", this.AUTHORIZATIONS_A_AND_B);
        e1.prepareMutation().alterElementVisibility(VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Map<Object, Long> propertyCountByValue = this.queryGraphQueryWithTermsAggregation("age", ElementType.EDGE, this.AUTHORIZATIONS_A_AND_B);
        Assume.assumeTrue((String)"terms aggregation not supported", (propertyCountByValue != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)propertyCountByValue.size());
        propertyCountByValue = this.queryGraphQueryWithTermsAggregation("age", ElementType.EDGE, this.AUTHORIZATIONS_A);
        Assume.assumeTrue((String)"terms aggregation not supported", (propertyCountByValue != null ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)propertyCountByValue.size());
        propertyCountByValue = this.queryGraphQueryWithTermsAggregation("age", ElementType.EDGE, this.AUTHORIZATIONS_B);
        Assume.assumeTrue((String)"terms aggregation not supported", (propertyCountByValue != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)propertyCountByValue.size());
    }

    private Map<Object, Long> queryGraphQueryWithTermsAggregation(String propertyName, ElementType elementType, Authorizations authorizations) {
        return this.queryGraphQueryWithTermsAggregation(null, propertyName, elementType, authorizations);
    }

    private Map<Object, Long> queryGraphQueryWithTermsAggregation(String queryString, String propertyName, ElementType elementType, Authorizations authorizations) {
        TermsAggregation agg;
        Query q = (queryString == null ? this.graph.query(authorizations) : this.graph.query(queryString, authorizations)).limit(Integer.valueOf(0));
        if (!q.isAggregationSupported((Aggregation)(agg = new TermsAggregation("terms-count", propertyName)))) {
            LOGGER.warn("%s unsupported", new Object[]{agg.getClass().getName()});
            return null;
        }
        q.addAggregation((Aggregation)agg);
        QueryResultsIterable elements = elementType == ElementType.VERTEX ? q.vertices() : q.edges();
        TermsResult aggregationResult = (TermsResult)elements.getAggregationResult("terms-count", TermsResult.class);
        return this.termsBucketToMap(aggregationResult.getBuckets());
    }

    @Test
    public void testGraphQueryWithNestedTermsAggregation() {
        this.graph.defineProperty("name").dataType(String.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH, TextIndexHint.FULL_TEXT}).define();
        this.graph.defineProperty("gender").dataType(String.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH}).define();
        this.graph.prepareVertex("v1", VISIBILITY_EMPTY).addPropertyValue("k1", "name", (Object)"Joe", VISIBILITY_EMPTY).addPropertyValue("k1", "gender", (Object)"male", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_EMPTY).addPropertyValue("k1", "name", (Object)"Sam", VISIBILITY_EMPTY).addPropertyValue("k1", "gender", (Object)"male", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v3", VISIBILITY_EMPTY).addPropertyValue("k1", "name", (Object)"Sam", VISIBILITY_EMPTY).addPropertyValue("k1", "gender", (Object)"female", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v4", VISIBILITY_EMPTY).addPropertyValue("k1", "name", (Object)"Sam", VISIBILITY_EMPTY).addPropertyValue("k1", "gender", (Object)"female", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Query q = this.graph.query(this.AUTHORIZATIONS_A_AND_B).limit(Integer.valueOf(0));
        TermsAggregation agg = new TermsAggregation("terms-count", "name");
        agg.addNestedAggregation((Aggregation)new TermsAggregation("nested", "gender"));
        Assume.assumeTrue((String)"terms aggregation not supported", (boolean)q.isAggregationSupported((Aggregation)agg));
        q.addAggregation((Aggregation)agg);
        TermsResult aggregationResult = (TermsResult)q.vertices().getAggregationResult("terms-count", TermsResult.class);
        Map<Object, Map<Object, Long>> vertexPropertyCountByValue = this.nestedTermsBucketToMap(aggregationResult.getBuckets(), "nested");
        Assert.assertEquals((long)2L, (long)vertexPropertyCountByValue.size());
        Assert.assertEquals((long)1L, (long)vertexPropertyCountByValue.get("Joe").size());
        Assert.assertEquals((long)1L, (long)vertexPropertyCountByValue.get("Joe").get("male"));
        Assert.assertEquals((long)2L, (long)vertexPropertyCountByValue.get("Sam").size());
        Assert.assertEquals((long)1L, (long)vertexPropertyCountByValue.get("Sam").get("male"));
        Assert.assertEquals((long)2L, (long)vertexPropertyCountByValue.get("Sam").get("female"));
    }

    @Test
    public void testVertexQueryWithNestedTermsAggregation() {
        this.graph.defineProperty("name").dataType(String.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH, TextIndexHint.FULL_TEXT}).define();
        this.graph.defineProperty("gender").dataType(String.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH}).define();
        this.graph.prepareVertex("v1", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_EMPTY).addPropertyValue("k1", "name", (Object)"Joe", VISIBILITY_EMPTY).addPropertyValue("k1", "gender", (Object)"male", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v3", VISIBILITY_EMPTY).addPropertyValue("k1", "name", (Object)"Sam", VISIBILITY_EMPTY).addPropertyValue("k1", "gender", (Object)"male", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v4", VISIBILITY_EMPTY).addPropertyValue("k1", "name", (Object)"Sam", VISIBILITY_EMPTY).addPropertyValue("k1", "gender", (Object)"female", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v5", VISIBILITY_EMPTY).addPropertyValue("k1", "name", (Object)"Sam", VISIBILITY_EMPTY).addPropertyValue("k1", "gender", (Object)"female", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.addEdge("v1", "v2", LABEL_LABEL1, VISIBILITY_EMPTY, this.AUTHORIZATIONS_A_AND_B);
        this.graph.addEdge("v1", "v3", LABEL_LABEL1, VISIBILITY_EMPTY, this.AUTHORIZATIONS_A_AND_B);
        this.graph.addEdge("v1", "v4", LABEL_LABEL1, VISIBILITY_EMPTY, this.AUTHORIZATIONS_A_AND_B);
        this.graph.addEdge("v1", "v5", LABEL_LABEL1, VISIBILITY_EMPTY, this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Query q = this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B).query(this.AUTHORIZATIONS_A_AND_B).limit(Integer.valueOf(0));
        TermsAggregation agg = new TermsAggregation("terms-count", "name");
        agg.addNestedAggregation((Aggregation)new TermsAggregation("nested", "gender"));
        Assume.assumeTrue((String)"terms aggregation not supported", (boolean)q.isAggregationSupported((Aggregation)agg));
        q.addAggregation((Aggregation)agg);
        TermsResult aggregationResult = (TermsResult)q.vertices().getAggregationResult("terms-count", TermsResult.class);
        Map<Object, Map<Object, Long>> vertexPropertyCountByValue = this.nestedTermsBucketToMap(aggregationResult.getBuckets(), "nested");
        Assert.assertEquals((long)2L, (long)vertexPropertyCountByValue.size());
        Assert.assertEquals((long)1L, (long)vertexPropertyCountByValue.get("Joe").size());
        Assert.assertEquals((long)1L, (long)vertexPropertyCountByValue.get("Joe").get("male"));
        Assert.assertEquals((long)2L, (long)vertexPropertyCountByValue.get("Sam").size());
        Assert.assertEquals((long)1L, (long)vertexPropertyCountByValue.get("Sam").get("male"));
        Assert.assertEquals((long)2L, (long)vertexPropertyCountByValue.get("Sam").get("female"));
    }

    @Test
    public void testVertexQueryWithNestedTermsAggregationOnExtendedData() {
        this.graph.defineProperty("name").dataType(String.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH, TextIndexHint.FULL_TEXT}).define();
        this.graph.defineProperty("gender").dataType(String.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH}).define();
        this.graph.prepareVertex("v1", VISIBILITY_EMPTY).addExtendedData("t1", "r1", "name", (Object)"Joe", VISIBILITY_EMPTY).addExtendedData("t1", "r1", "gender", (Object)"male", VISIBILITY_EMPTY).addExtendedData("t1", "r2", "name", (Object)"Sam", VISIBILITY_EMPTY).addExtendedData("t1", "r2", "gender", (Object)"male", VISIBILITY_EMPTY).addExtendedData("t1", "r3", "name", (Object)"Sam", VISIBILITY_EMPTY).addExtendedData("t1", "r3", "gender", (Object)"female", VISIBILITY_EMPTY).addExtendedData("t1", "r4", "name", (Object)"Sam", VISIBILITY_EMPTY).addExtendedData("t1", "r4", "gender", (Object)"female", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B);
        Query q = v1.getExtendedData("t1").query(this.AUTHORIZATIONS_A_AND_B).limit(Integer.valueOf(0));
        TermsAggregation agg = new TermsAggregation("terms-count", "name");
        agg.addNestedAggregation((Aggregation)new TermsAggregation("nested", "gender"));
        Assume.assumeTrue((String)"terms aggregation not supported", (boolean)q.isAggregationSupported((Aggregation)agg));
        q.addAggregation((Aggregation)agg);
        TermsResult aggregationResult = (TermsResult)q.extendedDataRows().getAggregationResult("terms-count", TermsResult.class);
        Map<Object, Map<Object, Long>> vertexPropertyCountByValue = this.nestedTermsBucketToMap(aggregationResult.getBuckets(), "nested");
        Assert.assertEquals((long)2L, (long)vertexPropertyCountByValue.size());
        Assert.assertEquals((long)1L, (long)vertexPropertyCountByValue.get("Joe").size());
        Assert.assertEquals((long)1L, (long)vertexPropertyCountByValue.get("Joe").get("male"));
        Assert.assertEquals((long)2L, (long)vertexPropertyCountByValue.get("Sam").size());
        Assert.assertEquals((long)1L, (long)vertexPropertyCountByValue.get("Sam").get("male"));
        Assert.assertEquals((long)2L, (long)vertexPropertyCountByValue.get("Sam").get("female"));
    }

    @Test
    public void testGraphQueryWithHistogramAggregation() throws ParseException {
        boolean searchIndexFieldLevelSecurity = this.isSearchIndexFieldLevelSecuritySupported();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.graph.defineProperty("emptyField").dataType(Integer.class).define();
        String agePropertyName = "age.property";
        this.graph.prepareVertex("v1", VISIBILITY_EMPTY).addPropertyValue("", agePropertyName, (Object)25, VISIBILITY_EMPTY).addPropertyValue("", "birthDate", (Object)simpleDateFormat.parse("1990-09-04"), VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_EMPTY).addPropertyValue("", agePropertyName, (Object)20, VISIBILITY_EMPTY).addPropertyValue("", "birthDate", (Object)simpleDateFormat.parse("1995-09-04"), VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v3", VISIBILITY_EMPTY).addPropertyValue("", agePropertyName, (Object)20, VISIBILITY_EMPTY).addPropertyValue("", "birthDate", (Object)simpleDateFormat.parse("1995-08-15"), VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v4", VISIBILITY_EMPTY).addPropertyValue("", agePropertyName, (Object)20, VISIBILITY_A).addPropertyValue("", "birthDate", (Object)simpleDateFormat.parse("1995-03-02"), VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Map<Object, Long> histogram = this.queryGraphQueryWithHistogramAggregation(agePropertyName, "1", 0L, new HistogramAggregation.ExtendedBounds((Object)20L, (Object)25L), this.AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"histogram aggregation not supported", (histogram != null ? 1 : 0) != 0);
        Assert.assertEquals((long)6L, (long)histogram.size());
        Assert.assertEquals((long)1L, (long)histogram.get("25"));
        Assert.assertEquals((long)(searchIndexFieldLevelSecurity ? 2L : 3L), (long)histogram.get("20"));
        histogram = this.queryGraphQueryWithHistogramAggregation(agePropertyName, "1", null, null, this.AUTHORIZATIONS_A_AND_B);
        Assume.assumeTrue((String)"histogram aggregation not supported", (histogram != null ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)histogram.size());
        Assert.assertEquals((long)1L, (long)histogram.get("25"));
        Assert.assertEquals((long)3L, (long)histogram.get("20"));
        histogram = this.queryGraphQueryWithHistogramAggregation("emptyField", "1", null, null, this.AUTHORIZATIONS_A_AND_B);
        Assume.assumeTrue((String)"histogram aggregation not supported", (histogram != null ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)histogram.size());
        histogram = this.queryGraphQueryWithHistogramAggregation("birthDate", "year", null, null, this.AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"histogram aggregation not supported", (histogram != null ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)histogram.size());
        histogram = this.queryGraphQueryWithHistogramAggregation("birthDate", "31536000000", null, null, this.AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"histogram aggregation not supported", (histogram != null ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)histogram.size());
    }

    private Map<Object, Long> queryGraphQueryWithHistogramAggregation(String propertyName, String interval, Long minDocCount, HistogramAggregation.ExtendedBounds extendedBounds, Authorizations authorizations) {
        Query q = this.graph.query(authorizations).limit(Integer.valueOf(0));
        HistogramAggregation agg = new HistogramAggregation("hist-count", propertyName, interval, minDocCount);
        agg.setExtendedBounds(extendedBounds);
        if (!q.isAggregationSupported((Aggregation)agg)) {
            LOGGER.warn("%s unsupported", new Object[]{HistogramAggregation.class.getName()});
            return null;
        }
        q.addAggregation((Aggregation)agg);
        return this.histogramBucketToMap(((HistogramResult)q.vertices().getAggregationResult("hist-count", HistogramResult.class)).getBuckets());
    }

    @Test
    public void testGraphQueryWithRangeAggregation() throws ParseException {
        boolean searchIndexFieldLevelSecurity = this.isSearchIndexFieldLevelSecuritySupported();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.graph.defineProperty("emptyField").dataType(Integer.class).define();
        this.graph.prepareVertex("v1", VISIBILITY_EMPTY).addPropertyValue("", "age", (Object)25, VISIBILITY_EMPTY).addPropertyValue("", "birthDate", (Object)simpleDateFormat.parse("1990-09-04"), VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_EMPTY).addPropertyValue("", "age", (Object)20, VISIBILITY_EMPTY).addPropertyValue("", "birthDate", (Object)simpleDateFormat.parse("1995-09-04"), VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v3", VISIBILITY_EMPTY).addPropertyValue("", "age", (Object)20, VISIBILITY_EMPTY).addPropertyValue("", "birthDate", (Object)simpleDateFormat.parse("1995-08-15"), VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v4", VISIBILITY_EMPTY).addPropertyValue("", "age", (Object)20, VISIBILITY_A).addPropertyValue("", "birthDate", (Object)simpleDateFormat.parse("1995-03-02"), VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        RangeResult aggregationResult = this.queryGraphQueryWithRangeAggregation("age", null, "lower", 21, "middle", 23, "upper", this.AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"range aggregation not supported", (aggregationResult != null ? 1 : 0) != 0);
        Assert.assertEquals((long)(searchIndexFieldLevelSecurity ? 2L : 3L), (long)aggregationResult.getBucketByKey((Object)"lower").getCount());
        Assert.assertEquals((long)0L, (long)aggregationResult.getBucketByKey((Object)"middle").getCount());
        Assert.assertEquals((long)1L, (long)aggregationResult.getBucketByKey((Object)"upper").getCount());
        aggregationResult = this.queryGraphQueryWithRangeAggregation("age", null, "lower", 21, "middle", 23, "upper", this.AUTHORIZATIONS_A_AND_B);
        Assume.assumeTrue((String)"range aggregation not supported", (aggregationResult != null ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)aggregationResult.getBucketByKey((Object)"lower").getCount());
        Assert.assertEquals((long)0L, (long)aggregationResult.getBucketByKey((Object)"middle").getCount());
        Assert.assertEquals((long)1L, (long)aggregationResult.getBucketByKey((Object)"upper").getCount());
        aggregationResult = this.queryGraphQueryWithRangeAggregation("emptyField", null, "lower", 21, "middle", 23, "upper", this.AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"range aggregation not supported", (aggregationResult != null ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)org.vertexium.util.IterableUtils.count((Iterable)aggregationResult.getBuckets()));
        aggregationResult = this.queryGraphQueryWithRangeAggregation("birthDate", null, "lower", "1991-01-01", "middle", "1995-08-30", "upper", this.AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"range aggregation not supported", (aggregationResult != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)aggregationResult.getBucketByKey((Object)"lower").getCount());
        Assert.assertEquals((long)2L, (long)aggregationResult.getBucketByKey((Object)"middle").getCount());
        Assert.assertEquals((long)1L, (long)aggregationResult.getBucketByKey((Object)"upper").getCount());
        aggregationResult = this.queryGraphQueryWithRangeAggregation("birthDate", "yyyy-MM-dd", null, "1991-01-01", null, "1995-08-30", null, this.AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"range aggregation not supported", (aggregationResult != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)aggregationResult.getBucketByKey((Object)"*-1991-01-01").getCount());
        Assert.assertEquals((long)2L, (long)aggregationResult.getBucketByKey((Object)"1991-01-01-1995-08-30").getCount());
        Assert.assertEquals((long)1L, (long)aggregationResult.getBucketByKey((Object)"1995-08-30-*").getCount());
        aggregationResult = this.queryGraphQueryWithRangeAggregation("birthDate", null, "lower", simpleDateFormat.parse("1991-01-01"), "middle", simpleDateFormat.parse("1995-08-30"), "upper", this.AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"range aggregation not supported", (aggregationResult != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)aggregationResult.getBucketByKey((Object)"lower").getCount());
        Assert.assertEquals((long)2L, (long)aggregationResult.getBucketByKey((Object)"middle").getCount());
        Assert.assertEquals((long)1L, (long)aggregationResult.getBucketByKey((Object)"upper").getCount());
    }

    private RangeResult queryGraphQueryWithRangeAggregation(String propertyName, String format, String keyOne, Object boundaryOne, String keyTwo, Object boundaryTwo, String keyThree, Authorizations authorizations) {
        RangeAggregation agg;
        Query q = this.graph.query(authorizations).limit(Integer.valueOf(0));
        if (!q.isAggregationSupported((Aggregation)(agg = new RangeAggregation("range-count", propertyName, format)))) {
            LOGGER.warn("%s unsupported", new Object[]{RangeAggregation.class.getName()});
            return null;
        }
        agg.addUnboundedTo(keyOne, boundaryOne);
        agg.addRange(keyTwo, boundaryOne, boundaryTwo);
        agg.addUnboundedFrom(keyThree, boundaryTwo);
        q.addAggregation((Aggregation)agg);
        return (RangeResult)q.vertices().getAggregationResult("range-count", RangeResult.class);
    }

    @Test
    public void testGraphQueryWithRangeAggregationAndNestedTerms() throws ParseException {
        String agePropertyName = "age.property";
        this.graph.prepareVertex("v1", VISIBILITY_EMPTY).addPropertyValue("", agePropertyName, (Object)25, VISIBILITY_EMPTY).addPropertyValue("", "name", (Object)"Alice", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_EMPTY).addPropertyValue("", agePropertyName, (Object)20, VISIBILITY_EMPTY).addPropertyValue("", "name", (Object)"Alice", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v3", VISIBILITY_EMPTY).addPropertyValue("", agePropertyName, (Object)21, VISIBILITY_EMPTY).addPropertyValue("", "name", (Object)"Alice", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v4", VISIBILITY_EMPTY).addPropertyValue("", agePropertyName, (Object)22, VISIBILITY_EMPTY).addPropertyValue("", "name", (Object)"Bob", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Query q = this.graph.query(this.AUTHORIZATIONS_A_AND_B).limit(Integer.valueOf(0));
        RangeAggregation rangeAggregation = new RangeAggregation("range-count", agePropertyName);
        TermsAggregation termsAggregation = new TermsAggregation("name-count", "name");
        rangeAggregation.addNestedAggregation((Aggregation)termsAggregation);
        Assume.assumeTrue((String)"range aggregation not supported", (boolean)q.isAggregationSupported((Aggregation)rangeAggregation));
        Assume.assumeTrue((String)"terms aggregation not supported", (boolean)q.isAggregationSupported((Aggregation)termsAggregation));
        rangeAggregation.addUnboundedTo("lower", (Object)23);
        rangeAggregation.addUnboundedFrom("upper", (Object)23);
        q.addAggregation((Aggregation)rangeAggregation);
        RangeResult rangeAggResult = (RangeResult)q.vertices().getAggregationResult("range-count", RangeResult.class);
        Assert.assertEquals((long)3L, (long)rangeAggResult.getBucketByKey((Object)"lower").getCount());
        Assert.assertEquals((long)1L, (long)rangeAggResult.getBucketByKey((Object)"upper").getCount());
        Comparator bucketComparator = (b1, b2) -> Long.compare(b2.getCount(), b1.getCount());
        Map lowerNestedResult = rangeAggResult.getBucketByKey((Object)"lower").getNestedResults();
        TermsResult lowerTermsResult = (TermsResult)lowerNestedResult.get(termsAggregation.getAggregationName());
        List lowerTermsBuckets = org.vertexium.util.IterableUtils.toList((Iterable)lowerTermsResult.getBuckets());
        Collections.sort(lowerTermsBuckets, bucketComparator);
        Assert.assertEquals((long)1L, (long)lowerNestedResult.size());
        Assert.assertEquals((long)2L, (long)lowerTermsBuckets.size());
        Assert.assertEquals((Object)"Alice", (Object)((TermsBucket)lowerTermsBuckets.get(0)).getKey());
        Assert.assertEquals((long)2L, (long)((TermsBucket)lowerTermsBuckets.get(0)).getCount());
        Assert.assertEquals((Object)"Bob", (Object)((TermsBucket)lowerTermsBuckets.get(1)).getKey());
        Assert.assertEquals((long)1L, (long)((TermsBucket)lowerTermsBuckets.get(1)).getCount());
        Map upperNestedResult = rangeAggResult.getBucketByKey((Object)"upper").getNestedResults();
        TermsResult upperTermsResult = (TermsResult)upperNestedResult.get(termsAggregation.getAggregationName());
        List upperTermsBuckets = org.vertexium.util.IterableUtils.toList((Iterable)upperTermsResult.getBuckets());
        Assert.assertEquals((long)1L, (long)upperNestedResult.size());
        Assert.assertEquals((long)1L, (long)upperTermsBuckets.size());
        Assert.assertEquals((Object)"Alice", (Object)((TermsBucket)upperTermsBuckets.get(0)).getKey());
        Assert.assertEquals((long)1L, (long)((TermsBucket)upperTermsBuckets.get(0)).getCount());
    }

    @Test
    public void testGraphQueryWithStatisticsAggregation() throws ParseException {
        this.graph.defineProperty("emptyField").dataType(Integer.class).define();
        this.graph.prepareVertex("v1", VISIBILITY_EMPTY).addPropertyValue("", "age", (Object)25, VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_EMPTY).addPropertyValue("", "age", (Object)20, VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v3", VISIBILITY_EMPTY).addPropertyValue("", "age", (Object)20, VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v4", VISIBILITY_EMPTY).addPropertyValue("", "age", (Object)30, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        StatisticsResult stats = this.queryGraphQueryWithStatisticsAggregation("age", this.AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"statistics aggregation not supported", (stats != null ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)stats.getCount());
        Assert.assertEquals((double)65.0, (double)stats.getSum(), (double)0.1);
        Assert.assertEquals((double)20.0, (double)stats.getMin(), (double)0.1);
        Assert.assertEquals((double)25.0, (double)stats.getMax(), (double)0.1);
        Assert.assertEquals((double)2.35702, (double)stats.getStandardDeviation(), (double)0.1);
        Assert.assertEquals((double)21.666666, (double)stats.getAverage(), (double)0.1);
        stats = this.queryGraphQueryWithStatisticsAggregation("emptyField", this.AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"statistics aggregation not supported", (stats != null ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)stats.getCount());
        Assert.assertEquals((double)0.0, (double)stats.getSum(), (double)0.1);
        Assert.assertEquals((double)0.0, (double)stats.getMin(), (double)0.1);
        Assert.assertEquals((double)0.0, (double)stats.getMax(), (double)0.1);
        Assert.assertEquals((double)0.0, (double)stats.getAverage(), (double)0.1);
        Assert.assertEquals((double)0.0, (double)stats.getStandardDeviation(), (double)0.1);
        stats = this.queryGraphQueryWithStatisticsAggregation("age", this.AUTHORIZATIONS_A_AND_B);
        Assume.assumeTrue((String)"statistics aggregation not supported", (stats != null ? 1 : 0) != 0);
        Assert.assertEquals((long)4L, (long)stats.getCount());
        Assert.assertEquals((double)95.0, (double)stats.getSum(), (double)0.1);
        Assert.assertEquals((double)20.0, (double)stats.getMin(), (double)0.1);
        Assert.assertEquals((double)30.0, (double)stats.getMax(), (double)0.1);
        Assert.assertEquals((double)23.75, (double)stats.getAverage(), (double)0.1);
        Assert.assertEquals((double)4.14578, (double)stats.getStandardDeviation(), (double)0.1);
    }

    private StatisticsResult queryGraphQueryWithStatisticsAggregation(String propertyName, Authorizations authorizations) {
        StatisticsAggregation agg;
        Query q = this.graph.query(authorizations).limit(Integer.valueOf(0));
        if (!q.isAggregationSupported((Aggregation)(agg = new StatisticsAggregation("stats", propertyName)))) {
            LOGGER.warn("%s unsupported", new Object[]{StatisticsAggregation.class.getName()});
            return null;
        }
        q.addAggregation((Aggregation)agg);
        return (StatisticsResult)q.vertices().getAggregationResult("stats", StatisticsResult.class);
    }

    @Test
    public void testGraphQueryWithPercentilesAggregation() throws ParseException {
        this.graph.defineProperty("emptyField").dataType(Integer.class).define();
        for (int i = 0; i <= 100; ++i) {
            this.graph.prepareVertex("v" + i, VISIBILITY_EMPTY).addPropertyValue("", "age", (Object)i, VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        }
        this.graph.prepareVertex("v200", VISIBILITY_EMPTY).addPropertyValue("", "age", (Object)30, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        PercentilesResult percentilesResult = this.queryGraphQueryWithPercentilesAggregation("age", VISIBILITY_EMPTY, this.AUTHORIZATIONS_EMPTY, new double[0]);
        Assume.assumeTrue((String)"percentiles aggregation not supported", (percentilesResult != null ? 1 : 0) != 0);
        List percentiles = org.vertexium.util.IterableUtils.toList((Iterable)percentilesResult.getPercentiles());
        percentiles.sort(Comparator.comparing(Percentile::getPercentile));
        Assert.assertEquals((long)7L, (long)percentiles.size());
        Assert.assertEquals((double)1.0, (double)((Percentile)percentiles.get(0)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)1.0, (double)((Percentile)percentiles.get(0)).getValue(), (double)0.1);
        Assert.assertEquals((double)5.0, (double)((Percentile)percentiles.get(1)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)5.0, (double)((Percentile)percentiles.get(1)).getValue(), (double)0.1);
        Assert.assertEquals((double)25.0, (double)((Percentile)percentiles.get(2)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)25.0, (double)((Percentile)percentiles.get(2)).getValue(), (double)0.1);
        Assert.assertEquals((double)50.0, (double)((Percentile)percentiles.get(3)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)50.0, (double)((Percentile)percentiles.get(3)).getValue(), (double)0.1);
        Assert.assertEquals((double)75.0, (double)((Percentile)percentiles.get(4)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)75.0, (double)((Percentile)percentiles.get(4)).getValue(), (double)0.1);
        Assert.assertEquals((double)95.0, (double)((Percentile)percentiles.get(5)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)95.0, (double)((Percentile)percentiles.get(5)).getValue(), (double)0.1);
        Assert.assertEquals((double)99.0, (double)((Percentile)percentiles.get(6)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)99.0, (double)((Percentile)percentiles.get(6)).getValue(), (double)0.1);
        percentilesResult = this.queryGraphQueryWithPercentilesAggregation("age", VISIBILITY_EMPTY, this.AUTHORIZATIONS_EMPTY, 60.0, 99.99);
        Assume.assumeTrue((String)"statistics aggregation not supported", (percentilesResult != null ? 1 : 0) != 0);
        percentiles = org.vertexium.util.IterableUtils.toList((Iterable)percentilesResult.getPercentiles());
        percentiles.sort(Comparator.comparing(Percentile::getPercentile));
        Assert.assertEquals((long)2L, (long)percentiles.size());
        Assert.assertEquals((double)60.0, (double)((Percentile)percentiles.get(0)).getValue(), (double)0.1);
        Assert.assertEquals((double)60.0, (double)((Percentile)percentiles.get(0)).getValue(), (double)0.1);
        Assert.assertEquals((double)99.99, (double)((Percentile)percentiles.get(1)).getValue(), (double)0.1);
        Assert.assertEquals((double)99.99, (double)((Percentile)percentiles.get(1)).getValue(), (double)0.1);
        percentilesResult = this.queryGraphQueryWithPercentilesAggregation("emptyField", VISIBILITY_EMPTY, this.AUTHORIZATIONS_EMPTY, new double[0]);
        Assume.assumeTrue((String)"statistics aggregation not supported", (percentilesResult != null ? 1 : 0) != 0);
        percentiles = org.vertexium.util.IterableUtils.toList((Iterable)percentilesResult.getPercentiles());
        Assert.assertEquals((long)0L, (long)percentiles.size());
        percentilesResult = this.queryGraphQueryWithPercentilesAggregation("age", VISIBILITY_A, this.AUTHORIZATIONS_A_AND_B, new double[0]);
        Assume.assumeTrue((String)"statistics aggregation not supported", (percentilesResult != null ? 1 : 0) != 0);
        percentiles = org.vertexium.util.IterableUtils.toList((Iterable)percentilesResult.getPercentiles());
        percentiles.sort(Comparator.comparing(Percentile::getPercentile));
        Assert.assertEquals((long)7L, (long)percentiles.size());
        Assert.assertEquals((double)1.0, (double)((Percentile)percentiles.get(0)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)30.0, (double)((Percentile)percentiles.get(0)).getValue(), (double)0.1);
        Assert.assertEquals((double)5.0, (double)((Percentile)percentiles.get(1)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)30.0, (double)((Percentile)percentiles.get(1)).getValue(), (double)0.1);
        Assert.assertEquals((double)25.0, (double)((Percentile)percentiles.get(2)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)30.0, (double)((Percentile)percentiles.get(2)).getValue(), (double)0.1);
        Assert.assertEquals((double)50.0, (double)((Percentile)percentiles.get(3)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)30.0, (double)((Percentile)percentiles.get(3)).getValue(), (double)0.1);
        Assert.assertEquals((double)75.0, (double)((Percentile)percentiles.get(4)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)30.0, (double)((Percentile)percentiles.get(4)).getValue(), (double)0.1);
        Assert.assertEquals((double)95.0, (double)((Percentile)percentiles.get(5)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)30.0, (double)((Percentile)percentiles.get(5)).getValue(), (double)0.1);
        Assert.assertEquals((double)99.0, (double)((Percentile)percentiles.get(6)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)30.0, (double)((Percentile)percentiles.get(6)).getValue(), (double)0.1);
    }

    private PercentilesResult queryGraphQueryWithPercentilesAggregation(String propertyName, Visibility visibility, Authorizations authorizations, double ... percents) {
        Query q = this.graph.query(authorizations).limit(Integer.valueOf(0));
        PercentilesAggregation agg = new PercentilesAggregation("percentiles", propertyName, visibility);
        agg.setPercents(percents);
        if (!q.isAggregationSupported((Aggregation)agg)) {
            LOGGER.warn("%s unsupported", new Object[]{StatisticsAggregation.class.getName()});
            return null;
        }
        q.addAggregation((Aggregation)agg);
        return (PercentilesResult)q.vertices().getAggregationResult("percentiles", PercentilesResult.class);
    }

    @Test
    public void testGraphQueryWithGeohashAggregation() {
        boolean searchIndexFieldLevelSecurity = this.isSearchIndexFieldLevelSecuritySupported();
        this.graph.defineProperty("emptyField").dataType(GeoPoint.class).define();
        this.graph.defineProperty("location").dataType(GeoPoint.class).define();
        this.graph.prepareVertex("v1", VISIBILITY_EMPTY).addPropertyValue("", "location", (Object)new GeoPoint(50.0, -10.0, "pt1"), VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_EMPTY).addPropertyValue("", "location", (Object)new GeoPoint(39.0, -77.0, "pt2"), VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v3", VISIBILITY_EMPTY).addPropertyValue("", "location", (Object)new GeoPoint(39.1, -77.1, "pt3"), VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v4", VISIBILITY_EMPTY).addPropertyValue("", "location", (Object)new GeoPoint(39.2, -77.2, "pt4"), VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Map<String, Long> histogram = this.queryGraphQueryWithGeohashAggregation("location", 2, this.AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"geo hash histogram aggregation not supported", (histogram != null ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)histogram.size());
        Assert.assertEquals((long)1L, (long)histogram.get("gb"));
        Assert.assertEquals((long)(searchIndexFieldLevelSecurity ? 2L : 3L), (long)histogram.get("dq"));
        histogram = this.queryGraphQueryWithGeohashAggregation("emptyField", 2, this.AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"geo hash histogram aggregation not supported", (histogram != null ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)histogram.size());
        histogram = this.queryGraphQueryWithGeohashAggregation("location", 2, this.AUTHORIZATIONS_A_AND_B);
        Assume.assumeTrue((String)"geo hash histogram aggregation not supported", (histogram != null ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)histogram.size());
        Assert.assertEquals((long)1L, (long)histogram.get("gb"));
        Assert.assertEquals((long)3L, (long)histogram.get("dq"));
    }

    @Test
    public void testGraphQueryWithCalendarFieldAggregation() {
        String dateFieldName = "agg_date_field";
        this.graph.prepareVertex("v0", VISIBILITY_EMPTY).addPropertyValue("", "other_field", (Object)this.createDate(2016, 3, 27, 10, 18, 56), VISIBILITY_A).save(this.AUTHORIZATIONS_ALL);
        this.graph.prepareVertex("v1", VISIBILITY_EMPTY).addPropertyValue("", dateFieldName, (Object)this.createDate(2016, 3, 27, 10, 18, 56), VISIBILITY_A).save(this.AUTHORIZATIONS_ALL);
        this.graph.prepareVertex("v2", VISIBILITY_EMPTY).addPropertyValue("", dateFieldName, (Object)this.createDate(2017, 4, 26, 10, 18, 56), VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_ALL);
        this.graph.prepareVertex("v3", VISIBILITY_A_AND_B).addPropertyValue("", dateFieldName, (Object)this.createDate(2016, 3, 27, 12, 18, 56), VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_ALL);
        this.graph.prepareVertex("v4", VISIBILITY_A_AND_B).addPropertyValue("", dateFieldName, (Object)this.createDate(2016, 3, 24, 12, 18, 56), VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_ALL);
        this.graph.prepareVertex("v5", VISIBILITY_A_AND_B).addPropertyValue("", dateFieldName, (Object)this.createDate(2016, 3, 25, 12, 18, 56), VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_ALL);
        this.graph.prepareVertex("v6", VISIBILITY_A_AND_B).addPropertyValue("", dateFieldName, (Object)this.createDate(2016, 3, 30, 12, 18, 56), VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        QueryResultsIterable results = this.graph.query(this.AUTHORIZATIONS_ALL).addAggregation((Aggregation)new CalendarFieldAggregation("agg1", dateFieldName, null, TimeZone.getDefault(), 11)).limit(Integer.valueOf(0)).vertices();
        HistogramResult aggResult = (HistogramResult)results.getAggregationResult("agg1", CalendarFieldAggregation.RESULT_CLASS);
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)aggResult.getBuckets()));
        Assert.assertEquals((long)2L, (long)aggResult.getBucketByKey((Object)10).getCount());
        Assert.assertEquals((long)4L, (long)aggResult.getBucketByKey((Object)12).getCount());
        results = this.graph.query(this.AUTHORIZATIONS_ALL).addAggregation((Aggregation)new CalendarFieldAggregation("agg1", dateFieldName, null, TimeZone.getDefault(), 7)).limit(Integer.valueOf(0)).vertices();
        aggResult = (HistogramResult)results.getAggregationResult("agg1", CalendarFieldAggregation.RESULT_CLASS);
        Assert.assertEquals((long)5L, (long)org.vertexium.util.IterableUtils.count((Iterable)aggResult.getBuckets()));
        Assert.assertEquals((long)1L, (long)aggResult.getBucketByKey((Object)1).getCount());
        Assert.assertEquals((long)1L, (long)aggResult.getBucketByKey((Object)2).getCount());
        Assert.assertEquals((long)2L, (long)aggResult.getBucketByKey((Object)4).getCount());
        Assert.assertEquals((long)1L, (long)aggResult.getBucketByKey((Object)6).getCount());
        Assert.assertEquals((long)1L, (long)aggResult.getBucketByKey((Object)7).getCount());
        results = this.graph.query(this.AUTHORIZATIONS_ALL).addAggregation((Aggregation)new CalendarFieldAggregation("agg1", dateFieldName, null, TimeZone.getDefault(), 5)).limit(Integer.valueOf(0)).vertices();
        aggResult = (HistogramResult)results.getAggregationResult("agg1", CalendarFieldAggregation.RESULT_CLASS);
        Assert.assertEquals((long)5L, (long)org.vertexium.util.IterableUtils.count((Iterable)aggResult.getBuckets()));
        Assert.assertEquals((long)1L, (long)aggResult.getBucketByKey((Object)24).getCount());
        Assert.assertEquals((long)1L, (long)aggResult.getBucketByKey((Object)25).getCount());
        Assert.assertEquals((long)1L, (long)aggResult.getBucketByKey((Object)26).getCount());
        Assert.assertEquals((long)2L, (long)aggResult.getBucketByKey((Object)27).getCount());
        Assert.assertEquals((long)1L, (long)aggResult.getBucketByKey((Object)30).getCount());
        results = this.graph.query(this.AUTHORIZATIONS_ALL).addAggregation((Aggregation)new CalendarFieldAggregation("agg1", dateFieldName, null, TimeZone.getDefault(), 2)).limit(Integer.valueOf(0)).vertices();
        aggResult = (HistogramResult)results.getAggregationResult("agg1", CalendarFieldAggregation.RESULT_CLASS);
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)aggResult.getBuckets()));
        Assert.assertEquals((long)5L, (long)aggResult.getBucketByKey((Object)3).getCount());
        Assert.assertEquals((long)1L, (long)aggResult.getBucketByKey((Object)4).getCount());
        results = this.graph.query(this.AUTHORIZATIONS_ALL).addAggregation((Aggregation)new CalendarFieldAggregation("agg1", dateFieldName, null, TimeZone.getDefault(), 1)).limit(Integer.valueOf(0)).vertices();
        aggResult = (HistogramResult)results.getAggregationResult("agg1", CalendarFieldAggregation.RESULT_CLASS);
        Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)aggResult.getBuckets()));
        Assert.assertEquals((long)5L, (long)aggResult.getBucketByKey((Object)2016).getCount());
        Assert.assertEquals((long)1L, (long)aggResult.getBucketByKey((Object)2017).getCount());
        results = this.graph.query(this.AUTHORIZATIONS_ALL).addAggregation((Aggregation)new CalendarFieldAggregation("agg1", dateFieldName, null, TimeZone.getDefault(), 3)).limit(Integer.valueOf(0)).vertices();
        aggResult = (HistogramResult)results.getAggregationResult("agg1", CalendarFieldAggregation.RESULT_CLASS);
        if (this.isPainlessDateMath()) {
            Assert.assertEquals((long)3L, (long)org.vertexium.util.IterableUtils.count((Iterable)aggResult.getBuckets()));
            Assert.assertEquals((long)1L, (long)aggResult.getBucketByKey((Object)16).getCount());
            Assert.assertEquals((long)4L, (long)aggResult.getBucketByKey((Object)17).getCount());
            Assert.assertEquals((long)1L, (long)aggResult.getBucketByKey((Object)21).getCount());
        } else {
            Assert.assertEquals((long)2L, (long)org.vertexium.util.IterableUtils.count((Iterable)aggResult.getBuckets()));
            Assert.assertEquals((long)5L, (long)aggResult.getBucketByKey((Object)18).getCount());
            Assert.assertEquals((long)1L, (long)aggResult.getBucketByKey((Object)21).getCount());
        }
    }

    protected boolean isPainlessDateMath() {
        return false;
    }

    @Test
    public void testGraphQueryWithCalendarFieldAggregationNested() {
        this.graph.prepareVertex("v1", VISIBILITY_EMPTY).addPropertyValue("", "date", (Object)this.createDate(2016, 3, 27, 10, 18, 56), VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_ALL);
        this.graph.prepareVertex("v2", VISIBILITY_EMPTY).addPropertyValue("", "date", (Object)this.createDate(2016, 3, 27, 10, 18, 56), VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_ALL);
        this.graph.prepareVertex("v3", VISIBILITY_EMPTY).addPropertyValue("", "date", (Object)this.createDate(2016, 3, 27, 12, 18, 56), VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("v4", VISIBILITY_EMPTY).addPropertyValue("", "date", (Object)this.createDate(2016, 3, 28, 10, 18, 56), VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        CalendarFieldAggregation agg = new CalendarFieldAggregation("agg1", "date", null, TimeZone.getDefault(), 7);
        agg.addNestedAggregation((Aggregation)new CalendarFieldAggregation("aggNested", "date", null, TimeZone.getDefault(), 11));
        QueryResultsIterable results = this.graph.query(this.AUTHORIZATIONS_ALL).addAggregation((Aggregation)agg).limit(Integer.valueOf(0)).vertices();
        HistogramResult aggResult = (HistogramResult)results.getAggregationResult("agg1", CalendarFieldAggregation.RESULT_CLASS);
        HistogramBucket bucket = aggResult.getBucketByKey((Object)4);
        Assert.assertEquals((long)3L, (long)bucket.getCount());
        HistogramResult nestedResult = (HistogramResult)bucket.getNestedResults().get("aggNested");
        Assert.assertEquals((long)2L, (long)nestedResult.getBucketByKey((Object)10).getCount());
        Assert.assertEquals((long)1L, (long)nestedResult.getBucketByKey((Object)12).getCount());
        bucket = aggResult.getBucketByKey((Object)5);
        Assert.assertEquals((long)1L, (long)bucket.getCount());
        nestedResult = (HistogramResult)bucket.getNestedResults().get("aggNested");
        Assert.assertEquals((long)1L, (long)nestedResult.getBucketByKey((Object)10).getCount());
    }

    @Test
    public void testLargeFieldValuesThatAreMarkedWithExactMatch() {
        this.graph.defineProperty("field1").dataType(String.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH}).define();
        StringBuilder largeText = new StringBuilder();
        for (int i = 0; i < 10000; ++i) {
            largeText.append("test ");
        }
        this.graph.prepareVertex("v1", VISIBILITY_EMPTY).addPropertyValue("", "field1", (Object)largeText.toString(), VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_EMPTY);
        this.graph.flush();
    }

    private Map<String, Long> queryGraphQueryWithGeohashAggregation(String propertyName, int precision, Authorizations authorizations) {
        GeohashAggregation agg;
        Query q = this.graph.query(authorizations).limit(Integer.valueOf(0));
        if (!q.isAggregationSupported((Aggregation)(agg = new GeohashAggregation("geo-count", propertyName, precision)))) {
            LOGGER.warn("%s unsupported", new Object[]{GeohashAggregation.class.getName()});
            return null;
        }
        q.addAggregation((Aggregation)agg);
        return this.geoHashBucketToMap(((GeohashResult)q.vertices().getAggregationResult("geo-count", GeohashResult.class)).getBuckets());
    }

    @Test
    public void testGetVertexPropertyCountByValue() {
        boolean searchIndexFieldLevelSecurity = this.isSearchIndexFieldLevelSecuritySupported();
        this.graph.defineProperty("name").dataType(String.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH}).define();
        this.graph.prepareVertex("v1", VISIBILITY_EMPTY).addPropertyValue("k1", "name", (Object)"Joe", VISIBILITY_EMPTY).addPropertyValue("k2", "name", (Object)"Joseph", VISIBILITY_EMPTY).addPropertyValue("", "age", (Object)25, VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareVertex("v2", VISIBILITY_EMPTY).addPropertyValue("k1", "name", (Object)"Joe", VISIBILITY_EMPTY).addPropertyValue("k2", "name", (Object)"Joseph", VISIBILITY_B).addPropertyValue("", "age", (Object)20, VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.prepareEdge("e1", "v1", LABEL_LABEL1, VISIBILITY_EMPTY).addPropertyValue("k1", "name", (Object)"Joe", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Map vertexPropertyCountByValue = this.graph.getVertexPropertyCountByValue("name", this.AUTHORIZATIONS_EMPTY);
        Assert.assertEquals((long)2L, (long)vertexPropertyCountByValue.size());
        Assert.assertEquals((long)2L, (long)((Long)vertexPropertyCountByValue.get("joe")));
        Assert.assertEquals((long)(searchIndexFieldLevelSecurity ? 1L : 2L), (long)((Long)vertexPropertyCountByValue.get("joseph")));
        vertexPropertyCountByValue = this.graph.getVertexPropertyCountByValue("name", this.AUTHORIZATIONS_A_AND_B);
        Assert.assertEquals((long)2L, (long)vertexPropertyCountByValue.size());
        Assert.assertEquals((long)2L, (long)((Long)vertexPropertyCountByValue.get("joe")));
        Assert.assertEquals((long)2L, (long)((Long)vertexPropertyCountByValue.get("joseph")));
    }

    @Test
    public void testGetCounts() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge("e1", v1, v2, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.flush();
        Assert.assertEquals((long)2L, (long)this.graph.getVertexCount(this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)1L, (long)this.graph.getEdgeCount(this.AUTHORIZATIONS_A));
    }

    @Test
    public void testFetchHintsEdgeLabels() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        Vertex v3 = this.graph.addVertex("v3", VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        this.graph.addEdge("e v1->v2", v1, v2, LABEL_LABEL1, VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        this.graph.addEdge("e v1->v3", v1, v3, LABEL_LABEL2, VISIBILITY_A, this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", FetchHint.EDGE_LABELS, this.AUTHORIZATIONS_ALL);
        List edgeLabels = org.vertexium.util.IterableUtils.toList((Iterable)v1.getEdgeLabels(Direction.BOTH, this.AUTHORIZATIONS_ALL));
        Assert.assertEquals((long)2L, (long)edgeLabels.size());
        Assert.assertTrue((String)"label1 missing", (boolean)edgeLabels.contains(LABEL_LABEL1));
        Assert.assertTrue((String)"label2 missing", (boolean)edgeLabels.contains(LABEL_LABEL2));
    }

    @Test
    public void testIPAddress() {
        this.graph.defineProperty("ipAddress2").dataType(IpV4Address.class).define();
        this.graph.prepareVertex("v1", VISIBILITY_A).addPropertyValue("k1", "ipAddress1", (Object)new IpV4Address("192.168.0.1"), VISIBILITY_A).addPropertyValue("k1", "ipAddress2", (Object)new IpV4Address("192.168.0.2"), VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("v2", VISIBILITY_A).addPropertyValue("k1", "ipAddress1", (Object)new IpV4Address("192.168.0.5"), VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("v3", VISIBILITY_A).addPropertyValue("k1", "ipAddress1", (Object)new IpV4Address("192.168.1.1"), VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertEquals((Object)new IpV4Address("192.168.0.1"), (Object)v1.getPropertyValue("ipAddress1"));
        Assert.assertEquals((Object)new IpV4Address(192, 168, 0, 2), (Object)v1.getPropertyValue("ipAddress2"));
        List<Vertex> vertices = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(this.AUTHORIZATIONS_A).has("ipAddress1", (Predicate)Compare.EQUAL, (Object)new IpV4Address("192.168.0.1")).vertices());
        Assert.assertEquals((long)1L, (long)vertices.size());
        Assert.assertEquals((Object)"v1", (Object)((Vertex)vertices.get(0)).getId());
        vertices = this.sortById(org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(this.AUTHORIZATIONS_A).range("ipAddress1", (Object)new IpV4Address("192.168.0.0"), (Object)new IpV4Address("192.168.0.255")).vertices()));
        Assert.assertEquals((long)2L, (long)vertices.size());
        Assert.assertEquals((Object)"v1", (Object)vertices.get(0).getId());
        Assert.assertEquals((Object)"v2", (Object)vertices.get(1).getId());
    }

    @Test
    public void testVertexHashCodeAndEquals() {
        Vertex v1 = (Vertex)this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("prop1", (Object)"value1", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        Vertex v2 = (Vertex)this.graph.prepareVertex("v2", VISIBILITY_A).setProperty("prop1", (Object)"value1", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        Vertex v1Loaded = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)v1Loaded.hashCode(), (long)v1.hashCode());
        Assert.assertTrue((boolean)v1Loaded.equals(v1));
        Assert.assertNotEquals((long)v1Loaded.hashCode(), (long)v2.hashCode());
        Assert.assertFalse((boolean)v1Loaded.equals(v2));
    }

    @Test
    public void testEdgeHashCodeAndEquals() {
        Vertex v1 = this.graph.prepareVertex("v1", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.prepareVertex("v2", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        Edge e1 = (Edge)this.graph.prepareEdge("e1", v1, v2, LABEL_LABEL1, VISIBILITY_A).setProperty("prop1", (Object)"value1", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        Edge e2 = (Edge)this.graph.prepareEdge("e2", v1, v2, LABEL_LABEL1, VISIBILITY_A).setProperty("prop1", (Object)"value1", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        Edge e1Loaded = this.graph.getEdge("e1", this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)e1Loaded.hashCode(), (long)e1.hashCode());
        Assert.assertTrue((boolean)e1Loaded.equals(e1));
        Assert.assertNotEquals((long)e1Loaded.hashCode(), (long)e2.hashCode());
        Assert.assertFalse((boolean)e1Loaded.equals(e2));
    }

    @Test
    public void testCaseSensitivityOfExactMatch() {
        this.graph.defineProperty("text").dataType(String.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH}).define();
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("text", (Object)"Joe", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("v2", VISIBILITY_A).setProperty("text", (Object)"joe", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("v3", VISIBILITY_A).setProperty("text", (Object)"JOE", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("v4", VISIBILITY_A).setProperty("text", (Object)"Joe", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        QueryResultsIterable vertices = this.graph.query(this.AUTHORIZATIONS_A).has("text", (Predicate)Compare.EQUAL, (Object)"Joe").addAggregation((Aggregation)new TermsAggregation("agg1", "text")).vertices();
        VertexiumAssert.assertVertexIdsAnyOrder((Iterable<Vertex>)vertices, "v1", "v2", "v3", "v4");
        TermsResult agg = (TermsResult)vertices.getAggregationResult("agg1", TermsResult.class);
        ArrayList buckets = Lists.newArrayList((Iterable)agg.getBuckets());
        Assert.assertEquals((long)1L, (long)buckets.size());
        Assert.assertEquals((Object)"Joe", (Object)((TermsBucket)buckets.get(0)).getKey());
        Assert.assertEquals((long)4L, (long)((TermsBucket)buckets.get(0)).getCount());
    }

    @Test
    public void testExtendedData() {
        Date date1 = new Date(1487083490000L);
        Date date2 = new Date(1487083480000L);
        Date date3 = new Date(1487083470000L);
        this.graph.prepareVertex("v1", VISIBILITY_A).addExtendedData("table1", "row1", "date", (Object)date1, VISIBILITY_A).addExtendedData("table1", "row1", "name", (Object)"value1", VISIBILITY_A).addExtendedData("table1", "row2", "date", (Object)date2, VISIBILITY_A).addExtendedData("table1", "row2", "name", (Object)"value2", VISIBILITY_A).addExtendedData("table1", "row3", "date", (Object)date3, VISIBILITY_A).addExtendedData("table1", "row3", "name", (Object)"value3", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        final AtomicInteger rowCount = new AtomicInteger();
        final AtomicInteger rowPropertyCount = new AtomicInteger();
        this.graph.visitElements((GraphVisitor)new DefaultGraphVisitor(){

            public void visitExtendedDataRow(Element element, String tableName, ExtendedDataRow row) {
                rowCount.incrementAndGet();
            }

            public void visitProperty(Element element, String tableName, ExtendedDataRow row, Property property) {
                rowPropertyCount.incrementAndGet();
            }
        }, this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)3L, (long)rowCount.get());
        Assert.assertEquals((long)6L, (long)rowPropertyCount.get());
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"table1"), (Object)v1.getExtendedDataTableNames());
        Iterator rows = v1.getExtendedData("table1").iterator();
        ExtendedDataRow row = (ExtendedDataRow)rows.next();
        Assert.assertEquals((Object)date1, (Object)row.getPropertyValue("date"));
        Assert.assertEquals((Object)"value1", (Object)row.getPropertyValue("name"));
        row = (ExtendedDataRow)rows.next();
        Assert.assertEquals((Object)date2, (Object)row.getPropertyValue("date"));
        Assert.assertEquals((Object)"value2", (Object)row.getPropertyValue("name"));
        row = (ExtendedDataRow)rows.next();
        Assert.assertEquals((Object)date3, (Object)row.getPropertyValue("date"));
        Assert.assertEquals((Object)"value3", (Object)row.getPropertyValue("name"));
        Assert.assertFalse((boolean)rows.hasNext());
        row = this.graph.getExtendedData(new ExtendedDataRowId(ElementType.VERTEX, "v1", "table1", "row1"), this.AUTHORIZATIONS_A);
        Assert.assertEquals((Object)"row1", (Object)row.getId().getRowId());
        Assert.assertEquals((Object)date1, (Object)row.getPropertyValue("date"));
        Assert.assertEquals((Object)"value1", (Object)row.getPropertyValue("name"));
        rows = this.graph.getExtendedData((Iterable)Lists.newArrayList((Object[])new ExtendedDataRowId[]{new ExtendedDataRowId(ElementType.VERTEX, "v1", "table1", "row1"), new ExtendedDataRowId(ElementType.VERTEX, "v1", "table1", "row2")}), this.AUTHORIZATIONS_A).iterator();
        row = (ExtendedDataRow)rows.next();
        Assert.assertEquals((Object)date1, (Object)row.getPropertyValue("date"));
        Assert.assertEquals((Object)"value1", (Object)row.getPropertyValue("name"));
        row = (ExtendedDataRow)rows.next();
        Assert.assertEquals((Object)date2, (Object)row.getPropertyValue("date"));
        Assert.assertEquals((Object)"value2", (Object)row.getPropertyValue("name"));
        Assert.assertFalse((boolean)rows.hasNext());
        rows = this.graph.getExtendedData(ElementType.VERTEX, "v1", "table1", this.AUTHORIZATIONS_A).iterator();
        row = (ExtendedDataRow)rows.next();
        Assert.assertEquals((Object)date1, (Object)row.getPropertyValue("date"));
        Assert.assertEquals((Object)"value1", (Object)row.getPropertyValue("name"));
        row = (ExtendedDataRow)rows.next();
        Assert.assertEquals((Object)date2, (Object)row.getPropertyValue("date"));
        Assert.assertEquals((Object)"value2", (Object)row.getPropertyValue("name"));
        row = (ExtendedDataRow)rows.next();
        Assert.assertEquals((Object)date3, (Object)row.getPropertyValue("date"));
        Assert.assertEquals((Object)"value3", (Object)row.getPropertyValue("name"));
        Assert.assertFalse((boolean)rows.hasNext());
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        v1.prepareMutation().addExtendedData("table1", "row4", "name", (Object)"value4", VISIBILITY_A).addExtendedData("table2", "row1", "name", (Object)"value1", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        Assert.assertTrue((String)"table1 should exist", (boolean)v1.getExtendedDataTableNames().contains((Object)"table1"));
        Assert.assertTrue((String)"table2 should exist", (boolean)v1.getExtendedDataTableNames().contains((Object)"table2"));
        List rowsList = org.vertexium.util.IterableUtils.toList((Iterable)v1.getExtendedData("table1"));
        Assert.assertEquals((long)4L, (long)rowsList.size());
        rowsList = org.vertexium.util.IterableUtils.toList((Iterable)v1.getExtendedData("table2"));
        Assert.assertEquals((long)1L, (long)rowsList.size());
    }

    @Test
    public void testExtendedDataInRange() {
        this.graph.prepareVertex(VISIBILITY_A_STRING, VISIBILITY_A).addExtendedData("table1", "row1", "name", (Object)"value1", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("aa", VISIBILITY_A).addExtendedData("table1", "row1", "name", (Object)"value2", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("az", VISIBILITY_A).addExtendedData("table1", "row1", "name", (Object)"value3", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex(VISIBILITY_B_STRING, VISIBILITY_A).addExtendedData("table1", "row1", "name", (Object)"value4", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareEdge("aa", VISIBILITY_A_STRING, "aa", "edge1", VISIBILITY_A).addExtendedData("table1", "row1", "name", (Object)"value5", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        List rows = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getExtendedDataInRange(ElementType.VERTEX, new Range(null, VISIBILITY_A_STRING), this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)0L, (long)rows.size());
        rows = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getExtendedDataInRange(ElementType.VERTEX, new Range(null, VISIBILITY_B_STRING), this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)3L, (long)rows.size());
        List<String> rowValues = rows.stream().map(row -> row.getPropertyValue("name").toString()).collect(Collectors.toList());
        VertexiumAssert.assertIdsAnyOrder(rowValues, "value1", "value2", "value3");
        rows = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getExtendedDataInRange(ElementType.VERTEX, new Range(null, "bb"), this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)4L, (long)rows.size());
        rowValues = rows.stream().map(row -> row.getPropertyValue("name").toString()).collect(Collectors.toList());
        VertexiumAssert.assertIdsAnyOrder(rowValues, "value1", "value2", "value3", "value4");
        rows = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getExtendedDataInRange(ElementType.VERTEX, new Range("aa", VISIBILITY_B_STRING), this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)2L, (long)rows.size());
        rowValues = rows.stream().map(row -> row.getPropertyValue("name").toString()).collect(Collectors.toList());
        VertexiumAssert.assertIdsAnyOrder(rowValues, "value2", "value3");
        rows = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getExtendedDataInRange(ElementType.VERTEX, new Range(null, null), this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)4L, (long)rows.size());
        rowValues = rows.stream().map(row -> row.getPropertyValue("name").toString()).collect(Collectors.toList());
        VertexiumAssert.assertIdsAnyOrder(rowValues, "value1", "value2", "value3", "value4");
        rows = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getExtendedDataInRange(ElementType.EDGE, new Range(null, VISIBILITY_A_STRING), this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)0L, (long)rows.size());
        rows = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getExtendedDataInRange(ElementType.EDGE, new Range(null, VISIBILITY_B_STRING), this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)1L, (long)rows.size());
        rowValues = rows.stream().map(row -> row.getPropertyValue("name").toString()).collect(Collectors.toList());
        VertexiumAssert.assertIdsAnyOrder(rowValues, "value5");
        rows = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getExtendedDataInRange(ElementType.EDGE, new Range("aa", VISIBILITY_B_STRING), this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)1L, (long)rows.size());
        rowValues = rows.stream().map(row -> row.getPropertyValue("name").toString()).collect(Collectors.toList());
        VertexiumAssert.assertIdsAnyOrder(rowValues, "value5");
        rows = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.getExtendedDataInRange(ElementType.EDGE, new Range(null, null), this.AUTHORIZATIONS_A));
        Assert.assertEquals((long)1L, (long)rows.size());
        rowValues = rows.stream().map(row -> row.getPropertyValue("name").toString()).collect(Collectors.toList());
        VertexiumAssert.assertIdsAnyOrder(rowValues, "value5");
    }

    @Test
    public void testExtendedDataDifferentValue() {
        this.graph.prepareVertex("v1", VISIBILITY_A).addExtendedData("table1", "row1", "name", (Object)"value1", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        ArrayList rows = Lists.newArrayList((Iterable)v1.getExtendedData("table1"));
        Assert.assertEquals((Object)"value1", (Object)((ExtendedDataRow)rows.get(0)).getPropertyValue("name"));
        this.graph.prepareVertex("v1", VISIBILITY_A).addExtendedData("table1", "row1", "name", (Object)"value2", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        rows = Lists.newArrayList((Iterable)v1.getExtendedData("table1"));
        Assert.assertEquals((Object)"value2", (Object)((ExtendedDataRow)rows.get(0)).getPropertyValue("name"));
    }

    @Test
    public void testExtendedDataDeleteColumn() {
        this.graph.prepareVertex("v1", VISIBILITY_A).addExtendedData("table1", "row1", "name", (Object)"value", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        this.graph.prepareVertex("v1", VISIBILITY_A).deleteExtendedData("table1", "row1", "name", VISIBILITY_B).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        ArrayList rows = Lists.newArrayList((Iterable)this.graph.getVertex("v1", this.AUTHORIZATIONS_A).getExtendedData("table1"));
        Assert.assertEquals((long)1L, (long)rows.size());
        QueryResultsIterable searchResults = this.graph.query("value", this.AUTHORIZATIONS_A).search();
        Assert.assertEquals((long)1L, (long)searchResults.getTotalHits());
        VertexiumAssert.clearGraphEvents();
        this.graph.getVertex("v1", this.AUTHORIZATIONS_A).prepareMutation().deleteExtendedData("table1", "row1", "name", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        VertexiumAssert.assertEvents(new GraphEvent[]{new DeleteExtendedDataEvent(this.graph, (Element)v1, "table1", "row1", "name", null)});
        if (v1.getExtendedDataTableNames().size() == 0) {
            Assert.assertEquals((String)"table names", (long)0L, (long)v1.getExtendedDataTableNames().size());
        } else {
            Assert.assertEquals((String)"extended data rows", (long)0L, (long)Lists.newArrayList((Iterable)v1.getExtendedData("table1")).size());
        }
        searchResults = this.graph.query("value", this.AUTHORIZATIONS_A).search();
        List searchResultsList = org.vertexium.util.IterableUtils.toList((Iterable)searchResults);
        Assert.assertEquals((String)"search result items", (long)0L, (long)searchResultsList.size());
        Assert.assertEquals((String)"total hits", (long)0L, (long)searchResults.getTotalHits());
    }

    @Test
    public void testExtendedDataDelete() {
        this.graph.prepareVertex("v1", VISIBILITY_A).addExtendedData("table1", "row1", "name", (Object)"value", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        this.graph.deleteVertex("v1", this.AUTHORIZATIONS_A);
        this.graph.flush();
        QueryResultsIterable searchResults = this.graph.query("value", this.AUTHORIZATIONS_A).search();
        Assert.assertEquals((long)0L, (long)searchResults.getTotalHits());
    }

    @Test
    public void testExtendedDataQueryVertices() {
        Date date1 = new Date(1487083490000L);
        Date date2 = new Date(1487083480000L);
        String tableName = "table.one";
        String rowOneName = "row.one";
        String rowTwoName = "row.two";
        String dateColumnName = "date.column";
        String nameColumnName = "name.column";
        this.graph.defineProperty(dateColumnName).sortable(true).dataType(Date.class).define();
        this.graph.defineProperty(nameColumnName).sortable(true).textIndexHint(TextIndexHint.values()).dataType(String.class).define();
        this.graph.prepareVertex("v1", VISIBILITY_A).addExtendedData(tableName, rowOneName, dateColumnName, (Object)date1, VISIBILITY_A).addExtendedData(tableName, rowOneName, nameColumnName, (Object)"value 1", VISIBILITY_A).addExtendedData(tableName, rowTwoName, dateColumnName, (Object)date2, VISIBILITY_A).addExtendedData(tableName, rowTwoName, nameColumnName, (Object)"value 2", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("v2", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        QueryResultsIterable queryResults = this.graph.query(this.AUTHORIZATIONS_A).has(dateColumnName, (Object)date1).sort(dateColumnName, SortDirection.ASCENDING).vertices();
        Assert.assertEquals((long)0L, (long)queryResults.getTotalHits());
        QueryResultsIterable searchResults = this.graph.query(this.AUTHORIZATIONS_A).has(dateColumnName, (Object)date1).sort(dateColumnName, SortDirection.ASCENDING).search();
        Assert.assertEquals((long)1L, (long)searchResults.getTotalHits());
        List searchResultsList = org.vertexium.util.IterableUtils.toList((Iterable)searchResults);
        Assert.assertEquals((long)1L, (long)searchResultsList.size());
        ExtendedDataRow searchResult = (ExtendedDataRow)searchResultsList.get(0);
        Assert.assertEquals((Object)"v1", (Object)searchResult.getId().getElementId());
        Assert.assertEquals((Object)rowOneName, (Object)searchResult.getId().getRowId());
        searchResults = this.graph.query("value", this.AUTHORIZATIONS_A).search();
        Assert.assertEquals((long)2L, (long)searchResults.getTotalHits());
        searchResultsList = org.vertexium.util.IterableUtils.toList((Iterable)searchResults);
        Assert.assertEquals((long)2L, (long)searchResultsList.size());
        VertexiumAssert.assertRowIdsAnyOrder(Lists.newArrayList((Object[])new String[]{rowOneName, rowTwoName}), searchResultsList);
        searchResults = this.graph.query("value", this.AUTHORIZATIONS_A).hasExtendedData(ElementType.VERTEX, "v1", tableName).search();
        Assert.assertEquals((long)2L, (long)searchResults.getTotalHits());
        searchResultsList = org.vertexium.util.IterableUtils.toList((Iterable)searchResults);
        Assert.assertEquals((long)2L, (long)searchResultsList.size());
        VertexiumAssert.assertRowIdsAnyOrder(Lists.newArrayList((Object[])new String[]{rowOneName, rowTwoName}), searchResultsList);
        searchResults = this.graph.query("value", this.AUTHORIZATIONS_A).hasExtendedData(tableName).search();
        Assert.assertEquals((long)2L, (long)searchResults.getTotalHits());
        searchResultsList = org.vertexium.util.IterableUtils.toList((Iterable)searchResults);
        Assert.assertEquals((long)2L, (long)searchResultsList.size());
        VertexiumAssert.assertRowIdsAnyOrder(Lists.newArrayList((Object[])new String[]{rowOneName, rowTwoName}), searchResultsList);
    }

    @Test
    public void testExtendedDataVertexQuery() {
        this.graph.prepareVertex("v1", VISIBILITY_A).addExtendedData("table1", "row1", "name", (Object)"value 1", VISIBILITY_A).addExtendedData("table1", "row2", "name", (Object)"value 2", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("v2", VISIBILITY_A).addExtendedData("table2", "row3", "name", (Object)"value 1", VISIBILITY_A).addExtendedData("table2", "row4", "name", (Object)"value 2", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareEdge("e1", "v1", "v2", LABEL_LABEL1, VISIBILITY_A).addExtendedData("table1", "row5", "name", (Object)"value 1", VISIBILITY_A).addExtendedData("table1", "row6", "name", (Object)"value 2", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        List searchResultsList = org.vertexium.util.IterableUtils.toList((Iterable)v1.query(this.AUTHORIZATIONS_A).extendedDataRows());
        VertexiumAssert.assertRowIdsAnyOrder(Lists.newArrayList((Object[])new String[]{"row3", "row4", "row5", "row6"}), searchResultsList);
        QueryResultsIterable rows = this.graph.query(this.AUTHORIZATIONS_A).hasId(new String[]{"v1"}).extendedDataRows();
        VertexiumAssert.assertResultsCount(2, 2, rows);
        rows = this.graph.query(this.AUTHORIZATIONS_A).hasId(new String[]{"v1", "v2"}).extendedDataRows();
        VertexiumAssert.assertResultsCount(4, 4, rows);
        searchResultsList = org.vertexium.util.IterableUtils.toList((Iterable)v1.query(this.AUTHORIZATIONS_A).sort("__extendedDataTableName", SortDirection.ASCENDING).sort("__extendedDataRowId", SortDirection.ASCENDING).extendedDataRows());
        VertexiumAssert.assertRowIds(Lists.newArrayList((Object[])new String[]{"row5", "row6", "row3", "row4"}), searchResultsList);
    }

    @Test
    public void testExtendedDataEdgeQuery() {
        this.graph.prepareVertex("v1", VISIBILITY_A).addExtendedData("table1", "row1", "name", (Object)"value 1", VISIBILITY_A).addExtendedData("table1", "row2", "name", (Object)"value 2", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("v2", VISIBILITY_A).addExtendedData("table1", "row3", "name", (Object)"value 1", VISIBILITY_A).addExtendedData("table1", "row4", "name", (Object)"value 2", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareEdge("e1", "v1", "v2", LABEL_LABEL1, VISIBILITY_A).addExtendedData("table1", "row5", "name", (Object)"value 1", VISIBILITY_A).addExtendedData("table1", "row6", "name", (Object)"value 2", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        Edge e1 = this.graph.getEdge("e1", this.AUTHORIZATIONS_A);
        List searchResultsList = org.vertexium.util.IterableUtils.toList((Iterable)this.getGraph().query("*", this.AUTHORIZATIONS_A).hasExtendedData(ElementType.EDGE, e1.getId(), "table1").extendedDataRows());
        VertexiumAssert.assertRowIdsAnyOrder(Lists.newArrayList((Object[])new String[]{"row5", "row6"}), searchResultsList);
        QueryResultsIterable rows = this.graph.query(this.AUTHORIZATIONS_A).hasId(new String[]{"e1"}).extendedDataRows();
        VertexiumAssert.assertResultsCount(2, 2, rows);
        rows = this.graph.query(this.AUTHORIZATIONS_A).hasId(new String[]{"v1", "e1"}).extendedDataRows();
        VertexiumAssert.assertResultsCount(4, 4, rows);
    }

    @Test
    public void testExtendedDataQueryAfterDeleteForVertex() {
        this.graph.prepareVertex("v1", VISIBILITY_A).addExtendedData("table1", "row1", "name", (Object)"value 1", VISIBILITY_A).addExtendedData("table1", "row2", "name", (Object)"value 2", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        List searchResultsList = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(this.AUTHORIZATIONS_A).extendedDataRows());
        VertexiumAssert.assertRowIdsAnyOrder(Lists.newArrayList((Object[])new String[]{"row1", "row2"}), searchResultsList);
        this.graph.deleteVertex("v1", this.AUTHORIZATIONS_A);
        this.graph.flush();
        searchResultsList = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(this.AUTHORIZATIONS_A).extendedDataRows());
        VertexiumAssert.assertRowIdsAnyOrder(Lists.newArrayList(), searchResultsList);
    }

    @Test
    public void testExtendedDataQueryAfterDeleteForEdge() {
        this.graph.prepareVertex("v1", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("v2", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareEdge("e1", "v1", "v2", LABEL_LABEL1, VISIBILITY_A).addExtendedData("table1", "row1", "name", (Object)"value 1", VISIBILITY_A).addExtendedData("table1", "row2", "name", (Object)"value 2", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        List searchResultsList = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(this.AUTHORIZATIONS_A).extendedDataRows());
        VertexiumAssert.assertRowIdsAnyOrder(Lists.newArrayList((Object[])new String[]{"row1", "row2"}), searchResultsList);
        this.graph.deleteEdge("e1", this.AUTHORIZATIONS_A);
        this.graph.flush();
        searchResultsList = org.vertexium.util.IterableUtils.toList((Iterable)this.graph.query(this.AUTHORIZATIONS_A).extendedDataRows());
        VertexiumAssert.assertRowIdsAnyOrder(Lists.newArrayList(), searchResultsList);
    }

    @Test
    public void testExtendedDataQueryEdges() {
        Date date1 = new Date(1487083490000L);
        Date date2 = new Date(1487083480000L);
        this.graph.prepareVertex("v1", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareVertex("v2", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareEdge("e1", "v1", "v2", LABEL_LABEL1, VISIBILITY_A).addExtendedData("table1", "row1", "date", (Object)date1, VISIBILITY_A).addExtendedData("table1", "row1", "name", (Object)"value 1", VISIBILITY_A).addExtendedData("table1", "row2", "date", (Object)date2, VISIBILITY_A).addExtendedData("table1", "row2", "name", (Object)"value 2", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.prepareEdge("e2", "v1", "v2", LABEL_LABEL1, VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        QueryResultsIterable queryResults = this.graph.query(this.AUTHORIZATIONS_A).has("date", (Object)date1).edges();
        Assert.assertEquals((long)0L, (long)queryResults.getTotalHits());
        QueryResultsIterable searchResults = this.graph.query(this.AUTHORIZATIONS_A).has("date", (Object)date1).search();
        Assert.assertEquals((long)1L, (long)searchResults.getTotalHits());
        List searchResultsList = org.vertexium.util.IterableUtils.toList((Iterable)searchResults);
        Assert.assertEquals((long)1L, (long)searchResultsList.size());
        ExtendedDataRow searchResult = (ExtendedDataRow)searchResultsList.get(0);
        Assert.assertEquals((Object)"e1", (Object)searchResult.getId().getElementId());
        Assert.assertEquals((Object)"row1", (Object)searchResult.getId().getRowId());
        searchResults = this.graph.query("value", this.AUTHORIZATIONS_A).search();
        Assert.assertEquals((long)2L, (long)searchResults.getTotalHits());
        searchResultsList = org.vertexium.util.IterableUtils.toList((Iterable)searchResults);
        Assert.assertEquals((long)2L, (long)searchResultsList.size());
        VertexiumAssert.assertRowIdsAnyOrder(Lists.newArrayList((Object[])new String[]{"row1", "row2"}), searchResultsList);
    }

    @Test
    public void testExtendedDataQueryWithMultiValue() {
        this.graph.prepareVertex("v1", VISIBILITY_A).addExtendedData("table1", "row1", "col1", "key1", (Object)"joe", VISIBILITY_A).addExtendedData("table1", "row1", "col1", "key2", (Object)"bob", VISIBILITY_A).addExtendedData("table1", "row2", "col1", "key1", (Object)"joe", VISIBILITY_A).addExtendedData("table1", "row2", "col1", "key2", (Object)"jane", VISIBILITY_A).save(this.AUTHORIZATIONS_A);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A);
        QueryableIterable rows = v1.getExtendedData("table1");
        for (ExtendedDataRow row : rows) {
            if (row.getId().getRowId().equals("row1")) {
                Assert.assertEquals((Object)"joe", (Object)row.getPropertyValue("key1", "col1"));
                Assert.assertEquals((Object)"bob", (Object)row.getPropertyValue("key2", "col1"));
                continue;
            }
            if (row.getId().getRowId().equals("row2")) {
                Assert.assertEquals((Object)"joe", (Object)row.getPropertyValue("key1", "col1"));
                Assert.assertEquals((Object)"jane", (Object)row.getPropertyValue("key2", "col1"));
                continue;
            }
            throw new VertexiumException("invalid row: " + row.getId());
        }
        QueryResultsIterable searchResults = this.graph.query("joe", this.AUTHORIZATIONS_A).search();
        Assert.assertEquals((long)2L, (long)searchResults.getTotalHits());
        List searchResultsList = org.vertexium.util.IterableUtils.toList((Iterable)searchResults);
        Assert.assertEquals((long)2L, (long)searchResultsList.size());
        VertexiumAssert.assertRowIdsAnyOrder(Lists.newArrayList((Object[])new String[]{"row1", "row2"}), searchResultsList);
        searchResults = this.graph.query("bob", this.AUTHORIZATIONS_A).search();
        Assert.assertEquals((long)1L, (long)searchResults.getTotalHits());
        searchResultsList = org.vertexium.util.IterableUtils.toList((Iterable)searchResults);
        Assert.assertEquals((long)1L, (long)searchResultsList.size());
        VertexiumAssert.assertRowIdsAnyOrder(Lists.newArrayList((Object[])new String[]{"row1"}), searchResultsList);
    }

    @Test
    public void testFetchHintsExceptions() {
        Metadata prop1Metadata = new Metadata();
        prop1Metadata.add("metadata1", (Object)"metadata1Value", VISIBILITY_A);
        this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("prop1", (Object)"value1", prop1Metadata, VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", EnumSet.of(FetchHint.PROPERTIES), this.AUTHORIZATIONS_A);
        Property prop1 = v1.getProperty("prop1");
        VertexiumAssert.assertThrowsException(() -> ((Property)prop1).getMetadata());
    }

    @Test
    public void benchmark() {
        Assume.assumeTrue((boolean)this.benchmarkEnabled());
        Random random = new Random(1L);
        int vertexCount = 10000;
        int edgeCount = 10000;
        int findVerticesByIdCount = 10000;
        this.benchmarkAddVertices(vertexCount);
        this.benchmarkAddEdges(random, vertexCount, edgeCount);
        this.benchmarkFindVerticesById(random, vertexCount, findVerticesByIdCount);
    }

    @Test
    public void benchmarkGetPropertyByName() {
        int propertyCount = 100;
        Assume.assumeTrue((boolean)this.benchmarkEnabled());
        VertexBuilder m = this.graph.prepareVertex("v1", VISIBILITY_A);
        for (int i = 0; i < 100; ++i) {
            m.addPropertyValue("key", "prop" + i, (Object)("value " + i), VISIBILITY_A);
        }
        m.save(this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_ALL);
        double startTime = System.currentTimeMillis();
        StringBuilder optimizationBuster = new StringBuilder();
        for (int i = 0; i < 10000; ++i) {
            for (int propIndex = 0; propIndex < 100; ++propIndex) {
                Object value = v1.getPropertyValue("key", "prop" + propIndex);
                optimizationBuster.append(value.toString().substring(0, 1));
            }
        }
        double endTime = System.currentTimeMillis();
        LOGGER.trace("optimizationBuster: %s", new Object[]{optimizationBuster.substring(0, 1)});
        LOGGER.info("get property by name and key in %.3fs", new Object[]{(endTime - startTime) / 1000.0});
        startTime = System.currentTimeMillis();
        optimizationBuster = new StringBuilder();
        for (int i = 0; i < 10000; ++i) {
            for (int propIndex = 0; propIndex < 100; ++propIndex) {
                Object value = v1.getPropertyValue("prop" + propIndex);
                optimizationBuster.append(value.toString().substring(0, 1));
            }
        }
        endTime = System.currentTimeMillis();
        LOGGER.trace("optimizationBuster: %s", new Object[]{optimizationBuster.substring(0, 1)});
        LOGGER.info("get property by name in %.3fs", new Object[]{(endTime - startTime) / 1000.0});
    }

    @Test
    public void benchmarkSaveElementMutations() {
        Assume.assumeTrue((boolean)this.benchmarkEnabled());
        int vertexCount = 1000;
        this.benchmarkAddVertices(vertexCount);
        this.benchmarkAddVerticesSaveElementMutations(vertexCount);
        this.benchmarkAddVertices(vertexCount);
    }

    private void benchmarkAddVertices(int vertexCount) {
        double startTime = System.currentTimeMillis();
        for (int i = 0; i < vertexCount; ++i) {
            String vertexId = "v" + i;
            this.graph.prepareVertex(vertexId, VISIBILITY_A).addPropertyValue("k1", "prop1", (Object)("value1 " + i), VISIBILITY_A).addPropertyValue("k1", "prop2", (Object)("value2 " + i), VISIBILITY_A).addPropertyValue("k1", "prop3", (Object)("value3 " + i), VISIBILITY_A).addPropertyValue("k1", "prop4", (Object)("value4 " + i), VISIBILITY_A).addPropertyValue("k1", "prop5", (Object)("value5 " + i), VISIBILITY_A).save(this.AUTHORIZATIONS_ALL);
        }
        this.graph.flush();
        double endTime = System.currentTimeMillis();
        LOGGER.info("add vertices in %.3fs", new Object[]{(endTime - startTime) / 1000.0});
    }

    private void benchmarkAddVerticesSaveElementMutations(int vertexCount) {
        double startTime = System.currentTimeMillis();
        ArrayList<ElementBuilder> mutations = new ArrayList<ElementBuilder>();
        for (int i = 0; i < vertexCount; ++i) {
            String vertexId = "v" + i;
            ElementBuilder m = this.graph.prepareVertex(vertexId, VISIBILITY_A).addPropertyValue("k1", "prop1", (Object)("value1 " + i), VISIBILITY_A).addPropertyValue("k1", "prop2", (Object)("value2 " + i), VISIBILITY_A).addPropertyValue("k1", "prop3", (Object)("value3 " + i), VISIBILITY_A).addPropertyValue("k1", "prop4", (Object)("value4 " + i), VISIBILITY_A).addPropertyValue("k1", "prop5", (Object)("value5 " + i), VISIBILITY_A);
            mutations.add(m);
        }
        this.graph.saveElementMutations(mutations, this.AUTHORIZATIONS_ALL);
        this.graph.flush();
        double endTime = System.currentTimeMillis();
        LOGGER.info("save element mutations in %.3fs", new Object[]{(endTime - startTime) / 1000.0});
    }

    private void benchmarkAddEdges(Random random, int vertexCount, int edgeCount) {
        double startTime = System.currentTimeMillis();
        for (int i = 0; i < edgeCount; ++i) {
            String edgeId = "e" + i;
            String outVertexId = "v" + random.nextInt(vertexCount);
            String inVertexId = "v" + random.nextInt(vertexCount);
            this.graph.prepareEdge(edgeId, outVertexId, inVertexId, LABEL_LABEL1, VISIBILITY_A).addPropertyValue("k1", "prop1", (Object)("value1 " + i), VISIBILITY_A).addPropertyValue("k1", "prop2", (Object)("value2 " + i), VISIBILITY_A).addPropertyValue("k1", "prop3", (Object)("value3 " + i), VISIBILITY_A).addPropertyValue("k1", "prop4", (Object)("value4 " + i), VISIBILITY_A).addPropertyValue("k1", "prop5", (Object)("value5 " + i), VISIBILITY_A).save(this.AUTHORIZATIONS_ALL);
        }
        this.graph.flush();
        double endTime = System.currentTimeMillis();
        LOGGER.info("add edges in %.3fs", new Object[]{(endTime - startTime) / 1000.0});
    }

    private void benchmarkFindVerticesById(Random random, int vertexCount, int findVerticesByIdCount) {
        double startTime = System.currentTimeMillis();
        for (int i = 0; i < findVerticesByIdCount; ++i) {
            String vertexId = "v" + random.nextInt(vertexCount);
            this.graph.getVertex(vertexId, this.AUTHORIZATIONS_ALL);
        }
        this.graph.flush();
        double endTime = System.currentTimeMillis();
        LOGGER.info("find vertices by id in %.3fs", new Object[]{(endTime - startTime) / 1000.0});
    }

    private boolean benchmarkEnabled() {
        return Boolean.parseBoolean(System.getProperty("benchmark", "false"));
    }

    private List<Vertex> getVertices(long count) {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        int i = 0;
        while ((long)i < count) {
            Vertex vertex = this.graph.addVertex(Integer.toString(i), VISIBILITY_EMPTY, this.AUTHORIZATIONS_EMPTY);
            vertices.add(vertex);
            ++i;
        }
        return vertices;
    }

    private boolean isDefaultSearchIndex() {
        if (!(this.graph instanceof GraphWithSearchIndex)) {
            return false;
        }
        GraphWithSearchIndex graphWithSearchIndex = (GraphWithSearchIndex)this.graph;
        return graphWithSearchIndex.getSearchIndex() instanceof DefaultSearchIndex;
    }

    protected List<Vertex> sortById(List<Vertex> vertices) {
        Collections.sort(vertices, Comparator.comparing(Element::getId));
        return vertices;
    }

    protected boolean disableEdgeIndexing(Graph graph) {
        return false;
    }

    private Map<Object, Long> termsBucketToMap(Iterable<TermsBucket> buckets) {
        HashMap<Object, Long> results = new HashMap<Object, Long>();
        for (TermsBucket b : buckets) {
            results.put(b.getKey(), b.getCount());
        }
        return results;
    }

    private Map<Object, Map<Object, Long>> nestedTermsBucketToMap(Iterable<TermsBucket> buckets, String nestedAggName) {
        HashMap<Object, Map<Object, Long>> results = new HashMap<Object, Map<Object, Long>>();
        for (TermsBucket entry : buckets) {
            TermsResult nestedResults = (TermsResult)entry.getNestedResults().get(nestedAggName);
            if (nestedResults == null) {
                throw new VertexiumException("Could not find nested: " + nestedAggName);
            }
            results.put(entry.getKey(), this.termsBucketToMap(nestedResults.getBuckets()));
        }
        return results;
    }

    private Map<Object, Long> histogramBucketToMap(Iterable<HistogramBucket> buckets) {
        HashMap<Object, Long> results = new HashMap<Object, Long>();
        for (HistogramBucket b : buckets) {
            results.put(b.getKey(), b.getCount());
        }
        return results;
    }

    private Map<String, Long> geoHashBucketToMap(Iterable<GeohashBucket> buckets) {
        HashMap<String, Long> results = new HashMap<String, Long>();
        for (GeohashBucket b : buckets) {
            results.put(b.getKey(), b.getCount());
        }
        return results;
    }

    @Test
    public void historicalPropertyValueAddProp() {
        Vertex vertexAdded = (Vertex)this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("prop1_A", (Object)"value1", VISIBILITY_A).setProperty("prop2_B", (Object)"value2", VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B);
        vertexAdded = (Vertex)v1.prepareMutation().setProperty("prop3_A", (Object)"value3", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        List values = org.vertexium.util.IterableUtils.toList((Iterable)v1.getHistoricalPropertyValues(this.AUTHORIZATIONS_A_AND_B));
        Collections.reverse(values);
        Assert.assertEquals((long)3L, (long)values.size());
        Assert.assertEquals((Object)"prop1_A", (Object)((HistoricalPropertyValue)values.get(0)).getPropertyName());
        Assert.assertEquals((Object)"prop2_B", (Object)((HistoricalPropertyValue)values.get(1)).getPropertyName());
        Assert.assertEquals((Object)"prop3_A", (Object)((HistoricalPropertyValue)values.get(2)).getPropertyName());
    }

    @Test
    public void historicalPropertyValueDeleteProp() {
        Vertex vertexAdded = (Vertex)this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("prop1_A", (Object)"value1", VISIBILITY_A).setProperty("prop2_B", (Object)"value2", VISIBILITY_B).setProperty("prop3_A", (Object)"value3", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B);
        vertexAdded = (Vertex)v1.prepareMutation().softDeleteProperties("prop2_B").save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        List values = org.vertexium.util.IterableUtils.toList((Iterable)v1.getHistoricalPropertyValues(this.AUTHORIZATIONS_A_AND_B));
        Collections.reverse(values);
        Assert.assertEquals((long)4L, (long)values.size());
        boolean isDeletedExpected = false;
        for (int i = 0; i < 4; ++i) {
            HistoricalPropertyValue item = (HistoricalPropertyValue)values.get(i);
            if (item.getPropertyName().equals("prop1_A")) {
                Assert.assertEquals((Object)"prop1_A", (Object)((HistoricalPropertyValue)values.get(i)).getPropertyName());
                Assert.assertEquals((Object)false, (Object)((HistoricalPropertyValue)values.get(i)).isDeleted());
                continue;
            }
            if (item.getPropertyName().equals("prop2_B")) {
                Assert.assertEquals((Object)"prop2_B", (Object)((HistoricalPropertyValue)values.get(i)).getPropertyName());
                Assert.assertEquals((Object)isDeletedExpected, (Object)((HistoricalPropertyValue)values.get(i)).isDeleted());
                isDeletedExpected = !isDeletedExpected;
                continue;
            }
            if (item.getPropertyName().equals("prop3_A")) {
                Assert.assertEquals((Object)"prop3_A", (Object)((HistoricalPropertyValue)values.get(i)).getPropertyName());
                Assert.assertEquals((Object)false, (Object)((HistoricalPropertyValue)values.get(i)).isDeleted());
                continue;
            }
            Assert.fail((String)("Invalid " + item));
        }
    }

    @Test
    public void historicalPropertyValueModifyPropValue() {
        Vertex vertexAdded = (Vertex)this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("prop1_A", (Object)"value1", VISIBILITY_A).setProperty("prop2_B", (Object)"value2", VISIBILITY_B).setProperty("prop3_A", (Object)"value3", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B);
        vertexAdded = (Vertex)v1.prepareMutation().setProperty("prop3_A", (Object)"value4", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B);
        vertexAdded = (Vertex)v1.prepareMutation().setProperty("prop3_A", (Object)"value3", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        List values = org.vertexium.util.IterableUtils.toList((Iterable)v1.getHistoricalPropertyValues(this.AUTHORIZATIONS_A_AND_B));
        Collections.reverse(values);
        Assert.assertEquals((long)5L, (long)values.size());
        Assert.assertEquals((Object)"prop1_A", (Object)((HistoricalPropertyValue)values.get(0)).getPropertyName());
        Assert.assertEquals((Object)false, (Object)((HistoricalPropertyValue)values.get(0)).isDeleted());
        Assert.assertEquals((Object)"value1", (Object)((HistoricalPropertyValue)values.get(0)).getValue());
        Assert.assertEquals((Object)"prop2_B", (Object)((HistoricalPropertyValue)values.get(1)).getPropertyName());
        Assert.assertEquals((Object)false, (Object)((HistoricalPropertyValue)values.get(1)).isDeleted());
        Assert.assertEquals((Object)"value2", (Object)((HistoricalPropertyValue)values.get(1)).getValue());
        Assert.assertEquals((Object)"prop3_A", (Object)((HistoricalPropertyValue)values.get(2)).getPropertyName());
        Assert.assertEquals((Object)false, (Object)((HistoricalPropertyValue)values.get(2)).isDeleted());
        Assert.assertEquals((Object)"value3", (Object)((HistoricalPropertyValue)values.get(2)).getValue());
        Assert.assertEquals((Object)"prop3_A", (Object)((HistoricalPropertyValue)values.get(3)).getPropertyName());
        Assert.assertEquals((Object)false, (Object)((HistoricalPropertyValue)values.get(3)).isDeleted());
        Assert.assertEquals((Object)"value4", (Object)((HistoricalPropertyValue)values.get(3)).getValue());
        Assert.assertEquals((Object)"prop3_A", (Object)((HistoricalPropertyValue)values.get(4)).getPropertyName());
        Assert.assertEquals((Object)false, (Object)((HistoricalPropertyValue)values.get(4)).isDeleted());
        Assert.assertEquals((Object)"value3", (Object)((HistoricalPropertyValue)values.get(4)).getValue());
    }

    @Test
    public void historicalPropertyValueModifyPropVisibility() {
        Vertex vertexAdded = (Vertex)this.graph.prepareVertex("v1", VISIBILITY_A).setProperty("prop1_A", (Object)"value1", VISIBILITY_A).setProperty("prop2_B", (Object)"value2", VISIBILITY_B).setProperty("prop3_A", (Object)"value3", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        Vertex v1 = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_A_AND_B);
        vertexAdded = (Vertex)v1.prepareMutation().alterPropertyVisibility("prop1_A", VISIBILITY_B).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_A_AND_B);
        vertexAdded = (Vertex)v1.prepareMutation().alterPropertyVisibility("prop1_A", VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        List values = org.vertexium.util.IterableUtils.toList((Iterable)v1.getHistoricalPropertyValues(this.AUTHORIZATIONS_A_AND_B));
        Collections.reverse(values);
        Assert.assertEquals((long)5L, (long)values.size());
        Assert.assertEquals((Object)"prop1_A", (Object)((HistoricalPropertyValue)values.get(0)).getPropertyName());
        Assert.assertEquals((Object)false, (Object)((HistoricalPropertyValue)values.get(0)).isDeleted());
        Assert.assertEquals((Object)VISIBILITY_A, (Object)((HistoricalPropertyValue)values.get(0)).getPropertyVisibility());
        Assert.assertEquals((Object)"prop2_B", (Object)((HistoricalPropertyValue)values.get(1)).getPropertyName());
        Assert.assertEquals((Object)false, (Object)((HistoricalPropertyValue)values.get(1)).isDeleted());
        Assert.assertEquals((Object)VISIBILITY_B, (Object)((HistoricalPropertyValue)values.get(1)).getPropertyVisibility());
        Assert.assertEquals((Object)"prop3_A", (Object)((HistoricalPropertyValue)values.get(2)).getPropertyName());
        Assert.assertEquals((Object)false, (Object)((HistoricalPropertyValue)values.get(2)).isDeleted());
        Assert.assertEquals((Object)VISIBILITY_A, (Object)((HistoricalPropertyValue)values.get(2)).getPropertyVisibility());
        Assert.assertEquals((Object)"prop1_A", (Object)((HistoricalPropertyValue)values.get(3)).getPropertyName());
        Assert.assertEquals((Object)false, (Object)((HistoricalPropertyValue)values.get(3)).isDeleted());
        Assert.assertEquals((Object)VISIBILITY_B, (Object)((HistoricalPropertyValue)values.get(3)).getPropertyVisibility());
        Assert.assertEquals((Object)"prop1_A", (Object)((HistoricalPropertyValue)values.get(4)).getPropertyName());
        Assert.assertEquals((Object)false, (Object)((HistoricalPropertyValue)values.get(4)).isDeleted());
        Assert.assertEquals((Object)VISIBILITY_A, (Object)((HistoricalPropertyValue)values.get(4)).getPropertyVisibility());
    }

    @Test
    @Ignore
    public void manyVisibilities() {
        String itemVisibilityString;
        int i;
        int count = 1010;
        ArrayList<String> authsToAdd = new ArrayList<String>();
        authsToAdd.add("all");
        for (i = 0; i < count; ++i) {
            itemVisibilityString = String.format("v%d", i);
            authsToAdd.add(itemVisibilityString);
        }
        System.out.println("Adding auths");
        this.addAuthorizations(authsToAdd.toArray(new String[authsToAdd.size()]));
        System.out.println("Add vertices");
        for (i = 0; i < count; ++i) {
            itemVisibilityString = String.format("v%d", i);
            Visibility visibility = new Visibility(String.format("v%d|all", i));
            Authorizations authorizations = this.createAuthorizations("all", itemVisibilityString);
            this.graph.prepareVertex(visibility).addPropertyValue("key1", "name1", (Object)itemVisibilityString, visibility).save(authorizations);
        }
        this.graph.flush();
        System.out.println("Getting vertices");
        Authorizations authorizations = this.createAuthorizations("all");
        ArrayList vertices = Lists.newArrayList((Iterable)this.graph.getVertices(authorizations));
        Assert.assertEquals((long)count, (long)vertices.size());
        System.out.println("Query vertices");
        vertices = Lists.newArrayList((Iterable)this.graph.query(authorizations).limit((Integer)null).vertices());
        Assert.assertEquals((long)count, (long)vertices.size());
    }
}

