/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.test.util;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.junit.Assert;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.ExtendedDataRow;
import org.vertexium.Vertex;
import org.vertexium.VertexiumException;
import org.vertexium.VertexiumObject;
import org.vertexium.event.GraphEvent;
import org.vertexium.query.IterableWithTotalHits;
import org.vertexium.query.QueryResultsIterable;
import org.vertexium.util.IterableUtils;
import org.vertexium.util.StreamUtils;

public class VertexiumAssert {
    protected static final List<GraphEvent> graphEvents = new ArrayList<GraphEvent>();

    public static void assertIdsAnyOrder(Iterable<String> ids, String ... expectedIds) {
        List<String> sortedIds = StreamUtils.stream((Iterable[])new Iterable[]{ids}).sorted().collect(Collectors.toList());
        Arrays.sort(expectedIds);
        String idsString = VertexiumAssert.idsToString(sortedIds.toArray(new String[sortedIds.size()]));
        String expectedIdsString = VertexiumAssert.idsToString(expectedIds);
        Assert.assertEquals((String)("ids length mismatch found:[" + idsString + "] expected:[" + expectedIdsString + "]"), (long)expectedIds.length, (long)sortedIds.size());
        for (int i = 0; i < expectedIds.length; ++i) {
            Assert.assertEquals((String)("at offset: " + i + " found:[" + idsString + "] expected:[" + expectedIdsString + "]"), (Object)expectedIds[i], sortedIds.get(i));
        }
    }

    public static void assertVertexIdsAnyOrder(Iterable<Vertex> vertices, String ... expectedIds) {
        VertexiumAssert.assertElementIdsAnyOrder(vertices, expectedIds);
    }

    public static void assertVertexIds(Iterable<Vertex> vertices, String ... expectedIds) {
        VertexiumAssert.assertElementIds(vertices, expectedIds);
    }

    public static String idsToString(String[] ids) {
        return Joiner.on((String)", ").join((Object[])ids);
    }

    public static String idsToStringSorted(Iterable<String> ids) {
        ArrayList idsList = Lists.newArrayList(ids);
        Collections.sort(idsList);
        return Joiner.on((String)", ").join((Iterable)idsList);
    }

    public static void assertEvents(GraphEvent ... expectedEvents) {
        Assert.assertEquals((String)"Different number of events occurred than were asserted", (long)expectedEvents.length, (long)graphEvents.size());
        for (int i = 0; i < expectedEvents.length; ++i) {
            Assert.assertEquals((Object)expectedEvents[i], (Object)graphEvents.get(i));
        }
    }

    public static void assertEdgeIdsAnyOrder(Iterable<Edge> edges, String ... expectedIds) {
        VertexiumAssert.assertElementIdsAnyOrder(edges, expectedIds);
    }

    public static void assertEdgeIds(Iterable<Edge> edges, String ... ids) {
        VertexiumAssert.assertElementIds(edges, ids);
    }

    public static void assertElementIdsAnyOrder(Iterable<? extends Element> elements, String ... expectedIds) {
        List sortedElements = StreamUtils.stream((Iterable[])new Iterable[]{elements}).sorted(Comparator.comparing(Element::getId)).collect(Collectors.toList());
        Arrays.sort(expectedIds);
        VertexiumAssert.assertElementIds(sortedElements, expectedIds);
    }

    public static void assertElementIds(Iterable<? extends Element> elements, String ... ids) {
        List elementList = IterableUtils.toList(elements);
        Assert.assertEquals((String)"ids length mismatch", (long)ids.length, (long)elementList.size());
        for (int i = 0; i < ids.length; ++i) {
            Assert.assertEquals((String)("at offset: " + i), (Object)ids[i], (Object)((Element)elementList.get(i)).getId());
        }
    }

    public static void assertResultsCount(int expectedCountAndTotalHits, QueryResultsIterable<? extends Element> results) {
        Assert.assertEquals((long)expectedCountAndTotalHits, (long)results.getTotalHits());
        VertexiumAssert.assertCount(expectedCountAndTotalHits, results);
    }

    public static void assertResultsCount(int expectedCount, int expectedTotalHits, IterableWithTotalHits<?> results) {
        Assert.assertEquals((long)expectedTotalHits, (long)results.getTotalHits());
        VertexiumAssert.assertCount(expectedCount, results);
    }

    private static void assertCount(int expectedCount, Iterable<?> results) {
        int count = 0;
        Iterator<?> it = results.iterator();
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        Assert.assertEquals((long)expectedCount, (long)count);
        Assert.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            throw new VertexiumException("Should throw NoSuchElementException: " + it.getClass().getName());
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    public static void addGraphEvent(GraphEvent graphEvent) {
        graphEvents.add(graphEvent);
    }

    public static void clearGraphEvents() {
        graphEvents.clear();
    }

    public static void assertRowIdsAnyOrder(Iterable<String> expectedRowIds, Iterable<? extends VertexiumObject> searchResults) {
        List<String> foundRowIds = VertexiumAssert.getRowIds(searchResults);
        Assert.assertEquals((Object)VertexiumAssert.idsToStringSorted(expectedRowIds), (Object)VertexiumAssert.idsToStringSorted(foundRowIds));
    }

    public static void assertRowIds(Iterable<String> expectedRowIds, Iterable<? extends VertexiumObject> searchResults) {
        List<String> foundRowIds = VertexiumAssert.getRowIds(searchResults);
        Assert.assertEquals(expectedRowIds, foundRowIds);
    }

    private static List<String> getRowIds(Iterable<? extends VertexiumObject> searchResults) {
        return StreamUtils.stream((Iterable[])new Iterable[]{searchResults}).filter(sr -> sr instanceof ExtendedDataRow).map(sr -> ((ExtendedDataRow)sr).getId().getRowId()).collect(Collectors.toList());
    }

    public static void assertThrowsException(Runnable fn) {
        try {
            fn.run();
        }
        catch (Throwable ex) {
            return;
        }
        TestCase.fail((String)"Should have thrown an exception");
    }
}

