/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.tools;

import com.beust.jcommander.Parameter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONObject;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Metadata;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.tools.GraphToolBase;
import org.vertexium.util.JavaSerializableUtils;

public class GraphBackup
extends GraphToolBase {
    public static final String BASE64_PREFIX = "base64/java:";
    @Parameter(names={"--out", "-o"}, description="Output filename")
    private String outputFileName = null;

    public static void main(String[] args) throws Exception {
        GraphBackup graphBackup = new GraphBackup();
        graphBackup.run(args);
    }

    @Override
    protected void run(String[] args) throws Exception {
        super.run(args);
        try (OutputStream out = this.createOutputStream();){
            this.save(this.getGraph(), out, this.getAuthorizations());
        }
    }

    private OutputStream createOutputStream() throws FileNotFoundException {
        if (this.outputFileName == null) {
            return System.out;
        }
        return new FileOutputStream(this.outputFileName);
    }

    public void save(Graph graph, OutputStream out, Authorizations authorizations) throws IOException {
        this.save(graph.getVertices(authorizations), graph.getEdges(authorizations), out);
    }

    public void save(Iterable<Vertex> vertices, Iterable<Edge> edges, OutputStream out) throws IOException {
        this.saveVertices(vertices, out);
        this.saveEdges(edges, out);
    }

    public void saveVertices(Iterable<Vertex> vertices, OutputStream out) throws IOException {
        for (Vertex vertex : vertices) {
            this.saveVertex(vertex, out);
        }
    }

    public void saveVertex(Vertex vertex, OutputStream out) throws IOException {
        JSONObject json = this.vertexToJson(vertex);
        out.write(86);
        out.write(json.toString().getBytes());
        out.write(10);
        this.saveStreamingPropertyValues(out, (Element)vertex);
    }

    public void saveEdges(Iterable<Edge> edges, OutputStream out) throws IOException {
        for (Edge edge : edges) {
            this.saveEdge(edge, out);
        }
    }

    public void saveEdge(Edge edge, OutputStream out) throws IOException {
        JSONObject json = this.edgeToJson(edge);
        out.write(69);
        out.write(json.toString().getBytes());
        out.write(10);
        this.saveStreamingPropertyValues(out, (Element)edge);
    }

    private JSONObject vertexToJson(Vertex vertex) {
        return this.elementToJson((Element)vertex);
    }

    private JSONObject edgeToJson(Edge edge) {
        JSONObject json = this.elementToJson((Element)edge);
        json.put("outVertexId", (Object)edge.getVertexId(Direction.OUT));
        json.put("inVertexId", (Object)edge.getVertexId(Direction.IN));
        json.put("label", (Object)edge.getLabel());
        return json;
    }

    private JSONObject elementToJson(Element element) {
        JSONObject json = new JSONObject();
        json.put("id", (Object)element.getId());
        json.put("visibility", (Object)element.getVisibility().getVisibilityString());
        json.put("properties", (Object)this.propertiesToJson(element.getProperties()));
        return json;
    }

    private JSONArray propertiesToJson(Iterable<Property> properties) {
        JSONArray json = new JSONArray();
        for (Property property : properties) {
            if (property.getValue() instanceof StreamingPropertyValue) continue;
            json.put((Object)this.propertyToJson(property));
        }
        return json;
    }

    private JSONObject propertyToJson(Property property) {
        Metadata metadata;
        JSONObject json = new JSONObject();
        json.put("key", (Object)property.getKey());
        json.put("name", (Object)property.getName());
        json.put("visibility", (Object)property.getVisibility().getVisibilityString());
        Object value = property.getValue();
        if (!(value instanceof StreamingPropertyValue)) {
            json.put("value", (Object)this.objectToJsonString(value));
        }
        if ((metadata = property.getMetadata()) != null) {
            json.put("metadata", (Object)this.metadataToJson(metadata));
        }
        return json;
    }

    private JSONObject metadataToJson(Metadata metadata) {
        JSONObject json = new JSONObject();
        for (Metadata.Entry m : metadata.entrySet()) {
            json.put(m.getKey(), (Object)this.metadataItemToJson(m));
        }
        return json;
    }

    private JSONObject metadataItemToJson(Metadata.Entry entry) {
        JSONObject json = new JSONObject();
        json.put("value", (Object)this.objectToJsonString(entry.getValue()));
        json.put("visibility", (Object)entry.getVisibility().getVisibilityString());
        return json;
    }

    private void saveStreamingPropertyValues(OutputStream out, Element element) throws IOException {
        for (Property property : element.getProperties()) {
            if (!(property.getValue() instanceof StreamingPropertyValue)) continue;
            this.saveStreamingProperty(out, property);
        }
    }

    private void saveStreamingProperty(OutputStream out, Property property) throws IOException {
        int read;
        StreamingPropertyValue spv = (StreamingPropertyValue)property.getValue();
        JSONObject json = this.propertyToJson(property);
        json.put("valueType", (Object)spv.getValueType().getName());
        json.put("searchIndex", spv.isSearchIndex());
        json.put("store", spv.isStore());
        out.write(68);
        out.write(json.toString().getBytes());
        out.write(10);
        InputStream in = spv.getInputStream();
        byte[] buffer = new byte[10240];
        while ((read = in.read(buffer)) > 0) {
            out.write(Integer.toString(read).getBytes());
            out.write(10);
            out.write(buffer, 0, read);
            out.write(10);
        }
        out.write(48);
        out.write(10);
    }

    private String objectToJsonString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        return BASE64_PREFIX + Base64.encodeBase64String((byte[])JavaSerializableUtils.objectToBytes((Object)value));
    }
}

