/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.tools;

import com.beust.jcommander.Parameter;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONObject;
import org.vertexium.Authorizations;
import org.vertexium.Edge;
import org.vertexium.EdgeBuilder;
import org.vertexium.Element;
import org.vertexium.ElementBuilder;
import org.vertexium.Graph;
import org.vertexium.Metadata;
import org.vertexium.Vertex;
import org.vertexium.VertexBuilder;
import org.vertexium.Visibility;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.tools.GraphToolBase;
import org.vertexium.util.JavaSerializableUtils;

public class GraphRestore
extends GraphToolBase {
    @Parameter(names={"--in", "-i"}, description="Input filename")
    private String inputFileName = null;

    public static void main(String[] args) throws Exception {
        GraphRestore graphRestore = new GraphRestore();
        graphRestore.run(args);
    }

    @Override
    protected void run(String[] args) throws Exception {
        super.run(args);
        try (InputStream in = this.createInputStream();){
            this.restore(this.getGraph(), in, this.getAuthorizations());
        }
    }

    private InputStream createInputStream() throws FileNotFoundException {
        if (this.inputFileName == null) {
            return System.in;
        }
        return new FileInputStream(this.inputFileName);
    }

    public void restore(Graph graph, InputStream in, Authorizations authorizations) throws IOException {
        String line;
        char lastType = 'V';
        Vertex element = null;
        while ((line = this.readLine(in)) != null) {
            try {
                char type = line.charAt(0);
                JSONObject json = new JSONObject(line.substring(1));
                switch (type) {
                    case 'V': {
                        element = this.restoreVertex(graph, json, authorizations);
                        break;
                    }
                    case 'E': {
                        if (type != lastType) {
                            graph.flush();
                        }
                        element = this.restoreEdge(graph, json, authorizations);
                        break;
                    }
                    case 'D': {
                        this.restoreStreamingPropertyValue(in, graph, json, (Element)element, authorizations);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected line: " + line);
                    }
                }
                lastType = type;
            }
            catch (Exception ex) {
                throw new IOException("Invalid line: " + line, ex);
            }
        }
    }

    private String readLine(InputStream in) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        while (true) {
            int b;
            if ((b = in.read()) < 0) {
                if (buffer.size() != 0) break;
                return null;
            }
            if (b == 10) break;
            buffer.write(b);
        }
        return new String(buffer.toByteArray());
    }

    private Vertex restoreVertex(Graph graph, JSONObject json, Authorizations authorizations) {
        Visibility visibility = this.jsonToVisibility(json);
        String vertexId = json.getString("id");
        VertexBuilder v = graph.prepareVertex(vertexId, visibility);
        this.jsonToProperties(json, (ElementBuilder)v);
        return v.save(authorizations);
    }

    private Edge restoreEdge(Graph graph, JSONObject json, Authorizations authorizations) {
        Visibility visibility = this.jsonToVisibility(json);
        String edgeId = json.getString("id");
        String outVertexId = json.getString("outVertexId");
        String inVertexId = json.getString("inVertexId");
        String label = json.getString("label");
        Vertex outVertex = graph.getVertex(outVertexId, authorizations);
        Vertex inVertex = graph.getVertex(inVertexId, authorizations);
        EdgeBuilder e = graph.prepareEdge(edgeId, outVertex, inVertex, label, visibility);
        this.jsonToProperties(json, (ElementBuilder)e);
        return e.save(authorizations);
    }

    protected Visibility jsonToVisibility(JSONObject jsonObject) {
        return new Visibility(jsonObject.getString("visibility"));
    }

    protected void jsonToProperties(JSONObject jsonObject, ElementBuilder e) {
        JSONArray propertiesJson = jsonObject.getJSONArray("properties");
        for (int i = 0; i < propertiesJson.length(); ++i) {
            JSONObject propertyJson = propertiesJson.getJSONObject(i);
            this.jsonToProperty(propertyJson, e);
        }
    }

    private void jsonToProperty(JSONObject propertyJson, ElementBuilder e) {
        String key = propertyJson.getString("key");
        String name = propertyJson.getString("name");
        Object value = this.jsonStringToObject(propertyJson.getString("value"));
        Metadata metadata = this.jsonToPropertyMetadata(propertyJson.optJSONObject("metadata"));
        Visibility visibility = new Visibility(propertyJson.getString("visibility"));
        e.addPropertyValue(key, name, value, metadata, visibility);
    }

    private void restoreStreamingPropertyValue(InputStream in, Graph graph, JSONObject propertyJson, Element element, Authorizations authorizations) throws ClassNotFoundException, IOException {
        String key = propertyJson.getString("key");
        String name = propertyJson.getString("name");
        Metadata metadata = this.jsonToPropertyMetadata(propertyJson.optJSONObject("metadata"));
        Visibility visibility = new Visibility(propertyJson.getString("visibility"));
        Class<?> valueType = Class.forName(propertyJson.getString("valueType"));
        StreamingPropertyValueInputStream spvin = new StreamingPropertyValueInputStream(in);
        StreamingPropertyValue value = new StreamingPropertyValue((InputStream)spvin, valueType);
        value.searchIndex(propertyJson.optBoolean("searchIndex", false));
        value.store(propertyJson.optBoolean("store", true));
        element.addPropertyValue(key, name, (Object)value, metadata, visibility, authorizations);
    }

    private Metadata jsonToPropertyMetadata(JSONObject metadataJson) {
        Metadata metadata = new Metadata();
        if (metadataJson == null) {
            return metadata;
        }
        for (Object key : metadataJson.keySet()) {
            String keyString = (String)key;
            JSONObject metadataItemJson = metadataJson.getJSONObject(keyString);
            Object val = this.jsonStringToObject(metadataItemJson.getString("value"));
            Visibility visibility = new Visibility(metadataItemJson.getString("visibility"));
            metadata.add(keyString, val, visibility);
        }
        return metadata;
    }

    private Object jsonStringToObject(String str) {
        if (str.startsWith("base64/java:")) {
            str = str.substring("base64/java:".length());
            return JavaSerializableUtils.bytesToObject((byte[])Base64.decodeBase64((String)str));
        }
        return str;
    }

    private class StreamingPropertyValueInputStream
    extends InputStream {
        private final InputStream in;
        private int segmentLength;
        private boolean done;

        public StreamingPropertyValueInputStream(InputStream in) throws IOException {
            this.in = in;
            this.readSegmentLengthLine();
        }

        private void readSegmentLengthLine() throws IOException {
            String line = GraphRestore.this.readLine(this.in);
            this.segmentLength = Integer.parseInt(line);
            if (this.segmentLength == 0) {
                this.done = true;
            }
        }

        @Override
        public int read() throws IOException {
            if (this.done) {
                return -1;
            }
            if (this.segmentLength == 0) {
                this.in.read();
                this.readSegmentLengthLine();
                if (this.done) {
                    return -1;
                }
            }
            int ret = this.in.read();
            --this.segmentLength;
            return ret;
        }
    }
}

