/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.tools;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.FileInputStream;
import java.util.Map;
import java.util.Properties;
import org.vertexium.Authorizations;
import org.vertexium.Graph;
import org.vertexium.GraphFactory;
import org.vertexium.accumulo.AccumuloAuthorizations;
import org.vertexium.util.MapUtils;

@Parameters(separators="=")
public abstract class GraphToolBase {
    @Parameter(names={"-c", "--config"}, description="Configuration file name")
    private String configFileName = null;
    @Parameter(names={"--configPrefix"}, description="Prefix of graph related configuration parameters")
    private String configPrefix = null;
    @Parameter(names={"-a", "--auth"}, description="Comma separated string of Authorizations")
    private String authString = "";
    private Graph graph;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(String[] args) throws Exception {
        new JCommander((Object)this, args);
        if (this.configFileName == null) {
            throw new RuntimeException("config is required");
        }
        Map<Object, Object> config = new Properties();
        try (FileInputStream in = new FileInputStream(this.configFileName);){
            config.load(in);
        }
        if (this.configPrefix != null) {
            config = MapUtils.getAllWithPrefix((Map)config, (String)this.configPrefix);
        }
        this.graph = new GraphFactory().createGraph((Map)config);
    }

    protected Authorizations getAuthorizations() {
        String[] split = this.authString.split(",");
        if (split.length == 1 && split[0].length() == 0) {
            split = new String[]{};
        }
        return new AccumuloAuthorizations(split);
    }

    protected Graph getGraph() {
        return this.graph;
    }
}

