/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.integration;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.classic.Session;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hsqldb.cmdline.SqlToolError;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.vibur.dbcp.ViburDBCPDataSource;
import org.vibur.dbcp.cache.StatementHolder;
import org.vibur.dbcp.cache.StatementMethod;
import org.vibur.dbcp.integration.ViburDBCPConnectionProvider;
import org.vibur.dbcp.model.Actor;
import org.vibur.dbcp.util.HibernateTestUtils;
import org.vibur.dbcp.util.HsqldbUtils;
import org.vibur.dbcp.util.StatementCacheUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class ViburDBCPConnectionProviderTest {
    @Captor
    private ArgumentCaptor<StatementMethod> key1;
    @Captor
    private ArgumentCaptor<StatementMethod> key2;
    @Captor
    private ArgumentCaptor<StatementHolder> val1;

    @BeforeClass
    public static void deployDatabaseSchemaAndData() throws IOException, SqlToolError, SQLException {
        Properties properties = ((SessionFactoryImplementor)HibernateTestUtils.getSessionFactoryWithStmtCache()).getProperties();
        HsqldbUtils.deployDatabaseSchemaAndData((String)properties.getProperty("hibernate.connection.url"), (String)properties.getProperty("hibernate.connection.username"), (String)properties.getProperty("hibernate.connection.password"));
    }

    @Test
    public void testSelectStatementNoStatementsCache() throws SQLException {
        Session session = HibernateTestUtils.getSessionFactoryWithoutStmtCache().getCurrentSession();
        try {
            this.executeAndVerifySelect((org.hibernate.Session)session);
        }
        catch (RuntimeException e) {
            session.getTransaction().rollback();
            throw e;
        }
    }

    @Test
    public void testSelectStatementWithStatementsCache() throws SQLException {
        Session session = HibernateTestUtils.getSessionFactoryWithStmtCache().openSession();
        ConnectionProvider cp = ((SessionFactoryImplementor)session.getSessionFactory()).getConnectionProvider();
        ViburDBCPDataSource ds = ((ViburDBCPConnectionProvider)cp).getDataSource();
        ConcurrentMap mockedStatementCache = StatementCacheUtils.mockStatementCache((ViburDBCPDataSource)ds);
        this.executeAndVerifySelectInSession((org.hibernate.Session)session);
        session = HibernateTestUtils.getSessionFactoryWithStmtCache().openSession();
        this.executeAndVerifySelectInSession((org.hibernate.Session)session);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockedStatementCache});
        ((ConcurrentMap)inOrder.verify((Object)mockedStatementCache)).get(this.key1.capture());
        ((ConcurrentMap)inOrder.verify((Object)mockedStatementCache)).putIfAbsent(Matchers.same((Object)this.key1.getValue()), this.val1.capture());
        ((ConcurrentMap)inOrder.verify((Object)mockedStatementCache)).get(this.key2.capture());
        Assert.assertEquals((long)1L, (long)mockedStatementCache.size());
        Assert.assertTrue((boolean)mockedStatementCache.containsKey(this.key1.getValue()));
        Assert.assertEquals((Object)this.key1.getValue(), (Object)this.key2.getValue());
        Assert.assertEquals((Object)StatementHolder.State.AVAILABLE, ((StatementHolder)this.val1.getValue()).state().get());
    }

    private void executeAndVerifySelectInSession(org.hibernate.Session session) {
        try {
            this.executeAndVerifySelect(session);
        }
        catch (RuntimeException e) {
            session.getTransaction().rollback();
            throw e;
        }
        finally {
            session.close();
        }
    }

    private void executeAndVerifySelect(org.hibernate.Session session) {
        session.beginTransaction();
        List list = session.createQuery("from Actor where firstName = ?").setParameter(0, (Object)"CHRISTIAN").list();
        session.getTransaction().commit();
        HashSet<String> expectedLastNames = new HashSet<String>(Arrays.asList("GABLE", "AKROYD", "NEESON"));
        Assert.assertEquals((long)expectedLastNames.size(), (long)list.size());
        for (Actor actor : list) {
            Assert.assertTrue((boolean)expectedLastNames.remove(actor.getLastName()));
        }
    }
}

