/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.util;

import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.vibur.dbcp.model.Actor;

public class HibernateTestUtils {
    private static SessionFactory sessionFactoryNoStmtCache = HibernateTestUtils.buildStatementFactory("hibernate-no-stmt-cache.cfg.xml");
    private static SessionFactory sessionFactoryWithStmtCache = HibernateTestUtils.buildStatementFactory("hibernate-with-stmt-cache.cfg.xml");

    private static SessionFactory buildStatementFactory(String configFileName) {
        try {
            Configuration cfg = new Configuration().configure(configFileName);
            cfg.addAnnotatedClass(Actor.class);
            return cfg.buildSessionFactory();
        }
        catch (HibernateException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static SessionFactory getSessionFactoryWithoutStmtCache() {
        return sessionFactoryNoStmtCache;
    }

    public static SessionFactory getSessionFactoryWithStmtCache() {
        return sessionFactoryWithStmtCache;
    }
}

