/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.integration;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.connection.ConnectionProvider;
import org.vibur.dbcp.ViburDBCPDataSource;

public class ViburDBCPConnectionProvider
implements ConnectionProvider {
    private static final String VIBUR_PREFIX = "hibernate.vibur.";
    private ViburDBCPDataSource dataSource = null;

    public void configure(Properties props) throws HibernateException {
        this.dataSource = new ViburDBCPDataSource(this.transform(props));
        this.dataSource.start();
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public void close() throws HibernateException {
        if (this.dataSource != null) {
            this.dataSource.terminate();
            this.dataSource = null;
        }
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    private Properties transform(Properties props) {
        String defaultAutoCommit;
        String defaultTransactionIsolationValue;
        String password;
        String username;
        String jdbcUrl;
        Properties result = new Properties();
        String driverClassName = props.getProperty("hibernate.connection.driver_class");
        if (driverClassName != null) {
            result.setProperty("driverClassName", driverClassName);
        }
        if ((jdbcUrl = props.getProperty("hibernate.connection.url")) != null) {
            result.setProperty("jdbcUrl", jdbcUrl);
        }
        if ((username = props.getProperty("hibernate.connection.username")) != null) {
            result.setProperty("username", username);
        }
        if ((password = props.getProperty("hibernate.connection.password")) != null) {
            result.setProperty("password", password);
        }
        if ((defaultTransactionIsolationValue = props.getProperty("hibernate.connection.isolation")) != null) {
            result.setProperty("defaultTransactionIsolationValue", defaultTransactionIsolationValue);
        }
        if ((defaultAutoCommit = props.getProperty("hibernate.connection.autocommit")) != null) {
            result.setProperty("defaultAutoCommit", defaultAutoCommit);
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith(VIBUR_PREFIX)) continue;
            key = key.substring(VIBUR_PREFIX.length());
            result.setProperty(key, value);
        }
        return result;
    }

    public ViburDBCPDataSource getDataSource() {
        return this.dataSource;
    }
}

