@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.accessanalyzer.kotlin

import com.pulumi.aws.accessanalyzer.kotlin.outputs.ArchiveRuleFilter
import com.pulumi.aws.accessanalyzer.kotlin.outputs.ArchiveRuleFilter.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ArchiveRule].
 */
@PulumiTagMarker
public class ArchiveRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ArchiveRuleArgs = ArchiveRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ArchiveRuleArgsBuilder.() -> Unit) {
        val builder = ArchiveRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ArchiveRule {
        val builtJavaResource = com.pulumi.aws.accessanalyzer.ArchiveRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ArchiveRule(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS AccessAnalyzer Archive Rule.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.accessanalyzer.ArchiveRule;
 * import com.pulumi.aws.accessanalyzer.ArchiveRuleArgs;
 * import com.pulumi.aws.accessanalyzer.inputs.ArchiveRuleFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ArchiveRule("example", ArchiveRuleArgs.builder()
 *             .analyzerName("example-analyzer")
 *             .filters(
 *                 ArchiveRuleFilterArgs.builder()
 *                     .criteria("condition.aws:UserId")
 *                     .eqs("userid")
 *                     .build(),
 *                 ArchiveRuleFilterArgs.builder()
 *                     .criteria("error")
 *                     .exists(true)
 *                     .build(),
 *                 ArchiveRuleFilterArgs.builder()
 *                     .criteria("isPublic")
 *                     .eqs("false")
 *                     .build())
 *             .ruleName("example-rule")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AccessAnalyzer ArchiveRule using the `analyzer_name/rule_name`. For example:
 * ```sh
 *  $ pulumi import aws:accessanalyzer/archiveRule:ArchiveRule example example-analyzer/example-rule
 * ```
 *
 */
public class ArchiveRule internal constructor(
    override val javaResource: com.pulumi.aws.accessanalyzer.ArchiveRule,
) : KotlinCustomResource(javaResource, ArchiveRuleMapper) {
    /**
     * Analyzer name.
     */
    public val analyzerName: Output<String>
        get() = javaResource.analyzerName().applyValue({ args0 -> args0 })

    /**
     * Filter criteria for the archive rule. See Filter for more details.
     */
    public val filters: Output<List<ArchiveRuleFilter>>
        get() = javaResource.filters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * Rule name.
     */
    public val ruleName: Output<String>
        get() = javaResource.ruleName().applyValue({ args0 -> args0 })
}

public object ArchiveRuleMapper : ResourceMapper<ArchiveRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.accessanalyzer.ArchiveRule::class == javaResource::class

    override fun map(javaResource: Resource): ArchiveRule = ArchiveRule(
        javaResource as
            com.pulumi.aws.accessanalyzer.ArchiveRule,
    )
}

/**
 * @see [ArchiveRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ArchiveRule].
 */
public suspend fun archiveRule(name: String, block: suspend ArchiveRuleResourceBuilder.() -> Unit):
    ArchiveRule {
    val builder = ArchiveRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ArchiveRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun archiveRule(name: String): ArchiveRule {
    val builder = ArchiveRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
