@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.accessanalyzer.kotlin

import com.pulumi.aws.accessanalyzer.ArchiveRuleArgs.builder
import com.pulumi.aws.accessanalyzer.kotlin.inputs.ArchiveRuleFilterArgs
import com.pulumi.aws.accessanalyzer.kotlin.inputs.ArchiveRuleFilterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS AccessAnalyzer Archive Rule.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.accessanalyzer.ArchiveRule;
 * import com.pulumi.aws.accessanalyzer.ArchiveRuleArgs;
 * import com.pulumi.aws.accessanalyzer.inputs.ArchiveRuleFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ArchiveRule("example", ArchiveRuleArgs.builder()
 *             .analyzerName("example-analyzer")
 *             .filters(
 *                 ArchiveRuleFilterArgs.builder()
 *                     .criteria("condition.aws:UserId")
 *                     .eqs("userid")
 *                     .build(),
 *                 ArchiveRuleFilterArgs.builder()
 *                     .criteria("error")
 *                     .exists(true)
 *                     .build(),
 *                 ArchiveRuleFilterArgs.builder()
 *                     .criteria("isPublic")
 *                     .eqs("false")
 *                     .build())
 *             .ruleName("example-rule")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AccessAnalyzer ArchiveRule using the `analyzer_name/rule_name`. For example:
 * ```sh
 *  $ pulumi import aws:accessanalyzer/archiveRule:ArchiveRule example example-analyzer/example-rule
 * ```
 * @property analyzerName Analyzer name.
 * @property filters Filter criteria for the archive rule. See Filter for more details.
 * @property ruleName Rule name.
 */
public data class ArchiveRuleArgs(
    public val analyzerName: Output<String>? = null,
    public val filters: Output<List<ArchiveRuleFilterArgs>>? = null,
    public val ruleName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.accessanalyzer.ArchiveRuleArgs> {
    override fun toJava(): com.pulumi.aws.accessanalyzer.ArchiveRuleArgs =
        com.pulumi.aws.accessanalyzer.ArchiveRuleArgs.builder()
            .analyzerName(analyzerName?.applyValue({ args0 -> args0 }))
            .filters(
                filters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ruleName(ruleName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ArchiveRuleArgs].
 */
@PulumiTagMarker
public class ArchiveRuleArgsBuilder internal constructor() {
    private var analyzerName: Output<String>? = null

    private var filters: Output<List<ArchiveRuleFilterArgs>>? = null

    private var ruleName: Output<String>? = null

    /**
     * @param value Analyzer name.
     */
    @JvmName("xsqiilxjxhcgasrg")
    public suspend fun analyzerName(`value`: Output<String>) {
        this.analyzerName = value
    }

    /**
     * @param value Filter criteria for the archive rule. See Filter for more details.
     */
    @JvmName("ferdsnrfyvnkklir")
    public suspend fun filters(`value`: Output<List<ArchiveRuleFilterArgs>>) {
        this.filters = value
    }

    @JvmName("tanhspjsawyxydgd")
    public suspend fun filters(vararg values: Output<ArchiveRuleFilterArgs>) {
        this.filters = Output.all(values.asList())
    }

    /**
     * @param values Filter criteria for the archive rule. See Filter for more details.
     */
    @JvmName("fjbpfvkdpbucxeef")
    public suspend fun filters(values: List<Output<ArchiveRuleFilterArgs>>) {
        this.filters = Output.all(values)
    }

    /**
     * @param value Rule name.
     */
    @JvmName("wmswbjveojkcmapt")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value Analyzer name.
     */
    @JvmName("rvvsgdclwpnrmufu")
    public suspend fun analyzerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.analyzerName = mapped
    }

    /**
     * @param value Filter criteria for the archive rule. See Filter for more details.
     */
    @JvmName("ncnksmuxedusagsn")
    public suspend fun filters(`value`: List<ArchiveRuleFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param argument Filter criteria for the archive rule. See Filter for more details.
     */
    @JvmName("cpuxkcxpbedondwj")
    public suspend fun filters(argument: List<suspend ArchiveRuleFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ArchiveRuleFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param argument Filter criteria for the archive rule. See Filter for more details.
     */
    @JvmName("mnacvbjsquubweme")
    public suspend fun filters(vararg argument: suspend ArchiveRuleFilterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ArchiveRuleFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param argument Filter criteria for the archive rule. See Filter for more details.
     */
    @JvmName("qqxytxyqisjsltqb")
    public suspend fun filters(argument: suspend ArchiveRuleFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ArchiveRuleFilterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param values Filter criteria for the archive rule. See Filter for more details.
     */
    @JvmName("lmtpofqnamvjglld")
    public suspend fun filters(vararg values: ArchiveRuleFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param value Rule name.
     */
    @JvmName("ifviauxmkfpuusfi")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    internal fun build(): ArchiveRuleArgs = ArchiveRuleArgs(
        analyzerName = analyzerName,
        filters = filters,
        ruleName = ruleName,
    )
}
