@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.accessanalyzer.kotlin.inputs

import com.pulumi.aws.accessanalyzer.inputs.ArchiveRuleFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property contains Contains comparator.
 * @property criteria Filter criteria.
 * @property eqs Equals comparator.
 * @property exists Boolean comparator.
 * @property neqs Not Equals comparator.
 */
public data class ArchiveRuleFilterArgs(
    public val contains: Output<List<String>>? = null,
    public val criteria: Output<String>,
    public val eqs: Output<List<String>>? = null,
    public val exists: Output<String>? = null,
    public val neqs: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.accessanalyzer.inputs.ArchiveRuleFilterArgs> {
    override fun toJava(): com.pulumi.aws.accessanalyzer.inputs.ArchiveRuleFilterArgs =
        com.pulumi.aws.accessanalyzer.inputs.ArchiveRuleFilterArgs.builder()
            .contains(contains?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .criteria(criteria.applyValue({ args0 -> args0 }))
            .eqs(eqs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .exists(exists?.applyValue({ args0 -> args0 }))
            .neqs(neqs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ArchiveRuleFilterArgs].
 */
@PulumiTagMarker
public class ArchiveRuleFilterArgsBuilder internal constructor() {
    private var contains: Output<List<String>>? = null

    private var criteria: Output<String>? = null

    private var eqs: Output<List<String>>? = null

    private var exists: Output<String>? = null

    private var neqs: Output<List<String>>? = null

    /**
     * @param value Contains comparator.
     */
    @JvmName("syfouwccrnxowxqm")
    public suspend fun contains(`value`: Output<List<String>>) {
        this.contains = value
    }

    @JvmName("vlgdgwwqxfiudvij")
    public suspend fun contains(vararg values: Output<String>) {
        this.contains = Output.all(values.asList())
    }

    /**
     * @param values Contains comparator.
     */
    @JvmName("bqanqnrwunovcqqs")
    public suspend fun contains(values: List<Output<String>>) {
        this.contains = Output.all(values)
    }

    /**
     * @param value Filter criteria.
     */
    @JvmName("njfbcfkhqsmkjnlh")
    public suspend fun criteria(`value`: Output<String>) {
        this.criteria = value
    }

    /**
     * @param value Equals comparator.
     */
    @JvmName("gsmvcgjjxnpbocfa")
    public suspend fun eqs(`value`: Output<List<String>>) {
        this.eqs = value
    }

    @JvmName("pirqwavqjkscjmdm")
    public suspend fun eqs(vararg values: Output<String>) {
        this.eqs = Output.all(values.asList())
    }

    /**
     * @param values Equals comparator.
     */
    @JvmName("tpifsadjpfdpdpou")
    public suspend fun eqs(values: List<Output<String>>) {
        this.eqs = Output.all(values)
    }

    /**
     * @param value Boolean comparator.
     */
    @JvmName("utwmwrkkeqwugqyu")
    public suspend fun exists(`value`: Output<String>) {
        this.exists = value
    }

    /**
     * @param value Not Equals comparator.
     */
    @JvmName("mlrurgjwttwdiriw")
    public suspend fun neqs(`value`: Output<List<String>>) {
        this.neqs = value
    }

    @JvmName("hypdtfqkwahikuat")
    public suspend fun neqs(vararg values: Output<String>) {
        this.neqs = Output.all(values.asList())
    }

    /**
     * @param values Not Equals comparator.
     */
    @JvmName("arqtsdcpfeekgwck")
    public suspend fun neqs(values: List<Output<String>>) {
        this.neqs = Output.all(values)
    }

    /**
     * @param value Contains comparator.
     */
    @JvmName("jvpdxyhgyteoiaqt")
    public suspend fun contains(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contains = mapped
    }

    /**
     * @param values Contains comparator.
     */
    @JvmName("orjtoimbrayrnuer")
    public suspend fun contains(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contains = mapped
    }

    /**
     * @param value Filter criteria.
     */
    @JvmName("mmokqhhfpvhcfygn")
    public suspend fun criteria(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.criteria = mapped
    }

    /**
     * @param value Equals comparator.
     */
    @JvmName("clgehholfxtflcbv")
    public suspend fun eqs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eqs = mapped
    }

    /**
     * @param values Equals comparator.
     */
    @JvmName("sbkbsctqneaumosg")
    public suspend fun eqs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eqs = mapped
    }

    /**
     * @param value Boolean comparator.
     */
    @JvmName("ibgbrkrcncycknbe")
    public suspend fun exists(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exists = mapped
    }

    /**
     * @param value Not Equals comparator.
     */
    @JvmName("yflwtbbfxcdqicxo")
    public suspend fun neqs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.neqs = mapped
    }

    /**
     * @param values Not Equals comparator.
     */
    @JvmName("yaagbuqbelusgcnv")
    public suspend fun neqs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.neqs = mapped
    }

    internal fun build(): ArchiveRuleFilterArgs = ArchiveRuleFilterArgs(
        contains = contains,
        criteria = criteria ?: throw PulumiNullFieldException("criteria"),
        eqs = eqs,
        exists = exists,
        neqs = neqs,
    )
}
