@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.account.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AlternativeContact].
 */
@PulumiTagMarker
public class AlternativeContactResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AlternativeContactArgs = AlternativeContactArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AlternativeContactArgsBuilder.() -> Unit) {
        val builder = AlternativeContactArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AlternativeContact {
        val builtJavaResource = com.pulumi.aws.account.AlternativeContact(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AlternativeContact(builtJavaResource)
    }
}

/**
 * Manages the specified alternate contact attached to an AWS Account.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.account.AlternativeContact;
 * import com.pulumi.aws.account.AlternativeContactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var operations = new AlternativeContact("operations", AlternativeContactArgs.builder()
 *             .alternateContactType("OPERATIONS")
 *             .emailAddress("test@example.com")
 *             .phoneNumber("+1234567890")
 *             .title("Example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Import the Alternate Contact for another account using the `account_id` and `alternate_contact_type` separated by a forward slash (`/`):
 * __Using `pulumi import` to import__ the Alternate Contact for the current or another account using the `alternate_contact_type`. For example:
 * Import the Alternate Contact for the current account:
 * ```sh
 *  $ pulumi import aws:account/alternativeContact:AlternativeContact operations OPERATIONS
 * ```
 *  Import the Alternate Contact for another account using the `account_id` and `alternate_contact_type` separated by a forward slash (`/`):
 * ```sh
 *  $ pulumi import aws:account/alternativeContact:AlternativeContact operations 1234567890/OPERATIONS
 * ```
 *
 */
public class AlternativeContact internal constructor(
    override val javaResource: com.pulumi.aws.account.AlternativeContact,
) : KotlinCustomResource(javaResource, AlternativeContactMapper) {
    /**
     * ID of the target account when managing member accounts. Will manage current user's account by default if omitted.
     */
    public val accountId: Output<String>?
        get() = javaResource.accountId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Type of the alternate contact. Allowed values are: `BILLING`, `OPERATIONS`, `SECURITY`.
     */
    public val alternateContactType: Output<String>
        get() = javaResource.alternateContactType().applyValue({ args0 -> args0 })

    /**
     * An email address for the alternate contact.
     */
    public val emailAddress: Output<String>
        get() = javaResource.emailAddress().applyValue({ args0 -> args0 })

    /**
     * Name of the alternate contact.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Phone number for the alternate contact.
     */
    public val phoneNumber: Output<String>
        get() = javaResource.phoneNumber().applyValue({ args0 -> args0 })

    /**
     * Title for the alternate contact.
     */
    public val title: Output<String>
        get() = javaResource.title().applyValue({ args0 -> args0 })
}

public object AlternativeContactMapper : ResourceMapper<AlternativeContact> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.account.AlternativeContact::class == javaResource::class

    override fun map(javaResource: Resource): AlternativeContact = AlternativeContact(
        javaResource as
            com.pulumi.aws.account.AlternativeContact,
    )
}

/**
 * @see [AlternativeContact].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AlternativeContact].
 */
public suspend fun alternativeContact(
    name: String,
    block: suspend AlternativeContactResourceBuilder.() -> Unit,
): AlternativeContact {
    val builder = AlternativeContactResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AlternativeContact].
 * @param name The _unique_ name of the resulting resource.
 */
public fun alternativeContact(name: String): AlternativeContact {
    val builder = AlternativeContactResourceBuilder()
    builder.name(name)
    return builder.build()
}
