@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.account.kotlin

import com.pulumi.aws.account.AlternativeContactArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages the specified alternate contact attached to an AWS Account.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.account.AlternativeContact;
 * import com.pulumi.aws.account.AlternativeContactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var operations = new AlternativeContact("operations", AlternativeContactArgs.builder()
 *             .alternateContactType("OPERATIONS")
 *             .emailAddress("test@example.com")
 *             .phoneNumber("+1234567890")
 *             .title("Example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Import the Alternate Contact for another account using the `account_id` and `alternate_contact_type` separated by a forward slash (`/`):
 * __Using `pulumi import` to import__ the Alternate Contact for the current or another account using the `alternate_contact_type`. For example:
 * Import the Alternate Contact for the current account:
 * ```sh
 *  $ pulumi import aws:account/alternativeContact:AlternativeContact operations OPERATIONS
 * ```
 *  Import the Alternate Contact for another account using the `account_id` and `alternate_contact_type` separated by a forward slash (`/`):
 * ```sh
 *  $ pulumi import aws:account/alternativeContact:AlternativeContact operations 1234567890/OPERATIONS
 * ```
 * @property accountId ID of the target account when managing member accounts. Will manage current user's account by default if omitted.
 * @property alternateContactType Type of the alternate contact. Allowed values are: `BILLING`, `OPERATIONS`, `SECURITY`.
 * @property emailAddress An email address for the alternate contact.
 * @property name Name of the alternate contact.
 * @property phoneNumber Phone number for the alternate contact.
 * @property title Title for the alternate contact.
 */
public data class AlternativeContactArgs(
    public val accountId: Output<String>? = null,
    public val alternateContactType: Output<String>? = null,
    public val emailAddress: Output<String>? = null,
    public val name: Output<String>? = null,
    public val phoneNumber: Output<String>? = null,
    public val title: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.account.AlternativeContactArgs> {
    override fun toJava(): com.pulumi.aws.account.AlternativeContactArgs =
        com.pulumi.aws.account.AlternativeContactArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .alternateContactType(alternateContactType?.applyValue({ args0 -> args0 }))
            .emailAddress(emailAddress?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .phoneNumber(phoneNumber?.applyValue({ args0 -> args0 }))
            .title(title?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlternativeContactArgs].
 */
@PulumiTagMarker
public class AlternativeContactArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var alternateContactType: Output<String>? = null

    private var emailAddress: Output<String>? = null

    private var name: Output<String>? = null

    private var phoneNumber: Output<String>? = null

    private var title: Output<String>? = null

    /**
     * @param value ID of the target account when managing member accounts. Will manage current user's account by default if omitted.
     */
    @JvmName("vgqkbfibyvotkmbk")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value Type of the alternate contact. Allowed values are: `BILLING`, `OPERATIONS`, `SECURITY`.
     */
    @JvmName("fwklocsfahemyyjk")
    public suspend fun alternateContactType(`value`: Output<String>) {
        this.alternateContactType = value
    }

    /**
     * @param value An email address for the alternate contact.
     */
    @JvmName("ahkvlxesgrerihpf")
    public suspend fun emailAddress(`value`: Output<String>) {
        this.emailAddress = value
    }

    /**
     * @param value Name of the alternate contact.
     */
    @JvmName("dylcbmuudfrpefuq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Phone number for the alternate contact.
     */
    @JvmName("nnrjhwkwrvepoche")
    public suspend fun phoneNumber(`value`: Output<String>) {
        this.phoneNumber = value
    }

    /**
     * @param value Title for the alternate contact.
     */
    @JvmName("vicdvdxmuydwswsw")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value ID of the target account when managing member accounts. Will manage current user's account by default if omitted.
     */
    @JvmName("ldtrmgbuprgadwdg")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value Type of the alternate contact. Allowed values are: `BILLING`, `OPERATIONS`, `SECURITY`.
     */
    @JvmName("khnrwlepdwdyvnnl")
    public suspend fun alternateContactType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alternateContactType = mapped
    }

    /**
     * @param value An email address for the alternate contact.
     */
    @JvmName("kakcnmlbfmjiyodk")
    public suspend fun emailAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailAddress = mapped
    }

    /**
     * @param value Name of the alternate contact.
     */
    @JvmName("mvqroexptfkduwhr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Phone number for the alternate contact.
     */
    @JvmName("ytyutjqpifvsqxwm")
    public suspend fun phoneNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phoneNumber = mapped
    }

    /**
     * @param value Title for the alternate contact.
     */
    @JvmName("frcfpoaayvuvqjjd")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    internal fun build(): AlternativeContactArgs = AlternativeContactArgs(
        accountId = accountId,
        alternateContactType = alternateContactType,
        emailAddress = emailAddress,
        name = name,
        phoneNumber = phoneNumber,
        title = title,
    )
}
