@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.account.kotlin

import com.pulumi.aws.account.PrimaryContactArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages the specified primary contact information associated with an AWS Account.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.account.PrimaryContact;
 * import com.pulumi.aws.account.PrimaryContactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new PrimaryContact("test", PrimaryContactArgs.builder()
 *             .addressLine1("123 Any Street")
 *             .city("Seattle")
 *             .companyName("Example Corp, Inc.")
 *             .countryCode("US")
 *             .districtOrCounty("King")
 *             .fullName("My Name")
 *             .phoneNumber("+64211111111")
 *             .postalCode("98101")
 *             .stateOrRegion("WA")
 *             .websiteUrl("https://www.examplecorp.com")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import the Primary Contact using the `account_id`. For example:
 * ```sh
 *  $ pulumi import aws:account/primaryContact:PrimaryContact test 1234567890
 * ```
 * @property accountId The ID of the target account when managing member accounts. Will manage current user's account by default if omitted.
 * @property addressLine1 The first line of the primary contact address.
 * @property addressLine2 The second line of the primary contact address, if any.
 * @property addressLine3 The third line of the primary contact address, if any.
 * @property city The city of the primary contact address.
 * @property companyName The name of the company associated with the primary contact information, if any.
 * @property countryCode The ISO-3166 two-letter country code for the primary contact address.
 * @property districtOrCounty The district or county of the primary contact address, if any.
 * @property fullName The full name of the primary contact address.
 * @property phoneNumber The phone number of the primary contact information. The number will be validated and, in some countries, checked for activation.
 * @property postalCode The postal code of the primary contact address.
 * @property stateOrRegion The state or region of the primary contact address. This field is required in selected countries.
 * @property websiteUrl The URL of the website associated with the primary contact information, if any.
 */
public data class PrimaryContactArgs(
    public val accountId: Output<String>? = null,
    public val addressLine1: Output<String>? = null,
    public val addressLine2: Output<String>? = null,
    public val addressLine3: Output<String>? = null,
    public val city: Output<String>? = null,
    public val companyName: Output<String>? = null,
    public val countryCode: Output<String>? = null,
    public val districtOrCounty: Output<String>? = null,
    public val fullName: Output<String>? = null,
    public val phoneNumber: Output<String>? = null,
    public val postalCode: Output<String>? = null,
    public val stateOrRegion: Output<String>? = null,
    public val websiteUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.account.PrimaryContactArgs> {
    override fun toJava(): com.pulumi.aws.account.PrimaryContactArgs =
        com.pulumi.aws.account.PrimaryContactArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .addressLine1(addressLine1?.applyValue({ args0 -> args0 }))
            .addressLine2(addressLine2?.applyValue({ args0 -> args0 }))
            .addressLine3(addressLine3?.applyValue({ args0 -> args0 }))
            .city(city?.applyValue({ args0 -> args0 }))
            .companyName(companyName?.applyValue({ args0 -> args0 }))
            .countryCode(countryCode?.applyValue({ args0 -> args0 }))
            .districtOrCounty(districtOrCounty?.applyValue({ args0 -> args0 }))
            .fullName(fullName?.applyValue({ args0 -> args0 }))
            .phoneNumber(phoneNumber?.applyValue({ args0 -> args0 }))
            .postalCode(postalCode?.applyValue({ args0 -> args0 }))
            .stateOrRegion(stateOrRegion?.applyValue({ args0 -> args0 }))
            .websiteUrl(websiteUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrimaryContactArgs].
 */
@PulumiTagMarker
public class PrimaryContactArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var addressLine1: Output<String>? = null

    private var addressLine2: Output<String>? = null

    private var addressLine3: Output<String>? = null

    private var city: Output<String>? = null

    private var companyName: Output<String>? = null

    private var countryCode: Output<String>? = null

    private var districtOrCounty: Output<String>? = null

    private var fullName: Output<String>? = null

    private var phoneNumber: Output<String>? = null

    private var postalCode: Output<String>? = null

    private var stateOrRegion: Output<String>? = null

    private var websiteUrl: Output<String>? = null

    /**
     * @param value The ID of the target account when managing member accounts. Will manage current user's account by default if omitted.
     */
    @JvmName("wxluqwrrtdphomxx")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value The first line of the primary contact address.
     */
    @JvmName("fmwfbsxcgvapnntn")
    public suspend fun addressLine1(`value`: Output<String>) {
        this.addressLine1 = value
    }

    /**
     * @param value The second line of the primary contact address, if any.
     */
    @JvmName("dotkdqngnycfcfuq")
    public suspend fun addressLine2(`value`: Output<String>) {
        this.addressLine2 = value
    }

    /**
     * @param value The third line of the primary contact address, if any.
     */
    @JvmName("ewbmheqpgpuxwwwu")
    public suspend fun addressLine3(`value`: Output<String>) {
        this.addressLine3 = value
    }

    /**
     * @param value The city of the primary contact address.
     */
    @JvmName("ahskudnuccvgsesk")
    public suspend fun city(`value`: Output<String>) {
        this.city = value
    }

    /**
     * @param value The name of the company associated with the primary contact information, if any.
     */
    @JvmName("prqngsvhekxbqkgs")
    public suspend fun companyName(`value`: Output<String>) {
        this.companyName = value
    }

    /**
     * @param value The ISO-3166 two-letter country code for the primary contact address.
     */
    @JvmName("bhivqomqagtrkcry")
    public suspend fun countryCode(`value`: Output<String>) {
        this.countryCode = value
    }

    /**
     * @param value The district or county of the primary contact address, if any.
     */
    @JvmName("nmvdjjhcncgknwpw")
    public suspend fun districtOrCounty(`value`: Output<String>) {
        this.districtOrCounty = value
    }

    /**
     * @param value The full name of the primary contact address.
     */
    @JvmName("gfiwwcydowqqeolk")
    public suspend fun fullName(`value`: Output<String>) {
        this.fullName = value
    }

    /**
     * @param value The phone number of the primary contact information. The number will be validated and, in some countries, checked for activation.
     */
    @JvmName("erjyblgprvyvtnlo")
    public suspend fun phoneNumber(`value`: Output<String>) {
        this.phoneNumber = value
    }

    /**
     * @param value The postal code of the primary contact address.
     */
    @JvmName("gtnexockwnryawxf")
    public suspend fun postalCode(`value`: Output<String>) {
        this.postalCode = value
    }

    /**
     * @param value The state or region of the primary contact address. This field is required in selected countries.
     */
    @JvmName("ghsesokfwfojpoap")
    public suspend fun stateOrRegion(`value`: Output<String>) {
        this.stateOrRegion = value
    }

    /**
     * @param value The URL of the website associated with the primary contact information, if any.
     */
    @JvmName("ojjpaomtawdfpgpp")
    public suspend fun websiteUrl(`value`: Output<String>) {
        this.websiteUrl = value
    }

    /**
     * @param value The ID of the target account when managing member accounts. Will manage current user's account by default if omitted.
     */
    @JvmName("mjqqtiykqgtsmwbm")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value The first line of the primary contact address.
     */
    @JvmName("etgostwldoudsnaq")
    public suspend fun addressLine1(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressLine1 = mapped
    }

    /**
     * @param value The second line of the primary contact address, if any.
     */
    @JvmName("vdqqmgsjlrodopyd")
    public suspend fun addressLine2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressLine2 = mapped
    }

    /**
     * @param value The third line of the primary contact address, if any.
     */
    @JvmName("gusicdfnojyvdwey")
    public suspend fun addressLine3(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressLine3 = mapped
    }

    /**
     * @param value The city of the primary contact address.
     */
    @JvmName("lpatjofytuwhceiv")
    public suspend fun city(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.city = mapped
    }

    /**
     * @param value The name of the company associated with the primary contact information, if any.
     */
    @JvmName("jaodrkagdtlocqci")
    public suspend fun companyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.companyName = mapped
    }

    /**
     * @param value The ISO-3166 two-letter country code for the primary contact address.
     */
    @JvmName("gphbmoxprhebiwsx")
    public suspend fun countryCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.countryCode = mapped
    }

    /**
     * @param value The district or county of the primary contact address, if any.
     */
    @JvmName("txsabamaktvvrihd")
    public suspend fun districtOrCounty(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.districtOrCounty = mapped
    }

    /**
     * @param value The full name of the primary contact address.
     */
    @JvmName("bdcvqxqweoakegbo")
    public suspend fun fullName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fullName = mapped
    }

    /**
     * @param value The phone number of the primary contact information. The number will be validated and, in some countries, checked for activation.
     */
    @JvmName("ljpgjftnbevjgden")
    public suspend fun phoneNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phoneNumber = mapped
    }

    /**
     * @param value The postal code of the primary contact address.
     */
    @JvmName("yvjklwavljdocmti")
    public suspend fun postalCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postalCode = mapped
    }

    /**
     * @param value The state or region of the primary contact address. This field is required in selected countries.
     */
    @JvmName("scqwuqbybrcmsxnw")
    public suspend fun stateOrRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stateOrRegion = mapped
    }

    /**
     * @param value The URL of the website associated with the primary contact information, if any.
     */
    @JvmName("fnakshfikxfwvecr")
    public suspend fun websiteUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.websiteUrl = mapped
    }

    internal fun build(): PrimaryContactArgs = PrimaryContactArgs(
        accountId = accountId,
        addressLine1 = addressLine1,
        addressLine2 = addressLine2,
        addressLine3 = addressLine3,
        city = city,
        companyName = companyName,
        countryCode = countryCode,
        districtOrCounty = districtOrCounty,
        fullName = fullName,
        phoneNumber = phoneNumber,
        postalCode = postalCode,
        stateOrRegion = stateOrRegion,
        websiteUrl = websiteUrl,
    )
}
