@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acm.kotlin

import com.pulumi.aws.acm.AcmFunctions.getCertificatePlain
import com.pulumi.aws.acm.kotlin.inputs.GetCertificatePlainArgs
import com.pulumi.aws.acm.kotlin.inputs.GetCertificatePlainArgsBuilder
import com.pulumi.aws.acm.kotlin.outputs.GetCertificateResult
import com.pulumi.aws.acm.kotlin.outputs.GetCertificateResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

public object AcmFunctions {
    /**
     * Use this data source to get the ARN of a certificate in AWS Certificate
     * Manager (ACM), you can reference
     * it by domain without having to hard code the ARNs as input.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.acm.AcmFunctions;
     * import com.pulumi.aws.acm.inputs.GetCertificateArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var issued = AcmFunctions.getCertificate(GetCertificateArgs.builder()
     *             .domain("tf.example.com")
     *             .statuses("ISSUED")
     *             .build());
     *         final var amazonIssued = AcmFunctions.getCertificate(GetCertificateArgs.builder()
     *             .domain("tf.example.com")
     *             .mostRecent(true)
     *             .types("AMAZON_ISSUED")
     *             .build());
     *         final var rsa4096 = AcmFunctions.getCertificate(GetCertificateArgs.builder()
     *             .domain("tf.example.com")
     *             .keyTypes("RSA_4096")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getCertificate.
     * @return A collection of values returned by getCertificate.
     */
    public suspend fun getCertificate(argument: GetCertificatePlainArgs): GetCertificateResult =
        toKotlin(getCertificatePlain(argument.toJava()).await())

    /**
     * @see [getCertificate].
     * @param domain Domain of the certificate to look up. If no certificate is found with this name, an error will be returned.
     * @param keyTypes List of key algorithms to filter certificates. By default, ACM does not return all certificate types when searching. See the [ACM API Reference](https://docs.aws.amazon.com/acm/latest/APIReference/API_CertificateDetail.html#ACM-Type-CertificateDetail-KeyAlgorithm) for supported key algorithms.
     * @param mostRecent If set to true, it sorts the certificates matched by previous criteria by the NotBefore field, returning only the most recent one. If set to false, it returns an error if more than one certificate is found. Defaults to false.
     * @param statuses List of statuses on which to filter the returned list. Valid values are `PENDING_VALIDATION`, `ISSUED`,
     * `INACTIVE`, `EXPIRED`, `VALIDATION_TIMED_OUT`, `REVOKED` and `FAILED`. If no value is specified, only certificates in the `ISSUED` state
     * are returned.
     * @param tags Mapping of tags for the resource.
     * @param types List of types on which to filter the returned list. Valid values are `AMAZON_ISSUED`, `PRIVATE`, and `IMPORTED`.
     * @return A collection of values returned by getCertificate.
     */
    public suspend fun getCertificate(
        domain: String,
        keyTypes: List<String>? = null,
        mostRecent: Boolean? = null,
        statuses: List<String>? = null,
        tags: Map<String, String>? = null,
        types: List<String>? = null,
    ): GetCertificateResult {
        val argument = GetCertificatePlainArgs(
            domain = domain,
            keyTypes = keyTypes,
            mostRecent = mostRecent,
            statuses = statuses,
            tags = tags,
            types = types,
        )
        return toKotlin(getCertificatePlain(argument.toJava()).await())
    }

    /**
     * @see [getCertificate].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;acm&#46;kotlin&#46;inputs&#46;GetCertificatePlainArgs].
     * @return A collection of values returned by getCertificate.
     */
    public suspend fun getCertificate(argument: suspend GetCertificatePlainArgsBuilder.() -> Unit):
        GetCertificateResult {
        val builder = GetCertificatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getCertificatePlain(builtArgument.toJava()).await())
    }
}
