@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acm.kotlin

import com.pulumi.aws.acm.kotlin.outputs.CertificateDomainValidationOption
import com.pulumi.aws.acm.kotlin.outputs.CertificateOptions
import com.pulumi.aws.acm.kotlin.outputs.CertificateRenewalSummary
import com.pulumi.aws.acm.kotlin.outputs.CertificateValidationOption
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.acm.kotlin.outputs.CertificateDomainValidationOption.Companion.toKotlin as certificateDomainValidationOptionToKotlin
import com.pulumi.aws.acm.kotlin.outputs.CertificateOptions.Companion.toKotlin as certificateOptionsToKotlin
import com.pulumi.aws.acm.kotlin.outputs.CertificateRenewalSummary.Companion.toKotlin as certificateRenewalSummaryToKotlin
import com.pulumi.aws.acm.kotlin.outputs.CertificateValidationOption.Companion.toKotlin as certificateValidationOptionToKotlin

/**
 * Builder for [Certificate].
 */
@PulumiTagMarker
public class CertificateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CertificateArgs = CertificateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CertificateArgsBuilder.() -> Unit) {
        val builder = CertificateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Certificate {
        val builtJavaResource = com.pulumi.aws.acm.Certificate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Certificate(builtJavaResource)
    }
}

/**
 * The ACM certificate resource allows requesting and management of certificates
 * from the Amazon Certificate Manager.
 * ACM certificates can be created in three ways:
 * Amazon-issued, where AWS provides the certificate authority and automatically manages renewal;
 * imported certificates, issued by another certificate authority;
 * and private certificates, issued using an ACM Private Certificate Authority.
 * ## Amazon-Issued Certificates
 * For Amazon-issued certificates, this resource deals with requesting certificates and managing their attributes and life-cycle.
 * This resource does not deal with validation of a certificate but can provide inputs
 * for other resources implementing the validation.
 * It does not wait for a certificate to be issued.
 * Use a `aws.acm.CertificateValidation` resource for this.
 * Most commonly, this resource is used together with `aws.route53.Record` and
 * `aws.acm.CertificateValidation` to request a DNS validated certificate,
 * deploy the required validation records and wait for validation to complete.
 * Domain validation through email is also supported but should be avoided as it requires a manual step outside of this provider.
 * ## Certificates Imported from Other Certificate Authority
 * Imported certificates can be used to make certificates created with an external certificate authority available for AWS services.
 * As they are not managed by AWS, imported certificates are not eligible for automatic renewal.
 * New certificate materials can be supplied to an existing imported certificate to update it in place.
 * ## Private Certificates
 * Private certificates are issued by an ACM Private Cerificate Authority, which can be created using the resource type `aws.acmpca.CertificateAuthority`.
 * Private certificates created using this resource are eligible for managed renewal if they have been exported or associated with another AWS service.
 * See [managed renewal documentation](https://docs.aws.amazon.com/acm/latest/userguide/managed-renewal.html) for more information.
 * By default, a certificate is valid for 395 days and the managed renewal process will start 60 days before expiration.
 * To renew the certificate earlier than 60 days before expiration, configure `early_renewal_duration`.
 * ## Example Usage
 * ### Create Certificate
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.acm.Certificate;
 * import com.pulumi.aws.acm.CertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cert = new Certificate("cert", CertificateArgs.builder()
 *             .domainName("example.com")
 *             .tags(Map.of("Environment", "test"))
 *             .validationMethod("DNS")
 *             .build());
 *     }
 * }
 * ```
 * ### Custom Domain Validation Options
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.acm.Certificate;
 * import com.pulumi.aws.acm.CertificateArgs;
 * import com.pulumi.aws.acm.inputs.CertificateValidationOptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cert = new Certificate("cert", CertificateArgs.builder()
 *             .domainName("testing.example.com")
 *             .validationMethod("EMAIL")
 *             .validationOptions(CertificateValidationOptionArgs.builder()
 *                 .domainName("testing.example.com")
 *                 .validationDomain("example.com")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Existing Certificate Body Import
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.tls.PrivateKey;
 * import com.pulumi.tls.PrivateKeyArgs;
 * import com.pulumi.tls.SelfSignedCert;
 * import com.pulumi.tls.SelfSignedCertArgs;
 * import com.pulumi.tls.inputs.SelfSignedCertSubjectArgs;
 * import com.pulumi.aws.acm.Certificate;
 * import com.pulumi.aws.acm.CertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var examplePrivateKey = new PrivateKey("examplePrivateKey", PrivateKeyArgs.builder()
 *             .algorithm("RSA")
 *             .build());
 *         var exampleSelfSignedCert = new SelfSignedCert("exampleSelfSignedCert", SelfSignedCertArgs.builder()
 *             .keyAlgorithm("RSA")
 *             .privateKeyPem(examplePrivateKey.privateKeyPem())
 *             .subject(SelfSignedCertSubjectArgs.builder()
 *                 .commonName("example.com")
 *                 .organization("ACME Examples, Inc")
 *                 .build())
 *             .validityPeriodHours(12)
 *             .allowedUses(
 *                 "key_encipherment",
 *                 "digital_signature",
 *                 "server_auth")
 *             .build());
 *         var cert = new Certificate("cert", CertificateArgs.builder()
 *             .privateKey(examplePrivateKey.privateKeyPem())
 *             .certificateBody(exampleSelfSignedCert.certPem())
 *             .build());
 *     }
 * }
 * ```
 * ### Referencing domain_validation_options With for_each Based Resources
 * See the `aws.acm.CertificateValidation` resource for a full example of performing DNS validation.
 * No Java example available.
 * ## Import
 * Using `pulumi import`, import certificates using their ARN. For example:
 * ```sh
 *  $ pulumi import aws:acm/certificate:Certificate cert arn:aws:acm:eu-central-1:123456789012:certificate/7e7a28d2-163f-4b8f-b9cd-822f96c08d6a
 * ```
 *
 */
public class Certificate internal constructor(
    override val javaResource: com.pulumi.aws.acm.Certificate,
) : KotlinCustomResource(javaResource, CertificateMapper) {
    /**
     * ARN of the certificate
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * ARN of an ACM PCA
     */
    public val certificateAuthorityArn: Output<String>?
        get() = javaResource.certificateAuthorityArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Certificate's PEM-formatted public key
     */
    public val certificateBody: Output<String>?
        get() = javaResource.certificateBody().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Certificate's PEM-formatted chain
     * * Creating a private CA issued certificate
     */
    public val certificateChain: Output<String>?
        get() = javaResource.certificateChain().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Fully qualified domain name (FQDN) in the certificate.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * Set of domain validation objects which can be used to complete certificate validation.
     * Can have more than one element, e.g., if SANs are defined.
     * Only set if `DNS`-validation was used.
     */
    public val domainValidationOptions: Output<List<CertificateDomainValidationOption>>
        get() = javaResource.domainValidationOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> certificateDomainValidationOptionToKotlin(args0) })
            })
        })

    /**
     * Amount of time to start automatic renewal process before expiration.
     * Has no effect if less than 60 days.
     * Represented by either
     * a subset of [RFC 3339 duration](https://www.rfc-editor.org/rfc/rfc3339) supporting years, months, and days (e.g., `P90D`),
     * or a string such as `2160h`.
     */
    public val earlyRenewalDuration: Output<String>?
        get() = javaResource.earlyRenewalDuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the algorithm of the public and private key pair that your Amazon issued certificate uses to encrypt data. See [ACM Certificate characteristics](https://docs.aws.amazon.com/acm/latest/userguide/acm-certificate.html#algorithms) for more details.
     */
    public val keyAlgorithm: Output<String>
        get() = javaResource.keyAlgorithm().applyValue({ args0 -> args0 })

    /**
     * Expiration date and time of the certificate.
     */
    public val notAfter: Output<String>
        get() = javaResource.notAfter().applyValue({ args0 -> args0 })

    /**
     * Start of the validity period of the certificate.
     */
    public val notBefore: Output<String>
        get() = javaResource.notBefore().applyValue({ args0 -> args0 })

    /**
     * Configuration block used to set certificate options. Detailed below.
     */
    public val options: Output<CertificateOptions>
        get() = javaResource.options().applyValue({ args0 ->
            args0.let({ args0 ->
                certificateOptionsToKotlin(args0)
            })
        })

    /**
     * `true` if a Private certificate eligible for managed renewal is within the `early_renewal_duration` period.
     */
    public val pendingRenewal: Output<Boolean>
        get() = javaResource.pendingRenewal().applyValue({ args0 -> args0 })

    /**
     * Certificate's PEM-formatted private key
     */
    public val privateKey: Output<String>?
        get() = javaResource.privateKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the certificate is eligible for managed renewal.
     */
    public val renewalEligibility: Output<String>
        get() = javaResource.renewalEligibility().applyValue({ args0 -> args0 })

    /**
     * Contains information about the status of ACM's [managed renewal](https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html) for the certificate.
     */
    public val renewalSummaries: Output<List<CertificateRenewalSummary>>
        get() = javaResource.renewalSummaries().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> certificateRenewalSummaryToKotlin(args0) })
            })
        })

    /**
     * Status of the certificate.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Set of domains that should be SANs in the issued certificate.
     * To remove all elements of a previously configured list, set this value equal to an empty list (`[]`)
     */
    public val subjectAlternativeNames: Output<List<String>>
        get() = javaResource.subjectAlternativeNames().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Source of the certificate.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * List of addresses that received a validation email. Only set if `EMAIL` validation was used.
     */
    public val validationEmails: Output<List<String>>
        get() = javaResource.validationEmails().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Which method to use for validation. `DNS` or `EMAIL` are valid. This parameter must not be set for certificates that were imported into ACM and then into Pulumi.
     */
    public val validationMethod: Output<String>
        get() = javaResource.validationMethod().applyValue({ args0 -> args0 })

    /**
     * Configuration block used to specify information about the initial validation of each domain name. Detailed below.
     * * Importing an existing certificate
     */
    public val validationOptions: Output<List<CertificateValidationOption>>?
        get() = javaResource.validationOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        certificateValidationOptionToKotlin(args0)
                    })
                })
            }).orElse(null)
        })
}

public object CertificateMapper : ResourceMapper<Certificate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.acm.Certificate::class == javaResource::class

    override fun map(javaResource: Resource): Certificate = Certificate(
        javaResource as
            com.pulumi.aws.acm.Certificate,
    )
}

/**
 * @see [Certificate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Certificate].
 */
public suspend fun certificate(name: String, block: suspend CertificateResourceBuilder.() -> Unit):
    Certificate {
    val builder = CertificateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Certificate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun certificate(name: String): Certificate {
    val builder = CertificateResourceBuilder()
    builder.name(name)
    return builder.build()
}
