@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acm.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [CertificateValidation].
 */
@PulumiTagMarker
public class CertificateValidationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CertificateValidationArgs = CertificateValidationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CertificateValidationArgsBuilder.() -> Unit) {
        val builder = CertificateValidationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CertificateValidation {
        val builtJavaResource = com.pulumi.aws.acm.CertificateValidation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CertificateValidation(builtJavaResource)
    }
}

/**
 * This resource represents a successful validation of an ACM certificate in concert
 * with other resources.
 * Most commonly, this resource is used together with `aws.route53.Record` and
 * `aws.acm.Certificate` to request a DNS validated certificate,
 * deploy the required validation records and wait for validation to complete.
 * > **WARNING:** This resource implements a part of the validation workflow. It does not represent a real-world entity in AWS, therefore changing or deleting this resource on its own has no immediate effect.
 * ## Example Usage
 * ### DNS Validation with Route 53
 * No Java example available.
 * ### Email Validation
 * No Java example available.
 */
public class CertificateValidation internal constructor(
    override val javaResource: com.pulumi.aws.acm.CertificateValidation,
) : KotlinCustomResource(javaResource, CertificateValidationMapper) {
    /**
     * ARN of the certificate that is being validated.
     */
    public val certificateArn: Output<String>
        get() = javaResource.certificateArn().applyValue({ args0 -> args0 })

    /**
     * List of FQDNs that implement the validation. Only valid for DNS validation method ACM certificates. If this is set, the resource can implement additional sanity checks and has an explicit dependency on the resource that is implementing the validation
     */
    public val validationRecordFqdns: Output<List<String>>?
        get() = javaResource.validationRecordFqdns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })
}

public object CertificateValidationMapper : ResourceMapper<CertificateValidation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.acm.CertificateValidation::class == javaResource::class

    override fun map(javaResource: Resource): CertificateValidation =
        CertificateValidation(javaResource as com.pulumi.aws.acm.CertificateValidation)
}

/**
 * @see [CertificateValidation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CertificateValidation].
 */
public suspend fun certificateValidation(
    name: String,
    block: suspend CertificateValidationResourceBuilder.() -> Unit,
): CertificateValidation {
    val builder = CertificateValidationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CertificateValidation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun certificateValidation(name: String): CertificateValidation {
    val builder = CertificateValidationResourceBuilder()
    builder.name(name)
    return builder.build()
}
