@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acm.kotlin

import com.pulumi.aws.acm.CertificateValidationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * This resource represents a successful validation of an ACM certificate in concert
 * with other resources.
 * Most commonly, this resource is used together with `aws.route53.Record` and
 * `aws.acm.Certificate` to request a DNS validated certificate,
 * deploy the required validation records and wait for validation to complete.
 * > **WARNING:** This resource implements a part of the validation workflow. It does not represent a real-world entity in AWS, therefore changing or deleting this resource on its own has no immediate effect.
 * ## Example Usage
 * ### DNS Validation with Route 53
 * No Java example available.
 * ### Email Validation
 * No Java example available.
 * @property certificateArn ARN of the certificate that is being validated.
 * @property validationRecordFqdns List of FQDNs that implement the validation. Only valid for DNS validation method ACM certificates. If this is set, the resource can implement additional sanity checks and has an explicit dependency on the resource that is implementing the validation
 */
public data class CertificateValidationArgs(
    public val certificateArn: Output<String>? = null,
    public val validationRecordFqdns: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.acm.CertificateValidationArgs> {
    override fun toJava(): com.pulumi.aws.acm.CertificateValidationArgs =
        com.pulumi.aws.acm.CertificateValidationArgs.builder()
            .certificateArn(certificateArn?.applyValue({ args0 -> args0 }))
            .validationRecordFqdns(
                validationRecordFqdns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [CertificateValidationArgs].
 */
@PulumiTagMarker
public class CertificateValidationArgsBuilder internal constructor() {
    private var certificateArn: Output<String>? = null

    private var validationRecordFqdns: Output<List<String>>? = null

    /**
     * @param value ARN of the certificate that is being validated.
     */
    @JvmName("wvqltaqqdohjwlkb")
    public suspend fun certificateArn(`value`: Output<String>) {
        this.certificateArn = value
    }

    /**
     * @param value List of FQDNs that implement the validation. Only valid for DNS validation method ACM certificates. If this is set, the resource can implement additional sanity checks and has an explicit dependency on the resource that is implementing the validation
     */
    @JvmName("spxoxgkinaqwvwop")
    public suspend fun validationRecordFqdns(`value`: Output<List<String>>) {
        this.validationRecordFqdns = value
    }

    @JvmName("vdtvrxmfnnnrpuyh")
    public suspend fun validationRecordFqdns(vararg values: Output<String>) {
        this.validationRecordFqdns = Output.all(values.asList())
    }

    /**
     * @param values List of FQDNs that implement the validation. Only valid for DNS validation method ACM certificates. If this is set, the resource can implement additional sanity checks and has an explicit dependency on the resource that is implementing the validation
     */
    @JvmName("pmsyrkklgsrvfjjm")
    public suspend fun validationRecordFqdns(values: List<Output<String>>) {
        this.validationRecordFqdns = Output.all(values)
    }

    /**
     * @param value ARN of the certificate that is being validated.
     */
    @JvmName("jlchnuhpcpdwqhsf")
    public suspend fun certificateArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateArn = mapped
    }

    /**
     * @param value List of FQDNs that implement the validation. Only valid for DNS validation method ACM certificates. If this is set, the resource can implement additional sanity checks and has an explicit dependency on the resource that is implementing the validation
     */
    @JvmName("rbovlcvwhafqsxpl")
    public suspend fun validationRecordFqdns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationRecordFqdns = mapped
    }

    /**
     * @param values List of FQDNs that implement the validation. Only valid for DNS validation method ACM certificates. If this is set, the resource can implement additional sanity checks and has an explicit dependency on the resource that is implementing the validation
     */
    @JvmName("xopwgluwupoigiio")
    public suspend fun validationRecordFqdns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validationRecordFqdns = mapped
    }

    internal fun build(): CertificateValidationArgs = CertificateValidationArgs(
        certificateArn = certificateArn,
        validationRecordFqdns = validationRecordFqdns,
    )
}
