@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acm.kotlin.inputs

import com.pulumi.aws.acm.inputs.CertificateOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property certificateTransparencyLoggingPreference Whether certificate details should be added to a certificate transparency log. Valid values are `ENABLED` or `DISABLED`. See https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency for more details.
 */
public data class CertificateOptionsArgs(
    public val certificateTransparencyLoggingPreference: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.acm.inputs.CertificateOptionsArgs> {
    override fun toJava(): com.pulumi.aws.acm.inputs.CertificateOptionsArgs =
        com.pulumi.aws.acm.inputs.CertificateOptionsArgs.builder()
            .certificateTransparencyLoggingPreference(
                certificateTransparencyLoggingPreference?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [CertificateOptionsArgs].
 */
@PulumiTagMarker
public class CertificateOptionsArgsBuilder internal constructor() {
    private var certificateTransparencyLoggingPreference: Output<String>? = null

    /**
     * @param value Whether certificate details should be added to a certificate transparency log. Valid values are `ENABLED` or `DISABLED`. See https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency for more details.
     */
    @JvmName("anqfulkwygeunnpr")
    public suspend fun certificateTransparencyLoggingPreference(`value`: Output<String>) {
        this.certificateTransparencyLoggingPreference = value
    }

    /**
     * @param value Whether certificate details should be added to a certificate transparency log. Valid values are `ENABLED` or `DISABLED`. See https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency for more details.
     */
    @JvmName("oiuhqkafnkdaddvq")
    public suspend fun certificateTransparencyLoggingPreference(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateTransparencyLoggingPreference = mapped
    }

    internal fun build(): CertificateOptionsArgs = CertificateOptionsArgs(
        certificateTransparencyLoggingPreference = certificateTransparencyLoggingPreference,
    )
}
