@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acm.kotlin.inputs

import com.pulumi.aws.acm.inputs.GetCertificatePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCertificate.
 * @property domain Domain of the certificate to look up. If no certificate is found with this name, an error will be returned.
 * @property keyTypes List of key algorithms to filter certificates. By default, ACM does not return all certificate types when searching. See the [ACM API Reference](https://docs.aws.amazon.com/acm/latest/APIReference/API_CertificateDetail.html#ACM-Type-CertificateDetail-KeyAlgorithm) for supported key algorithms.
 * @property mostRecent If set to true, it sorts the certificates matched by previous criteria by the NotBefore field, returning only the most recent one. If set to false, it returns an error if more than one certificate is found. Defaults to false.
 * @property statuses List of statuses on which to filter the returned list. Valid values are `PENDING_VALIDATION`, `ISSUED`,
 * `INACTIVE`, `EXPIRED`, `VALIDATION_TIMED_OUT`, `REVOKED` and `FAILED`. If no value is specified, only certificates in the `ISSUED` state
 * are returned.
 * @property tags Mapping of tags for the resource.
 * @property types List of types on which to filter the returned list. Valid values are `AMAZON_ISSUED`, `PRIVATE`, and `IMPORTED`.
 */
public data class GetCertificatePlainArgs(
    public val domain: String,
    public val keyTypes: List<String>? = null,
    public val mostRecent: Boolean? = null,
    public val statuses: List<String>? = null,
    public val tags: Map<String, String>? = null,
    public val types: List<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.acm.inputs.GetCertificatePlainArgs> {
    override fun toJava(): com.pulumi.aws.acm.inputs.GetCertificatePlainArgs =
        com.pulumi.aws.acm.inputs.GetCertificatePlainArgs.builder()
            .domain(domain.let({ args0 -> args0 }))
            .keyTypes(keyTypes?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .mostRecent(mostRecent?.let({ args0 -> args0 }))
            .statuses(statuses?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .types(types?.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetCertificatePlainArgs].
 */
@PulumiTagMarker
public class GetCertificatePlainArgsBuilder internal constructor() {
    private var domain: String? = null

    private var keyTypes: List<String>? = null

    private var mostRecent: Boolean? = null

    private var statuses: List<String>? = null

    private var tags: Map<String, String>? = null

    private var types: List<String>? = null

    /**
     * @param value Domain of the certificate to look up. If no certificate is found with this name, an error will be returned.
     */
    @JvmName("takpggvbkcrnevxr")
    public suspend fun domain(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domain = mapped
    }

    /**
     * @param value List of key algorithms to filter certificates. By default, ACM does not return all certificate types when searching. See the [ACM API Reference](https://docs.aws.amazon.com/acm/latest/APIReference/API_CertificateDetail.html#ACM-Type-CertificateDetail-KeyAlgorithm) for supported key algorithms.
     */
    @JvmName("jwtdywankokxphmm")
    public suspend fun keyTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyTypes = mapped
    }

    /**
     * @param values List of key algorithms to filter certificates. By default, ACM does not return all certificate types when searching. See the [ACM API Reference](https://docs.aws.amazon.com/acm/latest/APIReference/API_CertificateDetail.html#ACM-Type-CertificateDetail-KeyAlgorithm) for supported key algorithms.
     */
    @JvmName("pcgqttqmdmnjqkxw")
    public suspend fun keyTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyTypes = mapped
    }

    /**
     * @param value If set to true, it sorts the certificates matched by previous criteria by the NotBefore field, returning only the most recent one. If set to false, it returns an error if more than one certificate is found. Defaults to false.
     */
    @JvmName("yjtnqauqeshvneui")
    public suspend fun mostRecent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.mostRecent = mapped
    }

    /**
     * @param value List of statuses on which to filter the returned list. Valid values are `PENDING_VALIDATION`, `ISSUED`,
     * `INACTIVE`, `EXPIRED`, `VALIDATION_TIMED_OUT`, `REVOKED` and `FAILED`. If no value is specified, only certificates in the `ISSUED` state
     * are returned.
     */
    @JvmName("mrmnmqojxishnecp")
    public suspend fun statuses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.statuses = mapped
    }

    /**
     * @param values List of statuses on which to filter the returned list. Valid values are `PENDING_VALIDATION`, `ISSUED`,
     * `INACTIVE`, `EXPIRED`, `VALIDATION_TIMED_OUT`, `REVOKED` and `FAILED`. If no value is specified, only certificates in the `ISSUED` state
     * are returned.
     */
    @JvmName("gscimhmuuumkkpeg")
    public suspend fun statuses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.statuses = mapped
    }

    /**
     * @param value Mapping of tags for the resource.
     */
    @JvmName("qwefqhnfhwcnrkgw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Mapping of tags for the resource.
     */
    @JvmName("kqvpbmuyunvfmvdh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value List of types on which to filter the returned list. Valid values are `AMAZON_ISSUED`, `PRIVATE`, and `IMPORTED`.
     */
    @JvmName("qvmhbxphnspeouiq")
    public suspend fun types(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.types = mapped
    }

    /**
     * @param values List of types on which to filter the returned list. Valid values are `AMAZON_ISSUED`, `PRIVATE`, and `IMPORTED`.
     */
    @JvmName("dxasukabdiajbljp")
    public suspend fun types(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.types = mapped
    }

    internal fun build(): GetCertificatePlainArgs = GetCertificatePlainArgs(
        domain = domain ?: throw PulumiNullFieldException("domain"),
        keyTypes = keyTypes,
        mostRecent = mostRecent,
        statuses = statuses,
        tags = tags,
        types = types,
    )
}
