@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acm.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property domainName Fully qualified domain name (FQDN) in the certificate.
 * @property resourceRecordName The name of the DNS record to create to validate the certificate
 * @property resourceRecordType The type of DNS record to create
 * @property resourceRecordValue The value the DNS record needs to have
 */
public data class CertificateDomainValidationOption(
    public val domainName: String? = null,
    public val resourceRecordName: String? = null,
    public val resourceRecordType: String? = null,
    public val resourceRecordValue: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.acm.outputs.CertificateDomainValidationOption):
            CertificateDomainValidationOption = CertificateDomainValidationOption(
            domainName = javaType.domainName().map({ args0 -> args0 }).orElse(null),
            resourceRecordName = javaType.resourceRecordName().map({ args0 -> args0 }).orElse(null),
            resourceRecordType = javaType.resourceRecordType().map({ args0 -> args0 }).orElse(null),
            resourceRecordValue = javaType.resourceRecordValue().map({ args0 -> args0 }).orElse(null),
        )
    }
}
