@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acm.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property certificateTransparencyLoggingPreference Whether certificate details should be added to a certificate transparency log. Valid values are `ENABLED` or `DISABLED`. See https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency for more details.
 */
public data class CertificateOptions(
    public val certificateTransparencyLoggingPreference: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.acm.outputs.CertificateOptions): CertificateOptions =
            CertificateOptions(
                certificateTransparencyLoggingPreference = javaType.certificateTransparencyLoggingPreference().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
