@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acm.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property renewalStatus The status of ACM's managed renewal of the certificate
 * @property renewalStatusReason The reason that a renewal request was unsuccessful or is pending
 * @property updatedAt
 */
public data class CertificateRenewalSummary(
    public val renewalStatus: String? = null,
    public val renewalStatusReason: String? = null,
    public val updatedAt: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.acm.outputs.CertificateRenewalSummary):
            CertificateRenewalSummary = CertificateRenewalSummary(
            renewalStatus = javaType.renewalStatus().map({ args0 -> args0 }).orElse(null),
            renewalStatusReason = javaType.renewalStatusReason().map({ args0 -> args0 }).orElse(null),
            updatedAt = javaType.updatedAt().map({ args0 -> args0 }).orElse(null),
        )
    }
}
