@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acm.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property domainName Fully qualified domain name (FQDN) in the certificate.
 * @property validationDomain Domain name that you want ACM to use to send you validation emails. This domain name is the suffix of the email addresses that you want ACM to use. This must be the same as the `domain_name` value or a superdomain of the `domain_name` value. For example, if you request a certificate for `"testing.example.com"`, you can specify `"example.com"` for this value.
 */
public data class CertificateValidationOption(
    public val domainName: String,
    public val validationDomain: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.acm.outputs.CertificateValidationOption):
            CertificateValidationOption = CertificateValidationOption(
            domainName = javaType.domainName(),
            validationDomain = javaType.validationDomain(),
        )
    }
}
