@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin

import com.pulumi.aws.acmpca.AcmpcaFunctions.getCertificateAuthorityPlain
import com.pulumi.aws.acmpca.AcmpcaFunctions.getCertificatePlain
import com.pulumi.aws.acmpca.kotlin.inputs.GetCertificateAuthorityPlainArgs
import com.pulumi.aws.acmpca.kotlin.inputs.GetCertificateAuthorityPlainArgsBuilder
import com.pulumi.aws.acmpca.kotlin.inputs.GetCertificatePlainArgs
import com.pulumi.aws.acmpca.kotlin.inputs.GetCertificatePlainArgsBuilder
import com.pulumi.aws.acmpca.kotlin.outputs.GetCertificateAuthorityResult
import com.pulumi.aws.acmpca.kotlin.outputs.GetCertificateResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.acmpca.kotlin.outputs.GetCertificateAuthorityResult.Companion.toKotlin as getCertificateAuthorityResultToKotlin
import com.pulumi.aws.acmpca.kotlin.outputs.GetCertificateResult.Companion.toKotlin as getCertificateResultToKotlin

public object AcmpcaFunctions {
    /**
     * Get information on a Certificate issued by a AWS Certificate Manager Private Certificate Authority.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.acmpca.AcmpcaFunctions;
     * import com.pulumi.aws.acmpca.inputs.GetCertificateArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = AcmpcaFunctions.getCertificate(GetCertificateArgs.builder()
     *             .arn("arn:aws:acm-pca:us-east-1:123456789012:certificate-authority/12345678-1234-1234-1234-123456789012/certificate/1234b4a0d73e2056789bdbe77d5b1a23")
     *             .certificateAuthorityArn("arn:aws:acm-pca:us-east-1:123456789012:certificate-authority/12345678-1234-1234-1234-123456789012")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getCertificate.
     * @return A collection of values returned by getCertificate.
     */
    public suspend fun getCertificate(argument: GetCertificatePlainArgs): GetCertificateResult =
        getCertificateResultToKotlin(getCertificatePlain(argument.toJava()).await())

    /**
     * @see [getCertificate].
     * @param arn ARN of the certificate issued by the private certificate authority.
     * @param certificateAuthorityArn ARN of the certificate authority.
     * @return A collection of values returned by getCertificate.
     */
    public suspend fun getCertificate(arn: String, certificateAuthorityArn: String):
        GetCertificateResult {
        val argument = GetCertificatePlainArgs(
            arn = arn,
            certificateAuthorityArn = certificateAuthorityArn,
        )
        return getCertificateResultToKotlin(getCertificatePlain(argument.toJava()).await())
    }

    /**
     * @see [getCertificate].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;acmpca&#46;kotlin&#46;inputs&#46;GetCertificatePlainArgs].
     * @return A collection of values returned by getCertificate.
     */
    public suspend fun getCertificate(argument: suspend GetCertificatePlainArgsBuilder.() -> Unit):
        GetCertificateResult {
        val builder = GetCertificatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCertificateResultToKotlin(getCertificatePlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on a AWS Certificate Manager Private Certificate Authority (ACM PCA Certificate Authority).
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.acmpca.AcmpcaFunctions;
     * import com.pulumi.aws.acmpca.inputs.GetCertificateAuthorityArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = AcmpcaFunctions.getCertificateAuthority(GetCertificateAuthorityArgs.builder()
     *             .arn("arn:aws:acm-pca:us-east-1:123456789012:certificate-authority/12345678-1234-1234-1234-123456789012")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getCertificateAuthority.
     * @return A collection of values returned by getCertificateAuthority.
     */
    public suspend fun getCertificateAuthority(argument: GetCertificateAuthorityPlainArgs):
        GetCertificateAuthorityResult =
        getCertificateAuthorityResultToKotlin(getCertificateAuthorityPlain(argument.toJava()).await())

    /**
     * @see [getCertificateAuthority].
     * @param arn ARN of the certificate authority.
     * @param tags Key-value map of user-defined tags that are attached to the certificate authority.
     * @return A collection of values returned by getCertificateAuthority.
     */
    public suspend fun getCertificateAuthority(arn: String, tags: Map<String, String>? = null):
        GetCertificateAuthorityResult {
        val argument = GetCertificateAuthorityPlainArgs(
            arn = arn,
            tags = tags,
        )
        return getCertificateAuthorityResultToKotlin(getCertificateAuthorityPlain(argument.toJava()).await())
    }

    /**
     * @see [getCertificateAuthority].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;acmpca&#46;kotlin&#46;inputs&#46;GetCertificateAuthorityPlainArgs].
     * @return A collection of values returned by getCertificateAuthority.
     */
    public suspend
    fun getCertificateAuthority(argument: suspend GetCertificateAuthorityPlainArgsBuilder.() -> Unit):
        GetCertificateAuthorityResult {
        val builder = GetCertificateAuthorityPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCertificateAuthorityResultToKotlin(getCertificateAuthorityPlain(builtArgument.toJava()).await())
    }
}
