@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin

import com.pulumi.aws.acmpca.kotlin.outputs.CertificateValidity
import com.pulumi.aws.acmpca.kotlin.outputs.CertificateValidity.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Certificate].
 */
@PulumiTagMarker
public class CertificateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CertificateArgs = CertificateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CertificateArgsBuilder.() -> Unit) {
        val builder = CertificateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Certificate {
        val builtJavaResource = com.pulumi.aws.acmpca.Certificate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Certificate(builtJavaResource)
    }
}

/**
 * Provides a resource to issue a certificate using AWS Certificate Manager Private Certificate Authority (ACM PCA).
 * Certificates created using `aws.acmpca.Certificate` are not eligible for automatic renewal,
 * and must be replaced instead.
 * To issue a renewable certificate using an ACM PCA, create a `aws.acm.Certificate`
 * with the parameter `certificate_authority_arn`.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.acmpca.CertificateAuthority;
 * import com.pulumi.aws.acmpca.CertificateAuthorityArgs;
 * import com.pulumi.tls.PrivateKey;
 * import com.pulumi.tls.PrivateKeyArgs;
 * import com.pulumi.tls.CertRequest;
 * import com.pulumi.tls.CertRequestArgs;
 * import com.pulumi.tls.inputs.CertRequestSubjectArgs;
 * import com.pulumi.aws.acmpca.Certificate;
 * import com.pulumi.aws.acmpca.CertificateArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateValidityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleCertificateAuthority = new CertificateAuthority("exampleCertificateAuthority", CertificateAuthorityArgs.builder()
 *             .privateCertificateConfiguration(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *             .permanentDeletionTimeInDays(7)
 *             .build());
 *         var key = new PrivateKey("key", PrivateKeyArgs.builder()
 *             .algorithm("RSA")
 *             .build());
 *         var csr = new CertRequest("csr", CertRequestArgs.builder()
 *             .keyAlgorithm("RSA")
 *             .privateKeyPem(key.privateKeyPem())
 *             .subject(CertRequestSubjectArgs.builder()
 *                 .commonName("example")
 *                 .build())
 *             .build());
 *         var exampleCertificate = new Certificate("exampleCertificate", CertificateArgs.builder()
 *             .certificateAuthorityArn(exampleCertificateAuthority.arn())
 *             .certificateSigningRequest(csr.certRequestPem())
 *             .signingAlgorithm("SHA256WITHRSA")
 *             .validity(CertificateValidityArgs.builder()
 *                 .type("YEARS")
 *                 .value(1)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ACM PCA Certificates using their ARN. For example:
 * ```sh
 *  $ pulumi import aws:acmpca/certificate:Certificate cert arn:aws:acm-pca:eu-west-1:675225743824:certificate-authority/08319ede-83g9-1400-8f21-c7d12b2b6edb/certificate/a4e9c2aa4bcfab625g1b9136464cd3a
 * ```
 *
 */
public class Certificate internal constructor(
    override val javaResource: com.pulumi.aws.acmpca.Certificate,
) : KotlinCustomResource(javaResource, CertificateMapper) {
    /**
     * Specifies X.509 certificate information to be included in the issued certificate. To use with API Passthrough templates
     */
    public val apiPassthrough: Output<String>?
        get() = javaResource.apiPassthrough().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the certificate.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * PEM-encoded certificate value.
     */
    public val certificate: Output<String>
        get() = javaResource.certificate().applyValue({ args0 -> args0 })

    /**
     * ARN of the certificate authority.
     */
    public val certificateAuthorityArn: Output<String>
        get() = javaResource.certificateAuthorityArn().applyValue({ args0 -> args0 })

    /**
     * PEM-encoded certificate chain that includes any intermediate certificates and chains up to root CA.
     */
    public val certificateChain: Output<String>
        get() = javaResource.certificateChain().applyValue({ args0 -> args0 })

    /**
     * Certificate Signing Request in PEM format.
     */
    public val certificateSigningRequest: Output<String>
        get() = javaResource.certificateSigningRequest().applyValue({ args0 -> args0 })

    /**
     * Algorithm to use to sign certificate requests. Valid values: `SHA256WITHRSA`, `SHA256WITHECDSA`, `SHA384WITHRSA`, `SHA384WITHECDSA`, `SHA512WITHRSA`, `SHA512WITHECDSA`.
     */
    public val signingAlgorithm: Output<String>
        get() = javaResource.signingAlgorithm().applyValue({ args0 -> args0 })

    /**
     * Template to use when issuing a certificate.
     * See [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html) for more information.
     */
    public val templateArn: Output<String>?
        get() = javaResource.templateArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configures end of the validity period for the certificate. See validity block below.
     */
    public val validity: Output<CertificateValidity>
        get() = javaResource.validity().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
}

public object CertificateMapper : ResourceMapper<Certificate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.acmpca.Certificate::class == javaResource::class

    override fun map(javaResource: Resource): Certificate = Certificate(
        javaResource as
            com.pulumi.aws.acmpca.Certificate,
    )
}

/**
 * @see [Certificate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Certificate].
 */
public suspend fun certificate(name: String, block: suspend CertificateResourceBuilder.() -> Unit):
    Certificate {
    val builder = CertificateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Certificate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun certificate(name: String): Certificate {
    val builder = CertificateResourceBuilder()
    builder.name(name)
    return builder.build()
}
