@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin

import com.pulumi.aws.acmpca.kotlin.outputs.CertificateAuthorityCertificateAuthorityConfiguration
import com.pulumi.aws.acmpca.kotlin.outputs.CertificateAuthorityRevocationConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.acmpca.kotlin.outputs.CertificateAuthorityCertificateAuthorityConfiguration.Companion.toKotlin as certificateAuthorityCertificateAuthorityConfigurationToKotlin
import com.pulumi.aws.acmpca.kotlin.outputs.CertificateAuthorityRevocationConfiguration.Companion.toKotlin as certificateAuthorityRevocationConfigurationToKotlin

/**
 * Builder for [CertificateAuthority].
 */
@PulumiTagMarker
public class CertificateAuthorityResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CertificateAuthorityArgs = CertificateAuthorityArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CertificateAuthorityArgsBuilder.() -> Unit) {
        val builder = CertificateAuthorityArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CertificateAuthority {
        val builtJavaResource = com.pulumi.aws.acmpca.CertificateAuthority(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CertificateAuthority(builtJavaResource)
    }
}

/**
 * Provides a resource to manage AWS Certificate Manager Private Certificate Authorities (ACM PCA Certificate Authorities).
 * > **NOTE:** Creating this resource will leave the certificate authority in a `PENDING_CERTIFICATE` status, which means it cannot yet issue certificates. To complete this setup, you must fully sign the certificate authority CSR available in the `certificate_signing_request` attribute. The `aws.acmpca.CertificateAuthorityCertificate` resource can be used for this purpose.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.acmpca.CertificateAuthority;
 * import com.pulumi.aws.acmpca.CertificateAuthorityArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CertificateAuthority("example", CertificateAuthorityArgs.builder()
 *             .certificateAuthorityConfiguration(CertificateAuthorityCertificateAuthorityConfigurationArgs.builder()
 *                 .keyAlgorithm("RSA_4096")
 *                 .signingAlgorithm("SHA512WITHRSA")
 *                 .subject(CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs.builder()
 *                     .commonName("example.com")
 *                     .build())
 *                 .build())
 *             .permanentDeletionTimeInDays(7)
 *             .build());
 *     }
 * }
 * ```
 * ### Short-lived certificate
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.acmpca.CertificateAuthority;
 * import com.pulumi.aws.acmpca.CertificateAuthorityArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CertificateAuthority("example", CertificateAuthorityArgs.builder()
 *             .certificateAuthorityConfiguration(CertificateAuthorityCertificateAuthorityConfigurationArgs.builder()
 *                 .keyAlgorithm("RSA_4096")
 *                 .signingAlgorithm("SHA512WITHRSA")
 *                 .subject(CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs.builder()
 *                     .commonName("example.com")
 *                     .build())
 *                 .build())
 *             .usageMode("SHORT_LIVED_CERTIFICATE")
 *             .build());
 *     }
 * }
 * ```
 * ### Enable Certificate Revocation List
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.s3.BucketPolicy;
 * import com.pulumi.aws.s3.BucketPolicyArgs;
 * import com.pulumi.aws.acmpca.CertificateAuthority;
 * import com.pulumi.aws.acmpca.CertificateAuthorityArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityRevocationConfigurationArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityRevocationConfigurationCrlConfigurationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .forceDestroy(true)
 *             .build());
 *         final var acmpcaBucketAccess = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions(
 *                     "s3:GetBucketAcl",
 *                     "s3:GetBucketLocation",
 *                     "s3:PutObject",
 *                     "s3:PutObjectAcl")
 *                 .resources(
 *                     exampleBucketV2.arn(),
 *                     exampleBucketV2.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .identifiers("acm-pca.amazonaws.com")
 *                     .type("Service")
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleBucketPolicy = new BucketPolicy("exampleBucketPolicy", BucketPolicyArgs.builder()
 *             .bucket(exampleBucketV2.id())
 *             .policy(acmpcaBucketAccess.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(acmpcaBucketAccess -> acmpcaBucketAccess.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var exampleCertificateAuthority = new CertificateAuthority("exampleCertificateAuthority", CertificateAuthorityArgs.builder()
 *             .certificateAuthorityConfiguration(CertificateAuthorityCertificateAuthorityConfigurationArgs.builder()
 *                 .keyAlgorithm("RSA_4096")
 *                 .signingAlgorithm("SHA512WITHRSA")
 *                 .subject(CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs.builder()
 *                     .commonName("example.com")
 *                     .build())
 *                 .build())
 *             .revocationConfiguration(CertificateAuthorityRevocationConfigurationArgs.builder()
 *                 .crlConfiguration(CertificateAuthorityRevocationConfigurationCrlConfigurationArgs.builder()
 *                     .customCname("crl.example.com")
 *                     .enabled(true)
 *                     .expirationInDays(7)
 *                     .s3BucketName(exampleBucketV2.id())
 *                     .s3ObjectAcl("BUCKET_OWNER_FULL_CONTROL")
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleBucketPolicy)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_acmpca_certificate_authority` using the certificate authority ARN. For example:
 * ```sh
 *  $ pulumi import aws:acmpca/certificateAuthority:CertificateAuthority example arn:aws:acm-pca:us-east-1:123456789012:certificate-authority/12345678-1234-1234-1234-123456789012
 * ```
 * */
 */
public class CertificateAuthority internal constructor(
    override val javaResource: com.pulumi.aws.acmpca.CertificateAuthority,
) : KotlinCustomResource(javaResource, CertificateAuthorityMapper) {
    /**
     * ARN of the certificate authority.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Base64-encoded certificate authority (CA) certificate. Only available after the certificate authority certificate has been imported.
     */
    public val certificate: Output<String>
        get() = javaResource.certificate().applyValue({ args0 -> args0 })

    /**
     * Nested argument containing algorithms and certificate subject information. Defined below.
     */
    public val certificateAuthorityConfiguration:
        Output<CertificateAuthorityCertificateAuthorityConfiguration>
        get() = javaResource.certificateAuthorityConfiguration().applyValue({ args0 ->
            args0.let({ args0 -> certificateAuthorityCertificateAuthorityConfigurationToKotlin(args0) })
        })

    /**
     * Base64-encoded certificate chain that includes any intermediate certificates and chains up to root on-premises certificate that you used to sign your private CA certificate. The chain does not include your private CA certificate. Only available after the certificate authority certificate has been imported.
     */
    public val certificateChain: Output<String>
        get() = javaResource.certificateChain().applyValue({ args0 -> args0 })

    /**
     * The base64 PEM-encoded certificate signing request (CSR) for your private CA certificate.
     */
    public val certificateSigningRequest: Output<String>
        get() = javaResource.certificateSigningRequest().applyValue({ args0 -> args0 })

    /**
     * Whether the certificate authority is enabled or disabled. Defaults to `true`. Can only be disabled if the CA is in an `ACTIVE` state.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Cryptographic key management compliance standard used for handling CA keys. Defaults to `FIPS_140_2_LEVEL_3_OR_HIGHER`. Valid values: `FIPS_140_2_LEVEL_3_OR_HIGHER` and `FIPS_140_2_LEVEL_2_OR_HIGHER`. Supported standard for each region can be found in the [Storage and security compliance of AWS Private CA private keys Documentation](https://docs.aws.amazon.com/privateca/latest/userguide/data-protection.html#private-keys).
     */
    public val keyStorageSecurityStandard: Output<String>
        get() = javaResource.keyStorageSecurityStandard().applyValue({ args0 -> args0 })

    /**
     * Date and time after which the certificate authority is not valid. Only available after the certificate authority certificate has been imported.
     */
    public val notAfter: Output<String>
        get() = javaResource.notAfter().applyValue({ args0 -> args0 })

    /**
     * Date and time before which the certificate authority is not valid. Only available after the certificate authority certificate has been imported.
     */
    public val notBefore: Output<String>
        get() = javaResource.notBefore().applyValue({ args0 -> args0 })

    /**
     * Number of days to make a CA restorable after it has been deleted, must be between 7 to 30 days, with default to 30 days.
     */
    public val permanentDeletionTimeInDays: Output<Int>?
        get() = javaResource.permanentDeletionTimeInDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Nested argument containing revocation configuration. Defined below.
     */
    public val revocationConfiguration: Output<CertificateAuthorityRevocationConfiguration>?
        get() = javaResource.revocationConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    certificateAuthorityRevocationConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Serial number of the certificate authority. Only available after the certificate authority certificate has been imported.
     */
    public val serial: Output<String>
        get() = javaResource.serial().applyValue({ args0 -> args0 })

    /**
     * Key-value map of user-defined tags that are attached to the certificate authority. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Type of the certificate authority. Defaults to `SUBORDINATE`. Valid values: `ROOT` and `SUBORDINATE`.
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies whether the CA issues general-purpose certificates that typically require a revocation mechanism, or short-lived certificates that may optionally omit revocation because they expire quickly. Short-lived certificate validity is limited to seven days. Defaults to `GENERAL_PURPOSE`. Valid values: `GENERAL_PURPOSE` and `SHORT_LIVED_CERTIFICATE`.
     */
    public val usageMode: Output<String>
        get() = javaResource.usageMode().applyValue({ args0 -> args0 })
}

public object CertificateAuthorityMapper : ResourceMapper<CertificateAuthority> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.acmpca.CertificateAuthority::class == javaResource::class

    override fun map(javaResource: Resource): CertificateAuthority = CertificateAuthority(
        javaResource
            as com.pulumi.aws.acmpca.CertificateAuthority,
    )
}

/**
 * @see [CertificateAuthority].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CertificateAuthority].
 */
public suspend fun certificateAuthority(
    name: String,
    block: suspend CertificateAuthorityResourceBuilder.() -> Unit,
): CertificateAuthority {
    val builder = CertificateAuthorityResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CertificateAuthority].
 * @param name The _unique_ name of the resulting resource.
 */
public fun certificateAuthority(name: String): CertificateAuthority {
    val builder = CertificateAuthorityResourceBuilder()
    builder.name(name)
    return builder.build()
}
