@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin

import com.pulumi.aws.acmpca.CertificateAuthorityArgs.builder
import com.pulumi.aws.acmpca.kotlin.inputs.CertificateAuthorityCertificateAuthorityConfigurationArgs
import com.pulumi.aws.acmpca.kotlin.inputs.CertificateAuthorityCertificateAuthorityConfigurationArgsBuilder
import com.pulumi.aws.acmpca.kotlin.inputs.CertificateAuthorityRevocationConfigurationArgs
import com.pulumi.aws.acmpca.kotlin.inputs.CertificateAuthorityRevocationConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage AWS Certificate Manager Private Certificate Authorities (ACM PCA Certificate Authorities).
 * > **NOTE:** Creating this resource will leave the certificate authority in a `PENDING_CERTIFICATE` status, which means it cannot yet issue certificates. To complete this setup, you must fully sign the certificate authority CSR available in the `certificate_signing_request` attribute. The `aws.acmpca.CertificateAuthorityCertificate` resource can be used for this purpose.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.acmpca.CertificateAuthority;
 * import com.pulumi.aws.acmpca.CertificateAuthorityArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CertificateAuthority("example", CertificateAuthorityArgs.builder()
 *             .certificateAuthorityConfiguration(CertificateAuthorityCertificateAuthorityConfigurationArgs.builder()
 *                 .keyAlgorithm("RSA_4096")
 *                 .signingAlgorithm("SHA512WITHRSA")
 *                 .subject(CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs.builder()
 *                     .commonName("example.com")
 *                     .build())
 *                 .build())
 *             .permanentDeletionTimeInDays(7)
 *             .build());
 *     }
 * }
 * ```
 * ### Short-lived certificate
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.acmpca.CertificateAuthority;
 * import com.pulumi.aws.acmpca.CertificateAuthorityArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CertificateAuthority("example", CertificateAuthorityArgs.builder()
 *             .certificateAuthorityConfiguration(CertificateAuthorityCertificateAuthorityConfigurationArgs.builder()
 *                 .keyAlgorithm("RSA_4096")
 *                 .signingAlgorithm("SHA512WITHRSA")
 *                 .subject(CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs.builder()
 *                     .commonName("example.com")
 *                     .build())
 *                 .build())
 *             .usageMode("SHORT_LIVED_CERTIFICATE")
 *             .build());
 *     }
 * }
 * ```
 * ### Enable Certificate Revocation List
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.s3.BucketPolicy;
 * import com.pulumi.aws.s3.BucketPolicyArgs;
 * import com.pulumi.aws.acmpca.CertificateAuthority;
 * import com.pulumi.aws.acmpca.CertificateAuthorityArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityRevocationConfigurationArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityRevocationConfigurationCrlConfigurationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .forceDestroy(true)
 *             .build());
 *         final var acmpcaBucketAccess = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions(
 *                     "s3:GetBucketAcl",
 *                     "s3:GetBucketLocation",
 *                     "s3:PutObject",
 *                     "s3:PutObjectAcl")
 *                 .resources(
 *                     exampleBucketV2.arn(),
 *                     exampleBucketV2.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .identifiers("acm-pca.amazonaws.com")
 *                     .type("Service")
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleBucketPolicy = new BucketPolicy("exampleBucketPolicy", BucketPolicyArgs.builder()
 *             .bucket(exampleBucketV2.id())
 *             .policy(acmpcaBucketAccess.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(acmpcaBucketAccess -> acmpcaBucketAccess.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var exampleCertificateAuthority = new CertificateAuthority("exampleCertificateAuthority", CertificateAuthorityArgs.builder()
 *             .certificateAuthorityConfiguration(CertificateAuthorityCertificateAuthorityConfigurationArgs.builder()
 *                 .keyAlgorithm("RSA_4096")
 *                 .signingAlgorithm("SHA512WITHRSA")
 *                 .subject(CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs.builder()
 *                     .commonName("example.com")
 *                     .build())
 *                 .build())
 *             .revocationConfiguration(CertificateAuthorityRevocationConfigurationArgs.builder()
 *                 .crlConfiguration(CertificateAuthorityRevocationConfigurationCrlConfigurationArgs.builder()
 *                     .customCname("crl.example.com")
 *                     .enabled(true)
 *                     .expirationInDays(7)
 *                     .s3BucketName(exampleBucketV2.id())
 *                     .s3ObjectAcl("BUCKET_OWNER_FULL_CONTROL")
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleBucketPolicy)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_acmpca_certificate_authority` using the certificate authority ARN. For example:
 * ```sh
 *  $ pulumi import aws:acmpca/certificateAuthority:CertificateAuthority example arn:aws:acm-pca:us-east-1:123456789012:certificate-authority/12345678-1234-1234-1234-123456789012
 * ```
 * @property certificateAuthorityConfiguration Nested argument containing algorithms and certificate subject information. Defined below.
 * @property enabled Whether the certificate authority is enabled or disabled. Defaults to `true`. Can only be disabled if the CA is in an `ACTIVE` state.
 * @property keyStorageSecurityStandard Cryptographic key management compliance standard used for handling CA keys. Defaults to `FIPS_140_2_LEVEL_3_OR_HIGHER`. Valid values: `FIPS_140_2_LEVEL_3_OR_HIGHER` and `FIPS_140_2_LEVEL_2_OR_HIGHER`. Supported standard for each region can be found in the [Storage and security compliance of AWS Private CA private keys Documentation](https://docs.aws.amazon.com/privateca/latest/userguide/data-protection.html#private-keys).
 * @property permanentDeletionTimeInDays Number of days to make a CA restorable after it has been deleted, must be between 7 to 30 days, with default to 30 days.
 * @property revocationConfiguration Nested argument containing revocation configuration. Defined below.
 * @property tags Key-value map of user-defined tags that are attached to the certificate authority. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type Type of the certificate authority. Defaults to `SUBORDINATE`. Valid values: `ROOT` and `SUBORDINATE`.
 * @property usageMode Specifies whether the CA issues general-purpose certificates that typically require a revocation mechanism, or short-lived certificates that may optionally omit revocation because they expire quickly. Short-lived certificate validity is limited to seven days. Defaults to `GENERAL_PURPOSE`. Valid values: `GENERAL_PURPOSE` and `SHORT_LIVED_CERTIFICATE`.
 * */
 */
public data class CertificateAuthorityArgs(
    public val certificateAuthorityConfiguration:
    Output<CertificateAuthorityCertificateAuthorityConfigurationArgs>? = null,
    public val enabled: Output<Boolean>? = null,
    public val keyStorageSecurityStandard: Output<String>? = null,
    public val permanentDeletionTimeInDays: Output<Int>? = null,
    public val revocationConfiguration: Output<CertificateAuthorityRevocationConfigurationArgs>? =
        null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
    public val usageMode: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.acmpca.CertificateAuthorityArgs> {
    override fun toJava(): com.pulumi.aws.acmpca.CertificateAuthorityArgs =
        com.pulumi.aws.acmpca.CertificateAuthorityArgs.builder()
            .certificateAuthorityConfiguration(
                certificateAuthorityConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .keyStorageSecurityStandard(keyStorageSecurityStandard?.applyValue({ args0 -> args0 }))
            .permanentDeletionTimeInDays(permanentDeletionTimeInDays?.applyValue({ args0 -> args0 }))
            .revocationConfiguration(
                revocationConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 }))
            .usageMode(usageMode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertificateAuthorityArgs].
 */
@PulumiTagMarker
public class CertificateAuthorityArgsBuilder internal constructor() {
    private var certificateAuthorityConfiguration:
        Output<CertificateAuthorityCertificateAuthorityConfigurationArgs>? = null

    private var enabled: Output<Boolean>? = null

    private var keyStorageSecurityStandard: Output<String>? = null

    private var permanentDeletionTimeInDays: Output<Int>? = null

    private var revocationConfiguration: Output<CertificateAuthorityRevocationConfigurationArgs>? =
        null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    private var usageMode: Output<String>? = null

    /**
     * @param value Nested argument containing algorithms and certificate subject information. Defined below.
     */
    @JvmName("ojutvqjerqmcoxwk")
    public suspend
    fun certificateAuthorityConfiguration(`value`: Output<CertificateAuthorityCertificateAuthorityConfigurationArgs>) {
        this.certificateAuthorityConfiguration = value
    }

    /**
     * @param value Whether the certificate authority is enabled or disabled. Defaults to `true`. Can only be disabled if the CA is in an `ACTIVE` state.
     */
    @JvmName("hqkmcheqaobfkvwq")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Cryptographic key management compliance standard used for handling CA keys. Defaults to `FIPS_140_2_LEVEL_3_OR_HIGHER`. Valid values: `FIPS_140_2_LEVEL_3_OR_HIGHER` and `FIPS_140_2_LEVEL_2_OR_HIGHER`. Supported standard for each region can be found in the [Storage and security compliance of AWS Private CA private keys Documentation](https://docs.aws.amazon.com/privateca/latest/userguide/data-protection.html#private-keys).
     */
    @JvmName("qpfpqshojgwlsctm")
    public suspend fun keyStorageSecurityStandard(`value`: Output<String>) {
        this.keyStorageSecurityStandard = value
    }

    /**
     * @param value Number of days to make a CA restorable after it has been deleted, must be between 7 to 30 days, with default to 30 days.
     */
    @JvmName("majkjxoyxydvtupv")
    public suspend fun permanentDeletionTimeInDays(`value`: Output<Int>) {
        this.permanentDeletionTimeInDays = value
    }

    /**
     * @param value Nested argument containing revocation configuration. Defined below.
     */
    @JvmName("amoasbxqrgxyrtob")
    public suspend
    fun revocationConfiguration(`value`: Output<CertificateAuthorityRevocationConfigurationArgs>) {
        this.revocationConfiguration = value
    }

    /**
     * @param value Key-value map of user-defined tags that are attached to the certificate authority. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fhkuuypbiusapegf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Type of the certificate authority. Defaults to `SUBORDINATE`. Valid values: `ROOT` and `SUBORDINATE`.
     */
    @JvmName("xjkwvffbwfvyfsul")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies whether the CA issues general-purpose certificates that typically require a revocation mechanism, or short-lived certificates that may optionally omit revocation because they expire quickly. Short-lived certificate validity is limited to seven days. Defaults to `GENERAL_PURPOSE`. Valid values: `GENERAL_PURPOSE` and `SHORT_LIVED_CERTIFICATE`.
     */
    @JvmName("sjinstaeekupjjkl")
    public suspend fun usageMode(`value`: Output<String>) {
        this.usageMode = value
    }

    /**
     * @param value Nested argument containing algorithms and certificate subject information. Defined below.
     */
    @JvmName("onuvsbqsftfuqqwt")
    public suspend
    fun certificateAuthorityConfiguration(`value`: CertificateAuthorityCertificateAuthorityConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateAuthorityConfiguration = mapped
    }

    /**
     * @param argument Nested argument containing algorithms and certificate subject information. Defined below.
     */
    @JvmName("jonmkxylnfhjcwkd")
    public suspend
    fun certificateAuthorityConfiguration(argument: suspend CertificateAuthorityCertificateAuthorityConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            CertificateAuthorityCertificateAuthorityConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.certificateAuthorityConfiguration = mapped
    }

    /**
     * @param value Whether the certificate authority is enabled or disabled. Defaults to `true`. Can only be disabled if the CA is in an `ACTIVE` state.
     */
    @JvmName("hmfifwbjjoyncfjc")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Cryptographic key management compliance standard used for handling CA keys. Defaults to `FIPS_140_2_LEVEL_3_OR_HIGHER`. Valid values: `FIPS_140_2_LEVEL_3_OR_HIGHER` and `FIPS_140_2_LEVEL_2_OR_HIGHER`. Supported standard for each region can be found in the [Storage and security compliance of AWS Private CA private keys Documentation](https://docs.aws.amazon.com/privateca/latest/userguide/data-protection.html#private-keys).
     */
    @JvmName("xssosoclxfereocs")
    public suspend fun keyStorageSecurityStandard(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyStorageSecurityStandard = mapped
    }

    /**
     * @param value Number of days to make a CA restorable after it has been deleted, must be between 7 to 30 days, with default to 30 days.
     */
    @JvmName("fwllkdstngwohogw")
    public suspend fun permanentDeletionTimeInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permanentDeletionTimeInDays = mapped
    }

    /**
     * @param value Nested argument containing revocation configuration. Defined below.
     */
    @JvmName("cigiqqhihdhbaomy")
    public suspend
    fun revocationConfiguration(`value`: CertificateAuthorityRevocationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.revocationConfiguration = mapped
    }

    /**
     * @param argument Nested argument containing revocation configuration. Defined below.
     */
    @JvmName("ekmshcgfyasvhpmc")
    public suspend
    fun revocationConfiguration(argument: suspend CertificateAuthorityRevocationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = CertificateAuthorityRevocationConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.revocationConfiguration = mapped
    }

    /**
     * @param value Key-value map of user-defined tags that are attached to the certificate authority. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cxukmmgndykrwifl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of user-defined tags that are attached to the certificate authority. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sfpjlcdcbmfiaxgh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Type of the certificate authority. Defaults to `SUBORDINATE`. Valid values: `ROOT` and `SUBORDINATE`.
     */
    @JvmName("qxonunjtgrljrdik")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Specifies whether the CA issues general-purpose certificates that typically require a revocation mechanism, or short-lived certificates that may optionally omit revocation because they expire quickly. Short-lived certificate validity is limited to seven days. Defaults to `GENERAL_PURPOSE`. Valid values: `GENERAL_PURPOSE` and `SHORT_LIVED_CERTIFICATE`.
     */
    @JvmName("rwtfaihyrsrkkvkk")
    public suspend fun usageMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usageMode = mapped
    }

    internal fun build(): CertificateAuthorityArgs = CertificateAuthorityArgs(
        certificateAuthorityConfiguration = certificateAuthorityConfiguration,
        enabled = enabled,
        keyStorageSecurityStandard = keyStorageSecurityStandard,
        permanentDeletionTimeInDays = permanentDeletionTimeInDays,
        revocationConfiguration = revocationConfiguration,
        tags = tags,
        type = type,
        usageMode = usageMode,
    )
}
