@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [CertificateAuthorityCertificate].
 */
@PulumiTagMarker
public class CertificateAuthorityCertificateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CertificateAuthorityCertificateArgs = CertificateAuthorityCertificateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CertificateAuthorityCertificateArgsBuilder.() -> Unit) {
        val builder = CertificateAuthorityCertificateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CertificateAuthorityCertificate {
        val builtJavaResource =
            com.pulumi.aws.acmpca.CertificateAuthorityCertificate(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CertificateAuthorityCertificate(builtJavaResource)
    }
}

/**
 * Associates a certificate with an AWS Certificate Manager Private Certificate Authority (ACM PCA Certificate Authority). An ACM PCA Certificate Authority is unable to issue certificates until it has a certificate associated with it. A root level ACM PCA Certificate Authority is able to self-sign its own root certificate.
 * ## Example Usage
 * ### Self-Signed Root Certificate Authority Certificate
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.acmpca.CertificateAuthority;
 * import com.pulumi.aws.acmpca.CertificateAuthorityArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.acmpca.Certificate;
 * import com.pulumi.aws.acmpca.CertificateArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateValidityArgs;
 * import com.pulumi.aws.acmpca.CertificateAuthorityCertificate;
 * import com.pulumi.aws.acmpca.CertificateAuthorityCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleCertificateAuthority = new CertificateAuthority("exampleCertificateAuthority", CertificateAuthorityArgs.builder()
 *             .type("ROOT")
 *             .certificateAuthorityConfiguration(CertificateAuthorityCertificateAuthorityConfigurationArgs.builder()
 *                 .keyAlgorithm("RSA_4096")
 *                 .signingAlgorithm("SHA512WITHRSA")
 *                 .subject(CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs.builder()
 *                     .commonName("example.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         final var current = AwsFunctions.getPartition();
 *         var exampleCertificate = new Certificate("exampleCertificate", CertificateArgs.builder()
 *             .certificateAuthorityArn(exampleCertificateAuthority.arn())
 *             .certificateSigningRequest(exampleCertificateAuthority.certificateSigningRequest())
 *             .signingAlgorithm("SHA512WITHRSA")
 *             .templateArn(String.format("arn:%s:acm-pca:::template/RootCACertificate/V1", current.applyValue(getPartitionResult -> getPartitionResult.partition())))
 *             .validity(CertificateValidityArgs.builder()
 *                 .type("YEARS")
 *                 .value(1)
 *                 .build())
 *             .build());
 *         var exampleCertificateAuthorityCertificate = new CertificateAuthorityCertificate("exampleCertificateAuthorityCertificate", CertificateAuthorityCertificateArgs.builder()
 *             .certificateAuthorityArn(exampleCertificateAuthority.arn())
 *             .certificate(exampleCertificate.certificate())
 *             .certificateChain(exampleCertificate.certificateChain())
 *             .build());
 *     }
 * }
 * ```
 * ### Certificate for Subordinate Certificate Authority
 * Note that the certificate for the subordinate certificate authority must be issued by the root certificate authority using a signing request from the subordinate certificate authority.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.acmpca.CertificateAuthority;
 * import com.pulumi.aws.acmpca.CertificateAuthorityArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.acmpca.Certificate;
 * import com.pulumi.aws.acmpca.CertificateArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateValidityArgs;
 * import com.pulumi.aws.acmpca.CertificateAuthorityCertificate;
 * import com.pulumi.aws.acmpca.CertificateAuthorityCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var subordinateCertificateAuthority = new CertificateAuthority("subordinateCertificateAuthority", CertificateAuthorityArgs.builder()
 *             .type("SUBORDINATE")
 *             .certificateAuthorityConfiguration(CertificateAuthorityCertificateAuthorityConfigurationArgs.builder()
 *                 .keyAlgorithm("RSA_2048")
 *                 .signingAlgorithm("SHA512WITHRSA")
 *                 .subject(CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs.builder()
 *                     .commonName("sub.example.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var rootCertificateAuthority = new CertificateAuthority("rootCertificateAuthority");
 *         final var current = AwsFunctions.getPartition();
 *         var subordinateCertificate = new Certificate("subordinateCertificate", CertificateArgs.builder()
 *             .certificateAuthorityArn(rootCertificateAuthority.arn())
 *             .certificateSigningRequest(subordinateCertificateAuthority.certificateSigningRequest())
 *             .signingAlgorithm("SHA512WITHRSA")
 *             .templateArn(String.format("arn:%s:acm-pca:::template/SubordinateCACertificate_PathLen0/V1", current.applyValue(getPartitionResult -> getPartitionResult.partition())))
 *             .validity(CertificateValidityArgs.builder()
 *                 .type("YEARS")
 *                 .value(1)
 *                 .build())
 *             .build());
 *         var subordinateCertificateAuthorityCertificate = new CertificateAuthorityCertificate("subordinateCertificateAuthorityCertificate", CertificateAuthorityCertificateArgs.builder()
 *             .certificateAuthorityArn(subordinateCertificateAuthority.arn())
 *             .certificate(subordinateCertificate.certificate())
 *             .certificateChain(subordinateCertificate.certificateChain())
 *             .build());
 *         var rootCertificateAuthorityCertificate = new CertificateAuthorityCertificate("rootCertificateAuthorityCertificate");
 *         var rootCertificate = new Certificate("rootCertificate");
 *     }
 * }
 * ```
 */
public class CertificateAuthorityCertificate internal constructor(
    override val javaResource: com.pulumi.aws.acmpca.CertificateAuthorityCertificate,
) : KotlinCustomResource(javaResource, CertificateAuthorityCertificateMapper) {
    /**
     * PEM-encoded certificate for the Certificate Authority.
     */
    public val certificate: Output<String>
        get() = javaResource.certificate().applyValue({ args0 -> args0 })

    /**
     * ARN of the Certificate Authority.
     */
    public val certificateAuthorityArn: Output<String>
        get() = javaResource.certificateAuthorityArn().applyValue({ args0 -> args0 })

    /**
     * PEM-encoded certificate chain that includes any intermediate certificates and chains up to root CA. Required for subordinate Certificate Authorities. Not allowed for root Certificate Authorities.
     */
    public val certificateChain: Output<String>?
        get() = javaResource.certificateChain().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object CertificateAuthorityCertificateMapper :
    ResourceMapper<CertificateAuthorityCertificate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.acmpca.CertificateAuthorityCertificate::class == javaResource::class

    override fun map(javaResource: Resource): CertificateAuthorityCertificate =
        CertificateAuthorityCertificate(
            javaResource as
                com.pulumi.aws.acmpca.CertificateAuthorityCertificate,
        )
}

/**
 * @see [CertificateAuthorityCertificate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CertificateAuthorityCertificate].
 */
public suspend fun certificateAuthorityCertificate(
    name: String,
    block: suspend CertificateAuthorityCertificateResourceBuilder.() -> Unit,
):
    CertificateAuthorityCertificate {
    val builder = CertificateAuthorityCertificateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CertificateAuthorityCertificate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun certificateAuthorityCertificate(name: String): CertificateAuthorityCertificate {
    val builder = CertificateAuthorityCertificateResourceBuilder()
    builder.name(name)
    return builder.build()
}
