@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin

import com.pulumi.aws.acmpca.CertificateAuthorityCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Associates a certificate with an AWS Certificate Manager Private Certificate Authority (ACM PCA Certificate Authority). An ACM PCA Certificate Authority is unable to issue certificates until it has a certificate associated with it. A root level ACM PCA Certificate Authority is able to self-sign its own root certificate.
 * ## Example Usage
 * ### Self-Signed Root Certificate Authority Certificate
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.acmpca.CertificateAuthority;
 * import com.pulumi.aws.acmpca.CertificateAuthorityArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.acmpca.Certificate;
 * import com.pulumi.aws.acmpca.CertificateArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateValidityArgs;
 * import com.pulumi.aws.acmpca.CertificateAuthorityCertificate;
 * import com.pulumi.aws.acmpca.CertificateAuthorityCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleCertificateAuthority = new CertificateAuthority("exampleCertificateAuthority", CertificateAuthorityArgs.builder()
 *             .type("ROOT")
 *             .certificateAuthorityConfiguration(CertificateAuthorityCertificateAuthorityConfigurationArgs.builder()
 *                 .keyAlgorithm("RSA_4096")
 *                 .signingAlgorithm("SHA512WITHRSA")
 *                 .subject(CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs.builder()
 *                     .commonName("example.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         final var current = AwsFunctions.getPartition();
 *         var exampleCertificate = new Certificate("exampleCertificate", CertificateArgs.builder()
 *             .certificateAuthorityArn(exampleCertificateAuthority.arn())
 *             .certificateSigningRequest(exampleCertificateAuthority.certificateSigningRequest())
 *             .signingAlgorithm("SHA512WITHRSA")
 *             .templateArn(String.format("arn:%s:acm-pca:::template/RootCACertificate/V1", current.applyValue(getPartitionResult -> getPartitionResult.partition())))
 *             .validity(CertificateValidityArgs.builder()
 *                 .type("YEARS")
 *                 .value(1)
 *                 .build())
 *             .build());
 *         var exampleCertificateAuthorityCertificate = new CertificateAuthorityCertificate("exampleCertificateAuthorityCertificate", CertificateAuthorityCertificateArgs.builder()
 *             .certificateAuthorityArn(exampleCertificateAuthority.arn())
 *             .certificate(exampleCertificate.certificate())
 *             .certificateChain(exampleCertificate.certificateChain())
 *             .build());
 *     }
 * }
 * ```
 * ### Certificate for Subordinate Certificate Authority
 * Note that the certificate for the subordinate certificate authority must be issued by the root certificate authority using a signing request from the subordinate certificate authority.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.acmpca.CertificateAuthority;
 * import com.pulumi.aws.acmpca.CertificateAuthorityArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.acmpca.Certificate;
 * import com.pulumi.aws.acmpca.CertificateArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateValidityArgs;
 * import com.pulumi.aws.acmpca.CertificateAuthorityCertificate;
 * import com.pulumi.aws.acmpca.CertificateAuthorityCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var subordinateCertificateAuthority = new CertificateAuthority("subordinateCertificateAuthority", CertificateAuthorityArgs.builder()
 *             .type("SUBORDINATE")
 *             .certificateAuthorityConfiguration(CertificateAuthorityCertificateAuthorityConfigurationArgs.builder()
 *                 .keyAlgorithm("RSA_2048")
 *                 .signingAlgorithm("SHA512WITHRSA")
 *                 .subject(CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs.builder()
 *                     .commonName("sub.example.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var rootCertificateAuthority = new CertificateAuthority("rootCertificateAuthority");
 *         final var current = AwsFunctions.getPartition();
 *         var subordinateCertificate = new Certificate("subordinateCertificate", CertificateArgs.builder()
 *             .certificateAuthorityArn(rootCertificateAuthority.arn())
 *             .certificateSigningRequest(subordinateCertificateAuthority.certificateSigningRequest())
 *             .signingAlgorithm("SHA512WITHRSA")
 *             .templateArn(String.format("arn:%s:acm-pca:::template/SubordinateCACertificate_PathLen0/V1", current.applyValue(getPartitionResult -> getPartitionResult.partition())))
 *             .validity(CertificateValidityArgs.builder()
 *                 .type("YEARS")
 *                 .value(1)
 *                 .build())
 *             .build());
 *         var subordinateCertificateAuthorityCertificate = new CertificateAuthorityCertificate("subordinateCertificateAuthorityCertificate", CertificateAuthorityCertificateArgs.builder()
 *             .certificateAuthorityArn(subordinateCertificateAuthority.arn())
 *             .certificate(subordinateCertificate.certificate())
 *             .certificateChain(subordinateCertificate.certificateChain())
 *             .build());
 *         var rootCertificateAuthorityCertificate = new CertificateAuthorityCertificate("rootCertificateAuthorityCertificate");
 *         var rootCertificate = new Certificate("rootCertificate");
 *     }
 * }
 * ```
 * @property certificate PEM-encoded certificate for the Certificate Authority.
 * @property certificateAuthorityArn ARN of the Certificate Authority.
 * @property certificateChain PEM-encoded certificate chain that includes any intermediate certificates and chains up to root CA. Required for subordinate Certificate Authorities. Not allowed for root Certificate Authorities.
 */
public data class CertificateAuthorityCertificateArgs(
    public val certificate: Output<String>? = null,
    public val certificateAuthorityArn: Output<String>? = null,
    public val certificateChain: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.acmpca.CertificateAuthorityCertificateArgs> {
    override fun toJava(): com.pulumi.aws.acmpca.CertificateAuthorityCertificateArgs =
        com.pulumi.aws.acmpca.CertificateAuthorityCertificateArgs.builder()
            .certificate(certificate?.applyValue({ args0 -> args0 }))
            .certificateAuthorityArn(certificateAuthorityArn?.applyValue({ args0 -> args0 }))
            .certificateChain(certificateChain?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertificateAuthorityCertificateArgs].
 */
@PulumiTagMarker
public class CertificateAuthorityCertificateArgsBuilder internal constructor() {
    private var certificate: Output<String>? = null

    private var certificateAuthorityArn: Output<String>? = null

    private var certificateChain: Output<String>? = null

    /**
     * @param value PEM-encoded certificate for the Certificate Authority.
     */
    @JvmName("gkaypmpgtnpmcrxm")
    public suspend fun certificate(`value`: Output<String>) {
        this.certificate = value
    }

    /**
     * @param value ARN of the Certificate Authority.
     */
    @JvmName("xdibmhbcmnstnxap")
    public suspend fun certificateAuthorityArn(`value`: Output<String>) {
        this.certificateAuthorityArn = value
    }

    /**
     * @param value PEM-encoded certificate chain that includes any intermediate certificates and chains up to root CA. Required for subordinate Certificate Authorities. Not allowed for root Certificate Authorities.
     */
    @JvmName("ojgrqcmrqejrbmdh")
    public suspend fun certificateChain(`value`: Output<String>) {
        this.certificateChain = value
    }

    /**
     * @param value PEM-encoded certificate for the Certificate Authority.
     */
    @JvmName("bgbfgcurmaaqukvp")
    public suspend fun certificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificate = mapped
    }

    /**
     * @param value ARN of the Certificate Authority.
     */
    @JvmName("hvwahwsfgktjwweg")
    public suspend fun certificateAuthorityArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateAuthorityArn = mapped
    }

    /**
     * @param value PEM-encoded certificate chain that includes any intermediate certificates and chains up to root CA. Required for subordinate Certificate Authorities. Not allowed for root Certificate Authorities.
     */
    @JvmName("juqdmxeaiygmjqoi")
    public suspend fun certificateChain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateChain = mapped
    }

    internal fun build(): CertificateAuthorityCertificateArgs = CertificateAuthorityCertificateArgs(
        certificate = certificate,
        certificateAuthorityArn = certificateAuthorityArn,
        certificateChain = certificateChain,
    )
}
