@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin

import com.pulumi.aws.acmpca.PermissionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an AWS Certificate Manager Private Certificate Authorities Permission.
 * Currently, this is only required in order to allow the ACM service to automatically renew certificates issued by a PCA.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.acmpca.CertificateAuthority;
 * import com.pulumi.aws.acmpca.CertificateAuthorityArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs;
 * import com.pulumi.aws.acmpca.Permission;
 * import com.pulumi.aws.acmpca.PermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleCertificateAuthority = new CertificateAuthority("exampleCertificateAuthority", CertificateAuthorityArgs.builder()
 *             .certificateAuthorityConfiguration(CertificateAuthorityCertificateAuthorityConfigurationArgs.builder()
 *                 .keyAlgorithm("RSA_4096")
 *                 .signingAlgorithm("SHA512WITHRSA")
 *                 .subject(CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs.builder()
 *                     .commonName("example.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var examplePermission = new Permission("examplePermission", PermissionArgs.builder()
 *             .certificateAuthorityArn(exampleCertificateAuthority.arn())
 *             .actions(
 *                 "IssueCertificate",
 *                 "GetCertificate",
 *                 "ListPermissions")
 *             .principal("acm.amazonaws.com")
 *             .build());
 *     }
 * }
 * ```
 * @property actions Actions that the specified AWS service principal can use. These include `IssueCertificate`, `GetCertificate`, and `ListPermissions`. Note that in order for ACM to automatically rotate certificates issued by a PCA, it must be granted permission on all 3 actions, as per the example above.
 * @property certificateAuthorityArn ARN of the CA that grants the permissions.
 * @property principal AWS service or identity that receives the permission. At this time, the only valid principal is `acm.amazonaws.com`.
 * @property sourceAccount ID of the calling account
 */
public data class PermissionArgs(
    public val actions: Output<List<String>>? = null,
    public val certificateAuthorityArn: Output<String>? = null,
    public val principal: Output<String>? = null,
    public val sourceAccount: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.acmpca.PermissionArgs> {
    override fun toJava(): com.pulumi.aws.acmpca.PermissionArgs =
        com.pulumi.aws.acmpca.PermissionArgs.builder()
            .actions(actions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .certificateAuthorityArn(certificateAuthorityArn?.applyValue({ args0 -> args0 }))
            .principal(principal?.applyValue({ args0 -> args0 }))
            .sourceAccount(sourceAccount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PermissionArgs].
 */
@PulumiTagMarker
public class PermissionArgsBuilder internal constructor() {
    private var actions: Output<List<String>>? = null

    private var certificateAuthorityArn: Output<String>? = null

    private var principal: Output<String>? = null

    private var sourceAccount: Output<String>? = null

    /**
     * @param value Actions that the specified AWS service principal can use. These include `IssueCertificate`, `GetCertificate`, and `ListPermissions`. Note that in order for ACM to automatically rotate certificates issued by a PCA, it must be granted permission on all 3 actions, as per the example above.
     */
    @JvmName("aenjeatvmaucpebb")
    public suspend fun actions(`value`: Output<List<String>>) {
        this.actions = value
    }

    @JvmName("baewdmpefmkkeivd")
    public suspend fun actions(vararg values: Output<String>) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values Actions that the specified AWS service principal can use. These include `IssueCertificate`, `GetCertificate`, and `ListPermissions`. Note that in order for ACM to automatically rotate certificates issued by a PCA, it must be granted permission on all 3 actions, as per the example above.
     */
    @JvmName("plofajhlbomwmdxr")
    public suspend fun actions(values: List<Output<String>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value ARN of the CA that grants the permissions.
     */
    @JvmName("kbxafaqpmbidrfkx")
    public suspend fun certificateAuthorityArn(`value`: Output<String>) {
        this.certificateAuthorityArn = value
    }

    /**
     * @param value AWS service or identity that receives the permission. At this time, the only valid principal is `acm.amazonaws.com`.
     */
    @JvmName("rpnfyqqheyfajpqa")
    public suspend fun principal(`value`: Output<String>) {
        this.principal = value
    }

    /**
     * @param value ID of the calling account
     */
    @JvmName("yyqcwruewcpmvici")
    public suspend fun sourceAccount(`value`: Output<String>) {
        this.sourceAccount = value
    }

    /**
     * @param value Actions that the specified AWS service principal can use. These include `IssueCertificate`, `GetCertificate`, and `ListPermissions`. Note that in order for ACM to automatically rotate certificates issued by a PCA, it must be granted permission on all 3 actions, as per the example above.
     */
    @JvmName("ononjfiowpesydwc")
    public suspend fun actions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param values Actions that the specified AWS service principal can use. These include `IssueCertificate`, `GetCertificate`, and `ListPermissions`. Note that in order for ACM to automatically rotate certificates issued by a PCA, it must be granted permission on all 3 actions, as per the example above.
     */
    @JvmName("eccajmcfsxhuechn")
    public suspend fun actions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value ARN of the CA that grants the permissions.
     */
    @JvmName("siiapqmianlemgfr")
    public suspend fun certificateAuthorityArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateAuthorityArn = mapped
    }

    /**
     * @param value AWS service or identity that receives the permission. At this time, the only valid principal is `acm.amazonaws.com`.
     */
    @JvmName("mytkctxnsiedklov")
    public suspend fun principal(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principal = mapped
    }

    /**
     * @param value ID of the calling account
     */
    @JvmName("utcmcogbyywjchfj")
    public suspend fun sourceAccount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAccount = mapped
    }

    internal fun build(): PermissionArgs = PermissionArgs(
        actions = actions,
        certificateAuthorityArn = certificateAuthorityArn,
        principal = principal,
        sourceAccount = sourceAccount,
    )
}
