@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Policy].
 */
@PulumiTagMarker
public class PolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyArgs = PolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyArgsBuilder.() -> Unit) {
        val builder = PolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Policy {
        val builtJavaResource = com.pulumi.aws.acmpca.Policy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Policy(builtJavaResource)
    }
}

/**
 * Attaches a resource based policy to a private CA.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.acmpca.Policy;
 * import com.pulumi.aws.acmpca.PolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("1")
 *                     .effect("Allow")
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("AWS")
 *                         .identifiers(data.aws_caller_identity().current().account_id())
 *                         .build())
 *                     .actions(
 *                         "acm-pca:DescribeCertificateAuthority",
 *                         "acm-pca:GetCertificate",
 *                         "acm-pca:GetCertificateAuthorityCertificate",
 *                         "acm-pca:ListPermissions",
 *                         "acm-pca:ListTags")
 *                     .resources(aws_acmpca_certificate_authority.example().arn())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("2")
 *                     .effect(Allow)
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("AWS")
 *                         .identifiers(data.aws_caller_identity().current().account_id())
 *                         .build())
 *                     .actions("acm-pca:IssueCertificate")
 *                     .resources(aws_acmpca_certificate_authority.example().arn())
 *                     .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("StringEquals")
 *                         .variable("acm-pca:TemplateArn")
 *                         .values("arn:aws:acm-pca:::template/EndEntityCertificate/V1")
 *                         .build())
 *                     .build())
 *             .build());
 *         var examplePolicy = new Policy("examplePolicy", PolicyArgs.builder()
 *             .resourceArn(aws_acmpca_certificate_authority.example().arn())
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_acmpca_policy` using the `resource_arn` value. For example:
 * ```sh
 *  $ pulumi import aws:acmpca/policy:Policy example arn:aws:acm-pca:us-east-1:123456789012:certificate-authority/12345678-1234-1234-1234-123456789012
 * ```
 *
 */
public class Policy internal constructor(
    override val javaResource: com.pulumi.aws.acmpca.Policy,
) : KotlinCustomResource(javaResource, PolicyMapper) {
    /**
     * JSON-formatted IAM policy to attach to the specified private CA resource.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * ARN of the private CA to associate with the policy.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })
}

public object PolicyMapper : ResourceMapper<Policy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.acmpca.Policy::class == javaResource::class

    override fun map(javaResource: Resource): Policy = Policy(
        javaResource as
            com.pulumi.aws.acmpca.Policy,
    )
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Policy].
 */
public suspend fun policy(name: String, block: suspend PolicyResourceBuilder.() -> Unit): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policy(name: String): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
