@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin

import com.pulumi.aws.acmpca.PolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Attaches a resource based policy to a private CA.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.acmpca.Policy;
 * import com.pulumi.aws.acmpca.PolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("1")
 *                     .effect("Allow")
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("AWS")
 *                         .identifiers(data.aws_caller_identity().current().account_id())
 *                         .build())
 *                     .actions(
 *                         "acm-pca:DescribeCertificateAuthority",
 *                         "acm-pca:GetCertificate",
 *                         "acm-pca:GetCertificateAuthorityCertificate",
 *                         "acm-pca:ListPermissions",
 *                         "acm-pca:ListTags")
 *                     .resources(aws_acmpca_certificate_authority.example().arn())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .sid("2")
 *                     .effect(Allow)
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("AWS")
 *                         .identifiers(data.aws_caller_identity().current().account_id())
 *                         .build())
 *                     .actions("acm-pca:IssueCertificate")
 *                     .resources(aws_acmpca_certificate_authority.example().arn())
 *                     .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                         .test("StringEquals")
 *                         .variable("acm-pca:TemplateArn")
 *                         .values("arn:aws:acm-pca:::template/EndEntityCertificate/V1")
 *                         .build())
 *                     .build())
 *             .build());
 *         var examplePolicy = new Policy("examplePolicy", PolicyArgs.builder()
 *             .resourceArn(aws_acmpca_certificate_authority.example().arn())
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_acmpca_policy` using the `resource_arn` value. For example:
 * ```sh
 *  $ pulumi import aws:acmpca/policy:Policy example arn:aws:acm-pca:us-east-1:123456789012:certificate-authority/12345678-1234-1234-1234-123456789012
 * ```
 * @property policy JSON-formatted IAM policy to attach to the specified private CA resource.
 * @property resourceArn ARN of the private CA to associate with the policy.
 */
public data class PolicyArgs(
    public val policy: Output<String>? = null,
    public val resourceArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.acmpca.PolicyArgs> {
    override fun toJava(): com.pulumi.aws.acmpca.PolicyArgs =
        com.pulumi.aws.acmpca.PolicyArgs.builder()
            .policy(policy?.applyValue({ args0 -> args0 }))
            .resourceArn(resourceArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyArgs].
 */
@PulumiTagMarker
public class PolicyArgsBuilder internal constructor() {
    private var policy: Output<String>? = null

    private var resourceArn: Output<String>? = null

    /**
     * @param value JSON-formatted IAM policy to attach to the specified private CA resource.
     */
    @JvmName("vvldhpvgmvxodrhs")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value ARN of the private CA to associate with the policy.
     */
    @JvmName("lkgeqyfdimyebjee")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value JSON-formatted IAM policy to attach to the specified private CA resource.
     */
    @JvmName("bmmymmvdcrxkysep")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value ARN of the private CA to associate with the policy.
     */
    @JvmName("mudxeqlvnpmmlywl")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    internal fun build(): PolicyArgs = PolicyArgs(
        policy = policy,
        resourceArn = resourceArn,
    )
}
