@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin.inputs

import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property keyAlgorithm Type of the public key algorithm and size, in bits, of the key pair that your key pair creates when it issues a certificate. Valid values can be found in the [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CertificateAuthorityConfiguration.html).
 * @property signingAlgorithm Name of the algorithm your private CA uses to sign certificate requests. Valid values can be found in the [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CertificateAuthorityConfiguration.html).
 * @property subject Nested argument that contains X.500 distinguished name information. At least one nested attribute must be specified.
 */
public data class CertificateAuthorityCertificateAuthorityConfigurationArgs(
    public val keyAlgorithm: Output<String>,
    public val signingAlgorithm: Output<String>,
    public val subject: Output<CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationArgs =
        com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationArgs.builder()
            .keyAlgorithm(keyAlgorithm.applyValue({ args0 -> args0 }))
            .signingAlgorithm(signingAlgorithm.applyValue({ args0 -> args0 }))
            .subject(subject.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CertificateAuthorityCertificateAuthorityConfigurationArgs].
 */
@PulumiTagMarker
public class CertificateAuthorityCertificateAuthorityConfigurationArgsBuilder internal constructor() {
    private var keyAlgorithm: Output<String>? = null

    private var signingAlgorithm: Output<String>? = null

    private var subject: Output<CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs>? =
        null

    /**
     * @param value Type of the public key algorithm and size, in bits, of the key pair that your key pair creates when it issues a certificate. Valid values can be found in the [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CertificateAuthorityConfiguration.html).
     */
    @JvmName("ppxwbcqxrbrsscnk")
    public suspend fun keyAlgorithm(`value`: Output<String>) {
        this.keyAlgorithm = value
    }

    /**
     * @param value Name of the algorithm your private CA uses to sign certificate requests. Valid values can be found in the [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CertificateAuthorityConfiguration.html).
     */
    @JvmName("mcilvdrayithmnis")
    public suspend fun signingAlgorithm(`value`: Output<String>) {
        this.signingAlgorithm = value
    }

    /**
     * @param value Nested argument that contains X.500 distinguished name information. At least one nested attribute must be specified.
     */
    @JvmName("vmaxpqpwdcemvwme")
    public suspend
    fun subject(`value`: Output<CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs>) {
        this.subject = value
    }

    /**
     * @param value Type of the public key algorithm and size, in bits, of the key pair that your key pair creates when it issues a certificate. Valid values can be found in the [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CertificateAuthorityConfiguration.html).
     */
    @JvmName("wbkradgvrlyaevcj")
    public suspend fun keyAlgorithm(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyAlgorithm = mapped
    }

    /**
     * @param value Name of the algorithm your private CA uses to sign certificate requests. Valid values can be found in the [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CertificateAuthorityConfiguration.html).
     */
    @JvmName("ufpfxxgsmgpavcvw")
    public suspend fun signingAlgorithm(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.signingAlgorithm = mapped
    }

    /**
     * @param value Nested argument that contains X.500 distinguished name information. At least one nested attribute must be specified.
     */
    @JvmName("ltlkqbdeoepkwskk")
    public suspend
    fun subject(`value`: CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subject = mapped
    }

    /**
     * @param argument Nested argument that contains X.500 distinguished name information. At least one nested attribute must be specified.
     */
    @JvmName("lygflsqjswojjdwu")
    public suspend
    fun subject(argument: suspend CertificateAuthorityCertificateAuthorityConfigurationSubjectArgsBuilder.() -> Unit) {
        val toBeMapped =
            CertificateAuthorityCertificateAuthorityConfigurationSubjectArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.subject = mapped
    }

    internal fun build(): CertificateAuthorityCertificateAuthorityConfigurationArgs =
        CertificateAuthorityCertificateAuthorityConfigurationArgs(
            keyAlgorithm = keyAlgorithm ?: throw PulumiNullFieldException("keyAlgorithm"),
            signingAlgorithm = signingAlgorithm ?: throw PulumiNullFieldException("signingAlgorithm"),
            subject = subject ?: throw PulumiNullFieldException("subject"),
        )
}
