@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin.inputs

import com.pulumi.aws.acmpca.inputs.CertificateAuthorityRevocationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property crlConfiguration Nested argument containing configuration of the certificate revocation list (CRL), if any, maintained by the certificate authority. Defined below.
 * @property ocspConfiguration Nested argument containing configuration of
 * the custom OCSP responder endpoint. Defined below.
 */
public data class CertificateAuthorityRevocationConfigurationArgs(
    public val crlConfiguration:
    Output<CertificateAuthorityRevocationConfigurationCrlConfigurationArgs>? = null,
    public val ocspConfiguration:
    Output<CertificateAuthorityRevocationConfigurationOcspConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.acmpca.inputs.CertificateAuthorityRevocationConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.acmpca.inputs.CertificateAuthorityRevocationConfigurationArgs =
        com.pulumi.aws.acmpca.inputs.CertificateAuthorityRevocationConfigurationArgs.builder()
            .crlConfiguration(crlConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ocspConfiguration(
                ocspConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [CertificateAuthorityRevocationConfigurationArgs].
 */
@PulumiTagMarker
public class CertificateAuthorityRevocationConfigurationArgsBuilder internal constructor() {
    private var crlConfiguration:
        Output<CertificateAuthorityRevocationConfigurationCrlConfigurationArgs>? = null

    private var ocspConfiguration:
        Output<CertificateAuthorityRevocationConfigurationOcspConfigurationArgs>? = null

    /**
     * @param value Nested argument containing configuration of the certificate revocation list (CRL), if any, maintained by the certificate authority. Defined below.
     */
    @JvmName("pbefomshmmdwghmt")
    public suspend
    fun crlConfiguration(`value`: Output<CertificateAuthorityRevocationConfigurationCrlConfigurationArgs>) {
        this.crlConfiguration = value
    }

    /**
     * @param value Nested argument containing configuration of
     * the custom OCSP responder endpoint. Defined below.
     */
    @JvmName("ugmwjmggrdweoejk")
    public suspend
    fun ocspConfiguration(`value`: Output<CertificateAuthorityRevocationConfigurationOcspConfigurationArgs>) {
        this.ocspConfiguration = value
    }

    /**
     * @param value Nested argument containing configuration of the certificate revocation list (CRL), if any, maintained by the certificate authority. Defined below.
     */
    @JvmName("xjjvxwofxsmexamd")
    public suspend
    fun crlConfiguration(`value`: CertificateAuthorityRevocationConfigurationCrlConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crlConfiguration = mapped
    }

    /**
     * @param argument Nested argument containing configuration of the certificate revocation list (CRL), if any, maintained by the certificate authority. Defined below.
     */
    @JvmName("cbrvahfbuiksqbbv")
    public suspend
    fun crlConfiguration(argument: suspend CertificateAuthorityRevocationConfigurationCrlConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            CertificateAuthorityRevocationConfigurationCrlConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.crlConfiguration = mapped
    }

    /**
     * @param value Nested argument containing configuration of
     * the custom OCSP responder endpoint. Defined below.
     */
    @JvmName("dgkexdfrdfqdtfoh")
    public suspend
    fun ocspConfiguration(`value`: CertificateAuthorityRevocationConfigurationOcspConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ocspConfiguration = mapped
    }

    /**
     * @param argument Nested argument containing configuration of
     * the custom OCSP responder endpoint. Defined below.
     */
    @JvmName("ccwpqiqvphsdilox")
    public suspend
    fun ocspConfiguration(argument: suspend CertificateAuthorityRevocationConfigurationOcspConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            CertificateAuthorityRevocationConfigurationOcspConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ocspConfiguration = mapped
    }

    internal fun build(): CertificateAuthorityRevocationConfigurationArgs =
        CertificateAuthorityRevocationConfigurationArgs(
            crlConfiguration = crlConfiguration,
            ocspConfiguration = ocspConfiguration,
        )
}
