@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin.inputs

import com.pulumi.aws.acmpca.inputs.CertificateValidityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type Determines how `value` is interpreted. Valid values: `DAYS`, `MONTHS`, `YEARS`, `ABSOLUTE`, `END_DATE`.
 * @property value If `type` is `DAYS`, `MONTHS`, or `YEARS`, the relative time until the certificate expires. If `type` is `ABSOLUTE`, the date in seconds since the Unix epoch. If `type` is `END_DATE`, the  date in RFC 3339 format.
 */
public data class CertificateValidityArgs(
    public val type: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.acmpca.inputs.CertificateValidityArgs> {
    override fun toJava(): com.pulumi.aws.acmpca.inputs.CertificateValidityArgs =
        com.pulumi.aws.acmpca.inputs.CertificateValidityArgs.builder()
            .type(type.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertificateValidityArgs].
 */
@PulumiTagMarker
public class CertificateValidityArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Determines how `value` is interpreted. Valid values: `DAYS`, `MONTHS`, `YEARS`, `ABSOLUTE`, `END_DATE`.
     */
    @JvmName("wwigpmnycuokrtxw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value If `type` is `DAYS`, `MONTHS`, or `YEARS`, the relative time until the certificate expires. If `type` is `ABSOLUTE`, the date in seconds since the Unix epoch. If `type` is `END_DATE`, the  date in RFC 3339 format.
     */
    @JvmName("qucqcwqlnjjitdkg")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Determines how `value` is interpreted. Valid values: `DAYS`, `MONTHS`, `YEARS`, `ABSOLUTE`, `END_DATE`.
     */
    @JvmName("opkyghrqtmedkvcb")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value If `type` is `DAYS`, `MONTHS`, or `YEARS`, the relative time until the certificate expires. If `type` is `ABSOLUTE`, the date in seconds since the Unix epoch. If `type` is `END_DATE`, the  date in RFC 3339 format.
     */
    @JvmName("gxbvpedfusyatujf")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): CertificateValidityArgs = CertificateValidityArgs(
        type = type ?: throw PulumiNullFieldException("type"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
