@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property commonName Fully qualified domain name (FQDN) associated with the certificate subject. Must be less than or equal to 64 characters in length.
 * @property country Two digit code that specifies the country in which the certificate subject located. Must be less than or equal to 2 characters in length.
 * @property distinguishedNameQualifier Disambiguating information for the certificate subject. Must be less than or equal to 64 characters in length.
 * @property generationQualifier Typically a qualifier appended to the name of an individual. Examples include Jr. for junior, Sr. for senior, and III for third. Must be less than or equal to 3 characters in length.
 * @property givenName First name. Must be less than or equal to 16 characters in length.
 * @property initials Concatenation that typically contains the first letter of the `given_name`, the first letter of the middle name if one exists, and the first letter of the `surname`. Must be less than or equal to 5 characters in length.
 * @property locality Locality (such as a city or town) in which the certificate subject is located. Must be less than or equal to 128 characters in length.
 * @property organization Legal name of the organization with which the certificate subject is affiliated. Must be less than or equal to 64 characters in length.
 * @property organizationalUnit Subdivision or unit of the organization (such as sales or finance) with which the certificate subject is affiliated. Must be less than or equal to 64 characters in length.
 * @property pseudonym Typically a shortened version of a longer `given_name`. For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth, Liz, or Eliza. Must be less than or equal to 128 characters in length.
 * @property state State in which the subject of the certificate is located. Must be less than or equal to 128 characters in length.
 * @property surname Family name. In the US and the UK for example, the surname of an individual is ordered last. In Asian cultures the surname is typically ordered first. Must be less than or equal to 40 characters in length.
 * @property title Title such as Mr. or Ms. which is pre-pended to the name to refer formally to the certificate subject. Must be less than or equal to 64 characters in length.
 */
public data class CertificateAuthorityCertificateAuthorityConfigurationSubject(
    public val commonName: String? = null,
    public val country: String? = null,
    public val distinguishedNameQualifier: String? = null,
    public val generationQualifier: String? = null,
    public val givenName: String? = null,
    public val initials: String? = null,
    public val locality: String? = null,
    public val organization: String? = null,
    public val organizationalUnit: String? = null,
    public val pseudonym: String? = null,
    public val state: String? = null,
    public val surname: String? = null,
    public val title: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.acmpca.outputs.CertificateAuthorityCertificateAuthorityConfigurationSubject):
            CertificateAuthorityCertificateAuthorityConfigurationSubject =
            CertificateAuthorityCertificateAuthorityConfigurationSubject(
                commonName = javaType.commonName().map({ args0 -> args0 }).orElse(null),
                country = javaType.country().map({ args0 -> args0 }).orElse(null),
                distinguishedNameQualifier = javaType.distinguishedNameQualifier().map({ args0 ->
                    args0
                }).orElse(null),
                generationQualifier = javaType.generationQualifier().map({ args0 -> args0 }).orElse(null),
                givenName = javaType.givenName().map({ args0 -> args0 }).orElse(null),
                initials = javaType.initials().map({ args0 -> args0 }).orElse(null),
                locality = javaType.locality().map({ args0 -> args0 }).orElse(null),
                organization = javaType.organization().map({ args0 -> args0 }).orElse(null),
                organizationalUnit = javaType.organizationalUnit().map({ args0 -> args0 }).orElse(null),
                pseudonym = javaType.pseudonym().map({ args0 -> args0 }).orElse(null),
                state = javaType.state().map({ args0 -> args0 }).orElse(null),
                surname = javaType.surname().map({ args0 -> args0 }).orElse(null),
                title = javaType.title().map({ args0 -> args0 }).orElse(null),
            )
    }
}
