@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getCertificateAuthority.
 * @property arn
 * @property certificate Base64-encoded certificate authority (CA) certificate. Only available after the certificate authority certificate has been imported.
 * @property certificateChain Base64-encoded certificate chain that includes any intermediate certificates and chains up to root on-premises certificate that you used to sign your private CA certificate. The chain does not include your private CA certificate. Only available after the certificate authority certificate has been imported.
 * @property certificateSigningRequest The base64 PEM-encoded certificate signing request (CSR) for your private CA certificate.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property keyStorageSecurityStandard
 * @property notAfter Date and time after which the certificate authority is not valid. Only available after the certificate authority certificate has been imported.
 * @property notBefore Date and time before which the certificate authority is not valid. Only available after the certificate authority certificate has been imported.
 * @property revocationConfigurations Nested attribute containing revocation configuration.
 * * `revocation_configuration.0.crl_configuration` - Nested attribute containing configuration of the certificate revocation list (CRL), if any, maintained by the certificate authority.
 * * `revocation_configuration.0.crl_configuration.0.custom_cname` - Name inserted into the certificate CRL Distribution Points extension that enables the use of an alias for the CRL distribution point.
 * * `revocation_configuration.0.crl_configuration.0.enabled` - Boolean value that specifies whether certificate revocation lists (CRLs) are enabled.
 * * `revocation_configuration.0.crl_configuration.0.expiration_in_days` - Number of days until a certificate expires.
 * * `revocation_configuration.0.crl_configuration.0.s3_bucket_name` - Name of the S3 bucket that contains the CRL.
 * * `revocation_configuration.0.crl_configuration.0.s3_object_acl` - Whether the CRL is publicly readable or privately held in the CRL Amazon S3 bucket.
 * * `revocation_configuration.0.ocsp_configuration.0.enabled` - Boolean value that specifies whether a custom OCSP responder is enabled.
 * * `revocation_configuration.0.ocsp_configuration.0.ocsp_custom_cname` - A CNAME specifying a customized OCSP domain.
 * @property serial Serial number of the certificate authority. Only available after the certificate authority certificate has been imported.
 * @property status Status of the certificate authority.
 * @property tags Key-value map of user-defined tags that are attached to the certificate authority.
 * @property type Type of the certificate authority.
 * @property usageMode Specifies whether the CA issues general-purpose certificates that typically require a revocation mechanism, or short-lived certificates that may optionally omit revocation because they expire quickly.
 */
public data class GetCertificateAuthorityResult(
    public val arn: String,
    public val certificate: String,
    public val certificateChain: String,
    public val certificateSigningRequest: String,
    public val id: String,
    public val keyStorageSecurityStandard: String,
    public val notAfter: String,
    public val notBefore: String,
    public val revocationConfigurations: List<GetCertificateAuthorityRevocationConfiguration>,
    public val serial: String,
    public val status: String,
    public val tags: Map<String, String>,
    public val type: String,
    public val usageMode: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.acmpca.outputs.GetCertificateAuthorityResult):
            GetCertificateAuthorityResult = GetCertificateAuthorityResult(
            arn = javaType.arn(),
            certificate = javaType.certificate(),
            certificateChain = javaType.certificateChain(),
            certificateSigningRequest = javaType.certificateSigningRequest(),
            id = javaType.id(),
            keyStorageSecurityStandard = javaType.keyStorageSecurityStandard(),
            notAfter = javaType.notAfter(),
            notBefore = javaType.notBefore(),
            revocationConfigurations = javaType.revocationConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.acmpca.kotlin.outputs.GetCertificateAuthorityRevocationConfiguration.Companion.toKotlin(args0)
                })
            }),
            serial = javaType.serial(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            usageMode = javaType.usageMode(),
        )
    }
}
