@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin

import com.pulumi.aws.alb.ListenerArgs.builder
import com.pulumi.aws.alb.kotlin.inputs.ListenerDefaultActionArgs
import com.pulumi.aws.alb.kotlin.inputs.ListenerDefaultActionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Load Balancer Listener resource.
 * > **Note:** `aws.alb.Listener` is known as `aws.lb.Listener`. The functionality is identical.
 * ## Example Usage
 * ### Forward Action
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.LoadBalancer;
 * import com.pulumi.aws.lb.TargetGroup;
 * import com.pulumi.aws.lb.Listener;
 * import com.pulumi.aws.lb.ListenerArgs;
 * import com.pulumi.aws.lb.inputs.ListenerDefaultActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var frontEndLoadBalancer = new LoadBalancer("frontEndLoadBalancer");
 *         var frontEndTargetGroup = new TargetGroup("frontEndTargetGroup");
 *         var frontEndListener = new Listener("frontEndListener", ListenerArgs.builder()
 *             .loadBalancerArn(frontEndLoadBalancer.arn())
 *             .port("443")
 *             .protocol("HTTPS")
 *             .sslPolicy("ELBSecurityPolicy-2016-08")
 *             .certificateArn("arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4")
 *             .defaultActions(ListenerDefaultActionArgs.builder()
 *                 .type("forward")
 *                 .targetGroupArn(frontEndTargetGroup.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Redirect Action
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.LoadBalancer;
 * import com.pulumi.aws.lb.Listener;
 * import com.pulumi.aws.lb.ListenerArgs;
 * import com.pulumi.aws.lb.inputs.ListenerDefaultActionArgs;
 * import com.pulumi.aws.lb.inputs.ListenerDefaultActionRedirectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var frontEndLoadBalancer = new LoadBalancer("frontEndLoadBalancer");
 *         var frontEndListener = new Listener("frontEndListener", ListenerArgs.builder()
 *             .loadBalancerArn(frontEndLoadBalancer.arn())
 *             .port("80")
 *             .protocol("HTTP")
 *             .defaultActions(ListenerDefaultActionArgs.builder()
 *                 .type("redirect")
 *                 .redirect(ListenerDefaultActionRedirectArgs.builder()
 *                     .port("443")
 *                     .protocol("HTTPS")
 *                     .statusCode("HTTP_301")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Fixed-response Action
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.LoadBalancer;
 * import com.pulumi.aws.lb.Listener;
 * import com.pulumi.aws.lb.ListenerArgs;
 * import com.pulumi.aws.lb.inputs.ListenerDefaultActionArgs;
 * import com.pulumi.aws.lb.inputs.ListenerDefaultActionFixedResponseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var frontEndLoadBalancer = new LoadBalancer("frontEndLoadBalancer");
 *         var frontEndListener = new Listener("frontEndListener", ListenerArgs.builder()
 *             .loadBalancerArn(frontEndLoadBalancer.arn())
 *             .port("80")
 *             .protocol("HTTP")
 *             .defaultActions(ListenerDefaultActionArgs.builder()
 *                 .type("fixed-response")
 *                 .fixedResponse(ListenerDefaultActionFixedResponseArgs.builder()
 *                     .contentType("text/plain")
 *                     .messageBody("Fixed response content")
 *                     .statusCode("200")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Authenticate-cognito Action
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.LoadBalancer;
 * import com.pulumi.aws.lb.TargetGroup;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolClient;
 * import com.pulumi.aws.cognito.UserPoolDomain;
 * import com.pulumi.aws.lb.Listener;
 * import com.pulumi.aws.lb.ListenerArgs;
 * import com.pulumi.aws.lb.inputs.ListenerDefaultActionArgs;
 * import com.pulumi.aws.lb.inputs.ListenerDefaultActionAuthenticateCognitoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var frontEndLoadBalancer = new LoadBalancer("frontEndLoadBalancer");
 *         var frontEndTargetGroup = new TargetGroup("frontEndTargetGroup");
 *         var pool = new UserPool("pool");
 *         var client = new UserPoolClient("client");
 *         var domain = new UserPoolDomain("domain");
 *         var frontEndListener = new Listener("frontEndListener", ListenerArgs.builder()
 *             .loadBalancerArn(frontEndLoadBalancer.arn())
 *             .port("80")
 *             .protocol("HTTP")
 *             .defaultActions(
 *                 ListenerDefaultActionArgs.builder()
 *                     .type("authenticate-cognito")
 *                     .authenticateCognito(ListenerDefaultActionAuthenticateCognitoArgs.builder()
 *                         .userPoolArn(pool.arn())
 *                         .userPoolClientId(client.id())
 *                         .userPoolDomain(domain.domain())
 *                         .build())
 *                     .build(),
 *                 ListenerDefaultActionArgs.builder()
 *                     .type("forward")
 *                     .targetGroupArn(frontEndTargetGroup.arn())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Authenticate-OIDC Action
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.LoadBalancer;
 * import com.pulumi.aws.lb.TargetGroup;
 * import com.pulumi.aws.lb.Listener;
 * import com.pulumi.aws.lb.ListenerArgs;
 * import com.pulumi.aws.lb.inputs.ListenerDefaultActionArgs;
 * import com.pulumi.aws.lb.inputs.ListenerDefaultActionAuthenticateOidcArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var frontEndLoadBalancer = new LoadBalancer("frontEndLoadBalancer");
 *         var frontEndTargetGroup = new TargetGroup("frontEndTargetGroup");
 *         var frontEndListener = new Listener("frontEndListener", ListenerArgs.builder()
 *             .loadBalancerArn(frontEndLoadBalancer.arn())
 *             .port("80")
 *             .protocol("HTTP")
 *             .defaultActions(
 *                 ListenerDefaultActionArgs.builder()
 *                     .type("authenticate-oidc")
 *                     .authenticateOidc(ListenerDefaultActionAuthenticateOidcArgs.builder()
 *                         .authorizationEndpoint("https://example.com/authorization_endpoint")
 *                         .clientId("client_id")
 *                         .clientSecret("client_secret")
 *                         .issuer("https://example.com")
 *                         .tokenEndpoint("https://example.com/token_endpoint")
 *                         .userInfoEndpoint("https://example.com/user_info_endpoint")
 *                         .build())
 *                     .build(),
 *                 ListenerDefaultActionArgs.builder()
 *                     .type("forward")
 *                     .targetGroupArn(frontEndTargetGroup.arn())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Gateway Load Balancer Listener
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.LoadBalancer;
 * import com.pulumi.aws.lb.LoadBalancerArgs;
 * import com.pulumi.aws.lb.inputs.LoadBalancerSubnetMappingArgs;
 * import com.pulumi.aws.lb.TargetGroup;
 * import com.pulumi.aws.lb.TargetGroupArgs;
 * import com.pulumi.aws.lb.inputs.TargetGroupHealthCheckArgs;
 * import com.pulumi.aws.lb.Listener;
 * import com.pulumi.aws.lb.ListenerArgs;
 * import com.pulumi.aws.lb.inputs.ListenerDefaultActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLoadBalancer = new LoadBalancer("exampleLoadBalancer", LoadBalancerArgs.builder()
 *             .loadBalancerType("gateway")
 *             .subnetMappings(LoadBalancerSubnetMappingArgs.builder()
 *                 .subnetId(aws_subnet.example().id())
 *                 .build())
 *             .build());
 *         var exampleTargetGroup = new TargetGroup("exampleTargetGroup", TargetGroupArgs.builder()
 *             .port(6081)
 *             .protocol("GENEVE")
 *             .vpcId(aws_vpc.example().id())
 *             .healthCheck(TargetGroupHealthCheckArgs.builder()
 *                 .port(80)
 *                 .protocol("HTTP")
 *                 .build())
 *             .build());
 *         var exampleListener = new Listener("exampleListener", ListenerArgs.builder()
 *             .loadBalancerArn(exampleLoadBalancer.id())
 *             .defaultActions(ListenerDefaultActionArgs.builder()
 *                 .targetGroupArn(exampleTargetGroup.id())
 *                 .type("forward")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import listeners using their ARN. For example:
 * ```sh
 *  $ pulumi import aws:alb/listener:Listener front_end arn:aws:elasticloadbalancing:us-west-2:187416307283:listener/app/front-end-alb/8e4497da625e2d8a/9ab28ade35828f96
 * ```
 * @property alpnPolicy Name of the Application-Layer Protocol Negotiation (ALPN) policy. Can be set if `protocol` is `TLS`. Valid values are `HTTP1Only`, `HTTP2Only`, `HTTP2Optional`, `HTTP2Preferred`, and `None`.
 * @property certificateArn ARN of the default SSL server certificate. Exactly one certificate is required if the protocol is HTTPS. For adding additional SSL certificates, see the `aws.lb.ListenerCertificate` resource.
 * @property defaultActions Configuration block for default actions. Detailed below.
 * @property loadBalancerArn ARN of the load balancer.
 * The following arguments are optional:
 * @property port Port on which the load balancer is listening. Not valid for Gateway Load Balancers.
 * @property protocol Protocol for connections from clients to the load balancer. For Application Load Balancers, valid values are `HTTP` and `HTTPS`, with a default of `HTTP`. For Network Load Balancers, valid values are `TCP`, `TLS`, `UDP`, and `TCP_UDP`. Not valid to use `UDP` or `TCP_UDP` if dual-stack mode is enabled. Not valid for Gateway Load Balancers.
 * @property sslPolicy Name of the SSL Policy for the listener. Required if `protocol` is `HTTPS` or `TLS`.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * > **NOTE::** Please note that listeners that are attached to Application Load Balancers must use either `HTTP` or `HTTPS` protocols while listeners that are attached to Network Load Balancers must use the `TCP` protocol.
 */
public data class ListenerArgs(
    public val alpnPolicy: Output<String>? = null,
    public val certificateArn: Output<String>? = null,
    public val defaultActions: Output<List<ListenerDefaultActionArgs>>? = null,
    public val loadBalancerArn: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val protocol: Output<String>? = null,
    public val sslPolicy: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.alb.ListenerArgs> {
    override fun toJava(): com.pulumi.aws.alb.ListenerArgs = com.pulumi.aws.alb.ListenerArgs.builder()
        .alpnPolicy(alpnPolicy?.applyValue({ args0 -> args0 }))
        .certificateArn(certificateArn?.applyValue({ args0 -> args0 }))
        .defaultActions(
            defaultActions?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .loadBalancerArn(loadBalancerArn?.applyValue({ args0 -> args0 }))
        .port(port?.applyValue({ args0 -> args0 }))
        .protocol(protocol?.applyValue({ args0 -> args0 }))
        .sslPolicy(sslPolicy?.applyValue({ args0 -> args0 }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [ListenerArgs].
 */
@PulumiTagMarker
public class ListenerArgsBuilder internal constructor() {
    private var alpnPolicy: Output<String>? = null

    private var certificateArn: Output<String>? = null

    private var defaultActions: Output<List<ListenerDefaultActionArgs>>? = null

    private var loadBalancerArn: Output<String>? = null

    private var port: Output<Int>? = null

    private var protocol: Output<String>? = null

    private var sslPolicy: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the Application-Layer Protocol Negotiation (ALPN) policy. Can be set if `protocol` is `TLS`. Valid values are `HTTP1Only`, `HTTP2Only`, `HTTP2Optional`, `HTTP2Preferred`, and `None`.
     */
    @JvmName("oxvkooncgtseofbv")
    public suspend fun alpnPolicy(`value`: Output<String>) {
        this.alpnPolicy = value
    }

    /**
     * @param value ARN of the default SSL server certificate. Exactly one certificate is required if the protocol is HTTPS. For adding additional SSL certificates, see the `aws.lb.ListenerCertificate` resource.
     */
    @JvmName("epylyihjiuurocpf")
    public suspend fun certificateArn(`value`: Output<String>) {
        this.certificateArn = value
    }

    /**
     * @param value Configuration block for default actions. Detailed below.
     */
    @JvmName("advfgjxlvtrnjlfb")
    public suspend fun defaultActions(`value`: Output<List<ListenerDefaultActionArgs>>) {
        this.defaultActions = value
    }

    @JvmName("taycxtefhmkgquoo")
    public suspend fun defaultActions(vararg values: Output<ListenerDefaultActionArgs>) {
        this.defaultActions = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for default actions. Detailed below.
     */
    @JvmName("xkixkschwofsnoqu")
    public suspend fun defaultActions(values: List<Output<ListenerDefaultActionArgs>>) {
        this.defaultActions = Output.all(values)
    }

    /**
     * @param value ARN of the load balancer.
     * The following arguments are optional:
     */
    @JvmName("raesfljeultcijau")
    public suspend fun loadBalancerArn(`value`: Output<String>) {
        this.loadBalancerArn = value
    }

    /**
     * @param value Port on which the load balancer is listening. Not valid for Gateway Load Balancers.
     */
    @JvmName("ovriimxdyrxhhfmy")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Protocol for connections from clients to the load balancer. For Application Load Balancers, valid values are `HTTP` and `HTTPS`, with a default of `HTTP`. For Network Load Balancers, valid values are `TCP`, `TLS`, `UDP`, and `TCP_UDP`. Not valid to use `UDP` or `TCP_UDP` if dual-stack mode is enabled. Not valid for Gateway Load Balancers.
     */
    @JvmName("klgqsgwsqubkppar")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value Name of the SSL Policy for the listener. Required if `protocol` is `HTTPS` or `TLS`.
     */
    @JvmName("rcklffuwespchhbv")
    public suspend fun sslPolicy(`value`: Output<String>) {
        this.sslPolicy = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * > **NOTE::** Please note that listeners that are attached to Application Load Balancers must use either `HTTP` or `HTTPS` protocols while listeners that are attached to Network Load Balancers must use the `TCP` protocol.
     */
    @JvmName("jojtqhhudettknqw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the Application-Layer Protocol Negotiation (ALPN) policy. Can be set if `protocol` is `TLS`. Valid values are `HTTP1Only`, `HTTP2Only`, `HTTP2Optional`, `HTTP2Preferred`, and `None`.
     */
    @JvmName("srqlmrepmwbfylnp")
    public suspend fun alpnPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alpnPolicy = mapped
    }

    /**
     * @param value ARN of the default SSL server certificate. Exactly one certificate is required if the protocol is HTTPS. For adding additional SSL certificates, see the `aws.lb.ListenerCertificate` resource.
     */
    @JvmName("pjjetcdnitbosxnu")
    public suspend fun certificateArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateArn = mapped
    }

    /**
     * @param value Configuration block for default actions. Detailed below.
     */
    @JvmName("ddclqfrovvleqlnb")
    public suspend fun defaultActions(`value`: List<ListenerDefaultActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultActions = mapped
    }

    /**
     * @param argument Configuration block for default actions. Detailed below.
     */
    @JvmName("irykdykppmjnbmtu")
    public suspend
    fun defaultActions(argument: List<suspend ListenerDefaultActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ListenerDefaultActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.defaultActions = mapped
    }

    /**
     * @param argument Configuration block for default actions. Detailed below.
     */
    @JvmName("aotocqjdgjiacnjb")
    public suspend fun defaultActions(
        vararg
        argument: suspend ListenerDefaultActionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ListenerDefaultActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.defaultActions = mapped
    }

    /**
     * @param argument Configuration block for default actions. Detailed below.
     */
    @JvmName("hchstygkobhctxic")
    public suspend fun defaultActions(argument: suspend ListenerDefaultActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ListenerDefaultActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.defaultActions = mapped
    }

    /**
     * @param values Configuration block for default actions. Detailed below.
     */
    @JvmName("itegwfgvunkefary")
    public suspend fun defaultActions(vararg values: ListenerDefaultActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultActions = mapped
    }

    /**
     * @param value ARN of the load balancer.
     * The following arguments are optional:
     */
    @JvmName("gtqtjatbrwradvey")
    public suspend fun loadBalancerArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerArn = mapped
    }

    /**
     * @param value Port on which the load balancer is listening. Not valid for Gateway Load Balancers.
     */
    @JvmName("iqevvrdipuluqjva")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Protocol for connections from clients to the load balancer. For Application Load Balancers, valid values are `HTTP` and `HTTPS`, with a default of `HTTP`. For Network Load Balancers, valid values are `TCP`, `TLS`, `UDP`, and `TCP_UDP`. Not valid to use `UDP` or `TCP_UDP` if dual-stack mode is enabled. Not valid for Gateway Load Balancers.
     */
    @JvmName("xvnpseutijgljyhl")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Name of the SSL Policy for the listener. Required if `protocol` is `HTTPS` or `TLS`.
     */
    @JvmName("ofgxibqwefrnbqug")
    public suspend fun sslPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslPolicy = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * > **NOTE::** Please note that listeners that are attached to Application Load Balancers must use either `HTTP` or `HTTPS` protocols while listeners that are attached to Network Load Balancers must use the `TCP` protocol.
     */
    @JvmName("bjampfesxsxgpyyl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * > **NOTE::** Please note that listeners that are attached to Application Load Balancers must use either `HTTP` or `HTTPS` protocols while listeners that are attached to Network Load Balancers must use the `TCP` protocol.
     */
    @JvmName("bggjxyyqctgwrlhk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ListenerArgs = ListenerArgs(
        alpnPolicy = alpnPolicy,
        certificateArn = certificateArn,
        defaultActions = defaultActions,
        loadBalancerArn = loadBalancerArn,
        port = port,
        protocol = protocol,
        sslPolicy = sslPolicy,
        tags = tags,
    )
}
