@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin

import com.pulumi.aws.alb.kotlin.outputs.ListenerRuleAction
import com.pulumi.aws.alb.kotlin.outputs.ListenerRuleCondition
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.alb.kotlin.outputs.ListenerRuleAction.Companion.toKotlin as listenerRuleActionToKotlin
import com.pulumi.aws.alb.kotlin.outputs.ListenerRuleCondition.Companion.toKotlin as listenerRuleConditionToKotlin

/**
 * Builder for [ListenerRule].
 */
@PulumiTagMarker
public class ListenerRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ListenerRuleArgs = ListenerRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ListenerRuleArgsBuilder.() -> Unit) {
        val builder = ListenerRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ListenerRule {
        val builtJavaResource = com.pulumi.aws.alb.ListenerRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ListenerRule(builtJavaResource)
    }
}

/**
 * Provides a Load Balancer Listener Rule resource.
 * > **Note:** `aws.alb.ListenerRule` is known as `aws.lb.ListenerRule`. The functionality is identical.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.LoadBalancer;
 * import com.pulumi.aws.lb.Listener;
 * import com.pulumi.aws.lb.ListenerRule;
 * import com.pulumi.aws.lb.ListenerRuleArgs;
 * import com.pulumi.aws.lb.inputs.ListenerRuleActionArgs;
 * import com.pulumi.aws.lb.inputs.ListenerRuleConditionArgs;
 * import com.pulumi.aws.lb.inputs.ListenerRuleConditionPathPatternArgs;
 * import com.pulumi.aws.lb.inputs.ListenerRuleConditionHostHeaderArgs;
 * import com.pulumi.aws.lb.inputs.ListenerRuleActionForwardArgs;
 * import com.pulumi.aws.lb.inputs.ListenerRuleActionForwardStickinessArgs;
 * import com.pulumi.aws.lb.inputs.ListenerRuleActionRedirectArgs;
 * import com.pulumi.aws.lb.inputs.ListenerRuleConditionHttpHeaderArgs;
 * import com.pulumi.aws.lb.inputs.ListenerRuleActionFixedResponseArgs;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolClient;
 * import com.pulumi.aws.cognito.UserPoolDomain;
 * import com.pulumi.aws.lb.inputs.ListenerRuleActionAuthenticateCognitoArgs;
 * import com.pulumi.aws.lb.inputs.ListenerRuleActionAuthenticateOidcArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var frontEndLoadBalancer = new LoadBalancer("frontEndLoadBalancer");
 *         var frontEndListener = new Listener("frontEndListener");
 *         var static_ = new ListenerRule("static", ListenerRuleArgs.builder()
 *             .listenerArn(frontEndListener.arn())
 *             .priority(100)
 *             .actions(ListenerRuleActionArgs.builder()
 *                 .type("forward")
 *                 .targetGroupArn(aws_lb_target_group.static().arn())
 *                 .build())
 *             .conditions(
 *                 ListenerRuleConditionArgs.builder()
 *                     .pathPattern(ListenerRuleConditionPathPatternArgs.builder()
 *                         .values("/static/*")
 *                         .build())
 *                     .build(),
 *                 ListenerRuleConditionArgs.builder()
 *                     .hostHeader(ListenerRuleConditionHostHeaderArgs.builder()
 *                         .values("example.com")
 *                         .build())
 *                     .build())
 *             .build());
 *         var hostBasedWeightedRouting = new ListenerRule("hostBasedWeightedRouting", ListenerRuleArgs.builder()
 *             .listenerArn(frontEndListener.arn())
 *             .priority(99)
 *             .actions(ListenerRuleActionArgs.builder()
 *                 .type("forward")
 *                 .targetGroupArn(aws_lb_target_group.static().arn())
 *                 .build())
 *             .conditions(ListenerRuleConditionArgs.builder()
 *                 .hostHeader(ListenerRuleConditionHostHeaderArgs.builder()
 *                     .values("my-service.*.mycompany.io")
 *                     .build())
 *                 .build())
 *             .build());
 *         var hostBasedRouting = new ListenerRule("hostBasedRouting", ListenerRuleArgs.builder()
 *             .listenerArn(frontEndListener.arn())
 *             .priority(99)
 *             .actions(ListenerRuleActionArgs.builder()
 *                 .type("forward")
 *                 .forward(ListenerRuleActionForwardArgs.builder()
 *                     .targetGroups(
 *                         ListenerRuleActionForwardTargetGroupArgs.builder()
 *                             .arn(aws_lb_target_group.main().arn())
 *                             .weight(80)
 *                             .build(),
 *                         ListenerRuleActionForwardTargetGroupArgs.builder()
 *                             .arn(aws_lb_target_group.canary().arn())
 *                             .weight(20)
 *                             .build())
 *                     .stickiness(ListenerRuleActionForwardStickinessArgs.builder()
 *                         .enabled(true)
 *                         .duration(600)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .conditions(ListenerRuleConditionArgs.builder()
 *                 .hostHeader(ListenerRuleConditionHostHeaderArgs.builder()
 *                     .values("my-service.*.mycompany.io")
 *                     .build())
 *                 .build())
 *             .build());
 *         var redirectHttpToHttps = new ListenerRule("redirectHttpToHttps", ListenerRuleArgs.builder()
 *             .listenerArn(frontEndListener.arn())
 *             .actions(ListenerRuleActionArgs.builder()
 *                 .type("redirect")
 *                 .redirect(ListenerRuleActionRedirectArgs.builder()
 *                     .port("443")
 *                     .protocol("HTTPS")
 *                     .statusCode("HTTP_301")
 *                     .build())
 *                 .build())
 *             .conditions(ListenerRuleConditionArgs.builder()
 *                 .httpHeader(ListenerRuleConditionHttpHeaderArgs.builder()
 *                     .httpHeaderName("X-Forwarded-For")
 *                     .values("192.168.1.*")
 *                     .build())
 *                 .build())
 *             .build());
 *         var healthCheck = new ListenerRule("healthCheck", ListenerRuleArgs.builder()
 *             .listenerArn(frontEndListener.arn())
 *             .actions(ListenerRuleActionArgs.builder()
 *                 .type("fixed-response")
 *                 .fixedResponse(ListenerRuleActionFixedResponseArgs.builder()
 *                     .contentType("text/plain")
 *                     .messageBody("HEALTHY")
 *                     .statusCode("200")
 *                     .build())
 *                 .build())
 *             .conditions(ListenerRuleConditionArgs.builder()
 *                 .queryStrings(
 *                     ListenerRuleConditionQueryStringArgs.builder()
 *                         .key("health")
 *                         .value("check")
 *                         .build(),
 *                     ListenerRuleConditionQueryStringArgs.builder()
 *                         .value("bar")
 *                         .build())
 *                 .build())
 *             .build());
 *         var pool = new UserPool("pool");
 *         var client = new UserPoolClient("client");
 *         var domain = new UserPoolDomain("domain");
 *         var admin = new ListenerRule("admin", ListenerRuleArgs.builder()
 *             .listenerArn(frontEndListener.arn())
 *             .actions(
 *                 ListenerRuleActionArgs.builder()
 *                     .type("authenticate-cognito")
 *                     .authenticateCognito(ListenerRuleActionAuthenticateCognitoArgs.builder()
 *                         .userPoolArn(pool.arn())
 *                         .userPoolClientId(client.id())
 *                         .userPoolDomain(domain.domain())
 *                         .build())
 *                     .build(),
 *                 ListenerRuleActionArgs.builder()
 *                     .type("forward")
 *                     .targetGroupArn(aws_lb_target_group.static().arn())
 *                     .build())
 *             .build());
 *         var oidc = new ListenerRule("oidc", ListenerRuleArgs.builder()
 *             .listenerArn(frontEndListener.arn())
 *             .actions(
 *                 ListenerRuleActionArgs.builder()
 *                     .type("authenticate-oidc")
 *                     .authenticateOidc(ListenerRuleActionAuthenticateOidcArgs.builder()
 *                         .authorizationEndpoint("https://example.com/authorization_endpoint")
 *                         .clientId("client_id")
 *                         .clientSecret("client_secret")
 *                         .issuer("https://example.com")
 *                         .tokenEndpoint("https://example.com/token_endpoint")
 *                         .userInfoEndpoint("https://example.com/user_info_endpoint")
 *                         .build())
 *                     .build(),
 *                 ListenerRuleActionArgs.builder()
 *                     .type("forward")
 *                     .targetGroupArn(aws_lb_target_group.static().arn())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import rules using their ARN. For example:
 * ```sh
 *  $ pulumi import aws:alb/listenerRule:ListenerRule front_end arn:aws:elasticloadbalancing:us-west-2:187416307283:listener-rule/app/test/8e4497da625e2d8a/9ab28ade35828f96/67b3d2d36dd7c26b
 * ```
 * */
 */
public class ListenerRule internal constructor(
    override val javaResource: com.pulumi.aws.alb.ListenerRule,
) : KotlinCustomResource(javaResource, ListenerRuleMapper) {
    /**
     * An Action block. Action blocks are documented below.
     */
    public val actions: Output<List<ListenerRuleAction>>
        get() = javaResource.actions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    listenerRuleActionToKotlin(args0)
                })
            })
        })

    /**
     * The Amazon Resource Name (ARN) of the target group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A Condition block. Multiple condition blocks of different types can be set and all must be satisfied for the rule to match. Condition blocks are documented below.
     */
    public val conditions: Output<List<ListenerRuleCondition>>
        get() = javaResource.conditions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    listenerRuleConditionToKotlin(args0)
                })
            })
        })

    /**
     * The ARN of the listener to which to attach the rule.
     */
    public val listenerArn: Output<String>
        get() = javaResource.listenerArn().applyValue({ args0 -> args0 })

    /**
     * The priority for the rule between `1` and `50000`. Leaving it unset will automatically set the rule with next available priority after currently existing highest rule. A listener can't have multiple rules with the same priority.
     */
    public val priority: Output<Int>
        get() = javaResource.priority().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ListenerRuleMapper : ResourceMapper<ListenerRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.alb.ListenerRule::class == javaResource::class

    override fun map(javaResource: Resource): ListenerRule = ListenerRule(
        javaResource as
            com.pulumi.aws.alb.ListenerRule,
    )
}

/**
 * @see [ListenerRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ListenerRule].
 */
public suspend fun listenerRule(
    name: String,
    block: suspend ListenerRuleResourceBuilder.() -> Unit,
): ListenerRule {
    val builder = ListenerRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ListenerRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun listenerRule(name: String): ListenerRule {
    val builder = ListenerRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
