@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin

import com.pulumi.aws.alb.ListenerRuleArgs.builder
import com.pulumi.aws.alb.kotlin.inputs.ListenerRuleActionArgs
import com.pulumi.aws.alb.kotlin.inputs.ListenerRuleActionArgsBuilder
import com.pulumi.aws.alb.kotlin.inputs.ListenerRuleConditionArgs
import com.pulumi.aws.alb.kotlin.inputs.ListenerRuleConditionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Load Balancer Listener Rule resource.
 * > **Note:** `aws.alb.ListenerRule` is known as `aws.lb.ListenerRule`. The functionality is identical.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.LoadBalancer;
 * import com.pulumi.aws.lb.Listener;
 * import com.pulumi.aws.lb.ListenerRule;
 * import com.pulumi.aws.lb.ListenerRuleArgs;
 * import com.pulumi.aws.lb.inputs.ListenerRuleActionArgs;
 * import com.pulumi.aws.lb.inputs.ListenerRuleConditionArgs;
 * import com.pulumi.aws.lb.inputs.ListenerRuleConditionPathPatternArgs;
 * import com.pulumi.aws.lb.inputs.ListenerRuleConditionHostHeaderArgs;
 * import com.pulumi.aws.lb.inputs.ListenerRuleActionForwardArgs;
 * import com.pulumi.aws.lb.inputs.ListenerRuleActionForwardStickinessArgs;
 * import com.pulumi.aws.lb.inputs.ListenerRuleActionRedirectArgs;
 * import com.pulumi.aws.lb.inputs.ListenerRuleConditionHttpHeaderArgs;
 * import com.pulumi.aws.lb.inputs.ListenerRuleActionFixedResponseArgs;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolClient;
 * import com.pulumi.aws.cognito.UserPoolDomain;
 * import com.pulumi.aws.lb.inputs.ListenerRuleActionAuthenticateCognitoArgs;
 * import com.pulumi.aws.lb.inputs.ListenerRuleActionAuthenticateOidcArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var frontEndLoadBalancer = new LoadBalancer("frontEndLoadBalancer");
 *         var frontEndListener = new Listener("frontEndListener");
 *         var static_ = new ListenerRule("static", ListenerRuleArgs.builder()
 *             .listenerArn(frontEndListener.arn())
 *             .priority(100)
 *             .actions(ListenerRuleActionArgs.builder()
 *                 .type("forward")
 *                 .targetGroupArn(aws_lb_target_group.static().arn())
 *                 .build())
 *             .conditions(
 *                 ListenerRuleConditionArgs.builder()
 *                     .pathPattern(ListenerRuleConditionPathPatternArgs.builder()
 *                         .values("/static/*")
 *                         .build())
 *                     .build(),
 *                 ListenerRuleConditionArgs.builder()
 *                     .hostHeader(ListenerRuleConditionHostHeaderArgs.builder()
 *                         .values("example.com")
 *                         .build())
 *                     .build())
 *             .build());
 *         var hostBasedWeightedRouting = new ListenerRule("hostBasedWeightedRouting", ListenerRuleArgs.builder()
 *             .listenerArn(frontEndListener.arn())
 *             .priority(99)
 *             .actions(ListenerRuleActionArgs.builder()
 *                 .type("forward")
 *                 .targetGroupArn(aws_lb_target_group.static().arn())
 *                 .build())
 *             .conditions(ListenerRuleConditionArgs.builder()
 *                 .hostHeader(ListenerRuleConditionHostHeaderArgs.builder()
 *                     .values("my-service.*.mycompany.io")
 *                     .build())
 *                 .build())
 *             .build());
 *         var hostBasedRouting = new ListenerRule("hostBasedRouting", ListenerRuleArgs.builder()
 *             .listenerArn(frontEndListener.arn())
 *             .priority(99)
 *             .actions(ListenerRuleActionArgs.builder()
 *                 .type("forward")
 *                 .forward(ListenerRuleActionForwardArgs.builder()
 *                     .targetGroups(
 *                         ListenerRuleActionForwardTargetGroupArgs.builder()
 *                             .arn(aws_lb_target_group.main().arn())
 *                             .weight(80)
 *                             .build(),
 *                         ListenerRuleActionForwardTargetGroupArgs.builder()
 *                             .arn(aws_lb_target_group.canary().arn())
 *                             .weight(20)
 *                             .build())
 *                     .stickiness(ListenerRuleActionForwardStickinessArgs.builder()
 *                         .enabled(true)
 *                         .duration(600)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .conditions(ListenerRuleConditionArgs.builder()
 *                 .hostHeader(ListenerRuleConditionHostHeaderArgs.builder()
 *                     .values("my-service.*.mycompany.io")
 *                     .build())
 *                 .build())
 *             .build());
 *         var redirectHttpToHttps = new ListenerRule("redirectHttpToHttps", ListenerRuleArgs.builder()
 *             .listenerArn(frontEndListener.arn())
 *             .actions(ListenerRuleActionArgs.builder()
 *                 .type("redirect")
 *                 .redirect(ListenerRuleActionRedirectArgs.builder()
 *                     .port("443")
 *                     .protocol("HTTPS")
 *                     .statusCode("HTTP_301")
 *                     .build())
 *                 .build())
 *             .conditions(ListenerRuleConditionArgs.builder()
 *                 .httpHeader(ListenerRuleConditionHttpHeaderArgs.builder()
 *                     .httpHeaderName("X-Forwarded-For")
 *                     .values("192.168.1.*")
 *                     .build())
 *                 .build())
 *             .build());
 *         var healthCheck = new ListenerRule("healthCheck", ListenerRuleArgs.builder()
 *             .listenerArn(frontEndListener.arn())
 *             .actions(ListenerRuleActionArgs.builder()
 *                 .type("fixed-response")
 *                 .fixedResponse(ListenerRuleActionFixedResponseArgs.builder()
 *                     .contentType("text/plain")
 *                     .messageBody("HEALTHY")
 *                     .statusCode("200")
 *                     .build())
 *                 .build())
 *             .conditions(ListenerRuleConditionArgs.builder()
 *                 .queryStrings(
 *                     ListenerRuleConditionQueryStringArgs.builder()
 *                         .key("health")
 *                         .value("check")
 *                         .build(),
 *                     ListenerRuleConditionQueryStringArgs.builder()
 *                         .value("bar")
 *                         .build())
 *                 .build())
 *             .build());
 *         var pool = new UserPool("pool");
 *         var client = new UserPoolClient("client");
 *         var domain = new UserPoolDomain("domain");
 *         var admin = new ListenerRule("admin", ListenerRuleArgs.builder()
 *             .listenerArn(frontEndListener.arn())
 *             .actions(
 *                 ListenerRuleActionArgs.builder()
 *                     .type("authenticate-cognito")
 *                     .authenticateCognito(ListenerRuleActionAuthenticateCognitoArgs.builder()
 *                         .userPoolArn(pool.arn())
 *                         .userPoolClientId(client.id())
 *                         .userPoolDomain(domain.domain())
 *                         .build())
 *                     .build(),
 *                 ListenerRuleActionArgs.builder()
 *                     .type("forward")
 *                     .targetGroupArn(aws_lb_target_group.static().arn())
 *                     .build())
 *             .build());
 *         var oidc = new ListenerRule("oidc", ListenerRuleArgs.builder()
 *             .listenerArn(frontEndListener.arn())
 *             .actions(
 *                 ListenerRuleActionArgs.builder()
 *                     .type("authenticate-oidc")
 *                     .authenticateOidc(ListenerRuleActionAuthenticateOidcArgs.builder()
 *                         .authorizationEndpoint("https://example.com/authorization_endpoint")
 *                         .clientId("client_id")
 *                         .clientSecret("client_secret")
 *                         .issuer("https://example.com")
 *                         .tokenEndpoint("https://example.com/token_endpoint")
 *                         .userInfoEndpoint("https://example.com/user_info_endpoint")
 *                         .build())
 *                     .build(),
 *                 ListenerRuleActionArgs.builder()
 *                     .type("forward")
 *                     .targetGroupArn(aws_lb_target_group.static().arn())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import rules using their ARN. For example:
 * ```sh
 *  $ pulumi import aws:alb/listenerRule:ListenerRule front_end arn:aws:elasticloadbalancing:us-west-2:187416307283:listener-rule/app/test/8e4497da625e2d8a/9ab28ade35828f96/67b3d2d36dd7c26b
 * ```
 * @property actions An Action block. Action blocks are documented below.
 * @property conditions A Condition block. Multiple condition blocks of different types can be set and all must be satisfied for the rule to match. Condition blocks are documented below.
 * @property listenerArn The ARN of the listener to which to attach the rule.
 * @property priority The priority for the rule between `1` and `50000`. Leaving it unset will automatically set the rule with next available priority after currently existing highest rule. A listener can't have multiple rules with the same priority.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * */
 */
public data class ListenerRuleArgs(
    public val actions: Output<List<ListenerRuleActionArgs>>? = null,
    public val conditions: Output<List<ListenerRuleConditionArgs>>? = null,
    public val listenerArn: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.alb.ListenerRuleArgs> {
    override fun toJava(): com.pulumi.aws.alb.ListenerRuleArgs =
        com.pulumi.aws.alb.ListenerRuleArgs.builder()
            .actions(
                actions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .conditions(
                conditions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .listenerArn(listenerArn?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ListenerRuleArgs].
 */
@PulumiTagMarker
public class ListenerRuleArgsBuilder internal constructor() {
    private var actions: Output<List<ListenerRuleActionArgs>>? = null

    private var conditions: Output<List<ListenerRuleConditionArgs>>? = null

    private var listenerArn: Output<String>? = null

    private var priority: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value An Action block. Action blocks are documented below.
     */
    @JvmName("nefnwwdbrndhmptw")
    public suspend fun actions(`value`: Output<List<ListenerRuleActionArgs>>) {
        this.actions = value
    }

    @JvmName("crlejqkhgbfixuwx")
    public suspend fun actions(vararg values: Output<ListenerRuleActionArgs>) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values An Action block. Action blocks are documented below.
     */
    @JvmName("rxuwpdpwsexdyjjg")
    public suspend fun actions(values: List<Output<ListenerRuleActionArgs>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value A Condition block. Multiple condition blocks of different types can be set and all must be satisfied for the rule to match. Condition blocks are documented below.
     */
    @JvmName("ciestjrmmulvdomg")
    public suspend fun conditions(`value`: Output<List<ListenerRuleConditionArgs>>) {
        this.conditions = value
    }

    @JvmName("lojqxuiaxmykdsrk")
    public suspend fun conditions(vararg values: Output<ListenerRuleConditionArgs>) {
        this.conditions = Output.all(values.asList())
    }

    /**
     * @param values A Condition block. Multiple condition blocks of different types can be set and all must be satisfied for the rule to match. Condition blocks are documented below.
     */
    @JvmName("mrwvcabvkpxawdwt")
    public suspend fun conditions(values: List<Output<ListenerRuleConditionArgs>>) {
        this.conditions = Output.all(values)
    }

    /**
     * @param value The ARN of the listener to which to attach the rule.
     */
    @JvmName("qlfyfuuidhlilgqi")
    public suspend fun listenerArn(`value`: Output<String>) {
        this.listenerArn = value
    }

    /**
     * @param value The priority for the rule between `1` and `50000`. Leaving it unset will automatically set the rule with next available priority after currently existing highest rule. A listener can't have multiple rules with the same priority.
     */
    @JvmName("byubywljstknfjdg")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wmakdfawmdavhpqs")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value An Action block. Action blocks are documented below.
     */
    @JvmName("ptottyqeswdtmhjt")
    public suspend fun actions(`value`: List<ListenerRuleActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param argument An Action block. Action blocks are documented below.
     */
    @JvmName("ymupjronjqrmtehw")
    public suspend fun actions(argument: List<suspend ListenerRuleActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ListenerRuleActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param argument An Action block. Action blocks are documented below.
     */
    @JvmName("syvurbcfvrknvyxs")
    public suspend fun actions(vararg argument: suspend ListenerRuleActionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ListenerRuleActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param argument An Action block. Action blocks are documented below.
     */
    @JvmName("yjwtgekupumrqpje")
    public suspend fun actions(argument: suspend ListenerRuleActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ListenerRuleActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param values An Action block. Action blocks are documented below.
     */
    @JvmName("kgcjnheneengblod")
    public suspend fun actions(vararg values: ListenerRuleActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value A Condition block. Multiple condition blocks of different types can be set and all must be satisfied for the rule to match. Condition blocks are documented below.
     */
    @JvmName("mroxpksroiqwdnpa")
    public suspend fun conditions(`value`: List<ListenerRuleConditionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conditions = mapped
    }

    /**
     * @param argument A Condition block. Multiple condition blocks of different types can be set and all must be satisfied for the rule to match. Condition blocks are documented below.
     */
    @JvmName("daeiqbilqsfndpdd")
    public suspend
    fun conditions(argument: List<suspend ListenerRuleConditionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ListenerRuleConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param argument A Condition block. Multiple condition blocks of different types can be set and all must be satisfied for the rule to match. Condition blocks are documented below.
     */
    @JvmName("fcmvyuybduhnnami")
    public suspend fun conditions(
        vararg
        argument: suspend ListenerRuleConditionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ListenerRuleConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param argument A Condition block. Multiple condition blocks of different types can be set and all must be satisfied for the rule to match. Condition blocks are documented below.
     */
    @JvmName("vtdftlwgheudcste")
    public suspend fun conditions(argument: suspend ListenerRuleConditionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ListenerRuleConditionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param values A Condition block. Multiple condition blocks of different types can be set and all must be satisfied for the rule to match. Condition blocks are documented below.
     */
    @JvmName("xqvayfqvemhiinna")
    public suspend fun conditions(vararg values: ListenerRuleConditionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conditions = mapped
    }

    /**
     * @param value The ARN of the listener to which to attach the rule.
     */
    @JvmName("umbufynxwmfhfeev")
    public suspend fun listenerArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listenerArn = mapped
    }

    /**
     * @param value The priority for the rule between `1` and `50000`. Leaving it unset will automatically set the rule with next available priority after currently existing highest rule. A listener can't have multiple rules with the same priority.
     */
    @JvmName("oxoelucxgvgiovio")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vvqskpqktadxsuvo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ffsqcnsapayafmyj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ListenerRuleArgs = ListenerRuleArgs(
        actions = actions,
        conditions = conditions,
        listenerArn = listenerArn,
        priority = priority,
        tags = tags,
    )
}
