@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin

import com.pulumi.aws.alb.TargetGroupAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides the ability to register instances and containers with an Application Load Balancer (ALB) or Network Load Balancer (NLB) target group. For attaching resources with Elastic Load Balancer (ELB), see the `aws.elb.Attachment` resource.
 * > **Note:** `aws.alb.TargetGroupAttachment` is known as `aws.lb.TargetGroupAttachment`. The functionality is identical.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.TargetGroup;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.lb.TargetGroupAttachment;
 * import com.pulumi.aws.lb.TargetGroupAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testTargetGroup = new TargetGroup("testTargetGroup");
 *         var testInstance = new Instance("testInstance");
 *         var testTargetGroupAttachment = new TargetGroupAttachment("testTargetGroupAttachment", TargetGroupAttachmentArgs.builder()
 *             .targetGroupArn(testTargetGroup.arn())
 *             .targetId(testInstance.id())
 *             .port(80)
 *             .build());
 *     }
 * }
 * ```
 * ### Lambda Target
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.TargetGroup;
 * import com.pulumi.aws.lb.TargetGroupArgs;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.Permission;
 * import com.pulumi.aws.lambda.PermissionArgs;
 * import com.pulumi.aws.lb.TargetGroupAttachment;
 * import com.pulumi.aws.lb.TargetGroupAttachmentArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testTargetGroup = new TargetGroup("testTargetGroup", TargetGroupArgs.builder()
 *             .targetType("lambda")
 *             .build());
 *         var testFunction = new Function("testFunction");
 *         var withLb = new Permission("withLb", PermissionArgs.builder()
 *             .action("lambda:InvokeFunction")
 *             .function(testFunction.name())
 *             .principal("elasticloadbalancing.amazonaws.com")
 *             .sourceArn(testTargetGroup.arn())
 *             .build());
 *         var testTargetGroupAttachment = new TargetGroupAttachment("testTargetGroupAttachment", TargetGroupAttachmentArgs.builder()
 *             .targetGroupArn(testTargetGroup.arn())
 *             .targetId(testFunction.arn())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(withLb)
 *                 .build());
 *     }
 * }
 * ```
 * ### Registering Multiple Targets
 * No Java example available.
 * ## Import
 * You cannot import Target Group Attachments.
 * @property availabilityZone The Availability Zone where the IP address of the target is to be registered. If the private IP address is outside of the VPC scope, this value must be set to `all`.
 * @property port The port on which targets receive traffic.
 * @property targetGroupArn The ARN of the target group with which to register targets.
 * @property targetId The ID of the target. This is the Instance ID for an instance, or the container ID for an ECS container. If the target type is `ip`, specify an IP address. If the target type is `lambda`, specify the Lambda function ARN. If the target type is `alb`, specify the ALB ARN.
 * The following arguments are optional:
 */
public data class TargetGroupAttachmentArgs(
    public val availabilityZone: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val targetGroupArn: Output<String>? = null,
    public val targetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.alb.TargetGroupAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.alb.TargetGroupAttachmentArgs =
        com.pulumi.aws.alb.TargetGroupAttachmentArgs.builder()
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .targetGroupArn(targetGroupArn?.applyValue({ args0 -> args0 }))
            .targetId(targetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TargetGroupAttachmentArgs].
 */
@PulumiTagMarker
public class TargetGroupAttachmentArgsBuilder internal constructor() {
    private var availabilityZone: Output<String>? = null

    private var port: Output<Int>? = null

    private var targetGroupArn: Output<String>? = null

    private var targetId: Output<String>? = null

    /**
     * @param value The Availability Zone where the IP address of the target is to be registered. If the private IP address is outside of the VPC scope, this value must be set to `all`.
     */
    @JvmName("jhdllradpnpraqvk")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value The port on which targets receive traffic.
     */
    @JvmName("adyqfeuubseousrd")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The ARN of the target group with which to register targets.
     */
    @JvmName("ixpvvyxxxojagvnm")
    public suspend fun targetGroupArn(`value`: Output<String>) {
        this.targetGroupArn = value
    }

    /**
     * @param value The ID of the target. This is the Instance ID for an instance, or the container ID for an ECS container. If the target type is `ip`, specify an IP address. If the target type is `lambda`, specify the Lambda function ARN. If the target type is `alb`, specify the ALB ARN.
     * The following arguments are optional:
     */
    @JvmName("twokrgmbfifxgoql")
    public suspend fun targetId(`value`: Output<String>) {
        this.targetId = value
    }

    /**
     * @param value The Availability Zone where the IP address of the target is to be registered. If the private IP address is outside of the VPC scope, this value must be set to `all`.
     */
    @JvmName("utcbqrfqlhgfsddl")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value The port on which targets receive traffic.
     */
    @JvmName("kwewarauqedtmsmh")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The ARN of the target group with which to register targets.
     */
    @JvmName("ooojifxbmsgqspww")
    public suspend fun targetGroupArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetGroupArn = mapped
    }

    /**
     * @param value The ID of the target. This is the Instance ID for an instance, or the container ID for an ECS container. If the target type is `ip`, specify an IP address. If the target type is `lambda`, specify the Lambda function ARN. If the target type is `alb`, specify the ALB ARN.
     * The following arguments are optional:
     */
    @JvmName("oenlbltefdkxsvkw")
    public suspend fun targetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetId = mapped
    }

    internal fun build(): TargetGroupAttachmentArgs = TargetGroupAttachmentArgs(
        availabilityZone = availabilityZone,
        port = port,
        targetGroupArn = targetGroupArn,
        targetId = targetId,
    )
}
